/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.index.utils.FeatureSampler$;
import org.locationtech.geomesa.process.FeatureResult;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import scala.Function1;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\n\u0015\u0001}A\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"A1\n\u0001B\u0001B\u0003%A\nC\u0003[\u0001\u0011\u00051\fC\u0004b\u0001\t\u0007I\u0011\u00022\t\r%\u0004\u0001\u0015!\u0003d\u0011\u001dQ\u0007\u00011A\u0005\n-Dq\u0001\u001d\u0001A\u0002\u0013%\u0011\u000f\u0003\u0004x\u0001\u0001\u0006K\u0001\u001c\u0005\bq\u0002\u0011\r\u0011\"\u0003z\u0011\u0019i\b\u0001)A\u0005u\"9a\u0010\u0001b\u0001\n\u0013y\b\u0002CA\u0002\u0001\u0001\u0006I!!\u0001\t\u0013\u0005\u0015\u0001A1A\u0005\n\u0005\u001d\u0001\u0002CA\u0014\u0001\u0001\u0006I!!\u0003\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,!9\u0011q\u0007\u0001\u0005B\u0005e\u0002bBA\u001e\u0001\u0011\u0005\u0013Q\b\u0002\u0010'\u0006l\u0007\u000f\\5oOZK7/\u001b;pe*\u0011QCF\u0001\tC:\fG.\u001f;jG*\u0011q\u0003G\u0001\baJ|7-Z:t\u0015\tI\"$A\u0004hK>lWm]1\u000b\u0005ma\u0012\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001\u0003f\f\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nA\u0001\\1oO*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014#\u0005\u0019y%M[3diB\u0011\u0011&L\u0007\u0002U)\u0011qc\u000b\u0006\u0003Ya\tQ!\u001b8eKbL!A\f\u0016\u0003+\u001d+w.T3tCB\u0013xnY3tgZK7/\u001b;peB\u0011\u0001gN\u0007\u0002c)\u0011!gM\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003iU\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002m\u0005\u00191m\\7\n\u0005a\n$a\u0003'bufdunZ4j]\u001e\f\u0001BZ3biV\u0014Xm\u001d\t\u0003w\tk\u0011\u0001\u0010\u0006\u0003{y\naa]5na2,'BA A\u0003\u0011!\u0017\r^1\u000b\u0005\u0005c\u0012\u0001C4f_R|w\u000e\\:\n\u0005\rc$aF*j[BdWMR3biV\u0014XmQ8mY\u0016\u001cG/[8o\u0003\u001d\u0001XM]2f]R\u0004\"AR%\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u0013QA\u00127pCR\f\u0011\u0002\u001e5sK\u0006$\u0017N\\4\u0011\u0007\u0019ku*\u0003\u0002O\u000f\n1q\n\u001d;j_:\u0004\"\u0001U,\u000f\u0005E+\u0006C\u0001*H\u001b\u0005\u0019&B\u0001+\u001f\u0003\u0019a$o\\8u}%\u0011akR\u0001\u0007!J,G-\u001a4\n\u0005aK&AB*ue&twM\u0003\u0002W\u000f\u00061A(\u001b8jiz\"B\u0001\u00180`AB\u0011Q\fA\u0007\u0002)!)\u0011\b\u0002a\u0001u!)A\t\u0002a\u0001\u000b\")1\n\u0002a\u0001\u0019\u0006\u0011R.\u00198vC24\u0016n]5u%\u0016\u001cX\u000f\u001c;t+\u0005\u0019\u0007C\u00013h\u001b\u0005)'B\u00014?\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Q\u0016\u0014Q\u0003T5ti\u001a+\u0017\r^;sK\u000e{G\u000e\\3di&|g.A\nnC:,\u0018\r\u001c,jg&$(+Z:vYR\u001c\b%\u0001\u0006sKN,H\u000e^\"bY\u000e,\u0012\u0001\u001c\t\u0003[:l\u0011AF\u0005\u0003_Z\u0011QBR3biV\u0014XMU3tk2$\u0018A\u0004:fgVdGoQ1mG~#S-\u001d\u000b\u0003eV\u0004\"AR:\n\u0005Q<%\u0001B+oSRDqA\u001e\u0005\u0002\u0002\u0003\u0007A.A\u0002yIE\n1B]3tk2$8)\u00197dA\u0005\u0019a\u000e\u001e5\u0016\u0003i\u0004\"AR>\n\u0005q<%aA%oi\u0006!a\u000e\u001e5!\u0003\u0019!\bN]3bIV\u0011\u0011\u0011\u0001\t\u0004\r6S\u0018a\u0002;ie\u0016\fG\rI\u0001\tg\u0006l\u0007\u000f\\5oOV\u0011\u0011\u0011\u0002\t\b\r\u0006-\u0011qBA\u0011\u0013\r\tia\u0012\u0002\n\rVt7\r^5p]F\u0002B!!\u0005\u0002\u001e5\u0011\u00111\u0003\u0006\u0004{\u0005U!\u0002BA\f\u00033\tqAZ3biV\u0014XMC\u0002\u0002\u001cq\tqa\u001c9f]\u001eL7/\u0003\u0003\u0002 \u0005M!!D*j[BdWMR3biV\u0014X\rE\u0002G\u0003GI1!!\nH\u0005\u001d\u0011un\u001c7fC:\f\u0011b]1na2Lgn\u001a\u0011\u0002\u000bYL7/\u001b;\u0015\u0007I\fi\u0003C\u0004\u0002\u0018A\u0001\r!a\f\u0011\t\u0005E\u00121G\u0007\u0003\u0003+IA!!\u000e\u0002\u0016\t9a)Z1ukJ,\u0017!C4fiJ+7/\u001e7u)\u0005a\u0017aB3yK\u000e,H/\u001a\u000b\u0006e\u0006}\u0012\u0011\n\u0005\b\u0003\u0003\u0012\u0002\u0019AA\"\u0003\u0019\u0019x.\u001e:dKB\u00191(!\u0012\n\u0007\u0005\u001dCHA\nTS6\u0004H.\u001a$fCR,(/Z*pkJ\u001cW\rC\u0004\u0002LI\u0001\r!!\u0014\u0002\u000bE,XM]=\u0011\t\u0005=\u0013\u0011K\u0007\u0002}%\u0019\u00111\u000b \u0003\u000bE+XM]=")
public class SamplingVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private final float percent;
    private final Option<String> threading;
    private final ListFeatureCollection manualVisitResults;
    private FeatureResult resultCalc;
    private final int nth;
    private final Option<Object> thread;
    private final Function1<SimpleFeature, Object> sampling;
    private Logger logger;
    private volatile boolean bitmap$0;

    public List<Expression> getExpressions() {
        return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
    }

    private Logger logger$lzycompute() {
        SamplingVisitor samplingVisitor = this;
        synchronized (samplingVisitor) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private ListFeatureCollection manualVisitResults() {
        return this.manualVisitResults;
    }

    private FeatureResult resultCalc() {
        return this.resultCalc;
    }

    private void resultCalc_$eq(FeatureResult x$1) {
        this.resultCalc = x$1;
    }

    private int nth() {
        return this.nth;
    }

    private Option<Object> thread() {
        return this.thread;
    }

    private Function1<SimpleFeature, Object> sampling() {
        return this.sampling;
    }

    public void visit(Feature feature) {
        block0: {
            SimpleFeature sf = (SimpleFeature)feature;
            if (!BoxesRunTime.unboxToBoolean((Object)this.sampling().apply((Object)sf))) break block0;
            this.manualVisitResults().add(sf);
        }
    }

    public FeatureResult getResult() {
        return this.resultCalc();
    }

    public void execute(SimpleFeatureSource source, Query query) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running Geomesa sampling process on source type {}", new Object[]{source.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        query.getHints().put((Object)QueryHints$.MODULE$.SAMPLING(), (Object)BoxesRunTime.boxToFloat((float)this.percent));
        this.threading.foreach((Function1 & Serializable & scala.Serializable)x$2 -> query.getHints().put((Object)QueryHints$.MODULE$.SAMPLE_BY(), x$2));
        this.resultCalc_$eq(new FeatureResult(source.getFeatures(query)));
    }

    public SamplingVisitor(SimpleFeatureCollection features, float percent, Option<String> threading) {
        this.percent = percent;
        this.threading = threading;
        GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
        LazyLogging.$init$((LazyLogging)this);
        this.manualVisitResults = new ListFeatureCollection((SimpleFeatureType)features.getSchema());
        this.resultCalc = new FeatureResult((SimpleFeatureCollection)this.manualVisitResults());
        this.nth = (int)(1.0f / percent);
        SimpleFeatureType simpleFeatureType = (SimpleFeatureType)features.getSchema();
        this.thread = threading.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)simpleFeatureType.indexOf(x$1))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 != -1);
        this.sampling = FeatureSampler$.MODULE$.sample(this.nth(), this.thread());
    }
}

