/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.index.attribute.AttributeIndex$;
import org.locationtech.geomesa.index.iterators.StatsScan$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.analytic.AttributeResult;
import org.locationtech.geomesa.process.analytic.AttributeVisitor$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.stats.EnumerationStat;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.expression.Expression;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eh\u0001\u0002\u0010 \u0001)B\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t!\u0012\u0005\t!\u0002\u0011\t\u0011)A\u0005\r\"A\u0011\u000b\u0001BC\u0002\u0013\u0005!\u000b\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003T\u0011!q\u0006A!b\u0001\n\u0003y\u0006\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u00111\u0004!\u0011!Q\u0001\n5DQ\u0001\u001d\u0001\u0005\u0002EDq\u0001\u001f\u0001C\u0002\u0013%\u0011\u0010\u0003\u0004~\u0001\u0001\u0006IA\u001f\u0005\b}\u0002\u0011\r\u0011\"\u0003\u0000\u0011!\ti\u0002\u0001Q\u0001\n\u0005\u0005\u0001\"CA\u0010\u0001\u0001\u0007I\u0011BA\u0011\u0011%\tI\u0003\u0001a\u0001\n\u0013\tY\u0003\u0003\u0005\u00028\u0001\u0001\u000b\u0015BA\u0012\u0011%\tI\u0004\u0001EC\u0002\u0013%q\fC\u0004\u0002<\u0001!I!!\u0010\t\u000f\u0005}\u0003\u0001\"\u0003\u0002b!9\u0011Q\r\u0001\u0005\n\u0005\u001d\u0004\"CA6\u0001\t\u0007I\u0011BA7\u0011!\t)\b\u0001Q\u0001\n\u0005=\u0004bBA<\u0001\u0011\u0005\u0013\u0011\u0010\u0005\b\u0003\u000b\u0003A\u0011IAD\u0011\u001d\ty\t\u0001C!\u0003#Cq!!+\u0001\t\u0013\tYkB\u0004\u0002P~A\t!!5\u0007\ryy\u0002\u0012AAj\u0011\u0019\u00018\u0004\"\u0001\u0002\\\"9\u0011Q\\\u000e\u0005\u0002\u0005}'\u0001E!uiJL'-\u001e;f-&\u001c\u0018\u000e^8s\u0015\t\u0001\u0013%\u0001\u0005b]\u0006d\u0017\u0010^5d\u0015\t\u00113%A\u0004qe>\u001cWm]:\u000b\u0005\u0011*\u0013aB4f_6,7/\u0019\u0006\u0003M\u001d\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011\u0001K\u0001\u0004_J<7\u0001A\n\u0005\u0001-\u001a$\b\u0005\u0002-c5\tQF\u0003\u0002/_\u0005!A.\u00198h\u0015\u0005\u0001\u0014\u0001\u00026bm\u0006L!AM\u0017\u0003\r=\u0013'.Z2u!\t!\u0004(D\u00016\u0015\t\u0011cG\u0003\u00028G\u0005)\u0011N\u001c3fq&\u0011\u0011(\u000e\u0002\u0016\u000f\u0016|W*Z:b!J|7-Z:t-&\u001c\u0018\u000e^8s!\tY$)D\u0001=\u0015\tid(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002@\u0001\u0006AA/\u001f9fg\u00064WMC\u0001B\u0003\r\u0019w.\\\u0005\u0003\u0007r\u00121\u0002T1{s2{wmZ5oO\u0006Aa-Z1ukJ,7/F\u0001G!\t9e*D\u0001I\u0015\tI%*\u0001\u0004tS6\u0004H.\u001a\u0006\u0003\u00172\u000bA\u0001Z1uC*\u0011QjJ\u0001\tO\u0016|Go\\8mg&\u0011q\n\u0013\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:\f\u0011BZ3biV\u0014Xm\u001d\u0011\u0002'\u0005$HO]5ckR,G)Z:de&\u0004Ho\u001c:\u0016\u0003M\u0003\"\u0001V.\u000e\u0003US!AV,\u0002\tQL\b/\u001a\u0006\u00031f\u000bqAZ3biV\u0014XM\u0003\u0002[O\u00059q\u000e]3oO&\u001c\u0018B\u0001/V\u0005M\tE\u000f\u001e:jEV$X\rR3tGJL\u0007\u000f^8s\u0003Q\tG\u000f\u001e:jEV$X\rR3tGJL\u0007\u000f^8sA\u00051a-\u001b7uKJ,\u0012\u0001\u0019\t\u0004C\u00124W\"\u00012\u000b\u0003\r\fQa]2bY\u0006L!!\u001a2\u0003\r=\u0003H/[8o!\t9\u0017.D\u0001i\u0015\tq\u0016,\u0003\u0002kQ\n1a)\u001b7uKJ\fqAZ5mi\u0016\u0014\b%A\u0005iSN$xn\u001a:b[B\u0011\u0011M\\\u0005\u0003_\n\u0014qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0006eR,ho\u001e\t\u0003g\u0002i\u0011a\b\u0005\u0006\t\"\u0001\rA\u0012\u0005\u0006#\"\u0001\ra\u0015\u0005\u0006=\"\u0001\r\u0001\u0019\u0005\u0006Y\"\u0001\r!\\\u0001\nCR$(/\u001b2vi\u0016,\u0012A\u001f\t\u0003YmL!\u0001`\u0017\u0003\rM#(/\u001b8h\u0003)\tG\u000f\u001e:jEV$X\rI\u0001\rk:L\u0017/^3WC2,Xm]\u000b\u0003\u0003\u0003\u0001\u0002\"a\u0001\u0002\u000e\u0005E\u0011qC\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u00059Q.\u001e;bE2,'bAA\u0006E\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0011Q\u0001\u0002\u0004\u001b\u0006\u0004\bcA1\u0002\u0014%\u0019\u0011Q\u00032\u0003\u0007\u0005s\u0017\u0010E\u0002b\u00033I1!a\u0007c\u0005\u0011auN\\4\u0002\u001bUt\u0017.];f-\u0006dW/Z:!\u00031\tG\u000f\u001e:jEV$X-\u00133y+\t\t\u0019\u0003E\u0002b\u0003KI1!a\nc\u0005\rIe\u000e^\u0001\u0011CR$(/\u001b2vi\u0016LE\r_0%KF$B!!\f\u00024A\u0019\u0011-a\f\n\u0007\u0005E\"M\u0001\u0003V]&$\b\"CA\u001b\u001d\u0005\u0005\t\u0019AA\u0012\u0003\rAH%M\u0001\u000eCR$(/\u001b2vi\u0016LE\r\u001f\u0011\u0002\u00195\fg.^1m\r&dG/\u001a:\u0002\u0019\u001d,G/\u0011;ue&\u0014W\u000f^3\u0016\t\u0005}\u0012Q\t\u000b\u0005\u0003\u0003\n\t\u0006\u0005\u0003\u0002D\u0005\u0015C\u0002\u0001\u0003\b\u0003\u000f\n\"\u0019AA%\u0005\u0005!\u0016\u0003BA&\u0003#\u00012!YA'\u0013\r\tyE\u0019\u0002\b\u001d>$\b.\u001b8h\u0011\u001d\t\u0019&\u0005a\u0001\u0003+\n\u0011A\u001a\t\u0005\u0003/\nY&\u0004\u0002\u0002Z)\u0011\u0011jV\u0005\u0005\u0003;\nIFA\u0007TS6\u0004H.\u001a$fCR,(/Z\u0001\u0011C\u0012$7+\u001b8hk2\f'OV1mk\u0016$B!!\f\u0002d!9\u00111\u000b\nA\u0002\u0005U\u0013!D1eI6+H\u000e^5WC2,X\r\u0006\u0003\u0002.\u0005%\u0004bBA*'\u0001\u0007\u0011QK\u0001\tC\u0012$g+\u00197vKV\u0011\u0011q\u000e\t\bC\u0006E\u0014QKA\u0017\u0013\r\t\u0019H\u0019\u0002\n\rVt7\r^5p]F\n\u0011\"\u00193e-\u0006dW/\u001a\u0011\u0002\u000bYL7/\u001b;\u0015\t\u00055\u00121\u0010\u0005\u00071Z\u0001\r!! \u0011\t\u0005}\u0014\u0011Q\u0007\u0002/&\u0019\u00111Q,\u0003\u000f\u0019+\u0017\r^;sK\u0006Iq-\u001a;SKN,H\u000e\u001e\u000b\u0003\u0003\u0013\u00032a]AF\u0013\r\tii\b\u0002\u0010\u0003R$(/\u001b2vi\u0016\u0014Vm];mi\u00069Q\r_3dkR,GCBA\u0017\u0003'\u000bi\nC\u0004\u0002\u0016b\u0001\r!a&\u0002\rM|WO]2f!\r9\u0015\u0011T\u0005\u0004\u00037C%aE*j[BdWMR3biV\u0014XmU8ve\u000e,\u0007bBAP1\u0001\u0007\u0011\u0011U\u0001\u0006cV,'/\u001f\t\u0005\u0003G\u000b)+D\u0001K\u0013\r\t9K\u0013\u0002\u0006#V,'/_\u0001\tk:L\u0017/^3WkQ1\u0011QVAf\u0003\u001b\u0004b!a,\u0002@\u0006\u0015g\u0002BAY\u0003wsA!a-\u0002:6\u0011\u0011Q\u0017\u0006\u0004\u0003oK\u0013A\u0002\u001fs_>$h(C\u0001d\u0013\r\tiLY\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t-a1\u0003\u0011%#XM]1cY\u0016T1!!0c!\u001d\t\u0017qYA\t\u0003/I1!!3c\u0005\u0019!V\u000f\u001d7fe!9\u0011QS\rA\u0002\u0005]\u0005bBAP3\u0001\u0007\u0011\u0011U\u0001\u0011\u0003R$(/\u001b2vi\u00164\u0016n]5u_J\u0004\"a]\u000e\u0014\u0007m\t)\u000eE\u0002b\u0003/L1!!7c\u0005\u0019\te.\u001f*fMR\u0011\u0011\u0011[\u0001\u001aO\u0016$\u0018J\\2mk\u0012,\u0017\t\u001e;sS\n,H/\u001a$jYR,'\u000fF\u0002g\u0003CDa\u0001_\u000fA\u0002\u0005\r\b\u0003BAs\u0003[tA!a:\u0002jB\u0019\u00111\u00172\n\u0007\u0005-(-\u0001\u0004Qe\u0016$WMZ\u0005\u0004y\u0006=(bAAvE\u0002")
public class AttributeVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private Option<Filter> manualFilter;
    private final SimpleFeatureCollection features;
    private final AttributeDescriptor attributeDescriptor;
    private final Option<Filter> filter;
    private final String attribute;
    private final Map<Object, Object> uniqueValues;
    private int attributeIdx;
    private final Function1<SimpleFeature, BoxedUnit> addValue;
    private Logger logger;
    private volatile byte bitmap$0;

    public static Filter getIncludeAttributeFilter(String string) {
        return AttributeVisitor$.MODULE$.getIncludeAttributeFilter(string);
    }

    public java.util.List<Expression> getExpressions() {
        return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
    }

    private Logger logger$lzycompute() {
        AttributeVisitor attributeVisitor = this;
        synchronized (attributeVisitor) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public SimpleFeatureCollection features() {
        return this.features;
    }

    public AttributeDescriptor attributeDescriptor() {
        return this.attributeDescriptor;
    }

    public Option<Filter> filter() {
        return this.filter;
    }

    private String attribute() {
        return this.attribute;
    }

    private Map<Object, Object> uniqueValues() {
        return this.uniqueValues;
    }

    private int attributeIdx() {
        return this.attributeIdx;
    }

    private void attributeIdx_$eq(int x$1) {
        this.attributeIdx = x$1;
    }

    private Option<Filter> manualFilter$lzycompute() {
        AttributeVisitor attributeVisitor = this;
        synchronized (attributeVisitor) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.manualFilter = this.filter().map((Function1 & Serializable & scala.Serializable)x$8 -> FastFilterFactory$.MODULE$.optimize((SimpleFeatureType)this.features().getSchema(), x$8));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.manualFilter;
    }

    private Option<Filter> manualFilter() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.manualFilter$lzycompute() : this.manualFilter;
    }

    private <T> T getAttribute(SimpleFeature f) {
        block0: {
            if (this.attributeIdx() != -1) break block0;
            this.attributeIdx_$eq(f.getType().indexOf(this.attribute()));
        }
        return (T)f.getAttribute(this.attributeIdx());
    }

    private void addSingularValue(SimpleFeature f) {
        block0: {
            Object value = this.getAttribute(f);
            if (value == null) break block0;
            this.uniqueValues().update(value, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.uniqueValues().apply(value)) + 1L)));
        }
    }

    private void addMultiValue(SimpleFeature f) {
        block0: {
            Collection values = (Collection)this.getAttribute(f);
            if (values == null) break block0;
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(values).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                AttributeVisitor.$anonfun$addMultiValue$1(this, x$9);
                return BoxedUnit.UNIT;
            });
        }
    }

    private Function1<SimpleFeature, BoxedUnit> addValue() {
        return this.addValue;
    }

    public void visit(Feature feature) {
        block0: {
            SimpleFeature f = (SimpleFeature)feature;
            if (!this.manualFilter().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.evaluate((Object)f)))) break block0;
            this.addValue().apply((Object)f);
        }
    }

    public AttributeResult getResult() {
        return new AttributeResult((scala.collection.immutable.Map<Object, Object>)this.uniqueValues().toMap(Predef$.MODULE$.$conforms()));
    }

    public void execute(SimpleFeatureSource source, Query query) {
        Iterable iterable;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running Geomesa histogram process on source type {}", new Object[]{source.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.filter().foreach((Function1 & Serializable & scala.Serializable)f -> {
            query.setFilter(package$.MODULE$.mergeFilters(query.getFilter(), f));
            return BoxedUnit.UNIT;
        });
        SimpleFeatureType sft = (SimpleFeatureType)source.getSchema();
        if (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isMultiValued$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(this.attributeDescriptor()))) {
            iterable = this.uniqueV5(source, query);
        } else {
            EnumerationStat enumerationStat;
            query.getHints().put((Object)QueryHints$.MODULE$.STATS_STRING(), (Object)Stat$.MODULE$.Enumeration(this.attribute()));
            query.getHints().put((Object)QueryHints$.MODULE$.ENCODE_STATS(), (Object)Boolean.TRUE);
            try (SimpleFeatureIterator reader = source.getFeatures(query).features();){
                String encoded = (String)((SimpleFeature)reader.next()).getAttribute(0);
                enumerationStat = (EnumerationStat)StatsScan$.MODULE$.decodeStat(sft).apply((Object)encoded);
            }
            EnumerationStat enumeration = enumerationStat;
            iterable = enumeration.frequencies();
        }
        Iterable enumerated = iterable;
        this.uniqueValues().clear();
        enumerated.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object k = tuple2._1();
            long v = tuple2._2$mcJ$sp();
            Option option = this.uniqueValues().put(k, (Object)BoxesRunTime.boxToLong((long)v));
            return option;
        });
    }

    private Iterable<Tuple2<Object, Object>> uniqueV5(SimpleFeatureSource source, Query query) {
        query.setPropertyNames((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.attribute(), (List)Nil$.MODULE$)).asJava());
        Filter filter = query.getFilter();
        IncludeFilter includeFilter = Filter.INCLUDE;
        if (!(filter != null ? !filter.equals(includeFilter) : includeFilter != null) && AttributeIndex$.MODULE$.indexed((SimpleFeatureType)this.features().getSchema(), this.attribute())) {
            query.setFilter(AttributeVisitor$.MODULE$.getIncludeAttributeFilter(this.attribute()));
        }
        SelfClosingIterator$.MODULE$.apply(source.getFeatures(query).features()).foreach(this.addValue());
        return this.uniqueValues().toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$addMultiValue$1(AttributeVisitor $this, Object x$9) {
        $this.uniqueValues().update(x$9, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)$this.uniqueValues().apply(x$9)) + 1L)));
    }

    public AttributeVisitor(SimpleFeatureCollection features, AttributeDescriptor attributeDescriptor, Option<Filter> filter, boolean histogram) {
        this.features = features;
        this.attributeDescriptor = attributeDescriptor;
        this.filter = filter;
        GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
        LazyLogging.$init$((LazyLogging)this);
        this.attribute = attributeDescriptor.getLocalName();
        this.uniqueValues = Map$.MODULE$.empty().withDefaultValue((Object)BoxesRunTime.boxToLong((long)0L));
        this.attributeIdx = -1;
        this.addValue = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(attributeDescriptor)) ? (Function1 & Serializable & scala.Serializable)f -> {
            this.addMultiValue(f);
            return BoxedUnit.UNIT;
        } : (Function1 & Serializable & scala.Serializable)f -> {
            this.addSingularValue(f);
            return BoxedUnit.UNIT;
        };
    }
}

