/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.transform;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter$;
import org.locationtech.geomesa.arrow.io.package;
import org.locationtech.geomesa.arrow.package;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@DescribeProcess(title="Arrow Conversion", description="Converts a feature collection to arrow format")
@ScalaSignature(bytes="\u0006\u0001\u0011-d\u0001B)S\u0001uCQ\u0001\u001e\u0001\u0005\u0002UDQ\u0001\u001f\u0001\u0005\u0002e<qAa\u0001S\u0011\u0003\u0011)A\u0002\u0004R%\"\u0005!q\u0001\u0005\u0007i\u0012!\tAa\u0004\u0007\r\tEA\u0001\u0001B\n\u0011)\u0011\u0019C\u0002B\u0001B\u0003%!Q\u0005\u0005\u000b\u0005o1!\u0011!Q\u0001\n\te\u0002B\u0003B2\r\t\u0005\t\u0015!\u0003\u0002l!Q\u00111\u0012\u0004\u0003\u0002\u0003\u0006IA!\u001a\t\u0015\t]dA!A!\u0002\u0013\u0011I\b\u0003\u0006\u00022\u001a\u0011\t\u0011)A\u0005\u0005\u0007C!\"!0\u0007\u0005\u0003\u0005\u000b\u0011\u0002B=\u0011)\u0011)I\u0002B\u0001B\u0003%!q\u0010\u0005\u000b\u0003\u00134!\u0011!Q\u0001\n\t\u001d\u0005BCAn\r\t\u0005\t\u0015!\u0003\u0003\u0000!1AO\u0002C\u0001\u0005\u001bC!Ba*\u0007\u0011\u000b\u0007I\u0011\u0002BU\u0011-\u0011YM\u0002a\u0001\u0002\u0004%IA!2\t\u0017\t5g\u00011AA\u0002\u0013%!q\u001a\u0005\f\u0005+4\u0001\u0019!A!B\u0013\u00119\rC\u0004\u0003X\u001a!\tE!7\t\u000f\tEf\u0001\"\u0011\u0004\\!1\u0001P\u0002C!\u0007O2\u0011B!,\u0005!\u0003\r\nAa,\t\u000f\tE\u0016D\"\u0001\u00034\"9!1Y\r\u0007\u0002\t\u0015gABB@\t\u0011\u0019\t\t\u0003\u0006\u0003$q\u0011\t\u0011)A\u0005\u0005KA!Ba\u000e\u001d\u0005\u0003\u0005\u000b\u0011\u0002B\u001d\u0011)\u0019\u0019\t\bB\u0001B\u0003%1Q\u0011\u0005\u000b\u0007;c\"\u0011!Q\u0001\n\r}\u0005BCAe9\t\u0005\t\u0015!\u0003\u0003\b\"1A\u000f\bC\u0001\u0007OC\u0011b!.\u001d\u0005\u0004%Iaa.\t\u0011\r\u0015G\u0004)A\u0005\u0007sC\u0011ba2\u001d\u0005\u0004%Ia!3\t\u0011\r]G\u0004)A\u0005\u0007\u0017D\u0011b!7\u001d\u0001\u0004%Iaa7\t\u0013\r\rH\u00041A\u0005\n\r\u0015\b\u0002CBu9\u0001\u0006Ka!8\t\u0013\r-HD1A\u0005\n\r5\b\u0002CB}9\u0001\u0006Iaa<\t\u000f\tEF\u0004\"\u0011\u0004|\"9!1\u0019\u000f\u0005B\t\u0015gABB\u0000\t\u0011!\t\u0001\u0003\u0006\u0003$9\u0012\t\u0011)A\u0005\u0005KA!Ba\u000e/\u0005\u0003\u0005\u000b\u0011\u0002B\u001d\u0011)\u0019\u0019I\fB\u0001B\u0003%1Q\u0011\u0005\u000b\u0003\u0017s#\u0011!Q\u0001\n\t\u0015\u0004BCBO]\t\u0005\t\u0015!\u0003\u0004 \"Q!Q\u0011\u0018\u0003\u0002\u0003\u0006IAa \t\u0015\u0005%gF!A!\u0002\u0013\u00119\t\u0003\u0004u]\u0011\u0005A1\u0001\u0005\n\u0003+q#\u0019!C\u0005\t+A\u0001\u0002\"\b/A\u0003%Aq\u0003\u0005\b\u0005csC\u0011\tC\u0010\u0011\u001d\u0011\u0019M\fC!\u0005\u000bDq\u0001b\t/\t\u0013!)C\u0002\u0004\u0003^\u0012\u0001%q\u001c\u0005\u000b\u0005\u0007d$Q3A\u0005\u0002\tm\b\"\u0003B\u007fy\tE\t\u0015!\u0003{\u0011\u0019!H\b\"\u0001\u0003\u0000\"911\u0001\u001f\u0005B\r\u0015\u0001\"CB\u0004y\u0005\u0005I\u0011AB\u0005\u0011%\u0019i\u0001PI\u0001\n\u0003\u0019y\u0001C\u0005\u0004&q\n\t\u0011\"\u0011\u0004(!I1Q\u0006\u001f\u0002\u0002\u0013\u00051q\u0006\u0005\n\u0007ca\u0014\u0011!C\u0001\u0007gA\u0011b!\u0010=\u0003\u0003%\tea\u0010\t\u0013\r-C(!A\u0005\u0002\r5\u0003\"CB)y\u0005\u0005I\u0011IB*\u0011%\u0019)\u0006PA\u0001\n\u0003\u001a9fB\u0005\u0005@\u0011\t\t\u0011#\u0001\u0005B\u0019I!Q\u001c\u0003\u0002\u0002#\u0005A1\t\u0005\u0007i.#\t\u0001\"\u0015\t\u0013\u0011M3*!A\u0005F\u0011U\u0003\"\u0003C,\u0017\u0006\u0005I\u0011\u0011C-\u0011%!ifSA\u0001\n\u0003#y\u0006C\u0005\u0005h-\u000b\t\u0011\"\u0003\u0005j\t1\u0012I\u001d:po\u000e{gN^3sg&|g\u000e\u0015:pG\u0016\u001c8O\u0003\u0002T)\u0006IAO]1og\u001a|'/\u001c\u0006\u0003+Z\u000bq\u0001\u001d:pG\u0016\u001c8O\u0003\u0002X1\u00069q-Z8nKN\f'BA-[\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0016aA8sO\u000e\u00011\u0003\u0002\u0001_M*\u0004\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\t1\fgn\u001a\u0006\u0002G\u0006!!.\u0019<b\u0013\t)\u0007M\u0001\u0004PE*,7\r\u001e\t\u0003O\"l\u0011\u0001V\u0005\u0003SR\u0013abR3p\u001b\u0016\u001c\u0018\r\u0015:pG\u0016\u001c8\u000f\u0005\u0002le6\tAN\u0003\u0002n]\u0006a1oY1mC2|wmZ5oO*\u0011q\u000e]\u0001\tif\u0004Xm]1gK*\t\u0011/A\u0002d_6L!a\u001d7\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0004\"a\u001e\u0001\u000e\u0003I\u000bq!\u001a=fGV$X\rF\u000b{\u0003'\t)%a\u0017\u0002h\u0005%\u00151UAX\u0003w\u000b9-!7\u0011\tmt\u0018\u0011A\u0007\u0002y*\u0011QPY\u0001\u0005kRLG.\u0003\u0002\u0000y\nA\u0011\n^3sCR|'\u000f\u0005\u0004\u0002\u0004\u0005%\u0011QB\u0007\u0003\u0003\u000bQ!!a\u0002\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005-\u0011Q\u0001\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003\u0007\ty!\u0003\u0003\u0002\u0012\u0005\u0015!\u0001\u0002\"zi\u0016Dq!!\u0006\u0003\u0001\u0004\t9\"\u0001\u0005gK\u0006$XO]3t!\u0011\tI\"a\n\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\taa]5na2,'\u0002BA\u0011\u0003G\tA\u0001Z1uC*\u0019\u0011Q\u0005.\u0002\u0011\u001d,w\u000e^8pYNLA!!\u000b\u0002\u001c\t92+[7qY\u00164U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0015\r\u0003'\ti#a\u000f\u0002>\u0005}\u0012\u0011\t\t\u0005\u0003_\t9$\u0004\u0002\u00022)!\u00111GA\u001b\u0003\u001d1\u0017m\u0019;pefT1!VA\u0012\u0013\u0011\tI$!\r\u0003#\u0011+7o\u0019:jE\u0016\u0004\u0016M]1nKR,'/\u0001\u0003oC6,\u0017EAA\u000b\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0005\u0005\r\u0013AI%oaV$\bEZ3biV\u0014X\rI2pY2,7\r^5p]\u0002\"x\u000eI3oG>$W\rC\u0004\u0002H\t\u0001\r!!\u0013\u0002\u0017%t7\r\\;eK\u001aKGm\u001d\t\u0004?\u0006-\u0013bAA'A\n9!i\\8mK\u0006t\u0007\u0006EA#\u0003[\tY$!\u0015\u0002@\u0005M\u0013qKA-C\t\t9%\t\u0002\u0002V\u0005\t\u0013J\\2mk\u0012,\u0007EZ3biV\u0014X\rI%Eg\u0002Jg\u000eI1se><\bEZ5mK\u0006\u0019Q.\u001b8\u001e\u0003\u0001Aq!!\u0018\u0003\u0001\u0004\tI%A\u0005qe>D\u0018PR5eg\"\u0002\u00121LA\u0017\u0003w\t\t'a\u0010\u0002d\u0005]\u0013\u0011L\u0011\u0003\u0003;\n#!!\u001a\u0002YA\u0013x\u000e_=!M\u0016\fG/\u001e:fA%#5\u000f\t;pA%tGo\u001d\u0011j]N$X-\u00193!_\u001a\u00043\u000f\u001e:j]\u001e\u001c\bbBA5\u0005\u0001\u0007\u00111N\u0001\u000eM>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u0011\t\u00055\u00141\u0010\b\u0005\u0003_\n9\b\u0005\u0003\u0002r\u0005\u0015QBAA:\u0015\r\t)\bX\u0001\u0007yI|w\u000e\u001e \n\t\u0005e\u0014QA\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0014q\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\t\u0005e\u0014Q\u0001\u0015\u0011\u0003O\ni#a\u000f\u0002\u0004\u0006}\u0012QQA,\u00033\n#!!\u001b\"\u0005\u0005\u001d\u0015\u0001G!se><\b%\u0013)DA\u0019|'/\\1uAY,'o]5p]\"9\u00111\u0012\u0002A\u0002\u00055\u0015\u0001\u00053jGRLwN\\1ss\u001aKW\r\u001c3t!\u0015Y\u0018qRA6\u0013\r\t\t\n \u0002\u0005\u0019&\u001cH\u000f\u000b\r\u0002\n\u00065\u00121HAK\u0003\u007f\t9*a\u0016\u0002Z\u0005m\u0015QTAP\u0003C\u000b#!a#\"\u0005\u0005e\u0015aH!uiJL'-\u001e;fg\u0002\"x\u000e\t3jGRLwN\\1ss\u0002*gnY8eK\u0006\u0019Q.\u0019=\u001e\u0005\u0001\u0001\u0019AD2pY2,7\r^5p]RK\b/Z\u0012\u0003\u0003WBq!!*\u0003\u0001\u0004\tI%A\u000bvg\u0016\u001c\u0015m\u00195fI\u0012K7\r^5p]\u0006\u0014\u0018.Z:)!\u0005\r\u0016QFA\u001e\u0003S\u000by$a+\u0002X\u0005e\u0013EAASC\t\ti+A-Vg\u0016\u00043-Y2iK\u0012\u0004Co\u001c9.W\u0002\u001aH/\u0019;tA!Jg\rI1wC&d\u0017M\u00197fS1\u0002sN\u001d\u0011sk:\u0004\u0013\r\t3z]\u0006l\u0017n\u0019\u0011ti\u0006$8\u000fI9vKJL\b\u0005^8!EVLG\u000e\u001a\u0011eS\u000e$\u0018n\u001c8be&,7\u000fC\u0004\u00022\n\u0001\r!a\u001b\u0002\u0013M|'\u000f\u001e$jK2$\u0007\u0006EAX\u0003[\tY$!.\u0002@\u0005]\u0016qKA-C\t\t\t,\t\u0002\u0002:\u0006!\u0012\t\u001e;sS\n,H/\u001a\u0011u_\u0002\u001axN\u001d;!EfDq!!0\u0003\u0001\u0004\tI%A\u0006t_J$(+\u001a<feN,\u0007\u0006EA^\u0003[\tY$!1\u0002@\u0005\r\u0017qKA-C\t\ti,\t\u0002\u0002F\u0006q\"+\u001a<feN,\u0007\u0005\u001e5fA\u0011,g-Y;mi\u0002\u001axN\u001d;!_J$WM\u001d\u0005\b\u0003\u0013\u0014\u0001\u0019AAf\u0003%\u0011\u0017\r^2i'&TX\rE\u0002`\u0003\u001bL1!a4a\u0005\u001dIe\u000e^3hKJD\u0003#a2\u0002.\u0005m\u00121[A \u0003+\f9&!\u0017\"\u0005\u0005%\u0017EAAl\u0003IrU/\u001c2fe\u0002zg\r\t4fCR,(/Z:!i>\u0004\u0013N\\2mk\u0012,\u0007%\u001b8!K\u0006\u001c\u0007\u000e\t:fG>\u0014H\r\t2bi\u000eD\u0007bBAn\u0005\u0001\u0007\u0011\u0011J\u0001\u000bI>,(\r\\3QCN\u001c\b\u0006EAm\u0003[\tY$a8\u0002@\u0005\u0005\u0018qKA-C\t\tY.\t\u0002\u0002d\u0006y$)^5mI\u0002\"\u0017n\u0019;j_:\f'/[3tA\u0019L'o\u001d;-AQDWM\u001c\u0011rk\u0016\u0014\u0018\u0010\t:fgVdGo\u001d\u0011j]\u0002\n\u0007e]3qCJ\fG/\u001a\u0011tG\u0006t\u0007f\u0002\u0002\u0002h\u0006}\u0012Q\u001e\t\u0005\u0003_\tI/\u0003\u0003\u0002l\u0006E\"A\u0004#fg\u000e\u0014\u0018NY3SKN,H\u000e^\u0011\u0003\u0003_\f!$\u00128d_\u0012,G\r\t4fCR,(/\u001a\u0011d_2dWm\u0019;j_:D3\u0002AAz\u0003s\fY0a\u0010\u0002\u0000B!\u0011qFA{\u0013\u0011\t90!\r\u0003\u001f\u0011+7o\u0019:jE\u0016\u0004&o\\2fgN\fQ\u0001^5uY\u0016\f#!!@\u0002!\u0005\u0013(o\\<!\u0007>tg/\u001a:tS>t\u0017E\u0001B\u0001\u00035\u001auN\u001c<feR\u001c\b%\u0019\u0011gK\u0006$XO]3!G>dG.Z2uS>t\u0007\u0005^8!CJ\u0014xn\u001e\u0011g_Jl\u0017\r^\u0001\u0017\u0003J\u0014xn^\"p]Z,'o]5p]B\u0013xnY3tgB\u0011q\u000fB\n\u0004\t\t%\u0001\u0003BA\u0002\u0005\u0017IAA!\u0004\u0002\u0006\t1\u0011I\\=SK\u001a$\"A!\u0002\u0003\u0019\u0005\u0013(o\\<WSNLGo\u001c:\u0014\u000b\u0019q&Q\u00036\u0011\t\t]!qD\u0007\u0003\u00053Q1!\u0016B\u000e\u0015\r\u0011iBV\u0001\u0006S:$W\r_\u0005\u0005\u0005C\u0011IBA\u000bHK>lUm]1Qe>\u001cWm]:WSNLGo\u001c:\u0002\u0007M4G\u000f\u0005\u0003\u0003(\tMRB\u0001B\u0015\u0015\u0011\tiBa\u000b\u000b\t\t5\"qF\u0001\bM\u0016\fG/\u001e:f\u0015\r\u0011\tDW\u0001\b_B,gnZ5t\u0013\u0011\u0011)D!\u000b\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X-\u0001\u0005f]\u000e|G-\u001b8h!\u0011\u0011YD!\u0018\u000f\t\tu\"q\u000b\b\u0005\u0005\u007f\u0011\tF\u0004\u0003\u0003B\t5c\u0002\u0002B\"\u0005\u0017rAA!\u0012\u0003J9!\u0011\u0011\u000fB$\u0013\u0005Y\u0016BA-[\u0013\t9\u0006,C\u0002\u0003PY\u000bQ!\u0019:s_^LAAa\u0015\u0003V\u00051a/Z2u_JT1Aa\u0014W\u0013\u0011\u0011IFa\u0017\u0002'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f-\u0016\u001cGo\u001c:\u000b\t\tM#QK\u0005\u0005\u0005?\u0012\tGA\u000bTS6\u0004H.\u001a$fCR,(/Z#oG>$\u0017N\\4\u000b\t\te#1L\u0001\u000bSB\u001cg+\u001a:tS>t\u0007C\u0002B4\u0005c\nYG\u0004\u0003\u0003j\t5d\u0002BA9\u0005WJ!!a\u0002\n\t\t=\u0014QA\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019H!\u001e\u0003\u0007M+\u0017O\u0003\u0003\u0003p\u0005\u0015\u0011!E2bG\",G)[2uS>t\u0017M]5fgB1\u00111\u0001B>\u0005\u007fJAA! \u0002\u0006\t1q\n\u001d;j_:\u0004B!a\u0001\u0003\u0002&!\u0011QJA\u0003!\u0019\t\u0019Aa\u001f\u0002l\u0005I\u0001O]3T_J$X\r\u001a\t\u0005\u0003\u0007\u0011I)\u0003\u0003\u0003\f\u0006\u0015!aA%oiR1\"q\u0012BJ\u0005+\u00139J!'\u0003\u001c\nu%q\u0014BQ\u0005G\u0013)\u000bE\u0002\u0003\u0012\u001ai\u0011\u0001\u0002\u0005\b\u0005G\t\u0002\u0019\u0001B\u0013\u0011\u001d\u00119$\u0005a\u0001\u0005sAqAa\u0019\u0012\u0001\u0004\tY\u0007C\u0004\u0002\fF\u0001\rA!\u001a\t\u000f\t]\u0014\u00031\u0001\u0003z!9\u0011\u0011W\tA\u0002\t\r\u0005bBA_#\u0001\u0007!\u0011\u0010\u0005\b\u0005\u000b\u000b\u0002\u0019\u0001B@\u0011\u001d\tI-\u0005a\u0001\u0005\u000fCq!a7\u0012\u0001\u0004\u0011y(A\u0007nC:,\u0018\r\u001c,jg&$xN]\u000b\u0003\u0005W\u00032A!%\u001a\u0005I\t%O]8x\u001b\u0006tW/\u00197WSNLGo\u001c:\u0014\u0007e\u0011I!A\u0003wSNLG\u000f\u0006\u0003\u00036\nm\u0006\u0003BA\u0002\u0005oKAA!/\u0002\u0006\t!QK\\5u\u0011\u001d\u0011iC\u0007a\u0001\u0005{\u0003BAa\n\u0003@&!!\u0011\u0019B\u0015\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\u00069!/Z:vYR\u001cXC\u0001Bd!\u0019\u00119G!3\u0002\u0002%\u0019qP!\u001e\u0002\rI,7/\u001e7u\u0003)\u0011Xm];mi~#S-\u001d\u000b\u0005\u0005k\u0013\t\u000eC\u0005\u0003TR\t\t\u00111\u0001\u0003H\u0006\u0019\u0001\u0010J\u0019\u0002\u000fI,7/\u001e7uA\u0005Iq-\u001a;SKN,H\u000e\u001e\u000b\u0003\u00057\u00042A!%=\u0005-\t%O]8x%\u0016\u001cX\u000f\u001c;\u0014\u000fq\u0012\tOa<\u0003vB!!1\u001dBv\u001b\t\u0011)O\u0003\u0003\u0003h\n%\u0018a\u0002<jg&$xN\u001d\u0006\u0005\u0005[\t\u0019#\u0003\u0003\u0003n\n\u0015(AE!cgR\u0014\u0018m\u0019;DC2\u001c'+Z:vYR\u0004B!a\u0001\u0003r&!!1_A\u0003\u0005\u001d\u0001&o\u001c3vGR\u0004B!a\u0001\u0003x&!!\u0011`A\u0003\u00051\u0019VM]5bY&T\u0018M\u00197f+\u0005Q\u0018\u0001\u0003:fgVdGo\u001d\u0011\u0015\t\tm7\u0011\u0001\u0005\u0007\u0005\u0007|\u0004\u0019\u0001>\u0002\u0011\u001d,GOV1mk\u0016$\"A!\u0003\u0002\t\r|\u0007/\u001f\u000b\u0005\u00057\u001cY\u0001\u0003\u0005\u0003D\u0006\u0003\n\u00111\u0001{\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"a!\u0005+\u0007i\u001c\u0019b\u000b\u0002\u0004\u0016A!1qCB\u0011\u001b\t\u0019IB\u0003\u0003\u0004\u001c\ru\u0011!C;oG\",7m[3e\u0015\u0011\u0019y\"!\u0002\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004$\re!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"a!\u000b\u0011\u0007}\u001bY#C\u0002\u0002~\u0001\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\"\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!1QGB\u001e!\u0011\t\u0019aa\u000e\n\t\re\u0012Q\u0001\u0002\u0004\u0003:L\b\"\u0003Bj\u000b\u0006\u0005\t\u0019\u0001BD\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB!!\u0019\u0019\u0019e!\u0013\u000465\u00111Q\t\u0006\u0005\u0007\u000f\n)!\u0001\u0006d_2dWm\u0019;j_:L1a`B#\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B@\u0007\u001fB\u0011Ba5H\u0003\u0003\u0005\ra!\u000e\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa\"\u0002\r\u0015\fX/\u00197t)\u0011\u0011yh!\u0017\t\u0013\tM\u0017*!AA\u0002\rUB\u0003\u0002B[\u0007;BqA!\f\u0018\u0001\u0004\u0019y\u0006\u0005\u0003\u0004b\r\rTB\u0001B\u0016\u0013\u0011\u0019)Ga\u000b\u0003\u000f\u0019+\u0017\r^;sKR1!QWB5\u0007gBqaa\u001b\u0019\u0001\u0004\u0019i'\u0001\u0004t_V\u00148-\u001a\t\u0005\u00033\u0019y'\u0003\u0003\u0004r\u0005m!aE*j[BdWMR3biV\u0014XmU8ve\u000e,\u0007bBB;1\u0001\u00071qO\u0001\u0006cV,'/\u001f\t\u0005\u0007s\u001aY(\u0004\u0002\u0002 %!1QPA\u0010\u0005\u0015\tV/\u001a:z\u0005a\u0019\u0016.\u001c9mK\u0006\u0013(o\\<NC:,\u0018\r\u001c,jg&$xN]\n\u00069\t%!1V\u0001\bSB\u001cw\n\u001d;t!\u0011\u00199i!'\u000e\u0005\r%%\u0002BBF\u0007\u001b\u000bq!\\3tg\u0006<WM\u0003\u0003\u0004\u0010\u000eE\u0015aA5qG*!!1KBJ\u0015\u0011\u0011ye!&\u000b\u0007\r]%,\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u00077\u001bIIA\u0005Ja\u000e|\u0005\u000f^5p]\u0006!1o\u001c:u!\u0019\t\u0019Aa\u001f\u0004\"BA\u00111ABR\u0003W\u0012y(\u0003\u0003\u0004&\u0006\u0015!A\u0002+va2,'\u0007\u0006\u0007\u0004*\u000e-6QVBX\u0007c\u001b\u0019\fE\u0002\u0003\u0012rAqAa\t#\u0001\u0004\u0011)\u0003C\u0004\u00038\t\u0002\rA!\u000f\t\u000f\r\r%\u00051\u0001\u0004\u0006\"91Q\u0014\u0012A\u0002\r}\u0005bBAeE\u0001\u0007!qQ\u0001\u0004_V$XCAB]!\u0011\u0019Yl!1\u000e\u0005\ru&bAB`E\u0006\u0011\u0011n\\\u0005\u0005\u0007\u0007\u001ciLA\u000bCsR,\u0017I\u001d:bs>+H\u000f];u'R\u0014X-Y7\u0002\t=,H\u000fI\u0001\u0006Ef$Xm]\u000b\u0003\u0007\u0017\u0004ba!4\u0004T\u0006\u0005QBABh\u0015\u0011\u0019\tn!\u0012\u0002\u000f5,H/\u00192mK&!1Q[Bh\u0005)a\u0015n\u001d;Ck\u001a4WM]\u0001\u0007Ef$Xm\u001d\u0011\u0002\u000b\r|WO\u001c;\u0016\u0005\ru\u0007\u0003BA\u0002\u0007?LAa!9\u0002\u0006\t!Aj\u001c8h\u0003%\u0019w.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u00036\u000e\u001d\b\"\u0003BjQ\u0005\u0005\t\u0019ABo\u0003\u0019\u0019w.\u001e8uA\u00051qO]5uKJ,\"aa<\u0011\t\rE8Q_\u0007\u0003\u0007gTAaa0\u0003V%!1q_Bz\u0005q\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\u0006\u0013(o\\<GS2,wK]5uKJ\fqa\u001e:ji\u0016\u0014\b\u0005\u0006\u0003\u00036\u000eu\bb\u0002B\u0017Y\u0001\u0007!Q\u0018\u0002\u001a\u0007>l\u0007\u000f\\3y\u0003J\u0014xn^'b]V\fGNV5tSR|'oE\u0003/\u0005\u0013\u0011Y\u000b\u0006\t\u0005\u0006\u0011\u001dA\u0011\u0002C\u0006\t\u001b!y\u0001\"\u0005\u0005\u0014A\u0019!\u0011\u0013\u0018\t\u000f\t\rb\u00071\u0001\u0003&!9!q\u0007\u001cA\u0002\te\u0002bBBBm\u0001\u00071Q\u0011\u0005\b\u0003\u00173\u0004\u0019\u0001B3\u0011\u001d\u0019iJ\u000ea\u0001\u0007?CqA!\"7\u0001\u0004\u0011y\bC\u0004\u0002JZ\u0002\rAa\"\u0016\u0005\u0011]\u0001CBBg\t3\u0011i,\u0003\u0003\u0005\u001c\r='aC!se\u0006L()\u001e4gKJ\f\u0011BZ3biV\u0014Xm\u001d\u0011\u0015\t\tUF\u0011\u0005\u0005\b\u0005[I\u0004\u0019\u0001B_\u0003-\u0011W/\u001b7e%\u0016\u001cX\u000f\u001c;\u0015\r\t\u001dGq\u0005C\u001d\u0011\u001d!Ic\u000fa\u0001\tW\tA\u0002Z5di&|g.\u0019:jKN\u0004\u0002\"!\u001c\u0005.\u0005-D\u0011G\u0005\u0005\t_\tyHA\u0002NCB\u0004B\u0001b\r\u000565\u0011!1L\u0005\u0005\to\u0011YFA\bBeJ|w\u000fR5di&|g.\u0019:z\u0011\u001d!Yd\u000fa\u0001\t{\taa]8si\u0016$\u0007C\u0002B4\u0005\u0013\u0014i,A\u0006BeJ|wOU3tk2$\bc\u0001BI\u0017N)1\n\"\u0012\u0003vB9Aq\tC'u\nmWB\u0001C%\u0015\u0011!Y%!\u0002\u0002\u000fI,h\u000e^5nK&!Aq\nC%\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\t\u0003\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0007S\tQ!\u00199qYf$BAa7\u0005\\!1!1\u0019(A\u0002i\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0005b\u0011\r\u0004#BA\u0002\u0005wR\b\"\u0003C3\u001f\u0006\u0005\t\u0019\u0001Bn\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\rF\u0001_\u0001")
public class ArrowConversionProcess
implements GeoMesaProcess,
LazyLogging {
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ArrowConversionProcess arrowConversionProcess = this;
        synchronized (arrowConversionProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @DescribeResult(description="Encoded feature collection")
    public java.util.Iterator<byte[]> execute(@DescribeParameter(name="features", description="Input feature collection to encode") SimpleFeatureCollection features, @DescribeParameter(name="includeFids", description="Include feature IDs in arrow file", min=0) Boolean includeFids, @DescribeParameter(name="proxyFids", description="Proxy feature IDs to ints instead of strings", min=0) Boolean proxyFids, @DescribeParameter(name="formatVersion", description="Arrow IPC format version", min=0) String formatVersion, @DescribeParameter(name="dictionaryFields", description="Attributes to dictionary encode", min=0, max=128, collectionType=String.class) List<String> dictionaryFields, @DescribeParameter(name="useCachedDictionaries", description="Use cached top-k stats (if available), or run a dynamic stats query to build dictionaries", min=0) Boolean useCachedDictionaries, @DescribeParameter(name="sortField", description="Attribute to sort by", min=0) String sortField, @DescribeParameter(name="sortReverse", description="Reverse the default sort order", min=0) Boolean sortReverse, @DescribeParameter(name="batchSize", description="Number of features to include in each record batch", min=0) Integer batchSize, @DescribeParameter(name="doublePass", description="Build dictionaries first, then query results in a separate scan", min=0) Boolean doublePass) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running arrow encoding for {}", new Object[]{features.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SimpleFeatureType sft = (SimpleFeatureType)features.getSchema();
        Seq toEncode = (Seq)Option$.MODULE$.apply(dictionaryFields).map((Function1 & Serializable & scala.Serializable)x$1 -> ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        toEncode.foreach((Function1 & Serializable & scala.Serializable)attribute -> {
            ArrowConversionProcess.$anonfun$execute$3(sft, attribute);
            return BoxedUnit.UNIT;
        });
        Option cacheDictionaries = Option$.MODULE$.apply((Object)useCachedDictionaries).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2));
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(includeFids == null || Predef$.MODULE$.Boolean2boolean(includeFids), proxyFids != null && Predef$.MODULE$.Boolean2boolean(proxyFids));
        String ipcVersion = (String)Option$.MODULE$.apply((Object)formatVersion).getOrElse((Function0 & Serializable & scala.Serializable)() -> package.FormatVersion$.MODULE$.ArrowFormatVersion().get());
        Option reverse = Option$.MODULE$.apply((Object)sortReverse).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3));
        int batch = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)batchSize).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(package.ArrowProperties$.MODULE$.BatchSize().get())).toInt()));
        boolean bl = Option$.MODULE$.apply((Object)doublePass).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5));
        ArrowVisitor visitor = new ArrowVisitor(sft, encoding, ipcVersion, (Seq<String>)toEncode, (Option<Object>)cacheDictionaries, (Option<String>)Option$.MODULE$.apply((Object)sortField), (Option<Object>)reverse, false, batch, bl);
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    public static final /* synthetic */ void $anonfun$execute$3(SimpleFeatureType sft$1, String attribute) {
        if (sft$1.indexOf(attribute) == -1) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Attribute ").append(attribute).append(" doesn't exist in ").append(sft$1).toString());
        }
    }

    public ArrowConversionProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }

    public static interface ArrowManualVisitor {
        public void visit(SimpleFeature var1);

        public Iterator<byte[]> results();
    }

    public static class ArrowResult
    extends AbstractCalcResult
    implements Product,
    scala.Serializable {
        private final java.util.Iterator<byte[]> results;

        public java.util.Iterator<byte[]> results() {
            return this.results;
        }

        public Object getValue() {
            return this.results();
        }

        public ArrowResult copy(java.util.Iterator<byte[]> results) {
            return new ArrowResult(results);
        }

        public java.util.Iterator<byte[]> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "ArrowResult";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return this.results();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ArrowResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ArrowResult)) return false;
            boolean bl = true;
            if (!bl) return false;
            ArrowResult arrowResult = (ArrowResult)((Object)x$1);
            java.util.Iterator<byte[]> iterator = this.results();
            java.util.Iterator<byte[]> iterator2 = arrowResult.results();
            if (iterator == null) {
                if (iterator2 != null) {
                    return false;
                }
            } else if (!iterator.equals(iterator2)) return false;
            if (!arrowResult.canEqual((Object)this)) return false;
            return true;
        }

        public ArrowResult(java.util.Iterator<byte[]> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class ArrowVisitor
    implements GeoMesaProcessVisitor,
    LazyLogging {
        private ArrowManualVisitor manualVisitor;
        private final SimpleFeatureType sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final String ipcVersion;
        private final Seq<String> dictionaryFields;
        private final Option<Object> cacheDictionaries;
        private final Option<String> sortField;
        private final Option<Object> sortReverse;
        private final boolean preSorted;
        private final int batchSize;
        private final boolean doublePass;
        private Iterator<byte[]> result;
        private Logger logger;
        private volatile byte bitmap$0;

        public List<Expression> getExpressions() {
            return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
        }

        private Logger logger$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.logger;
        }

        public Logger logger() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
        }

        private ArrowManualVisitor manualVisitor$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    Option sort = this.sortField.map((Function1 & Serializable & scala.Serializable)s -> new Tuple2(s, $this.sortReverse.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)));
                    IpcOption ipcOpts = package.FormatVersion$.MODULE$.options(this.ipcVersion);
                    this.manualVisitor = this.dictionaryFields.isEmpty() && (this.sortField.isEmpty() || this.preSorted) ? new SimpleArrowManualVisitor(this.sft, this.encoding, ipcOpts, (Option<Tuple2<String, Object>>)sort, this.batchSize) : new ComplexArrowManualVisitor(this.sft, this.encoding, ipcOpts, this.dictionaryFields, (Option<Tuple2<String, Object>>)sort, this.preSorted, this.batchSize);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.manualVisitor;
        }

        private ArrowManualVisitor manualVisitor() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.manualVisitor$lzycompute() : this.manualVisitor;
        }

        private Iterator<byte[]> result() {
            return this.result;
        }

        private void result_$eq(Iterator<byte[]> x$1) {
            this.result = x$1;
        }

        public ArrowResult getResult() {
            return this.result() != null ? new ArrowResult((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.result()).asJava()) : new ArrowResult((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.manualVisitor().results()).asJava());
        }

        public void visit(Feature feature) {
            this.manualVisitor().visit((SimpleFeature)feature);
        }

        public void execute(SimpleFeatureSource source, Query query) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Visiting source type: {}", new Object[]{source.getClass().getName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_ENCODE(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_DICTIONARY_FIELDS(), (Object)this.dictionaryFields.mkString(","));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.fids().isDefined()));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_PROXY_FID(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.fids().contains((Object)SimpleFeatureVector.SimpleFeatureEncoding$.Encoding$.MODULE$.Min())));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_BATCH_SIZE(), (Object)BoxesRunTime.boxToInteger((int)this.batchSize));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_DOUBLE_PASS(), (Object)BoxesRunTime.boxToBoolean((boolean)this.doublePass));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_FORMAT_VERSION(), (Object)this.ipcVersion);
            this.cacheDictionaries.foreach((Function1 & Serializable & scala.Serializable)x$6 -> ArrowVisitor.$anonfun$execute$10(query, BoxesRunTime.unboxToBoolean((Object)x$6)));
            this.sortField.foreach((Function1 & Serializable & scala.Serializable)x$7 -> query.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_FIELD(), x$7));
            this.sortReverse.foreach((Function1 & Serializable & scala.Serializable)x$8 -> ArrowVisitor.$anonfun$execute$12(query, BoxesRunTime.unboxToBoolean((Object)x$8)));
            SelfClosingIterator features = SelfClosingIterator$.MODULE$.apply(source.getFeatures(query));
            this.result_$eq((Iterator<byte[]>)features.map((Function1 & Serializable & scala.Serializable)x$9 -> (byte[])x$9.getAttribute(0)));
        }

        public static final /* synthetic */ Object $anonfun$execute$10(Query query$1, boolean x$6) {
            return query$1.getHints().put((Object)QueryHints$.MODULE$.ARROW_DICTIONARY_CACHED(), (Object)BoxesRunTime.boxToBoolean((boolean)x$6));
        }

        public static final /* synthetic */ Object $anonfun$execute$12(Query query$1, boolean x$8) {
            return query$1.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_REVERSE(), (Object)BoxesRunTime.boxToBoolean((boolean)x$8));
        }

        public ArrowVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, String ipcVersion, Seq<String> dictionaryFields, Option<Object> cacheDictionaries, Option<String> sortField, Option<Object> sortReverse, boolean preSorted, int batchSize, boolean doublePass) {
            this.sft = sft;
            this.encoding = encoding;
            this.ipcVersion = ipcVersion;
            this.dictionaryFields = dictionaryFields;
            this.cacheDictionaries = cacheDictionaries;
            this.sortField = sortField;
            this.sortReverse = sortReverse;
            this.preSorted = preSorted;
            this.batchSize = batchSize;
            this.doublePass = doublePass;
            GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
            LazyLogging.$init$((LazyLogging)this);
        }
    }

    private static class ComplexArrowManualVisitor
    implements ArrowManualVisitor {
        private final SimpleFeatureType sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final IpcOption ipcOpts;
        private final Seq<String> dictionaryFields;
        private final Option<Tuple2<String, Object>> sort;
        private final boolean preSorted;
        private final int batchSize;
        private final ArrayBuffer<SimpleFeature> features;

        private ArrayBuffer<SimpleFeature> features() {
            return this.features;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.features().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeature[]{ScalaSimpleFeature$.MODULE$.copy(feature)}));
        }

        @Override
        public Iterator<byte[]> results() {
            Iterator iterator;
            None$ ordering;
            Map map;
            if (this.dictionaryFields.isEmpty()) {
                map = Predef$.MODULE$.Map().empty();
            } else {
                Seq indicesAndValues = (Seq)this.dictionaryFields.map((Function1 & Serializable & scala.Serializable)field -> new Tuple3(field, (Object)BoxesRunTime.boxToInteger((int)$this.sft.indexOf(field)), (Object)HashSet$.MODULE$.empty()), Seq$.MODULE$.canBuildFrom());
                this.features().foreach((Function1 & Serializable & scala.Serializable)f -> {
                    indicesAndValues.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ComplexArrowManualVisitor.$anonfun$results$3(f, x0$1)));
                    return BoxedUnit.UNIT;
                });
                map = ((TraversableOnce)indicesAndValues.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple3 tuple3 = x0$2;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    String n = (String)tuple3._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    HashSet v = (HashSet)tuple3._3();
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n), (Object)ArrowDictionary$.MODULE$.create($this.sft.getTypeName(), (long)i, (Object[])v.toArray(ClassTag$.MODULE$.AnyRef()), ClassTag$.MODULE$.apply($this.sft.getDescriptor(i).getType().getBinding())));
                    return tuple2;
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
            Map dictionaries = map;
            None$ none$ = ordering = this.preSorted ? None$.MODULE$ : this.sort.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String field = (String)tuple2._1();
                boolean reverse = tuple2._2$mcZ$sp();
                Ordering ordering = SimpleFeatureOrdering$.MODULE$.apply($this.sft, field, reverse);
                return ordering;
            });
            if (None$.MODULE$.equals(none$)) {
                iterator = this.features().iterator();
            } else if (none$ instanceof Some) {
                Some some = (Some)none$;
                Ordering o = (Ordering)some.value();
                iterator = ((IndexedSeqLike)this.features().sorted(o)).iterator();
            } else {
                throw new MatchError((Object)none$);
            }
            Iterator sorted = iterator;
            return this.buildResult((Map<String, ArrowDictionary>)dictionaries, (Iterator<SimpleFeature>)sorted);
        }

        private Iterator<byte[]> buildResult(Map<String, ArrowDictionary> dictionaries, Iterator<SimpleFeature> sorted) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ListBuffer bytes = (ListBuffer)ListBuffer$.MODULE$.empty();
            package.WithClose$.MODULE$.apply((Object)SimpleFeatureArrowFileWriter$.MODULE$.apply((OutputStream)out, this.sft, dictionaries, this.encoding, this.ipcOpts, this.sort), (Function1 & Serializable & scala.Serializable)writer -> {
                ComplexArrowManualVisitor.$anonfun$buildResult$1(this, sorted, bytes, out, writer);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            bytes.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{out.toByteArray()}));
            return bytes.iterator();
        }

        public static final /* synthetic */ boolean $anonfun$results$3(SimpleFeature f$1, Tuple3 x0$1) {
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
            HashSet v = (HashSet)tuple3._3();
            boolean bl = v.add(f$1.getAttribute(i));
            return bl;
        }

        public static final /* synthetic */ void $anonfun$buildResult$1(ComplexArrowManualVisitor $this, Iterator sorted$1, ListBuffer bytes$1, ByteArrayOutputStream out$1, SimpleFeatureArrowFileWriter writer) {
            while (sorted$1.hasNext()) {
                for (int i = 0; i < $this.batchSize && sorted$1.hasNext(); ++i) {
                    writer.add((SimpleFeature)sorted$1.next());
                }
                writer.flush();
                bytes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{out$1.toByteArray()}));
                out$1.reset();
            }
        }

        public ComplexArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, IpcOption ipcOpts, Seq<String> dictionaryFields, Option<Tuple2<String, Object>> sort, boolean preSorted, int batchSize) {
            this.sft = sft;
            this.encoding = encoding;
            this.ipcOpts = ipcOpts;
            this.dictionaryFields = dictionaryFields;
            this.sort = sort;
            this.preSorted = preSorted;
            this.batchSize = batchSize;
            this.features = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        }
    }

    private static class SimpleArrowManualVisitor
    implements ArrowManualVisitor {
        private final int batchSize;
        private final ByteArrayOutputStream out;
        private final ListBuffer<byte[]> bytes;
        private long count;
        private final SimpleFeatureArrowFileWriter writer;

        private ByteArrayOutputStream out() {
            return this.out;
        }

        private ListBuffer<byte[]> bytes() {
            return this.bytes;
        }

        private long count() {
            return this.count;
        }

        private void count_$eq(long x$1) {
            this.count = x$1;
        }

        private SimpleFeatureArrowFileWriter writer() {
            return this.writer;
        }

        @Override
        public void visit(SimpleFeature feature) {
            block0: {
                this.writer().add(feature);
                this.count_$eq(this.count() + 1L);
                if (this.count() % (long)this.batchSize != 0L) break block0;
                this.writer().flush();
                this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
                this.out().reset();
            }
        }

        @Override
        public Iterator<byte[]> results() {
            package.CloseWithLogging$.MODULE$.apply((Object)this.writer(), IsCloseable$.MODULE$.closeableIsCloseable());
            this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
            return this.bytes().iterator();
        }

        public SimpleArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, IpcOption ipcOpts, Option<Tuple2<String, Object>> sort, int batchSize) {
            this.batchSize = batchSize;
            this.out = new ByteArrayOutputStream();
            this.bytes = (ListBuffer)ListBuffer$.MODULE$.empty();
            this.count = 0L;
            this.writer = SimpleFeatureArrowFileWriter$.MODULE$.apply((OutputStream)this.out(), sft, Predef$.MODULE$.Map().empty(), encoding, ipcOpts, sort);
        }
    }
}

