/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.query.ProximityVisitor;
import org.opengis.feature.FeatureVisitor;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@DescribeProcess(title="Geomesa-enabled Proximity Search", description="Performs a proximity search on a Geomesa feature collection using another feature collection as input")
@ScalaSignature(bytes="\u0006\u0001\r4Aa\u0001\u0003\u0001\u001f!)a\u0005\u0001C\u0001O!)!\u0006\u0001C\u0001W\t1\u0002K]8yS6LG/_*fCJ\u001c\u0007\u000e\u0015:pG\u0016\u001c8O\u0003\u0002\u0006\r\u0005)\u0011/^3ss*\u0011q\u0001C\u0001\baJ|7-Z:t\u0015\tI!\"A\u0004hK>lWm]1\u000b\u0005-a\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001\u0002\u0004\b\t\u0003#Yi\u0011A\u0005\u0006\u0003'Q\tA\u0001\\1oO*\tQ#\u0001\u0003kCZ\f\u0017BA\f\u0013\u0005\u0019y%M[3diB\u0011\u0011DG\u0007\u0002\r%\u00111D\u0002\u0002\u000f\u000f\u0016|W*Z:b!J|7-Z:t!\tiB%D\u0001\u001f\u0015\ty\u0002%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002\"E\u0005AA/\u001f9fg\u00064WMC\u0001$\u0003\r\u0019w.\\\u0005\u0003Ky\u00111\u0002T1{s2{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\u000b\t\u0003S\u0001i\u0011\u0001B\u0001\bKb,7-\u001e;f)\u0011ac'R&\u0011\u00055\"T\"\u0001\u0018\u000b\u0005=\u0002\u0014AB:j[BdWM\u0003\u00022e\u0005!A-\u0019;b\u0015\t\u0019D\"\u0001\u0005hK>$xn\u001c7t\u0013\t)dFA\fTS6\u0004H.\u001a$fCR,(/Z\"pY2,7\r^5p]\")qG\u0001a\u0001Y\u0005i\u0011N\u001c9vi\u001a+\u0017\r^;sKNDcAN\u001dA\u0003\n\u001b\u0005C\u0001\u001e?\u001b\u0005Y$B\u0001\u001f>\u0003\u001d1\u0017m\u0019;pefT!a\u0002\u001a\n\u0005}Z$!\u0005#fg\u000e\u0014\u0018NY3QCJ\fW.\u001a;fe\u0006!a.Y7fC\u00059\u0014a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\f\u0013\u0001R\u0001;\u0013:\u0004X\u000f\u001e\u0011gK\u0006$XO]3!G>dG.Z2uS>t\u0007\u0005\u001e5bi\u0002\"WMZ5oKN\u0004C\u000f[3!aJ|\u00070[7jif\u00043/Z1sG\"DQA\u0012\u0002A\u00021\nA\u0002Z1uC\u001a+\u0017\r^;sKNDc!R\u001dA\u0011\nK\u0015%\u0001$\"\u0003)\u000b1\u0006\u00165fA\u0011\fG/\u0019\u0011tKR\u0004Co\u001c\u0011rk\u0016\u0014\u0018\u0010\t4pe\u0002j\u0017\r^2iS:<\u0007EZ3biV\u0014Xm\u001d\u0005\u0006\u0019\n\u0001\r!T\u0001\u000fEV4g-\u001a:ESN$\u0018M\\2f!\t\tb*\u0003\u0002P%\t1Ai\\;cY\u0016DcaS\u001dA#\n\u0013\u0016%\u0001'\"\u0003M\u000bQCQ;gM\u0016\u0014\be]5{K\u0002Jg\u000eI7fi\u0016\u00148\u000f\u000b\u0003\u0003+\nC\u0006C\u0001\u001eW\u0013\t96H\u0001\bEKN\u001c'/\u001b2f%\u0016\u001cX\u000f\u001c;\"\u0003e\u000b\u0011dT;uaV$\bEZ3biV\u0014X\rI2pY2,7\r^5p]\"2\u0001a\u00170`\u0005\u0006\u0004\"A\u000f/\n\u0005u[$a\u0004#fg\u000e\u0014\u0018NY3Qe>\u001cWm]:\u0002\u000bQLG\u000f\\3\"\u0003\u0001\f\u0001eR3p[\u0016\u001c\u0018-L3oC\ndW\r\u001a\u0011Qe>D\u0018.\\5us\u0002\u001aV-\u0019:dQ\u0006\n!-A3QKJ4wN]7tA\u0005\u0004\u0003O]8yS6LG/\u001f\u0011tK\u0006\u00148\r\u001b\u0011p]\u0002\n\u0007eR3p[\u0016\u001c\u0018\r\t4fCR,(/\u001a\u0011d_2dWm\u0019;j_:\u0004So]5oO\u0002\ngn\u001c;iKJ\u0004c-Z1ukJ,\u0007eY8mY\u0016\u001cG/[8oA\u0005\u001c\b%\u001b8qkR\u0004")
public class ProximitySearchProcess
implements GeoMesaProcess,
LazyLogging {
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ProximitySearchProcess proximitySearchProcess = this;
        synchronized (proximitySearchProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @DescribeResult(description="Output feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="inputFeatures", description="Input feature collection that defines the proximity search") SimpleFeatureCollection inputFeatures, @DescribeParameter(name="dataFeatures", description="The data set to query for matching features") SimpleFeatureCollection dataFeatures, @DescribeParameter(name="bufferDistance", description="Buffer size in meters") Double bufferDistance) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Attempting Geomesa Proximity Search on collection type {}", new Object[]{dataFeatures.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ProximityVisitor visitor = new ProximityVisitor(inputFeatures, dataFeatures, bufferDistance);
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)dataFeatures, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    public ProximitySearchProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

