/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.query.QueryVisitor;
import org.opengis.feature.FeatureVisitor;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DescribeProcess(title="Geomesa Query", description="Performs a Geomesa optimized query using spatiotemporal indexes")
@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\u0003\u0006\u0001AAQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005\u00021Bq\u0001\u001f\u0001\u0012\u0002\u0013\u0005\u0011P\u0001\u0007Rk\u0016\u0014\u0018\u0010\u0015:pG\u0016\u001c8O\u0003\u0002\u0007\u000f\u0005)\u0011/^3ss*\u0011\u0001\"C\u0001\baJ|7-Z:t\u0015\tQ1\"A\u0004hK>lWm]1\u000b\u00051i\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\t\u0012$\b\t\u0003%]i\u0011a\u0005\u0006\u0003)U\tA\u0001\\1oO*\ta#\u0001\u0003kCZ\f\u0017B\u0001\r\u0014\u0005\u0019y%M[3diB\u0011!dG\u0007\u0002\u000f%\u0011Ad\u0002\u0002\u000f\u000f\u0016|W*Z:b!J|7-Z:t!\tqR%D\u0001 \u0015\t\u0001\u0013%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002#G\u0005AA/\u001f9fg\u00064WMC\u0001%\u0003\r\u0019w.\\\u0005\u0003M}\u00111\u0002T1{s2{wmZ5oO\u00061A(\u001b8jiz\"\u0012!\u000b\t\u0003U\u0001i\u0011!B\u0001\bKb,7-\u001e;f)\u0011isGR+\u0011\u00059*T\"A\u0018\u000b\u0005A\n\u0014AB:j[BdWM\u0003\u00023g\u0005!A-\u0019;b\u0015\t!T\"\u0001\u0005hK>$xn\u001c7t\u0013\t1tFA\fTS6\u0004H.\u001a$fCR,(/Z\"pY2,7\r^5p]\")\u0001H\u0001a\u0001[\u0005Aa-Z1ukJ,7\u000f\u000b\u00048u\u0005\u00135\t\u0012\t\u0003w}j\u0011\u0001\u0010\u0006\u0003{y\nqAZ1di>\u0014\u0018P\u0003\u0002\tg%\u0011\u0001\t\u0010\u0002\u0012\t\u0016\u001c8M]5cKB\u000b'/Y7fi\u0016\u0014\u0018\u0001\u00028b[\u0016\f\u0013\u0001O\u0001\fI\u0016\u001c8M]5qi&|g.I\u0001F\u0003\u0005\"\u0006.\u001a\u0011gK\u0006$XO]3!g\u0016$\be\u001c8!o\"L7\r\u001b\u0011u_\u0002\nX/\u001a:z\u0011\u00159%\u00011\u0001I\u0003\u00191\u0017\u000e\u001c;feB\u0011\u0011*T\u0007\u0002\u0015*\u0011qi\u0013\u0006\u0003\u00196\tqa\u001c9f]\u001eL7/\u0003\u0002O\u0015\n1a)\u001b7uKJD\u0003B\u0012\u001eB!F\u00136iU\u0011\u0002\u000f\u0006\u0019Q.\u001b8\u001e\u0003\u0001\t\u0013\u0001V\u0001.)\",\u0007EZ5mi\u0016\u0014\b\u0005^8!CB\u0004H.\u001f\u0011u_\u0002\"\b.\u001a\u0011gK\u0006$XO]3!G>dG.Z2uS>t\u0007b\u0002,\u0003!\u0003\u0005\raV\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bc\u0001-\\;6\t\u0011L\u0003\u0002[+\u0005!Q\u000f^5m\u0013\ta\u0016L\u0001\u0003MSN$\bC\u00010h\u001d\tyV\r\u0005\u0002aG6\t\u0011M\u0003\u0002c\u001f\u00051AH]8pizR\u0011\u0001Z\u0001\u0006g\u000e\fG.Y\u0005\u0003M\u000e\fa\u0001\u0015:fI\u00164\u0017B\u00015j\u0005\u0019\u0019FO]5oO*\u0011am\u0019\u0015\r+j\n5.\u0015*m[:|7\t]\u0011\u0002-\u0006\u0019Q.\u0019=\u001e\u0005\u0001\u0001\u0019AD2pY2,7\r^5p]RK\b/Z\u0012\u0002;\u0006\n\u0011/\u0001\u001fUQ\u0016\u0004\u0003O]8qKJ$\u0018.Z:0iJ\fgn\u001d4pe6\u001c\b\u0005^8!CB\u0004H.\u001f\u0011u_\u0002\"\b.\u001a\u0011gK\u0006$XO]3!G>dG.Z2uS>t\u0007\u0006\u0002\u0002t\u0007Z\u0004\"a\u000f;\n\u0005Ud$A\u0004#fg\u000e\u0014\u0018NY3SKN,H\u000e^\u0011\u0002o\u0006Ir*\u001e;qkR\u0004c-Z1ukJ,\u0007eY8mY\u0016\u001cG/[8o\u0003E)\u00070Z2vi\u0016$C-\u001a4bk2$HeM\u000b\u0002u*\u0012qk_\u0016\u0002yB\u0019Q0!\u0002\u000e\u0003yT1a`A\u0001\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0004\r\f!\"\u00198o_R\fG/[8o\u0013\r\t9A \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007F\u0003\u0001\u0002\f\u0005E\u00111C\"\u0002\u0018A\u00191(!\u0004\n\u0007\u0005=AHA\bEKN\u001c'/\u001b2f!J|7-Z:t\u0003\u0015!\u0018\u000e\u001e7fC\t\t)\"A\u0007HK>lWm]1!#V,'/_\u0011\u0003\u00033\tq\bU3sM>\u0014Xn\u001d\u0011bA\u001d+w.\\3tC\u0002z\u0007\u000f^5nSj,G\rI9vKJL\b%^:j]\u001e\u00043\u000f]1uS>$X-\u001c9pe\u0006d\u0007%\u001b8eKb,7\u000f")
public class QueryProcess
implements GeoMesaProcess,
LazyLogging {
    private Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        QueryProcess queryProcess = this;
        synchronized (queryProcess) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @DescribeResult(description="Output feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="The feature set on which to query") SimpleFeatureCollection features, @DescribeParameter(name="filter", min=0, description="The filter to apply to the feature collection") Filter filter, @DescribeParameter(name="properties", min=0, max=128, collectionType=String.class, description="The properties/transforms to apply to the feature collection") List<String> properties) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(33).append("Attempting Geomesa query on type ").append(features.getClass().getName()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String[] propsArray = (String[])Option$.MODULE$.apply(properties).map((Function1 & Serializable & scala.Serializable)x$1 -> (String[])x$1.toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)QueryProcess.$anonfun$execute$2(x$2))).orNull(Predef$.MODULE$.$conforms());
        QueryVisitor visitor = new QueryVisitor(features, (Filter)Option$.MODULE$.apply((Object)filter).getOrElse((Function0 & Serializable & scala.Serializable)() -> Filter.INCLUDE), propsArray);
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    public List<String> execute$default$3() {
        return null;
    }

    public static final /* synthetic */ boolean $anonfun$execute$2(String[] x$2) {
        return x$2.length > 0;
    }

    public QueryProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

