/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.tube;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.process.tube.TubeBuilder;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0003\u0006\u0001+!IA\u0005\u0001B\u0001B\u0003%Qe\f\u0005\na\u0001\u0011\t\u0011)A\u0005c]B\u0011\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u001f\t\u000bu\u0002A\u0011\u0001 \t\u000f\r\u0003!\u0019!C\u0001\t\"1\u0011\u000b\u0001Q\u0001\n\u0015CQA\u0015\u0001\u0005\u0002MCQa\u0018\u0001\u0005B\u0001\u00141\u0002T5oK\u001e\u000b\u0007OR5mY*\u00111\u0002D\u0001\u0005iV\u0014WM\u0003\u0002\u000e\u001d\u00059\u0001O]8dKN\u001c(BA\b\u0011\u0003\u001d9Wm\\7fg\u0006T!!\u0005\n\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003M\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\f\u001b!\t9\u0002$D\u0001\u000b\u0013\tI\"BA\u0006Uk\n,')^5mI\u0016\u0014\bCA\u000e#\u001b\u0005a\"BA\u000f\u001f\u00031\u00198-\u00197bY><w-\u001b8h\u0015\ty\u0002%\u0001\u0005usB,7/\u00194f\u0015\u0005\t\u0013aA2p[&\u00111\u0005\b\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0007uk\n,g)Z1ukJ,7\u000f\u0005\u0002'[5\tqE\u0003\u0002)S\u000511/[7qY\u0016T!AK\u0016\u0002\t\u0011\fG/\u0019\u0006\u0003YI\t\u0001bZ3pi>|Gn]\u0005\u0003]\u001d\u0012qcU5na2,g)Z1ukJ,7i\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0011B\u0012A\u00042vM\u001a,'\u000fR5ti\u0006t7-\u001a\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\t>,(\r\\3\n\u0005AB\u0012aB7bq\nKgn\u001d\t\u0003eiJ!aO\u001a\u0003\u0007%sG/\u0003\u000291\u00051A(\u001b8jiz\"Ba\u0010!B\u0005B\u0011q\u0003\u0001\u0005\u0006I\u0011\u0001\r!\n\u0005\u0006a\u0011\u0001\r!\r\u0005\u0006q\u0011\u0001\r!O\u0001\u0003S\u0012,\u0012!\u0012\t\u0003\r>k\u0011a\u0012\u0006\u0003\u0011&\u000ba!\u0019;p[&\u001c'B\u0001&L\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u00196\u000bA!\u001e;jY*\ta*\u0001\u0003kCZ\f\u0017B\u0001)H\u00055\tEo\\7jG&sG/Z4fe\u0006\u0019\u0011\u000e\u001a\u0011\u0002\r9,\u0007\u0010^%e+\u0005!\u0006CA+]\u001d\t1&\f\u0005\u0002Xg5\t\u0001L\u0003\u0002Z)\u00051AH]8pizJ!aW\u001a\u0002\rA\u0013X\rZ3g\u0013\tifL\u0001\u0004TiJLgn\u001a\u0006\u00037N\n!b\u0019:fCR,G+\u001e2f+\u0005\t\u0007c\u00012hU:\u00111-\u001a\b\u0003/\u0012L\u0011\u0001N\u0005\u0003MN\nq\u0001]1dW\u0006<W-\u0003\u0002iS\nA\u0011\n^3sCR|'O\u0003\u0002ggA\u00111.]\u0007\u0002Y*\u0011\u0001&\u001c\u0006\u0003]>\fqAZ3biV\u0014XM\u0003\u0002q%\u00059q\u000e]3oO&\u001c\u0018B\u0001:m\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\u0002")
public class LineGapFill
extends TubeBuilder {
    private final AtomicInteger id = new AtomicInteger(0);

    public AtomicInteger id() {
        return this.id;
    }

    public String nextId() {
        return Integer.toString(this.id().getAndIncrement());
    }

    @Override
    public Iterator<SimpleFeature> createTube() {
        Iterator iterator;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Creating tube with line gap fill");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Iterator<SimpleFeature> transformed = this.transform(super.tubeFeatures(), this.dtgField());
        Seq sortedTube = (Seq)transformed.toSeq().sortBy((Function1 & Serializable & scala.Serializable)sf -> BoxesRunTime.boxToLong((long)LineGapFill.$anonfun$createTube$2(this, sf)), (Ordering)Ordering.Long$.MODULE$);
        Seq pointsAndTimes = (Seq)sortedTube.map((Function1 & Serializable & scala.Serializable)sf -> new Tuple2((Object)Conversions.RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(this.getGeom((SimpleFeature)sf))), (Object)this.getStartTime((SimpleFeature)sf)), Seq$.MODULE$.canBuildFrom());
        if (pointsAndTimes.lengthCompare(1) == 0) {
            BoxedUnit boxedUnit2;
            Tuple2 tuple2 = (Tuple2)pointsAndTimes.head();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Point p1 = (Point)tuple2._1();
            Date t1 = (Date)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)p1, (Object)t1);
            Tuple2 tuple23 = tuple22;
            Point p12 = (Point)tuple23._1();
            Date t12 = (Date)tuple23._2();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Only a single result - can't create a line");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeature[]{this.builder().buildFeature(this.nextId(), new Object[]{p12, t12, t12})}));
        } else {
            iterator = pointsAndTimes.sliding(2).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BoxedUnit boxedUnit;
                Point geo;
                Seq seq = x0$1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (some.isEmpty()) throw new MatchError((Object)seq);
                if (some.get() == null) throw new MatchError((Object)seq);
                if (((SeqLike)some.get()).lengthCompare(2) != 0) throw new MatchError((Object)seq);
                Tuple2 tuple2 = (Tuple2)((SeqLike)some.get()).apply(0);
                Tuple2 tuple22 = (Tuple2)((SeqLike)some.get()).apply(1);
                if (tuple2 == null) throw new MatchError((Object)seq);
                Point p1 = (Point)tuple2._1();
                Date t1 = (Date)tuple2._2();
                if (tuple22 == null) throw new MatchError((Object)seq);
                Point p2 = (Point)tuple22._1();
                Date t2 = (Date)tuple22._2();
                Object object = geo = p1.equals((Geometry)p2) ? p1 : this.makeIDLSafeLineString(p1.getCoordinate(), p2.getCoordinate());
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Created Line-filled Geometry: {} From {} and {}", new Object[]{WKTUtils$.MODULE$.write((Geometry)geo), WKTUtils$.MODULE$.write((Geometry)p1), WKTUtils$.MODULE$.write((Geometry)p2)});
                    boxedUnit = BoxedUnit.UNIT;
                    return this.builder().buildFeature(this.nextId(), new Object[]{geo, t1, t2});
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this.builder().buildFeature(this.nextId(), new Object[]{geo, t1, t2});
            });
        }
        Iterator lineFeatures = iterator;
        return this.buffer((Iterator<SimpleFeature>)lineFeatures, super.bufferDistance());
    }

    public static final /* synthetic */ long $anonfun$createTube$2(LineGapFill $this, SimpleFeature sf) {
        return $this.getStartTime(sf).getTime();
    }

    public LineGapFill(SimpleFeatureCollection tubeFeatures, double bufferDistance, int maxBins) {
        super(tubeFeatures, bufferDistance, maxBins);
    }
}

