/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.tube;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Date;
import org.geotools.data.Query;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.tube.GapFill$;
import org.locationtech.geomesa.process.tube.InterpolatedGapFill;
import org.locationtech.geomesa.process.tube.LineGapFill;
import org.locationtech.geomesa.process.tube.NoGapFill;
import org.locationtech.geomesa.process.tube.TubeBuilder;
import org.locationtech.geomesa.process.tube.TubeResult;
import org.locationtech.geomesa.process.tube.TubeVisitor$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.iterators.DeduplicatingSimpleFeatureIterator;
import org.locationtech.geomesa.utils.iterators.DeduplicatingSimpleFeatureIterator$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.Intersects;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001B\u0010!\u0001-B\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t#\u0002\u0011\t\u0011)A\u0005\u000f\"A!\u000b\u0001BC\u0002\u0013\u0005a\t\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003H\u0011!!\u0006A!b\u0001\n\u0003)\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001B\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tO\u0002\u0011)\u0019!C\u0001?\"A\u0001\u000e\u0001B\u0001B\u0003%\u0001\r\u0003\u0005j\u0001\t\u0015\r\u0011\"\u0001k\u0011!q\u0007A!A!\u0002\u0013Y\u0007\u0002C8\u0001\u0005\u000b\u0007I\u0011\u00019\t\u0011Q\u0004!\u0011!Q\u0001\nED\u0001\"\u001e\u0001\u0003\u0006\u0004%\tA\u001e\u0005\t\u007f\u0002\u0011\t\u0011)A\u0005o\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001\"CA\f\u0001\u0001\u0007I\u0011AA\r\u0011%\t\t\u0003\u0001a\u0001\n\u0003\t\u0019\u0003\u0003\u0005\u00020\u0001\u0001\u000b\u0015BA\u000e\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!a\u0011\u0001\t\u0003\n)\u0005\u0003\u0005\u0002V\u0001\u0011\r\u0011\"\u0003k\u0011\u001d\t9\u0006\u0001Q\u0001\n-Dq!!\u0017\u0001\t\u0003\nYfB\u0005\u0002t\u0001\n\t\u0011#\u0001\u0002v\u0019Aq\u0004IA\u0001\u0012\u0003\t9\bC\u0004\u0002\u0002m!\t!a \t\u0013\u0005\u00055$%A\u0005\u0002\u0005\r\u0005\"CAM7E\u0005I\u0011AAN\u0005-!VOY3WSNLGo\u001c:\u000b\u0005\u0005\u0012\u0013\u0001\u0002;vE\u0016T!a\t\u0013\u0002\u000fA\u0014xnY3tg*\u0011QEJ\u0001\bO\u0016|W.Z:b\u0015\t9\u0003&\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001*\u0003\ry'oZ\u0002\u0001'\u0011\u0001A\u0006N\u001e\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001\u00027b]\u001eT\u0011!M\u0001\u0005U\u00064\u0018-\u0003\u00024]\t1qJ\u00196fGR\u0004\"!N\u001d\u000e\u0003YR!aI\u001c\u000b\u0005a\"\u0013!B5oI\u0016D\u0018B\u0001\u001e7\u0005U9Um\\'fg\u0006\u0004&o\\2fgN4\u0016n]5u_J\u0004\"\u0001P\"\u000e\u0003uR!AP \u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0001\u000b\u0015\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\t\u000b1aY8n\u0013\t!UHA\u0006MCjLHj\\4hS:<\u0017\u0001\u0004;vE\u00164U-\u0019;ve\u0016\u001cX#A$\u0011\u0005!{U\"A%\u000b\u0005)[\u0015AB:j[BdWM\u0003\u0002M\u001b\u0006!A-\u0019;b\u0015\tq\u0005&\u0001\u0005hK>$xn\u001c7t\u0013\t\u0001\u0016JA\fTS6\u0004H.\u001a$fCR,(/Z\"pY2,7\r^5p]\u0006iA/\u001e2f\r\u0016\fG/\u001e:fg\u0002\n\u0011CZ3biV\u0014XmQ8mY\u0016\u001cG/[8o\u0003I1W-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0011\u0002\r\u0019LG\u000e^3s+\u00051\u0006CA,\\\u001b\u0005A&B\u0001+Z\u0015\tQ\u0006&A\u0004pa\u0016tw-[:\n\u0005qC&A\u0002$jYR,'/A\u0004gS2$XM\u001d\u0011\u0002\u00115\f\u0007p\u00159fK\u0012,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0002G\u0006)1oY1mC&\u0011QM\u0019\u0002\u0005\u0019>tw-A\u0005nCb\u001c\u0006/Z3eA\u00059Q.\u0019=US6,\u0017\u0001C7bqRKW.\u001a\u0011\u0002\u0015\t,hMZ3s'&TX-F\u0001l!\t\tG.\u0003\u0002nE\n1Ai\\;cY\u0016\f1BY;gM\u0016\u00148+\u001b>fA\u00059Q.\u0019=CS:\u001cX#A9\u0011\u0005\u0005\u0014\u0018BA:c\u0005\rIe\u000e^\u0001\t[\u0006D()\u001b8tA\u00059q-\u00199GS2dW#A<\u0011\u0005adhBA={\u001b\u0005\u0001\u0013BA>!\u0003\u001d9\u0015\r\u001d$jY2L!! @\u0003\u000f\u001d\u000b\u0007OR5mY*\u00111\u0010I\u0001\tO\u0006\u0004h)\u001b7mA\u00051A(\u001b8jiz\"\"#!\u0002\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0002\u0016A\u0011\u0011\u0010\u0001\u0005\u0006\u000bF\u0001\ra\u0012\u0005\u0006%F\u0001\ra\u0012\u0005\b)F\u0001\n\u00111\u0001W\u0011\u0015q\u0016\u00031\u0001a\u0011\u00159\u0017\u00031\u0001a\u0011\u0015I\u0017\u00031\u0001l\u0011\u0015y\u0017\u00031\u0001r\u0011\u001d)\u0018\u0003%AA\u0002]\f!B]3tk2$8)\u00197d+\t\tY\u0002E\u0002z\u0003;I1!a\b!\u0005)!VOY3SKN,H\u000e^\u0001\u000fe\u0016\u001cX\u000f\u001c;DC2\u001cw\fJ3r)\u0011\t)#a\u000b\u0011\u0007\u0005\f9#C\u0002\u0002*\t\u0014A!\u00168ji\"I\u0011QF\n\u0002\u0002\u0003\u0007\u00111D\u0001\u0004q\u0012\n\u0014a\u0003:fgVdGoQ1mG\u0002\nQA^5tSR$B!!\n\u00026!9\u0011qG\u000bA\u0002\u0005e\u0012a\u00024fCR,(/\u001a\t\u0005\u0003w\ty$\u0004\u0002\u0002>)\u0019\u0011qG-\n\t\u0005\u0005\u0013Q\b\u0002\b\r\u0016\fG/\u001e:f\u0003%9W\r\u001e*fgVdG\u000f\u0006\u0002\u0002HA!\u0011\u0011JA)\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013a\u0002<jg&$xN\u001d\u0006\u0004\u0003oi\u0015\u0002BA*\u0003\u0017\u0012!bQ1mGJ+7/\u001e7u\u00039\u0011WO\u001a4fe\u0012K7\u000f^1oG\u0016\fqBY;gM\u0016\u0014H)[:uC:\u001cW\rI\u0001\bKb,7-\u001e;f)\u0019\t)#!\u0018\u0002h!9\u0011qL\rA\u0002\u0005\u0005\u0014AB:pkJ\u001cW\rE\u0002I\u0003GJ1!!\u001aJ\u0005M\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKN{WO]2f\u0011\u001d\tI'\u0007a\u0001\u0003W\nQ!];fef\u0004B!!\u001c\u0002p5\t1*C\u0002\u0002r-\u0013Q!U;fef\f1\u0002V;cKZK7/\u001b;peB\u0011\u0011pG\n\u00047\u0005e\u0004cA1\u0002|%\u0019\u0011Q\u00102\u0003\r\u0005s\u0017PU3g)\t\t)(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0003\u000bS3AVADW\t\tI\t\u0005\u0003\u0002\f\u0006UUBAAG\u0015\u0011\ty)!%\u0002\u0013Ut7\r[3dW\u0016$'bAAJE\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0015Q\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0002\u001e*\u001aq/a\"")
public class TubeVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private final SimpleFeatureCollection tubeFeatures;
    private final SimpleFeatureCollection featureCollection;
    private final Filter filter;
    private final long maxSpeed;
    private final long maxTime;
    private final double bufferSize;
    private final int maxBins;
    private final Enumeration.Value gapFill;
    private TubeResult resultCalc;
    private final double bufferDistance;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static Enumeration.Value $lessinit$greater$default$8() {
        return TubeVisitor$.MODULE$.$lessinit$greater$default$8();
    }

    public static Filter $lessinit$greater$default$3() {
        return TubeVisitor$.MODULE$.$lessinit$greater$default$3();
    }

    public java.util.List<Expression> getExpressions() {
        return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
    }

    private Logger logger$lzycompute() {
        TubeVisitor tubeVisitor = this;
        synchronized (tubeVisitor) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public SimpleFeatureCollection tubeFeatures() {
        return this.tubeFeatures;
    }

    public SimpleFeatureCollection featureCollection() {
        return this.featureCollection;
    }

    public Filter filter() {
        return this.filter;
    }

    public long maxSpeed() {
        return this.maxSpeed;
    }

    public long maxTime() {
        return this.maxTime;
    }

    public double bufferSize() {
        return this.bufferSize;
    }

    public int maxBins() {
        return this.maxBins;
    }

    public Enumeration.Value gapFill() {
        return this.gapFill;
    }

    public TubeResult resultCalc() {
        return this.resultCalc;
    }

    public void resultCalc_$eq(TubeResult x$1) {
        this.resultCalc = x$1;
    }

    public void visit(Feature feature) {
    }

    public CalcResult getResult() {
        return this.resultCalc();
    }

    private double bufferDistance() {
        return this.bufferDistance;
    }

    public void execute(SimpleFeatureSource source, Query query) {
        TubeBuilder tubeBuilder;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(22).append("Visiting source type: ").append(source.getClass().getName()).toString());
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        PropertyName geomProperty = package$.MODULE$.ff().property(source.getSchema().getGeometryDescriptor().getName());
        PropertyName dateProperty = package$.MODULE$.ff().property((String)source.getSchema().getUserData().get(SimpleFeatureTypes.Configs$.MODULE$.DefaultDtgField()));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(29).append("Querying with date property: ").append(dateProperty).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(33).append("Querying with geometry property: ").append(geomProperty).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Enumeration.Value value = this.gapFill();
        Enumeration.Value value2 = GapFill$.MODULE$.LINE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            tubeBuilder = new LineGapFill(this.tubeFeatures(), this.bufferDistance(), this.maxBins());
        } else {
            Enumeration.Value value4 = GapFill$.MODULE$.INTERPOLATED();
            Enumeration.Value value5 = value;
            tubeBuilder = !(value4 != null ? !value4.equals(value5) : value5 != null) ? new InterpolatedGapFill(this.tubeFeatures(), this.bufferDistance(), this.maxBins()) : new NoGapFill(this.tubeFeatures(), this.bufferDistance(), this.maxBins());
        }
        LineGapFill tubeBuilder2 = tubeBuilder;
        Iterator<SimpleFeature> tube = ((TubeBuilder)tubeBuilder2).createTube();
        CloseableIterator queryResults = CloseableIterator$.MODULE$.apply(tube, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CloseableIterator$.MODULE$.apply$default$2()).flatMap((Function1 & Serializable & scala.Serializable)sf -> {
            long sfMin = tubeBuilder2.getStartTime((SimpleFeature)sf).getTime();
            Date minDate = new Date(sfMin - this.maxTime() * 1000L);
            long sfMax = tubeBuilder2.getEndTime((SimpleFeature)sf).getTime();
            Date maxDate = new Date(sfMax + this.maxTime() * 1000L);
            PropertyIsGreaterThan dtg1 = package$.MODULE$.ff().greater((Expression)dateProperty, (Expression)package$.MODULE$.ff().literal((Object)minDate));
            PropertyIsLessThan dtg2 = package$.MODULE$.ff().less((Expression)dateProperty, (Expression)package$.MODULE$.ff().literal((Object)maxDate));
            Geometry geom = (Geometry)sf.getDefaultGeometry();
            Iterator geoms = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), geom.getNumGeometries()).toIterator().map((Function1 & Serializable & scala.Serializable)x$1 -> geom.getGeometryN(BoxesRunTime.unboxToInt((Object)x$1)));
            return SelfClosingIterator$.MODULE$.apply(geoms, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SelfClosingIterator$.MODULE$.apply$default$2()).flatMap((Function1 & Serializable & scala.Serializable)g -> {
                Intersects geomFilter = package$.MODULE$.ff().intersects((Expression)geomProperty, (Expression)package$.MODULE$.ff().literal(g));
                And combinedFilter = package$.MODULE$.ff().and((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)query.getFilter(), (List)new .colon.colon((Object)geomFilter, (List)new .colon.colon((Object)dtg1, (List)new .colon.colon((Object)dtg2, (List)new .colon.colon((Object)this.filter(), (List)Nil$.MODULE$)))))).asJava());
                return SelfClosingIterator$.MODULE$.apply(source.getFeatures((Filter)combinedFilter).features());
            });
        });
        ListFeatureCollection collection = new ListFeatureCollection((SimpleFeatureType)source.getSchema());
        package.WithClose$.MODULE$.apply((Object)new DeduplicatingSimpleFeatureIterator(queryResults, DeduplicatingSimpleFeatureIterator$.MODULE$.$lessinit$greater$default$2(), DeduplicatingSimpleFeatureIterator$.MODULE$.$lessinit$greater$default$3()), (Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)collection$1.add(x$1)));
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
        this.resultCalc_$eq(new TubeResult((SimpleFeatureCollection)collection));
    }

    public TubeVisitor(SimpleFeatureCollection tubeFeatures, SimpleFeatureCollection featureCollection, Filter filter, long maxSpeed, long maxTime, double bufferSize, int maxBins, Enumeration.Value gapFill) {
        this.tubeFeatures = tubeFeatures;
        this.featureCollection = featureCollection;
        this.filter = filter;
        this.maxSpeed = maxSpeed;
        this.maxTime = maxTime;
        this.bufferSize = bufferSize;
        this.maxBins = maxBins;
        this.gapFill = gapFill;
        GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
        LazyLogging.$init$((LazyLogging)this);
        this.resultCalc = new TubeResult((SimpleFeatureCollection)new EmptyFeatureCollection((SimpleFeatureType)featureCollection.getSchema()));
        this.bufferDistance = bufferSize > 0.0 ? bufferSize : (double)(maxSpeed * maxTime);
    }
}

