/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import org.geotools.data.DataAccess;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.index.stats.package;
import org.locationtech.geomesa.process.FeatureResult;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.analytic.MinMaxProcess$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.stats.MinMax;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DescribeProcess(title="Min/Max Process", description="Gets attribute bounds for a data set")
@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001\u0002\u000b\u0016\u0001\u0001BQa\u000e\u0001\u0005\u0002aBQa\u000f\u0001\u0005\u0002qBq\u0001 \u0001\u0012\u0002\u0013\u0005QpB\u0004\u0002$UA\t!!\n\u0007\rQ)\u0002\u0012AA\u0014\u0011\u00199T\u0001\"\u0001\u00022\u00191\u00111G\u0003\u0001\u0003kA\u0001\u0002S\u0004\u0003\u0002\u0003\u0006I!\u0010\u0005\t/\u001e\u0011\t\u0011)A\u00051\"I!n\u0002B\u0001B\u0003%\u0011Q\t\u0005\u0007o\u001d!\t!!\u0013\t\u0015\u0005Us\u0001#b\u0001\n\u0013\t9\u0006C\u0006\u0002j\u001d\u0001\r\u00111A\u0005\n\u0005-\u0004bCA:\u000f\u0001\u0007\t\u0019!C\u0005\u0003kB1\"!!\b\u0001\u0004\u0005\t\u0015)\u0003\u0002n!9\u00111Q\u0004\u0005B\u0005\u0015\u0005bBAM\u000f\u0011\u0005\u00131\u0014\u0005\u0007w\u001d!\t%!(\t\u000f\u0005UV\u0001\"\u0003\u00028\niQ*\u001b8NCb\u0004&o\\2fgNT!AF\f\u0002\u0011\u0005t\u0017\r\\=uS\u000eT!\u0001G\r\u0002\u000fA\u0014xnY3tg*\u0011!dG\u0001\bO\u0016|W.Z:b\u0015\taR$\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u001f\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011%K\u0017\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013\u0001\u00027b]\u001eT\u0011AJ\u0001\u0005U\u00064\u0018-\u0003\u0002)G\t1qJ\u00196fGR\u0004\"AK\u0016\u000e\u0003]I!\u0001L\f\u0003\u001d\u001d+w.T3tCB\u0013xnY3tgB\u0011a&N\u0007\u0002_)\u0011\u0001'M\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003eM\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002i\u0005\u00191m\\7\n\u0005Yz#a\u0003'bufdunZ4j]\u001e\fa\u0001P5oSRtD#A\u001d\u0011\u0005i\u0002Q\"A\u000b\u0002\u000f\u0015DXmY;uKR!Qh\u0012,j!\tqT)D\u0001@\u0015\t\u0001\u0015)\u0001\u0004tS6\u0004H.\u001a\u0006\u0003\u0005\u000e\u000bA\u0001Z1uC*\u0011A)H\u0001\tO\u0016|Go\\8mg&\u0011ai\u0010\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:DQ\u0001\u0013\u0002A\u0002u\n\u0001BZ3biV\u0014Xm\u001d\u0015\u0007\u000f*\u000b&k\u0015+\u0011\u0005-{U\"\u0001'\u000b\u00055s\u0015a\u00024bGR|'/\u001f\u0006\u00031\rK!\u0001\u0015'\u0003#\u0011+7o\u0019:jE\u0016\u0004\u0016M]1nKR,'/\u0001\u0003oC6,\u0017%\u0001%\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0002+\u0006\tC\u000b[3!M\u0016\fG/\u001e:fAM,G\u000fI8oA]D\u0017n\u00195!i>\u0004\u0013/^3ss\")qK\u0001a\u00011\u0006I\u0011\r\u001e;sS\n,H/\u001a\t\u00033\nt!A\u00171\u0011\u0005msV\"\u0001/\u000b\u0005u{\u0012A\u0002\u001fs_>$hHC\u0001`\u0003\u0015\u00198-\u00197b\u0013\t\tg,\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u0014aa\u0015;sS:<'BA1_Q\u00191&*\u00154TO\u0006\nq+I\u0001i\u0003\t\"\u0006.\u001a\u0011biR\u0014\u0018NY;uK\u0002\"x\u000eI4bi\",'\u000f\t2pk:$7\u000f\t4pe\"9!N\u0001I\u0001\u0002\u0004Y\u0017AB2bG\",G\r\u0005\u0002#Y&\u0011Qn\t\u0002\b\u0005>|G.Z1oQ)I'*U8TaJ\u001cH/^\u0011\u0002U\u0006\n\u0011/\u0001\u0012SKR,(O\u001c\u0011dC\u000eDW\r\u001a\u0011wC2,Xm\u001d\u0017!S\u001a\u0004\u0013M^1jY\u0006\u0014G.Z\u0001\u0004[&tW$\u0001\u0001\u0002\u00075\f\u00070H\u0001\u0002Q\u0011\u0011qo\u0015>\u0011\u0005-C\u0018BA=M\u00059!Um]2sS\n,'+Z:vYR\f\u0013a_\u0001\u001a\u001fV$\b/\u001e;!M\u0016\fG/\u001e:fA\r|G\u000e\\3di&|g.A\tfq\u0016\u001cW\u000f^3%I\u00164\u0017-\u001e7uIM*\u0012A \u0016\u0003W~\\#!!\u0001\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017q\u0016AC1o]>$\u0018\r^5p]&!\u0011qBA\u0003\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u000b\u0001\u0005M\u0011\u0011DA\u000e'\u0006}\u0001cA&\u0002\u0016%\u0019\u0011q\u0003'\u0003\u001f\u0011+7o\u0019:jE\u0016\u0004&o\\2fgN\fQ\u0001^5uY\u0016\f#!!\b\u0002\u001f5KgnL'bq\u0002\u0002&o\\2fgN\f#!!\t\u0002I\u001d+Go\u001d\u0011biR\u0014\u0018NY;uK\u0002\u0012w.\u001e8eg\u00022wN\u001d\u0011bA\u0011\fG/\u0019\u0011tKR\fQ\"T5o\u001b\u0006D\bK]8dKN\u001c\bC\u0001\u001e\u0006'\r)\u0011\u0011\u0006\t\u0005\u0003W\ti#D\u0001_\u0013\r\tyC\u0018\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005\u0015\"!D'j]6\u000b\u0007PV5tSR|'oE\u0003\bC\u0005]R\u0006\u0005\u0003\u0002:\u0005\u0005SBAA\u001e\u0015\rA\u0012Q\b\u0006\u0004\u0003\u007fI\u0012!B5oI\u0016D\u0018\u0002BA\"\u0003w\u0011QcR3p\u001b\u0016\u001c\u0018\r\u0015:pG\u0016\u001c8OV5tSR|'\u000f\u0005\u0003\u0002,\u0005\u001d\u0013BA7_)!\tY%a\u0014\u0002R\u0005M\u0003cAA'\u000f5\tQ\u0001C\u0003I\u0017\u0001\u0007Q\bC\u0003X\u0017\u0001\u0007\u0001\f\u0003\u0004k\u0017\u0001\u0007\u0011QI\u0001\u0005gR\fG/\u0006\u0002\u0002ZA!\u00111LA3\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014!B:uCR\u001c(bAA23\u0005)Q\u000f^5mg&!\u0011qMA/\u0005\u0011\u0019F/\u0019;\u0002\u0015I,7/\u001e7u\u0007\u0006d7-\u0006\u0002\u0002nA\u0019!&a\u001c\n\u0007\u0005EtCA\u0007GK\u0006$XO]3SKN,H\u000e^\u0001\u000fe\u0016\u001cX\u000f\u001c;DC2\u001cw\fJ3r)\u0011\t9(! \u0011\t\u0005-\u0012\u0011P\u0005\u0004\u0003wr&\u0001B+oSRD\u0011\"a \u000f\u0003\u0003\u0005\r!!\u001c\u0002\u0007a$\u0013'A\u0006sKN,H\u000e^\"bY\u000e\u0004\u0013!\u0002<jg&$H\u0003BA<\u0003\u000fCq!!#\u0011\u0001\u0004\tY)A\u0004gK\u0006$XO]3\u0011\t\u00055\u0015QS\u0007\u0003\u0003\u001fSA!!#\u0002\u0012*\u0019\u00111S\u000f\u0002\u000f=\u0004XM\\4jg&!\u0011qSAH\u0005\u001d1U-\u0019;ve\u0016\f\u0011bZ3u%\u0016\u001cX\u000f\u001c;\u0015\u0005\u00055DCBA<\u0003?\u000bI\u000bC\u0004\u0002\"J\u0001\r!a)\u0002\rM|WO]2f!\rq\u0014QU\u0005\u0004\u0003O{$aE*j[BdWMR3biV\u0014XmU8ve\u000e,\u0007bBAV%\u0001\u0007\u0011QV\u0001\u0006cV,'/\u001f\t\u0005\u0003_\u000b\t,D\u0001B\u0013\r\t\u0019,\u0011\u0002\u0006#V,'/_\u0001\rGJ,\u0017\r^3SKN,H\u000e\u001e\u000b\u0005\u0003[\nI\f\u0003\u0004\u0002VM\u0001\r\u0001\u0017")
public class MinMaxProcess
implements GeoMesaProcess,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        MinMaxProcess minMaxProcess = this;
        synchronized (minMaxProcess) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @DescribeResult(description="Output feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="The feature set on which to query") SimpleFeatureCollection features, @DescribeParameter(name="attribute", description="The attribute to gather bounds for") String attribute, @DescribeParameter(name="cached", description="Return cached values, if available", min=0, max=1) Boolean cached) {
        BoxedUnit boxedUnit;
        Predef$.MODULE$.require(attribute != null, (Function0 & Serializable & scala.Serializable)() -> "Attribute is a required field");
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Attempting min/max process on type {}", new Object[]{features.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        MinMaxVisitor visitor = new MinMaxVisitor(features, attribute, Option$.MODULE$.apply((Object)cached).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1)));
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    public Boolean execute$default$3() {
        return null;
    }

    public MinMaxProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }

    public static class MinMaxVisitor
    implements GeoMesaProcessVisitor,
    LazyLogging {
        private Stat stat;
        private final SimpleFeatureCollection features;
        private final String attribute;
        private final boolean cached;
        private FeatureResult resultCalc;
        private transient Logger logger;
        private volatile boolean bitmap$0;
        private volatile transient boolean bitmap$trans$0;

        public List<Expression> getExpressions() {
            return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
        }

        private Logger logger$lzycompute() {
            MinMaxVisitor minMaxVisitor = this;
            synchronized (minMaxVisitor) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        private Stat stat$lzycompute() {
            MinMaxVisitor minMaxVisitor = this;
            synchronized (minMaxVisitor) {
                if (!this.bitmap$0) {
                    this.stat = Stat$.MODULE$.apply((SimpleFeatureType)this.features.getSchema(), Stat$.MODULE$.MinMax(this.attribute));
                    this.bitmap$0 = true;
                }
            }
            return this.stat;
        }

        private Stat stat() {
            if (!this.bitmap$0) {
                return this.stat$lzycompute();
            }
            return this.stat;
        }

        private FeatureResult resultCalc() {
            return this.resultCalc;
        }

        private void resultCalc_$eq(FeatureResult x$1) {
            this.resultCalc = x$1;
        }

        public void visit(Feature feature) {
            this.stat().observe((SimpleFeature)feature);
        }

        public FeatureResult getResult() {
            if (this.resultCalc() != null) {
                return this.resultCalc();
            }
            return MinMaxProcess$.MODULE$.org$locationtech$geomesa$process$analytic$MinMaxProcess$$createResult(this.stat().toJson());
        }

        public void execute(SimpleFeatureSource source, Query query) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Running Geomesa min/max process on source type {}", new Object[]{source.getClass().getName()});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            DataAccess dataAccess = source.getDataStore();
            if (dataAccess instanceof package.HasGeoMesaStats) {
                FeatureResult featureResult;
                DataAccess dataAccess2 = dataAccess;
                Option option = ((package.HasGeoMesaStats)dataAccess2).stats().getMinMax((SimpleFeatureType)source.getSchema(), this.attribute, query.getFilter(), !this.cached);
                if (None$.MODULE$.equals(option)) {
                    featureResult = MinMaxProcess$.MODULE$.org$locationtech$geomesa$process$analytic$MinMaxProcess$$createResult("{}");
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    MinMax mm = (MinMax)some.value();
                    featureResult = MinMaxProcess$.MODULE$.org$locationtech$geomesa$process$analytic$MinMaxProcess$$createResult(mm.toJson());
                } else {
                    throw new MatchError((Object)option);
                }
                this.resultCalc_$eq(featureResult);
                return;
            }
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Running unoptimized min/max query on {}", new Object[]{dataAccess.getClass().getName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            SelfClosingIterator$.MODULE$.apply(this.features.features()).foreach((Function1 & Serializable & scala.Serializable)feature -> {
                this.visit(feature);
                return BoxedUnit.UNIT;
            });
        }

        public MinMaxVisitor(SimpleFeatureCollection features, String attribute, boolean cached) {
            this.features = features;
            this.attribute = attribute;
            this.cached = cached;
            GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
            LazyLogging.$init$((LazyLogging)this);
        }
    }
}

