/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.features.TransformSimpleFeature;
import org.locationtech.geomesa.features.TransformSimpleFeature$;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.planning.QueryPlanner$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.FeatureResult;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u000b\u0017\u0001\u0005B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"Aa\n\u0001B\u0001B\u0003%q\nC\u0003a\u0001\u0011\u0005\u0011\r\u0003\u0006h\u0001A\u0005\t1!Q\u0001\n!Dqa\u001e\u0001C\u0002\u0013%\u0001\u0010\u0003\u0004z\u0001\u0001\u0006Ia\u001b\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u0011\u0019a\b\u0001)A\u0005e\"9Q\u0010\u0001b\u0001\n\u0013q\bbBA\u0006\u0001\u0001\u0006Ia \u0005\u000b\u0003\u001b\u0001\u0001R1A\u0005\n\u0005=\u0001\"CA\t\u0001\t\u0007I\u0011BA\n\u0011!\t\t\u0003\u0001Q\u0001\n\u0005U\u0001\"CA\u0012\u0001\u0001\u0007I\u0011BA\u0013\u0011%\ty\u0003\u0001a\u0001\n\u0013\t\t\u0004\u0003\u0005\u0002>\u0001\u0001\u000b\u0015BA\u0014\u0011\u001d\ty\u0004\u0001C!\u0003\u0003Bq!!\u0014\u0001\t\u0003\ny\u0005C\u0004\u0002R\u0001!\t%a\u0015\u0003\u0019E+XM]=WSNLGo\u001c:\u000b\u0005]A\u0012!B9vKJL(BA\r\u001b\u0003\u001d\u0001(o\\2fgNT!a\u0007\u000f\u0002\u000f\u001d,w.\\3tC*\u0011QDH\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002?\u0005\u0019qN]4\u0004\u0001M!\u0001A\t\u00162!\t\u0019\u0003&D\u0001%\u0015\t)c%\u0001\u0003mC:<'\"A\u0014\u0002\t)\fg/Y\u0005\u0003S\u0011\u0012aa\u00142kK\u000e$\bCA\u00160\u001b\u0005a#BA\r.\u0015\tq#$A\u0003j]\u0012,\u00070\u0003\u00021Y\t)r)Z8NKN\f\u0007K]8dKN\u001ch+[:ji>\u0014\bC\u0001\u001a:\u001b\u0005\u0019$B\u0001\u001b6\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t1t'\u0001\u0005usB,7/\u00194f\u0015\u0005A\u0014aA2p[&\u0011!h\r\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0005gK\u0006$XO]3t!\tiD)D\u0001?\u0015\ty\u0004)\u0001\u0004tS6\u0004H.\u001a\u0006\u0003\u0003\n\u000bA\u0001Z1uC*\u00111IH\u0001\tO\u0016|Go\\8mg&\u0011QI\u0010\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:\faAZ5mi\u0016\u0014\bC\u0001%M\u001b\u0005I%B\u0001$K\u0015\tYe$A\u0004pa\u0016tw-[:\n\u00055K%A\u0002$jYR,'/\u0001\u0006qe>\u0004XM\u001d;jKN\u00042\u0001U*V\u001b\u0005\t&\"\u0001*\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\u000b&!B!se\u0006L\bC\u0001,^\u001d\t96\f\u0005\u0002Y#6\t\u0011L\u0003\u0002[A\u00051AH]8pizJ!\u0001X)\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039F\u000ba\u0001P5oSRtD\u0003\u00022eK\u001a\u0004\"a\u0019\u0001\u000e\u0003YAQa\u000f\u0003A\u0002qBQA\u0012\u0003A\u0002\u001dCQA\u0014\u0003A\u0002=\u000b1\u0001\u001f\u00134!\u0011\u0001\u0016n\u001b:\n\u0005)\f&A\u0002+va2,'\u0007\u0005\u0002ma6\tQN\u0003\u0002@]*\u0011qNS\u0001\bM\u0016\fG/\u001e:f\u0013\t\tXNA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016\u0004\"a];\u000e\u0003QT!a\u000f\u000e\n\u0005Y$(A\u0006+sC:\u001chm\u001c:n'&l\u0007\u000f\\3GK\u0006$XO]3\u0002\u0007M4G/F\u0001l\u0003\u0011\u0019h\r\u001e\u0011\u0002!Q\u0014\u0018M\\:g_Jlg)Z1ukJ,W#\u0001:\u0002#Q\u0014\u0018M\\:g_Jlg)Z1ukJ,\u0007%\u0001\u0004sKRL\b/Z\u000b\u0002\u007fB9\u0001+!\u0001\u0002\u0006\u0005\u0015\u0011bAA\u0002#\nIa)\u001e8di&|g.\r\t\u0004Y\u0006\u001d\u0011bAA\u0005[\ni1+[7qY\u00164U-\u0019;ve\u0016\fqA]3usB,\u0007%\u0001\u0007nC:,\u0018\r\u001c$jYR,'/F\u0001H\u0003Ii\u0017M\\;bYZK7/\u001b;SKN,H\u000e^:\u0016\u0005\u0005U\u0001\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005m\u0001)\u0001\u0006d_2dWm\u0019;j_:LA!a\b\u0002\u001a\t)B*[:u\r\u0016\fG/\u001e:f\u0007>dG.Z2uS>t\u0017aE7b]V\fGNV5tSR\u0014Vm];miN\u0004\u0013A\u0003:fgVdGoQ1mGV\u0011\u0011q\u0005\t\u0005\u0003S\tY#D\u0001\u0019\u0013\r\ti\u0003\u0007\u0002\u000e\r\u0016\fG/\u001e:f%\u0016\u001cX\u000f\u001c;\u0002\u001dI,7/\u001e7u\u0007\u0006d7m\u0018\u0013fcR!\u00111GA\u001d!\r\u0001\u0016QG\u0005\u0004\u0003o\t&\u0001B+oSRD\u0011\"a\u000f\u0011\u0003\u0003\u0005\r!a\n\u0002\u0007a$\u0013'A\u0006sKN,H\u000e^\"bY\u000e\u0004\u0013!\u0002<jg&$H\u0003BA\u001a\u0003\u0007Baa\u001c\nA\u0002\u0005\u0015\u0003\u0003BA$\u0003\u0013j\u0011A\\\u0005\u0004\u0003\u0017r'a\u0002$fCR,(/Z\u0001\nO\u0016$(+Z:vYR$\"!a\n\u0002\u000f\u0015DXmY;uKR1\u00111GA+\u0003?Bq!a\u0016\u0015\u0001\u0004\tI&\u0001\u0004t_V\u00148-\u001a\t\u0004{\u0005m\u0013bAA/}\t\u00192+[7qY\u00164U-\u0019;ve\u0016\u001cv.\u001e:dK\"1q\u0003\u0006a\u0001\u0003C\u0002B!a\u0019\u0002f5\t\u0001)C\u0002\u0002h\u0001\u0013Q!U;fef\u0004")
public class QueryVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private Filter manualFilter;
    private SimpleFeatureCollection features;
    private final Filter filter;
    private final String[] properties;
    private final /* synthetic */ Tuple2 x$3;
    private final SimpleFeatureType sft;
    private final TransformSimpleFeature transformFeature;
    private final Function1<SimpleFeature, SimpleFeature> retype;
    private final ListFeatureCollection manualVisitResults;
    private FeatureResult resultCalc;
    private transient Logger logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public List<Expression> getExpressions() {
        return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
    }

    private Logger logger$lzycompute() {
        QueryVisitor queryVisitor = this;
        synchronized (queryVisitor) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private SimpleFeatureType sft() {
        return this.sft;
    }

    private TransformSimpleFeature transformFeature() {
        return this.transformFeature;
    }

    private Function1<SimpleFeature, SimpleFeature> retype() {
        return this.retype;
    }

    private Filter manualFilter$lzycompute() {
        QueryVisitor queryVisitor = this;
        synchronized (queryVisitor) {
            if (!this.bitmap$0) {
                this.manualFilter = FastFilterFactory$.MODULE$.optimize((SimpleFeatureType)this.features.getSchema(), this.filter);
                this.bitmap$0 = true;
            }
        }
        this.features = null;
        return this.manualFilter;
    }

    private Filter manualFilter() {
        if (!this.bitmap$0) {
            return this.manualFilter$lzycompute();
        }
        return this.manualFilter;
    }

    private ListFeatureCollection manualVisitResults() {
        return this.manualVisitResults;
    }

    private FeatureResult resultCalc() {
        return this.resultCalc;
    }

    private void resultCalc_$eq(FeatureResult x$1) {
        this.resultCalc = x$1;
    }

    public void visit(Feature feature) {
        SimpleFeature sf = (SimpleFeature)feature;
        if (this.manualFilter().evaluate((Object)sf)) {
            this.manualVisitResults().add((SimpleFeature)this.retype().apply((Object)sf));
            return;
        }
    }

    public FeatureResult getResult() {
        return this.resultCalc();
    }

    public void execute(SimpleFeatureSource source, Query query) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running Geomesa query on source type {}", new Object[]{source.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        query.setFilter(package$.MODULE$.mergeFilters(query.getFilter(), this.filter));
        if (this.properties != null && this.properties.length > 0) {
            BoxedUnit boxedUnit2;
            List list = query.getProperties();
            List list2 = Query.ALL_PROPERTIES;
            if (list == null ? list2 != null : !((Object)list).equals(list2)) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder(67).append("Overriding inner query's properties (").append(query.getProperties()).append(") ").append("with properties/transforms ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.properties)).mkString(",")).append(".").toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            query.setPropertyNames(this.properties);
        }
        this.resultCalc_$eq(new FeatureResult(source.getFeatures(query)));
    }

    public QueryVisitor(SimpleFeatureCollection features, Filter filter, String[] properties) {
        Tuple2 tuple2;
        this.features = features;
        this.filter = filter;
        this.properties = properties;
        GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
        LazyLogging.$init$((LazyLogging)this);
        if (properties == null) {
            tuple2 = new Tuple2((Object)features.getSchema(), null);
        } else {
            Some some;
            Tuple3 tuple3;
            Option option;
            SimpleFeatureType original = (SimpleFeatureType)features.getSchema();
            Query query = new Query(original.getTypeName(), (Filter)Filter.INCLUDE);
            if (properties != null) {
                query.setPropertyNames(properties);
            }
            if (None$.MODULE$.equals(option = QueryPlanner$.MODULE$.extractQueryTransforms(original, query))) {
                tuple2 = new Tuple2((Object)original, null);
            } else if (option instanceof Some && (tuple3 = (Tuple3)(some = (Some)option).value()) != null) {
                SimpleFeatureType tsft = (SimpleFeatureType)tuple3._1();
                Seq tdefs = (Seq)tuple3._2();
                tuple2 = new Tuple2((Object)tsft, (Object)TransformSimpleFeature$.MODULE$.apply(tsft, tdefs));
            } else {
                throw new MatchError((Object)option);
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        SimpleFeatureType sft = (SimpleFeatureType)tuple22._1();
        TransformSimpleFeature transformFeature = (TransformSimpleFeature)tuple22._2();
        this.x$3 = new Tuple2((Object)sft, (Object)transformFeature);
        this.sft = (SimpleFeatureType)this.x$3._1();
        this.transformFeature = (TransformSimpleFeature)this.x$3._2();
        this.retype = this.transformFeature() == null ? (Function1 & Serializable & scala.Serializable)sf -> sf : (Function1 & Serializable & scala.Serializable)sf -> {
            this.transformFeature().setFeature(sf);
            return ScalaSimpleFeature$.MODULE$.copy((SimpleFeature)this.transformFeature());
        };
        this.manualVisitResults = new ListFeatureCollection(this.sft());
        this.resultCalc = new FeatureResult((SimpleFeatureCollection)this.manualVisitResults());
    }
}

