/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.transform;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Locale;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.transform.BinVisitor;
import org.locationtech.geomesa.utils.bin.AxisOrder$;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DescribeProcess(title="Binary Conversion", description="Converts a feature collection to binary format")
@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0002\u0005\u0001=AQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005\u0002-\u0012ACQ5o\u0007>tg/\u001a:tS>t\u0007K]8dKN\u001c(BA\u0003\u0007\u0003%!(/\u00198tM>\u0014XN\u0003\u0002\b\u0011\u00059\u0001O]8dKN\u001c(BA\u0005\u000b\u0003\u001d9Wm\\7fg\u0006T!a\u0003\u0007\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00199A\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\u0005Y\u0006twMC\u0001\u0016\u0003\u0011Q\u0017M^1\n\u0005]\u0011\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001a55\ta!\u0003\u0002\u001c\r\tqq)Z8NKN\f\u0007K]8dKN\u001c\bCA\u000f%\u001b\u0005q\"BA\u0010!\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\t#%\u0001\u0005usB,7/\u00194f\u0015\u0005\u0019\u0013aA2p[&\u0011QE\b\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u0002\t\u00059Q\r_3dkR,Gc\u0002\u0017<)\u001el7/\u001f\t\u0004[A\u0012T\"\u0001\u0018\u000b\u0005=\"\u0012\u0001B;uS2L!!\r\u0018\u0003\u0011%#XM]1u_J\u00042a\r\u001c9\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$!B!se\u0006L\bCA\u001a:\u0013\tQDG\u0001\u0003CsR,\u0007\"\u0002\u001f\u0003\u0001\u0004i\u0014\u0001\u00034fCR,(/Z:\u0011\u0005y*U\"A \u000b\u0005\u0001\u000b\u0015AB:j[BdWM\u0003\u0002C\u0007\u0006!A-\u0019;b\u0015\t!E\"\u0001\u0005hK>$xn\u001c7t\u0013\t1uHA\fTS6\u0004H.\u001a$fCR,(/Z\"pY2,7\r^5p]\"21\bS(Q#J\u0003\"!S'\u000e\u0003)S!a\u0013'\u0002\u000f\u0019\f7\r^8ss*\u0011qaQ\u0005\u0003\u001d*\u0013\u0011\u0003R3tGJL'-\u001a)be\u0006lW\r^3s\u0003\u0011q\u0017-\\3\"\u0003q\n1\u0002Z3tGJL\u0007\u000f^5p]\u0006\n1+\u0001\u0012J]B,H\u000f\t4fCR,(/\u001a\u0011d_2dWm\u0019;j_:\u0004Co\u001c\u0011rk\u0016\u0014\u0018\u0010\t\u0005\u0006+\n\u0001\rAV\u0001\u0006iJ\f7m\u001b\t\u0003/zs!\u0001\u0017/\u0011\u0005e#T\"\u0001.\u000b\u0005ms\u0011A\u0002\u001fs_>$h(\u0003\u0002^i\u00051\u0001K]3eK\u001aL!a\u00181\u0003\rM#(/\u001b8h\u0015\tiF\u0007\u000b\u0005U\u0011>\u0013\u0017kY3gC\u0005)\u0016%\u00013\u0002EQ\u0013\u0018mY6!M&,G\u000e\u001a\u0011u_\u0002*8/\u001a\u0011g_J\u0004#)\u0013(!e\u0016\u001cwN\u001d3t\u0003\ri\u0017N\\\u000f\u0002\u0001!)\u0001N\u0001a\u0001-\u0006!q-Z8nQ!9\u0007j\u00146RW\u00164\u0017%\u00015\"\u00031\fQeR3p[\u0016$(/\u001f\u0011gS\u0016dG\r\t;pAU\u001cX\r\t4pe\u0002\u0012\u0015J\u0014\u0011sK\u000e|'\u000fZ:\t\u000b9\u0014\u0001\u0019\u0001,\u0002\u0007\u0011$x\r\u000b\u0005n\u0011>\u0003\u0018+]3gC\u0005q\u0017%\u0001:\u0002C\u0011\u000bG/\u001a\u0011gS\u0016dG\r\t;pAU\u001cX\r\t4pe\u0002\u0012\u0015J\u0014\u0011sK\u000e|'\u000fZ:\t\u000bQ\u0014\u0001\u0019\u0001,\u0002\u000b1\f'-\u001a7)\u0011MDuJ^)xK\u001a\f\u0013\u0001^\u0011\u0002q\u0006\u0011C*\u00192fY\u00022\u0017.\u001a7eAQ|\u0007%^:fA\u0019|'\u000f\t\"J\u001d\u0002\u0012XmY8sINDQA\u001f\u0002A\u0002Y\u000b\u0011\"\u0019=jg>\u0013H-\u001a:)\u0011eDu\n`)~K\u001a\f\u0013A_\u0011\u0002}\u0006!\u0013\t_5tA=\u0014H-\u001a:![\u0001*\u0017\u000e\u001e5fe\u0002b\u0017\r\u001e7p]\u0002z'\u000f\t7p]2\fG\u000f\u000b\u0004\u0003\u0003\u0003\t\u0016q\u0001\t\u0004\u0013\u0006\r\u0011bAA\u0003\u0015\nqA)Z:de&\u0014WMU3tk2$\u0018EAA\u0005\u0003i)enY8eK\u0012\u0004c-Z1ukJ,\u0007eY8mY\u0016\u001cG/[8oQ)\u0001\u0011QBA\n\u0003+\t\u0016\u0011\u0004\t\u0004\u0013\u0006=\u0011bAA\t\u0015\nyA)Z:de&\u0014W\r\u0015:pG\u0016\u001c8/A\u0003uSRdW-\t\u0002\u0002\u0018\u0005\t\")\u001b8bef\u00043i\u001c8wKJ\u001c\u0018n\u001c8\"\u0005\u0005m\u0011AL\"p]Z,'\u000f^:!C\u00022W-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8!i>\u0004#-\u001b8bef\u0004cm\u001c:nCR\u0004")
public class BinConversionProcess
implements GeoMesaProcess,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        BinConversionProcess binConversionProcess = this;
        synchronized (binConversionProcess) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @DescribeResult(description="Encoded feature collection")
    public Iterator<byte[]> execute(@DescribeParameter(name="features", description="Input feature collection to query ") SimpleFeatureCollection features, @DescribeParameter(name="track", description="Track field to use for BIN records", min=0) String track, @DescribeParameter(name="geom", description="Geometry field to use for BIN records", min=0) String geom, @DescribeParameter(name="dtg", description="Date field to use for BIN records", min=0) String dtg, @DescribeParameter(name="label", description="Label field to use for BIN records", min=0) String label, @DescribeParameter(name="axisOrder", description="Axis order - either latlon or lonlat", min=0) String axisOrder) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running BIN encoding for {}", new Object[]{features.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SimpleFeatureType sft = (SimpleFeatureType)features.getSchema();
        Option geomField = Option$.MODULE$.apply((Object)geom).map((Function1 & Serializable & scala.Serializable)attribute -> BoxesRunTime.boxToInteger((int)BinConversionProcess.indexOf$1(attribute, sft)));
        Option dtgField = Option$.MODULE$.apply((Object)dtg).map((Function1 & Serializable & scala.Serializable)attribute -> BoxesRunTime.boxToInteger((int)BinConversionProcess.indexOf$1(attribute, sft))).orElse((Function0 & Serializable & scala.Serializable)() -> RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        Option trackField = Option$.MODULE$.apply((Object)track).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BinConversionProcess.$anonfun$execute$4(x$1))).map((Function1 & Serializable & scala.Serializable)attribute -> BoxesRunTime.boxToInteger((int)BinConversionProcess.indexOf$1(attribute, sft)));
        Option labelField = Option$.MODULE$.apply((Object)label).map((Function1 & Serializable & scala.Serializable)attribute -> BoxesRunTime.boxToInteger((int)BinConversionProcess.indexOf$1(attribute, sft)));
        Option axis = Option$.MODULE$.apply((Object)axisOrder).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            String string2 = string.toLowerCase(Locale.US);
            String string3 = "latlon";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return AxisOrder$.MODULE$.LatLon();
            }
            String string4 = string.toLowerCase(Locale.US);
            String string5 = "lonlat";
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                return AxisOrder$.MODULE$.LonLat();
            }
            throw new IllegalArgumentException(new StringBuilder(61).append("Invalid axis order '").append(string).append("'. Valid values are 'latlon' and 'lonlat'").toString());
        });
        BinVisitor visitor = new BinVisitor(sft, new BinaryOutputEncoder.EncodingOptions(geomField, dtgField, trackField, labelField, axis));
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    private static final int indexOf$1(String attribute, SimpleFeatureType sft$1) {
        int i = sft$1.indexOf(attribute);
        if (i == -1) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Attribute ").append(attribute).append(" doesn't exist in ").append(sft$1.getTypeName()).append(" ").append(SimpleFeatureTypes$.MODULE$.encodeType(sft$1)).toString());
        }
        return i;
    }

    public static final /* synthetic */ boolean $anonfun$execute$4(String x$1) {
        String string = x$1;
        String string2 = "id";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public BinConversionProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

