/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import java.io.Serializable;
import java.util.Date;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.util.ProgressListener;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction1;

@DescribeProcess(title="Track Label Process", description="Returns a single feature appropriate for labelling a track of features")
@ScalaSignature(bytes="\u0006\u0001m4Aa\u0001\u0003\u0001\u001f!)A\u0004\u0001C\u0001;!)\u0001\u0005\u0001C\u0001C\t\tBK]1dW2\u000b'-\u001a7Qe>\u001cWm]:\u000b\u0005\u00151\u0011\u0001C1oC2LH/[2\u000b\u0005\u001dA\u0011a\u00029s_\u000e,7o\u001d\u0006\u0003\u0013)\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\f\u0019\u0005aAn\\2bi&|g\u000e^3dQ*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!a\u0001\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\t1\fgn\u001a\u0006\u0002+\u0005!!.\u0019<b\u0013\t9\"C\u0001\u0004PE*,7\r\u001e\t\u00033ii\u0011AB\u0005\u00037\u0019\u0011abR3p\u001b\u0016\u001c\u0018\r\u0015:pG\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002\t\u00059Q\r_3dkR,G#\u0002\u0012-w93\u0006CA\u0012+\u001b\u0005!#BA\u0013'\u0003\u0019\u0019\u0018.\u001c9mK*\u0011q\u0005K\u0001\u0005I\u0006$\u0018M\u0003\u0002*\u0019\u0005Aq-Z8u_>d7/\u0003\u0002,I\t92+[7qY\u00164U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0005\u0006[\t\u0001\rAI\u0001\u0012M\u0016\fG/\u001e:f\u0007>dG.Z2uS>t\u0007F\u0002\u00170m]B\u0014\b\u0005\u00021i5\t\u0011G\u0003\u00023g\u00059a-Y2u_JL(BA\u0004)\u0013\t)\u0014GA\tEKN\u001c'/\u001b2f!\u0006\u0014\u0018-\\3uKJ\fAA\\1nK\u0006\nq%A\u0006eKN\u001c'/\u001b9uS>t\u0017%\u0001\u001e\u0002\u001d%s\u0007/\u001e;!M\u0016\fG/\u001e:fg\")AH\u0001a\u0001{\u0005)AO]1dWB\u0011ah\u0012\b\u0003\u007f\u0015\u0003\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\b\u0002\rq\u0012xn\u001c;?\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001*\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019\u001b\u0005FB\u001e0m-CD*I\u0001=C\u0005i\u0015\u0001\f+sC\u000e\\\u0007%\u0019;ue&\u0014W\u000f^3!i>\u0004So]3!M>\u0014\be\u001a:pkBLgn\u001a\u0011gK\u0006$XO]3t\u0011\u0015y%\u00011\u0001>\u0003\r!Go\u001a\u0015\t\u001d>2\u0014\u000b\u000f*U+\u0006\nq*I\u0001T\u0003%\"\u0015\r^3!CR$(/\u001b2vi\u0016\u0004Co\u001c\u0011vg\u0016\u0004cm\u001c:!_J$WM]5oO\u0002\"(/Y2lg\u0006\u0019Q.\u001b8\u001e\u0003\u0001AQa\u0016\u0002A\u0002a\u000bq!\\8oSR|'\u000f\u0005\u0002Z=6\t!L\u0003\u0002\\9\u0006!Q\u000f^5m\u0015\tiF\"A\u0004pa\u0016tw-[:\n\u0005}S&\u0001\u0005)s_\u001e\u0014Xm]:MSN$XM\\3sQ\u0019\u0011\u0011M\u000e39MB\u0011\u0001GY\u0005\u0003GF\u0012a\u0002R3tGJL'-\u001a*fgVdG/I\u0001f\u0003\u0019\u0011Xm];mi\u0006\nq-\u0001\bMC\n,G\u000e\t4fCR,(/Z:)\u0007\tI\u0017\u000fE\u0002kW6l\u0011aQ\u0005\u0003Y\u000e\u0013a\u0001\u001e5s_^\u001c\bC\u00018p\u001b\u0005\u0019\u0014B\u000194\u0005A\u0001&o\\2fgN,\u0005pY3qi&|gnI\u0001nQ\u0019\u00011O^<9sB\u0011\u0001\u0007^\u0005\u0003kF\u0012q\u0002R3tGJL'-\u001a)s_\u000e,7o]\u0001\u0006i&$H.Z\u0011\u0002q\u0006\u0019BK]1dW\u0002b\u0015MY3mAA\u0013xnY3tg\u0006\n!0\u0001$SKR,(O\\:!C\u0002\u001a\u0018N\\4mK\u00022W-\u0019;ve\u0016\u0004\u0013\r\u001d9s_B\u0014\u0018.\u0019;fA\u0019|'\u000f\t7bE\u0016dG.\u001b8hA\u0005\u0004CO]1dW\u0002zg\r\t4fCR,(/Z:")
public class TrackLabelProcess
implements GeoMesaProcess {
    @DescribeResult(name="result", description="Label features")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input features") SimpleFeatureCollection featureCollection, @DescribeParameter(name="track", description="Track attribute to use for grouping features") String track, @DescribeParameter(name="dtg", description="Date attribute to use for ordering tracks", min=0) String dtg, ProgressListener monitor) throws ProcessException {
        LazyRef sftString$lzy = new LazyRef();
        SimpleFeatureType sft = (SimpleFeatureType)featureCollection.getSchema();
        int trackField = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)track).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 != -1).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(32).append("Invalid track field ").append(track).append(" for schema ").append(TrackLabelProcess.sftString$1(sftString$lzy, sft)).toString());
        }));
        Option dtgField = Option$.MODULE$.apply((Object)dtg).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1))).orElse((Function0 & Serializable & scala.Serializable)() -> RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgIndex$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)));
        if (dtgField.exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 == -1)) {
            throw new IllegalArgumentException(new StringBuilder(32).append("Invalid track field ").append(track).append(" for schema ").append(TrackLabelProcess.sftString$1(sftString$lzy, sft)).toString());
        }
        ListFeatureCollection results = new ListFeatureCollection(sft);
        Map grouped = SelfClosingIterator$.MODULE$.apply(featureCollection).toSeq().groupBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getAttribute(trackField));
        Option option = dtgField;
        if (None$.MODULE$.equals(option)) {
            grouped.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TrackLabelProcess.$anonfun$execute$8(results, x0$1)));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            int d = BoxesRunTime.unboxToInt((Object)some.value());
            grouped.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TrackLabelProcess.$anonfun$execute$9(results, d, x0$2)));
        } else {
            throw new MatchError((Object)option);
        }
        return results;
    }

    private static final /* synthetic */ String sftString$lzycompute$1(LazyRef sftString$lzy$1, SimpleFeatureType sft$1) {
        String string;
        LazyRef lazyRef = sftString$lzy$1;
        synchronized (lazyRef) {
            string = sftString$lzy$1.initialized() ? (String)sftString$lzy$1.value() : (String)sftString$lzy$1.initialize((Object)new StringBuilder(2).append(sft$1.getTypeName()).append(": ").append(SimpleFeatureTypes$.MODULE$.encodeType(sft$1)).toString());
        }
        return string;
    }

    private static final String sftString$1(LazyRef sftString$lzy$1, SimpleFeatureType sft$1) {
        if (sftString$lzy$1.initialized()) {
            return (String)sftString$lzy$1.value();
        }
        return TrackLabelProcess.sftString$lzycompute$1(sftString$lzy$1, sft$1);
    }

    public static final /* synthetic */ boolean $anonfun$execute$8(ListFeatureCollection results$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Seq features = (Seq)tuple2._2();
            return results$1.add((SimpleFeature)features.head());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$execute$9(ListFeatureCollection results$1, int d$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Seq features = (Seq)tuple2._2();
            return results$1.add((SimpleFeature)features.maxBy((Function1 & Serializable & scala.Serializable)x$4 -> (Date)x$4.getAttribute(d$1), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
        }
        throw new MatchError((Object)tuple2);
    }
}

