/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.SchemaBuilder;
import org.locationtech.geomesa.utils.geotools.SchemaBuilder$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DescribeProcess(title="Point2PointProcess", description="Aggregates a collection of points into a collection of line segments")
@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001\u0002\u0005\n\u0001QAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u00042\u0001\u0001\u0006Ia\n\u0005\be\u0001\u0011\r\u0011\"\u00034\u0011\u0019a\u0004\u0001)A\u0005i!)Q\b\u0001C\u0001}!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\"A\u0005)pS:$(\u0007U8j]R\u0004&o\\2fgNT!AC\u0006\u0002\u0011\u0005t\u0017\r\\=uS\u000eT!\u0001D\u0007\u0002\u000fA\u0014xnY3tg*\u0011abD\u0001\bO\u0016|W.Z:b\u0015\t\u0001\u0012#\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\r\u0001Q#\b\t\u0003-mi\u0011a\u0006\u0006\u00031e\tA\u0001\\1oO*\t!$\u0001\u0003kCZ\f\u0017B\u0001\u000f\u0018\u0005\u0019y%M[3diB\u0011adH\u0007\u0002\u0017%\u0011\u0001e\u0003\u0002\u000f\u000f\u0016|W*Z:b!J|7-Z:t\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\t\u0011\"\u0001\u0005cCN,G+\u001f9f+\u00059\u0003C\u0001\u00150\u001b\u0005I#B\u0001\u0016,\u0003\u0019\u0019\u0018.\u001c9mK*\u0011A&L\u0001\bM\u0016\fG/\u001e:f\u0015\tq\u0013#A\u0004pa\u0016tw-[:\n\u0005AJ#!E*j[BdWMR3biV\u0014X\rV=qK\u0006I!-Y:f)f\u0004X\rI\u0001\u0003O\u001a,\u0012\u0001\u000e\t\u0003kij\u0011A\u000e\u0006\u0003oa\nAaZ3p[*\u0011\u0011hD\u0001\u0004UR\u001c\u0018BA\u001e7\u0005=9Um\\7fiJLh)Y2u_JL\u0018aA4gA\u00059Q\r_3dkR,G\u0003C I-&|'0a\u0002\u0011\u0005\u00013U\"A!\u000b\u0005)\u0012%BA\"E\u0003\u0011!\u0017\r^1\u000b\u0005\u0015\u000b\u0012\u0001C4f_R|w\u000e\\:\n\u0005\u001d\u000b%aF*j[BdWMR3biV\u0014XmQ8mY\u0016\u001cG/[8o\u0011\u0015\u0019e\u00011\u0001@Q\u0019A%*\u0015*T)B\u00111jT\u0007\u0002\u0019*\u0011QJT\u0001\bM\u0006\u001cGo\u001c:z\u0015\taA)\u0003\u0002Q\u0019\n\tB)Z:de&\u0014W\rU1sC6,G/\u001a:\u0002\t9\fW.Z\u0011\u0002\u0007\u0006YA-Z:de&\u0004H/[8oC\u0005)\u0016\u0001G%oaV$\bEZ3biV\u0014X\rI2pY2,7\r^5p]\")qK\u0002a\u00011\u0006iqM]8va&twMR5fY\u0012\u0004\"!\u00172\u000f\u0005i\u0003\u0007CA._\u001b\u0005a&BA/\u0014\u0003\u0019a$o\\8u})\tq,A\u0003tG\u0006d\u0017-\u0003\u0002b=\u00061\u0001K]3eK\u001aL!a\u00193\u0003\rM#(/\u001b8h\u0015\t\tg\f\u000b\u0004W\u0015F37kZ\u0011\u0002/\u0006\n\u0001.A\fGS\u0016dG\rI8oA]D\u0017n\u00195!i>\u0004sM]8va\")!N\u0002a\u00011\u0006I1o\u001c:u\r&,G\u000e\u001a\u0015\u0007S*\u000bFnU7\"\u0003)\f\u0013A\\\u0001+\r&,G\u000e\u001a\u0011p]\u0002:\b.[2iAQ|\u0007e]8si\u0002BS.^:uA\t,\u0007\u0005R1uK\u0002\"\u0018\u0010]3*\u0011\u0015\u0001h\u00011\u0001r\u0003%i\u0017N\u001c)pS:$8\u000f\u0005\u0002sg6\ta,\u0003\u0002u=\n\u0019\u0011J\u001c;)\r=T\u0015K^*yC\u00059\u0018!F7j]&lW/\u001c(v[\n,'o\u00144Q_&tGo]\u0011\u0002s\u0006AR*\u001b8j[Vl\u0007E\\;nE\u0016\u0014\be\u001c4!a>Lg\u000e^:\t\u000bm4\u0001\u0019\u0001?\u0002\u0015\t\u0014X-Y6P]\u0012\u000b\u0017\u0010\u0005\u0002s{&\u0011aP\u0018\u0002\b\u0005>|G.Z1oQ!Q(*UA\u0001'\u0006\r\u0011%A>\"\u0005\u0005\u0015\u0011A\b\"sK\u0006\\\u0007eY8o]\u0016\u001cG/[8og\u0002zg\u000e\t3bs\u0002j\u0017M]6t\u0011\u0019\tIA\u0002a\u0001y\u0006!b-\u001b7uKJ\u001c\u0016N\\4vY\u0006\u0014\bk\\5oiNDS\"a\u0002K#\u000651+a\u0004\u0002\u0014\u0005U\u0011EAA\u0005C\t\t\t\"A\u0018GS2$XM\u001d\u0011pkR\u00043/Z4nK:$8\u000f\t;iCR\u0004c-\u00197mA=t\u0007\u0005\u001e5fAM\fW.\u001a\u0011q_&tG/\u0001\u0007eK\u001a\fW\u000f\u001c;WC2,X-\t\u0002\u0002\u0018\u0005!AO];fQ%1\u00111D)\u0002\"M\u000b)\u0003E\u0002L\u0003;I1!a\bM\u00059!Um]2sS\n,'+Z:vYR\f#!a\t\u0002\rI,7/\u001e7uC\t\t9#A\u000fBO\u001e\u0014XmZ1uK\u0012\u0004c-Z1ukJ,\u0007eY8mY\u0016\u001cG/[8o\u000319W\r\u001e#bs>3\u0017,Z1s)\u0015\t\u0018QFA\u0019\u0011\u0019\tyc\u0002a\u0001c\u0006q1o\u001c:u\r&,G\u000eZ%oI\u0016D\bbBA\u001a\u000f\u0001\u0007\u0011QG\u0001\u0002MB\u0019\u0001&a\u000e\n\u0007\u0005e\u0012FA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\u0015\u000b\u0001\u0005u\u00121IA#'\u0006%\u0003cA&\u0002@%\u0019\u0011\u0011\t'\u0003\u001f\u0011+7o\u0019:jE\u0016\u0004&o\\2fgN\fQ\u0001^5uY\u0016\f#!a\u0012\u0002%A{\u0017N\u001c;3!>Lg\u000e\u001e)s_\u000e,7o]\u0011\u0003\u0003\u0017\nA)Q4he\u0016<\u0017\r^3tA\u0005\u00043m\u001c7mK\u000e$\u0018n\u001c8!_\u001a\u0004\u0003o\\5oiN\u0004\u0013N\u001c;pA\u0005\u00043m\u001c7mK\u000e$\u0018n\u001c8!_\u001a\u0004C.\u001b8fAM,w-\\3oiN\u0004")
public class Point2PointProcess
implements GeoMesaProcess {
    private final SimpleFeatureType baseType = SchemaBuilder$.MODULE$.toSchemaBuilder((SchemaBuilder.AttributeBuilder)SchemaBuilder$.MODULE$.builder().addLineString("geom", true)).build("point2point");
    private final GeometryFactory gf = JTSFactoryFinder.getGeometryFactory();

    private SimpleFeatureType baseType() {
        return this.baseType;
    }

    private GeometryFactory gf() {
        return this.gf;
    }

    @DescribeResult(name="result", description="Aggregated feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input feature collection") SimpleFeatureCollection data, @DescribeParameter(name="groupingField", description="Field on which to group") String groupingField, @DescribeParameter(name="sortField", description="Field on which to sort (must be Date type)") String sortField, @DescribeParameter(name="minimumNumberOfPoints", description="Minimum number of points") int minPoints, @DescribeParameter(name="breakOnDay", description="Break connections on day marks") boolean breakOnDay, @DescribeParameter(name="filterSingularPoints", description="Filter out segments that fall on the same point", defaultValue="true") boolean filterSingularPoints) {
        SimpleFeatureType queryType = (SimpleFeatureType)data.getSchema();
        SimpleFeatureTypeBuilder sftBuilder = new SimpleFeatureTypeBuilder();
        sftBuilder.init(this.baseType());
        int groupingFieldIndex = ((SimpleFeatureType)data.getSchema()).indexOf(groupingField);
        sftBuilder.add((AttributeDescriptor)queryType.getAttributeDescriptors().get(groupingFieldIndex));
        int sortFieldIndex = ((SimpleFeatureType)data.getSchema()).indexOf(sortField);
        AttributeDescriptor sortDesc = (AttributeDescriptor)queryType.getAttributeDescriptors().get(sortFieldIndex);
        String sortAttrName = sortDesc.getLocalName();
        Class sortType = sortDesc.getType().getBinding();
        sftBuilder.add(new StringBuilder(6).append(sortAttrName).append("_start").toString(), sortType);
        sftBuilder.add(new StringBuilder(4).append(sortAttrName).append("_end").toString(), sortType);
        SimpleFeatureType sft = sftBuilder.buildFeatureType();
        Iterable lineFeatures = (Iterable)((TraversableLike)SelfClosingIterator$.MODULE$.apply(data.features()).toList().groupBy((Function1 & Serializable & scala.Serializable)f -> String.valueOf(f.getAttribute(groupingFieldIndex))).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Point2PointProcess.$anonfun$execute$2(minPoints, x0$1)))).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> new ArrayOps.ofRef(Point2PointProcess.$anonfun$execute$3(this, sortFieldIndex, breakOnDay, groupingFieldIndex, sortAttrName, sft, filterSingularPoints, x0$2)), Iterable$.MODULE$.canBuildFrom());
        return new ListFeatureCollection(sft, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)lineFeatures.toList()).asJava());
    }

    public int getDayOfYear(int sortFieldIndex, SimpleFeature f) {
        return ZonedDateTime.ofInstant(DateUtils$.MODULE$.toInstant((Date)f.getAttribute(sortFieldIndex)), ZoneOffset.UTC).getDayOfYear();
    }

    public static final /* synthetic */ boolean $anonfun$execute$2(int minPoints$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            List coll = (List)tuple2._2();
            return coll.lengthCompare(minPoints$1) > 0;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$execute$6(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            List g = (List)tuple2._2();
            return g.lengthCompare(2) >= 0;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Object[] $anonfun$execute$3(Point2PointProcess $this, int sortFieldIndex$1, boolean breakOnDay$1, int groupingFieldIndex$1, String sortAttrName$1, SimpleFeatureType sft$1, boolean filterSingularPoints$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            List coll = (List)tuple2._2();
            List globalSorted = (List)coll.sortBy((Function1 & Serializable & scala.Serializable)x$1 -> (Date)Conversions.RichSimpleFeature$.MODULE$.get$extension0(Conversions$.MODULE$.RichSimpleFeature(x$1), sortFieldIndex$1), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            List[] groups = !breakOnDay$1 ? (List[])((Object[])new List[]{globalSorted}) : (List[])((TraversableOnce)((TraversableLike)globalSorted.groupBy((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToInteger((int)$this.getDayOfYear(sortFieldIndex$1, f))).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)Point2PointProcess.$anonfun$execute$6(x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    List g = (List)tuple2._2();
                    return g;
                }
                throw new MatchError((Object)tuple2);
            }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(List.class));
            Tuple2[] results = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groups)).flatMap((Function1 & Serializable & scala.Serializable)sorted -> sorted.sliding(2).zipWithIndex().map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 != null) {
                    List ptLst = (List)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    List pts = (List)ptLst.map((Function1 & Serializable & scala.Serializable)x$2 -> Conversions.RichSimpleFeature$.MODULE$.point$extension(Conversions$.MODULE$.RichSimpleFeature(x$2)).getCoordinate(), List$.MODULE$.canBuildFrom());
                    double length = JTS.orthodromicDistance((Coordinate)((Coordinate)pts.head()), (Coordinate)((Coordinate)pts.last()), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                    Object group = ((SimpleFeature)ptLst.head()).getAttribute(groupingFieldIndex$1);
                    Object startDtg = ((SimpleFeature)ptLst.head()).getAttribute(sortAttrName$1);
                    Object endDtg = ((SimpleFeature)ptLst.last()).getAttribute(sortAttrName$1);
                    Object[] attrs = new Object[]{$this.gf().createLineString((Coordinate[])pts.toArray(ClassTag$.MODULE$.apply(Coordinate.class))), group, startDtg, endDtg};
                    ScalaSimpleFeature sf = new ScalaSimpleFeature(sft$1, new StringBuilder(1).append(group).append("-").append(idx).toString(), attrs, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
                    return new Tuple2((Object)BoxesRunTime.boxToDouble((double)length), (Object)sf);
                }
                throw new MatchError((Object)tuple2);
            }), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            if (filterSingularPoints$1) {
                return Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])results)).collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Tuple2<Object, ScalaSimpleFeature>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 != null) {
                            double length = A1._1$mcD$sp();
                            ScalaSimpleFeature sf = (ScalaSimpleFeature)A1._2();
                            if (length > 0.0) {
                                return (B1)sf;
                            }
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Tuple2<Object, ScalaSimpleFeature> x1) {
                        double length;
                        Tuple2<Object, ScalaSimpleFeature> tuple2 = x1;
                        return tuple2 != null && (length = tuple2._1$mcD$sp()) > 0.0;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaSimpleFeature.class))));
            }
            return Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])results)).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 != null) {
                    ScalaSimpleFeature sf = (ScalaSimpleFeature)tuple2._2();
                    return sf;
                }
                throw new MatchError((Object)tuple2);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaSimpleFeature.class))));
        }
        throw new MatchError((Object)tuple2);
    }
}

