/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.FeatureResult;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001\u0002\t\u0012\u0001qA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005o!A!\t\u0001B\u0001B\u0003%1\tC\u0003J\u0001\u0011\u0005!\nC\u0004Q\u0001\t\u0007I\u0011B)\t\ri\u0003\u0001\u0015!\u0003S\u0011!Y\u0006\u0001#b\u0001\n\u0013\t\u0006b\u0002/\u0001\u0005\u0004%I!\u0018\u0005\u0007I\u0002\u0001\u000b\u0011\u00020\t\u000f\u0015\u0004\u0001\u0019!C\u0005M\"91\u000e\u0001a\u0001\n\u0013a\u0007B\u0002:\u0001A\u0003&q\rC\u0003t\u0001\u0011\u0005C\u000fC\u0003}\u0001\u0011\u0005S\u0010C\u0003\u007f\u0001\u0011\u0005sP\u0001\tQe>D\u0018.\\5usZK7/\u001b;pe*\u0011!cE\u0001\u0006cV,'/\u001f\u0006\u0003)U\tq\u0001\u001d:pG\u0016\u001c8O\u0003\u0002\u0017/\u00059q-Z8nKN\f'B\u0001\r\u001a\u00031awnY1uS>tG/Z2i\u0015\u0005Q\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u001eK1\u0002\"AH\u0012\u000e\u0003}Q!\u0001I\u0011\u0002\t1\fgn\u001a\u0006\u0002E\u0005!!.\u0019<b\u0013\t!sD\u0001\u0004PE*,7\r\u001e\t\u0003M)j\u0011a\n\u0006\u0003)!R!!K\u000b\u0002\u000b%tG-\u001a=\n\u0005-:#!F$f_6+7/\u0019)s_\u000e,7o\u001d,jg&$xN\u001d\t\u0003[Qj\u0011A\f\u0006\u0003_A\nAb]2bY\u0006dwnZ4j]\u001eT!!\r\u001a\u0002\u0011QL\b/Z:bM\u0016T\u0011aM\u0001\u0004G>l\u0017BA\u001b/\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\u001b%t\u0007/\u001e;GK\u0006$XO]3t!\tAt(D\u0001:\u0015\tQ4(\u0001\u0004tS6\u0004H.\u001a\u0006\u0003yu\nA\u0001Z1uC*\u0011a(G\u0001\tO\u0016|Go\\8mg&\u0011\u0001)\u000f\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:\fA\u0002Z1uC\u001a+\u0017\r^;sKN\faBY;gM\u0016\u0014\u0018J\\'fi\u0016\u00148\u000f\u0005\u0002E\u000f6\tQIC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tAUI\u0001\u0004E_V\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\t-kej\u0014\t\u0003\u0019\u0002i\u0011!\u0005\u0005\u0006m\u0011\u0001\ra\u000e\u0005\u0006\u0003\u0012\u0001\ra\u000e\u0005\u0006\u0005\u0012\u0001\raQ\u0001\bI^LG\u000f[5o+\u0005\u0011\u0006CA*Y\u001b\u0005!&BA+W\u0003\u00191\u0017\u000e\u001c;fe*\u0011q+G\u0001\b_B,gnZ5t\u0013\tIFK\u0001\u0004GS2$XM]\u0001\tI^LG\u000f[5oA\u0005aQ.\u00198vC24\u0015\u000e\u001c;fe\u0006\u0011R.\u00198vC24\u0016n]5u%\u0016\u001cX\u000f\u001c;t+\u0005q\u0006CA0c\u001b\u0005\u0001'BA1<\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003G\u0002\u0014Q\u0003T5ti\u001a+\u0017\r^;sK\u000e{G\u000e\\3di&|g.A\nnC:,\u0018\r\u001c,jg&$(+Z:vYR\u001c\b%\u0001\u0006sKN,H\u000e^\"bY\u000e,\u0012a\u001a\t\u0003Q&l\u0011aE\u0005\u0003UN\u0011QBR3biV\u0014XMU3tk2$\u0018A\u0004:fgVdGoQ1mG~#S-\u001d\u000b\u0003[B\u0004\"\u0001\u00128\n\u0005=,%\u0001B+oSRDq!]\u0006\u0002\u0002\u0003\u0007q-A\u0002yIE\n1B]3tk2$8)\u00197dA\u0005)a/[:jiR\u0011Q.\u001e\u0005\u0006m6\u0001\ra^\u0001\bM\u0016\fG/\u001e:f!\tA(0D\u0001z\u0015\t1h+\u0003\u0002|s\n9a)Z1ukJ,\u0017!C4fiJ+7/\u001e7u)\u00059\u0017aB3yK\u000e,H/\u001a\u000b\u0006[\u0006\u0005\u00111\u0002\u0005\b\u0003\u0007y\u0001\u0019AA\u0003\u0003\u0019\u0019x.\u001e:dKB\u0019\u0001(a\u0002\n\u0007\u0005%\u0011HA\nTS6\u0004H.\u001a$fCR,(/Z*pkJ\u001cW\r\u0003\u0004\u0013\u001f\u0001\u0007\u0011Q\u0002\t\u0005\u0003\u001f\t\t\"D\u0001<\u0013\r\t\u0019b\u000f\u0002\u0006#V,'/\u001f")
public class ProximityVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private Filter manualFilter;
    private SimpleFeatureCollection dataFeatures;
    private final double bufferInMeters;
    private final Filter dwithin;
    private final ListFeatureCollection manualVisitResults;
    private FeatureResult resultCalc;
    private transient Logger logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public List<Expression> getExpressions() {
        return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
    }

    private Logger logger$lzycompute() {
        ProximityVisitor proximityVisitor = this;
        synchronized (proximityVisitor) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Filter dwithin() {
        return this.dwithin;
    }

    private Filter manualFilter$lzycompute() {
        ProximityVisitor proximityVisitor = this;
        synchronized (proximityVisitor) {
            if (!this.bitmap$0) {
                this.manualFilter = FastFilterFactory$.MODULE$.optimize((SimpleFeatureType)this.dataFeatures.getSchema(), this.dwithin());
                this.bitmap$0 = true;
            }
        }
        this.dataFeatures = null;
        return this.manualFilter;
    }

    private Filter manualFilter() {
        if (!this.bitmap$0) {
            return this.manualFilter$lzycompute();
        }
        return this.manualFilter;
    }

    private ListFeatureCollection manualVisitResults() {
        return this.manualVisitResults;
    }

    private FeatureResult resultCalc() {
        return this.resultCalc;
    }

    private void resultCalc_$eq(FeatureResult x$1) {
        this.resultCalc = x$1;
    }

    public void visit(Feature feature) {
        SimpleFeature sf = (SimpleFeature)feature;
        if (this.manualFilter().evaluate((Object)sf)) {
            this.manualVisitResults().add(sf);
            return;
        }
    }

    public FeatureResult getResult() {
        return this.resultCalc();
    }

    public void execute(SimpleFeatureSource source, Query query) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running Geomesa Proximity Search on source type {}", new Object[]{source.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Filter combinedFilter = package$.MODULE$.mergeFilters(query.getFilter(), this.dwithin());
        this.resultCalc_$eq(new FeatureResult(source.getFeatures(combinedFilter)));
    }

    public ProximityVisitor(SimpleFeatureCollection inputFeatures, SimpleFeatureCollection dataFeatures, double bufferInMeters) {
        this.dataFeatures = dataFeatures;
        this.bufferInMeters = bufferInMeters;
        GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
        LazyLogging.$init$((LazyLogging)this);
        PropertyName geomProperty = package$.MODULE$.ff().property(dataFeatures.getSchema().getGeometryDescriptor().getName());
        CloseableIterator geomFilters = SelfClosingIterator$.MODULE$.apply(inputFeatures.features()).map((Function1 & Serializable & scala.Serializable)sf -> package$.MODULE$.ff().dwithin((Expression)geomProperty, (Expression)package$.MODULE$.ff().literal((Object)Conversions.RichSimpleFeature$.MODULE$.geometry$extension(Conversions$.MODULE$.RichSimpleFeature(sf))), $this.bufferInMeters, "meters"));
        this.dwithin = package$.MODULE$.orFilters(geomFilters.toSeq(), (FilterFactory)package$.MODULE$.ff());
        this.manualVisitResults = new ListFeatureCollection((SimpleFeatureType)dataFeatures.getSchema());
        this.resultCalc = new FeatureResult((SimpleFeatureCollection)this.manualVisitResults());
    }
}

