/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.transform;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter$;
import org.locationtech.geomesa.arrow.io.package;
import org.locationtech.geomesa.arrow.package;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@DescribeProcess(title="Arrow Conversion", description="Converts a feature collection to arrow format")
@ScalaSignature(bytes="\u0006\u0001\u0011%c\u0001B(Q\u0001mCQA\u001d\u0001\u0005\u0002MDQA\u001e\u0001\u0005\u0002]<q!a:Q\u0011\u0003\tIO\u0002\u0004P!\"\u0005\u00111\u001e\u0005\u0007e\u0012!\t!a=\u0007\r\u0005UH\u0001AA|\u0011)\u00119A\u0002B\u0001B\u0003%!\u0011\u0002\u0005\u000b\u000571!\u0011!Q\u0001\n\tu\u0001B\u0003B$\r\t\u0005\t\u0015!\u0003\u0002h!Q\u0011q\u0011\u0004\u0003\u0002\u0003\u0006IA!\u0013\t\u0015\u0005\u0005fA!A!\u0002\u0013\u0011Y\u0006\u0003\u0006\u0002.\u001a\u0011\t\u0011)A\u0005\u0005CB!Ba\u001a\u0007\u0005\u0003\u0005\u000b\u0011\u0002B2\u0011)\tIL\u0002B\u0001B\u0003%!\u0011\u000e\u0005\u0007e\u001a!\tAa\u001c\t\u0015\t\u0015e\u0001#b\u0001\n\u0013\u00119\tC\u0006\u0003*\u001a\u0001\r\u00111A\u0005\n\t\r\u0006b\u0003BV\r\u0001\u0007\t\u0019!C\u0005\u0005[C1Ba-\u0007\u0001\u0004\u0005\t\u0015)\u0003\u0003&\"9!Q\u0017\u0004\u0005B\t]\u0006b\u0002BH\r\u0011\u00053\u0011\b\u0005\u0007m\u001a!\te!\u0012\u0007\u0013\t-E\u0001%A\u0012\u0002\t5\u0005b\u0002BH/\u0019\u0005!\u0011\u0013\u0005\b\u0005C;b\u0011\u0001BR\r\u0019\u0019i\u0006\u0002\u0003\u0004`!Q!q\u0001\u000e\u0003\u0002\u0003\u0006IA!\u0003\t\u0015\tm!D!A!\u0002\u0013\u0011i\u0002\u0003\u0006\u0004bi\u0011\t\u0011)A\u0005\u0007GB!ba\u001f\u001b\u0005\u0003\u0005\u000b\u0011BB?\u0011)\tIL\u0007B\u0001B\u0003%!\u0011\u000e\u0005\u0007ej!\ta!\"\t\u0013\rM%D1A\u0005\n\rU\u0005\u0002CBR5\u0001\u0006Iaa&\t\u0013\r\u0015&D1A\u0005\n\r\u001d\u0006\u0002CB[5\u0001\u0006Ia!+\t\u0013\r]&\u00041A\u0005\n\re\u0006\"CBa5\u0001\u0007I\u0011BBb\u0011!\u00199M\u0007Q!\n\rm\u0006\"CBe5\t\u0007I\u0011BBf\u0011!\u00199N\u0007Q\u0001\n\r5\u0007b\u0002BH5\u0011\u00053\u0011\u001c\u0005\b\u0005CSB\u0011\tBR\r\u0019\u0019i\u000e\u0002\u0003\u0004`\"Q!q\u0001\u0017\u0003\u0002\u0003\u0006IA!\u0003\t\u0015\tmAF!A!\u0002\u0013\u0011i\u0002\u0003\u0006\u0004b1\u0012\t\u0011)A\u0005\u0007GB!\"a\"-\u0005\u0003\u0005\u000b\u0011\u0002B%\u0011)\u0019Y\b\fB\u0001B\u0003%1Q\u0010\u0005\u000b\u0005Ob#\u0011!Q\u0001\n\t\r\u0004BCA]Y\t\u0005\t\u0015!\u0003\u0003j!1!\u000f\fC\u0001\u0007CD\u0011\"!\u0005-\u0005\u0004%Iaa=\t\u0011\rmH\u0006)A\u0005\u0007kDqAa$-\t\u0003\u001ai\u0010C\u0004\u0003\"2\"\tEa)\t\u000f\u0011\u0005A\u0006\"\u0003\u0005\u0004\u00191!1\u0018\u0003A\u0005{C!B!);\u0005+\u0007I\u0011\u0001Bm\u0011%\u0011YN\u000fB\tB\u0003%\u0001\u0010\u0003\u0004su\u0011\u0005!Q\u001c\u0005\b\u0005CTD\u0011\tBr\u0011%\u0011)OOA\u0001\n\u0003\u00119\u000fC\u0005\u0003lj\n\n\u0011\"\u0001\u0003n\"I11\u0001\u001e\u0002\u0002\u0013\u00053Q\u0001\u0005\n\u0007\u0017Q\u0014\u0011!C\u0001\u0007\u001bA\u0011ba\u0004;\u0003\u0003%\ta!\u0005\t\u0013\rm!(!A\u0005B\ru\u0001\"CB\u0015u\u0005\u0005I\u0011AB\u0016\u0011%\u0019yCOA\u0001\n\u0003\u001a\t\u0004C\u0005\u00044i\n\t\u0011\"\u0011\u00046\u001dIAQ\u0004\u0003\u0002\u0002#\u0005Aq\u0004\u0004\n\u0005w#\u0011\u0011!E\u0001\tCAaA]%\u0005\u0002\u0011=\u0002\"\u0003C\u0019\u0013\u0006\u0005IQ\tC\u001a\u0011%!)$SA\u0001\n\u0003#9\u0004C\u0005\u0005<%\u000b\t\u0011\"!\u0005>!IAQI%\u0002\u0002\u0013%Aq\t\u0002\u0017\u0003J\u0014xn^\"p]Z,'o]5p]B\u0013xnY3tg*\u0011\u0011KU\u0001\niJ\fgn\u001d4pe6T!a\u0015+\u0002\u000fA\u0014xnY3tg*\u0011QKV\u0001\bO\u0016|W.Z:b\u0015\t9\u0006,\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001Z\u0003\ry'oZ\u0002\u0001'\u0011\u0001A\f\u001a5\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00027b]\u001eT\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\n1qJ\u00196fGR\u0004\"!\u001a4\u000e\u0003IK!a\u001a*\u0003\u001d\u001d+w.T3tCB\u0013xnY3tgB\u0011\u0011\u000e]\u0007\u0002U*\u00111\u000e\\\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003[:\f\u0001\u0002^=qKN\fg-\u001a\u0006\u0002_\u0006\u00191m\\7\n\u0005ET'a\u0003'bufdunZ4j]\u001e\fa\u0001P5oSRtD#\u0001;\u0011\u0005U\u0004Q\"\u0001)\u0002\u000f\u0015DXmY;uKR\t\u00020a\u0004\u0002B\u0005]\u00131MAC\u0003?\u000bY+a.\u0011\u0007edh0D\u0001{\u0015\tY\b-\u0001\u0003vi&d\u0017BA?{\u0005!IE/\u001a:bi>\u0014\b#B@\u0002\u0006\u0005%QBAA\u0001\u0015\t\t\u0019!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\b\u0005\u0005!!B!se\u0006L\bcA@\u0002\f%!\u0011QBA\u0001\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005E!\u00011\u0001\u0002\u0014\u0005Aa-Z1ukJ,7\u000f\u0005\u0003\u0002\u0016\u0005\rRBAA\f\u0015\u0011\tI\"a\u0007\u0002\rMLW\u000e\u001d7f\u0015\u0011\ti\"a\b\u0002\t\u0011\fG/\u0019\u0006\u0004\u0003CA\u0016\u0001C4f_R|w\u000e\\:\n\t\u0005\u0015\u0012q\u0003\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:DC\"a\u0004\u0002*\u0005]\u0012\u0011HA\u001e\u0003{\u0001B!a\u000b\u000245\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0004gC\u000e$xN]=\u000b\u0007M\u000by\"\u0003\u0003\u00026\u00055\"!\u0005#fg\u000e\u0014\u0018NY3QCJ\fW.\u001a;fe\u0006!a.Y7fC\t\t\t\"A\u0006eKN\u001c'/\u001b9uS>t\u0017EAA \u0003\tJe\u000e];uA\u0019,\u0017\r^;sK\u0002\u001aw\u000e\u001c7fGRLwN\u001c\u0011u_\u0002*gnY8eK\"9\u00111\t\u0002A\u0002\u0005\u0015\u0013aC5oG2,H-\u001a$jIN\u00042!XA$\u0013\r\tIE\u0018\u0002\b\u0005>|G.Z1oQA\t\t%!\u000b\u00028\u00055\u00131HA(\u0003'\n)&\t\u0002\u0002D\u0005\u0012\u0011\u0011K\u0001\"\u0013:\u001cG.\u001e3fA\u0019,\u0017\r^;sK\u0002JEi\u001d\u0011j]\u0002\n'O]8xA\u0019LG.Z\u0001\u0004[&tW$\u0001\u0001\t\u000f\u0005e#\u00011\u0001\u0002F\u0005I\u0001O]8ys\u001aKGm\u001d\u0015\u0011\u0003/\nI#a\u000e\u0002^\u0005m\u0012qLA*\u0003+\n#!!\u0017\"\u0005\u0005\u0005\u0014\u0001\f)s_bL\bEZ3biV\u0014X\rI%Eg\u0002\"x\u000eI5oiN\u0004\u0013N\\:uK\u0006$\u0007e\u001c4!gR\u0014\u0018N\\4t\u0011\u001d\t)G\u0001a\u0001\u0003O\nQBZ8s[\u0006$h+\u001a:tS>t\u0007\u0003BA5\u0003orA!a\u001b\u0002tA!\u0011QNA\u0001\u001b\t\tyGC\u0002\u0002ri\u000ba\u0001\u0010:p_Rt\u0014\u0002BA;\u0003\u0003\ta\u0001\u0015:fI\u00164\u0017\u0002BA=\u0003w\u0012aa\u0015;sS:<'\u0002BA;\u0003\u0003A\u0003#a\u0019\u0002*\u0005]\u0012qPA\u001e\u0003\u0003\u000b\u0019&!\u0016\"\u0005\u0005\u0015\u0014EAAB\u0003a\t%O]8xA%\u00036\t\t4pe6\fG\u000f\t<feNLwN\u001c\u0005\b\u0003\u000f\u0013\u0001\u0019AAE\u0003A!\u0017n\u0019;j_:\f'/\u001f$jK2$7\u000fE\u0003z\u0003\u0017\u000b9'C\u0002\u0002\u000ej\u0014A\u0001T5ti\"B\u0012QQA\u0015\u0003o\t\t*a\u000f\u0002\u0014\u0006M\u0013QKAL\u00033\u000bY*!(\"\u0005\u0005\u001d\u0015EAAK\u0003}\tE\u000f\u001e:jEV$Xm\u001d\u0011u_\u0002\"\u0017n\u0019;j_:\f'/\u001f\u0011f]\u000e|G-Z\u0001\u0004[\u0006DXD\u0001\u0001\u0001\u00049\u0019w\u000e\u001c7fGRLwN\u001c+za\u0016\u001c#!a\u001a\t\u000f\u0005\u0005&\u00011\u0001\u0002h\u0005I1o\u001c:u\r&,G\u000e\u001a\u0015\u0011\u0003?\u000bI#a\u000e\u0002&\u0006m\u0012qUA*\u0003+\n#!!)\"\u0005\u0005%\u0016\u0001F!uiJL'-\u001e;fAQ|\u0007e]8si\u0002\u0012\u0017\u0010C\u0004\u0002.\n\u0001\r!!\u0012\u0002\u0017M|'\u000f\u001e*fm\u0016\u00148/\u001a\u0015\u0011\u0003W\u000bI#a\u000e\u00022\u0006m\u00121WA*\u0003+\n#!!,\"\u0005\u0005U\u0016A\b*fm\u0016\u00148/\u001a\u0011uQ\u0016\u0004C-\u001a4bk2$\be]8si\u0002z'\u000fZ3s\u0011\u001d\tIL\u0001a\u0001\u0003w\u000b\u0011BY1uG\"\u001c\u0016N_3\u0011\u0007u\u000bi,C\u0002\u0002@z\u0013q!\u00138uK\u001e,'\u000f\u000b\t\u00028\u0006%\u0012qGAb\u0003w\t)-a\u0015\u0002V\u0005\u0012\u0011\u0011X\u0011\u0003\u0003\u000f\f!GT;nE\u0016\u0014\be\u001c4!M\u0016\fG/\u001e:fg\u0002\"x\u000eI5oG2,H-\u001a\u0011j]\u0002*\u0017m\u00195!e\u0016\u001cwN\u001d3!E\u0006$8\r\u001b\u0015\b\u0005\u0005-\u00171HAi!\u0011\tY#!4\n\t\u0005=\u0017Q\u0006\u0002\u000f\t\u0016\u001c8M]5cKJ+7/\u001e7uC\t\t\u0019.\u0001\u000eF]\u000e|G-\u001a3!M\u0016\fG/\u001e:fA\r|G\u000e\\3di&|g\u000eK\u0006\u0001\u0003/\fi.a8\u0002<\u0005\r\b\u0003BA\u0016\u00033LA!a7\u0002.\tyA)Z:de&\u0014W\r\u0015:pG\u0016\u001c8/A\u0003uSRdW-\t\u0002\u0002b\u0006\u0001\u0012I\u001d:po\u0002\u001auN\u001c<feNLwN\\\u0011\u0003\u0003K\fQfQ8om\u0016\u0014Ho\u001d\u0011bA\u0019,\u0017\r^;sK\u0002\u001aw\u000e\u001c7fGRLwN\u001c\u0011u_\u0002\n'O]8xA\u0019|'/\\1u\u0003Y\t%O]8x\u0007>tg/\u001a:tS>t\u0007K]8dKN\u001c\bCA;\u0005'\r!\u0011Q\u001e\t\u0004\u007f\u0006=\u0018\u0002BAy\u0003\u0003\u0011a!\u00118z%\u00164GCAAu\u00051\t%O]8x-&\u001c\u0018\u000e^8s'\u00151A,!?i!\u0011\tYPa\u0001\u000e\u0005\u0005u(bA*\u0002\u0000*\u0019!\u0011\u0001+\u0002\u000b%tG-\u001a=\n\t\t\u0015\u0011Q \u0002\u0016\u000f\u0016|W*Z:b!J|7-Z:t-&\u001c\u0018\u000e^8s\u0003\r\u0019h\r\u001e\t\u0005\u0005\u0017\u00119\"\u0004\u0002\u0003\u000e)!\u0011\u0011\u0004B\b\u0015\u0011\u0011\tBa\u0005\u0002\u000f\u0019,\u0017\r^;sK*\u0019!Q\u0003-\u0002\u000f=\u0004XM\\4jg&!!\u0011\u0004B\u0007\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0001\tK:\u001cw\u000eZ5oOB!!q\u0004B!\u001d\u0011\u0011\tCa\u000f\u000f\t\t\r\"Q\u0007\b\u0005\u0005K\u0011\tD\u0004\u0003\u0003(\t=b\u0002\u0002B\u0015\u0005[qA!!\u001c\u0003,%\t\u0011,\u0003\u0002X1&\u0011QKV\u0005\u0004\u0005g!\u0016!B1se><\u0018\u0002\u0002B\u001c\u0005s\taA^3di>\u0014(b\u0001B\u001a)&!!Q\bB \u0003M\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKZ+7\r^8s\u0015\u0011\u00119D!\u000f\n\t\t\r#Q\t\u0002\u0016'&l\u0007\u000f\\3GK\u0006$XO]3F]\u000e|G-\u001b8h\u0015\u0011\u0011iDa\u0010\u0002\u0015%\u00048MV3sg&|g\u000e\u0005\u0004\u0003L\tU\u0013q\r\b\u0005\u0005\u001b\u0012\tF\u0004\u0003\u0002n\t=\u0013BAA\u0002\u0013\u0011\u0011\u0019&!\u0001\u0002\u000fA\f7m[1hK&!!q\u000bB-\u0005\r\u0019V-\u001d\u0006\u0005\u0005'\n\t\u0001E\u0003\u0000\u0005;\n9'\u0003\u0003\u0003`\u0005\u0005!AB(qi&|g\u000eE\u0003\u0000\u0005;\u0012\u0019\u0007E\u0002\u0000\u0005KJA!!\u0013\u0002\u0002\u0005I\u0001O]3T_J$X\r\u001a\t\u0004\u007f\n-\u0014\u0002\u0002B7\u0003\u0003\u00111!\u00138u)I\u0011\tH!\u001e\u0003x\te$1\u0010B?\u0005\u007f\u0012\tIa!\u0011\u0007\tMd!D\u0001\u0005\u0011\u001d\u00119a\u0004a\u0001\u0005\u0013AqAa\u0007\u0010\u0001\u0004\u0011i\u0002C\u0004\u0003H=\u0001\r!a\u001a\t\u000f\u0005\u001du\u00021\u0001\u0003J!9\u0011\u0011U\bA\u0002\tm\u0003bBAW\u001f\u0001\u0007!\u0011\r\u0005\b\u0005Oz\u0001\u0019\u0001B2\u0011\u001d\tIl\u0004a\u0001\u0005S\nQ\"\\1ok\u0006dg+[:ji>\u0014XC\u0001BE!\r\u0011\u0019h\u0006\u0002\u0013\u0003J\u0014xn^'b]V\fGNV5tSR|'oE\u0002\u0018\u0003[\fQA^5tSR$BAa%\u0003\u001aB\u0019qP!&\n\t\t]\u0015\u0011\u0001\u0002\u0005+:LG\u000fC\u0004\u0003\u0012a\u0001\rAa'\u0011\t\t-!QT\u0005\u0005\u0005?\u0013iAA\u0007TS6\u0004H.\u001a$fCR,(/Z\u0001\be\u0016\u001cX\u000f\u001c;t+\t\u0011)\u000bE\u0003\u0003L\t\u001df0C\u0002~\u00053\naA]3tk2$\u0018A\u0003:fgVdGo\u0018\u0013fcR!!1\u0013BX\u0011%\u0011\tLEA\u0001\u0002\u0004\u0011)+A\u0002yIE\nqA]3tk2$\b%A\u0005hKR\u0014Vm];miR\u0011!\u0011\u0018\t\u0004\u0005gR$aC!se><(+Z:vYR\u001crA\u000fB`\u0005\u001b\u0014\u0019\u000e\u0005\u0003\u0003B\n%WB\u0001Bb\u0015\u0011\u0011)Ma2\u0002\u000fYL7/\u001b;pe*!!\u0011CA\u0010\u0013\u0011\u0011YMa1\u0003%\u0005\u00137\u000f\u001e:bGR\u001c\u0015\r\\2SKN,H\u000e\u001e\t\u0004\u007f\n=\u0017\u0002\u0002Bi\u0003\u0003\u0011q\u0001\u0015:pIV\u001cG\u000fE\u0002\u0000\u0005+LAAa6\u0002\u0002\ta1+\u001a:jC2L'0\u00192mKV\t\u00010\u0001\u0005sKN,H\u000e^:!)\u0011\u0011ILa8\t\r\t\u0005V\b1\u0001y\u0003!9W\r\u001e,bYV,GCAAw\u0003\u0011\u0019w\u000e]=\u0015\t\te&\u0011\u001e\u0005\t\u0005C{\u0004\u0013!a\u0001q\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BxU\rA(\u0011_\u0016\u0003\u0005g\u0004BA!>\u0003\u00006\u0011!q\u001f\u0006\u0005\u0005s\u0014Y0A\u0005v]\u000eDWmY6fI*!!Q`A\u0001\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u0003\u00119PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAB\u0004!\ri6\u0011B\u0005\u0004\u0003sr\u0016\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B5\u00039\u0001(o\u001c3vGR,E.Z7f]R$Baa\u0005\u0004\u001aA\u0019qp!\u0006\n\t\r]\u0011\u0011\u0001\u0002\u0004\u0003:L\b\"\u0003BY\u0007\u0006\u0005\t\u0019\u0001B5\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB\u0010!\u0019\u0019\tca\n\u0004\u00145\u001111\u0005\u0006\u0005\u0007K\t\t!\u0001\u0006d_2dWm\u0019;j_:L1!`B\u0012\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B2\u0007[A\u0011B!-F\u0003\u0003\u0005\raa\u0005\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!\u001b\u0002\r\u0015\fX/\u00197t)\u0011\u0011\u0019ga\u000e\t\u0013\tEv)!AA\u0002\rMA\u0003\u0002BJ\u0007wAqA!\u0005\u0016\u0001\u0004\u0019i\u0004\u0005\u0003\u0004@\r\u0005SB\u0001B\b\u0013\u0011\u0019\u0019Ea\u0004\u0003\u000f\u0019+\u0017\r^;sKR1!1SB$\u0007#Bqa!\u0013\u0017\u0001\u0004\u0019Y%\u0001\u0004t_V\u00148-\u001a\t\u0005\u0003+\u0019i%\u0003\u0003\u0004P\u0005]!aE*j[BdWMR3biV\u0014XmU8ve\u000e,\u0007bBB*-\u0001\u00071QK\u0001\u0006cV,'/\u001f\t\u0005\u0007/\u001aI&\u0004\u0002\u0002\u001c%!11LA\u000e\u0005\u0015\tV/\u001a:z\u0005a\u0019\u0016.\u001c9mK\u0006\u0013(o\\<NC:,\u0018\r\u001c,jg&$xN]\n\u00065\u00055(\u0011R\u0001\bSB\u001cw\n\u001d;t!\u0011\u0019)ga\u001e\u000e\u0005\r\u001d$\u0002BB5\u0007W\nq!\\3tg\u0006<WM\u0003\u0003\u0004n\r=\u0014aA5qG*!!qGB9\u0015\u0011\u0011\u0019da\u001d\u000b\u0007\rU\u0004,\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0007s\u001a9GA\u0005Ja\u000e|\u0005\u000f^5p]\u0006!1o\u001c:u!\u0015y(QLB@!\u001dy8\u0011QA4\u0005GJAaa!\u0002\u0002\t1A+\u001e9mKJ\"Bba\"\u0004\n\u000e-5QRBH\u0007#\u00032Aa\u001d\u001b\u0011\u001d\u00119\u0001\ta\u0001\u0005\u0013AqAa\u0007!\u0001\u0004\u0011i\u0002C\u0004\u0004b\u0001\u0002\raa\u0019\t\u000f\rm\u0004\u00051\u0001\u0004~!9\u0011\u0011\u0018\u0011A\u0002\t%\u0014aA8viV\u00111q\u0013\t\u0005\u00073\u001by*\u0004\u0002\u0004\u001c*\u00191Q\u00141\u0002\u0005%|\u0017\u0002BBQ\u00077\u0013QCQ=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fW.\u0001\u0003pkR\u0004\u0013!\u00022zi\u0016\u001cXCABU!\u0015\u0019Yk!-\u007f\u001b\t\u0019iK\u0003\u0003\u00040\u000e\r\u0012aB7vi\u0006\u0014G.Z\u0005\u0005\u0007g\u001biK\u0001\u0006MSN$()\u001e4gKJ\faAY=uKN\u0004\u0013!B2pk:$XCAB^!\ry8QX\u0005\u0005\u0007\u007f\u000b\tA\u0001\u0003M_:<\u0017!C2pk:$x\fJ3r)\u0011\u0011\u0019j!2\t\u0013\tEf%!AA\u0002\rm\u0016AB2pk:$\b%\u0001\u0004xe&$XM]\u000b\u0003\u0007\u001b\u0004Baa4\u0004T6\u00111\u0011\u001b\u0006\u0005\u0007;\u0013I$\u0003\u0003\u0004V\u000eE'\u0001H*j[BdWMR3biV\u0014X-\u0011:s_^4\u0015\u000e\\3Xe&$XM]\u0001\boJLG/\u001a:!)\u0011\u0011\u0019ja7\t\u000f\tE!\u00061\u0001\u0003\u001c\nI2i\\7qY\u0016D\u0018I\u001d:po6\u000bg.^1m-&\u001c\u0018\u000e^8s'\u0015a\u0013Q\u001eBE)A\u0019\u0019o!:\u0004h\u000e%81^Bw\u0007_\u001c\t\u0010E\u0002\u0003t1BqAa\u00025\u0001\u0004\u0011I\u0001C\u0004\u0003\u001cQ\u0002\rA!\b\t\u000f\r\u0005D\u00071\u0001\u0004d!9\u0011q\u0011\u001bA\u0002\t%\u0003bBB>i\u0001\u00071Q\u0010\u0005\b\u0005O\"\u0004\u0019\u0001B2\u0011\u001d\tI\f\u000ea\u0001\u0005S*\"a!>\u0011\r\r-6q\u001fBN\u0013\u0011\u0019Ip!,\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM]\u0001\nM\u0016\fG/\u001e:fg\u0002\"BAa%\u0004\u0000\"9!\u0011C\u001cA\u0002\tm\u0015a\u00032vS2$'+Z:vYR$bA!*\u0005\u0006\u0011]\u0001b\u0002C\u0004s\u0001\u0007A\u0011B\u0001\rI&\u001cG/[8oCJLWm\u001d\t\t\u0003S\"Y!a\u001a\u0005\u0010%!AQBA>\u0005\ri\u0015\r\u001d\t\u0005\t#!\u0019\"\u0004\u0002\u0003@%!AQ\u0003B \u0005=\t%O]8x\t&\u001cG/[8oCJL\bb\u0002C\rs\u0001\u0007A1D\u0001\u0007g>\u0014H/\u001a3\u0011\r\t-#q\u0015BN\u0003-\t%O]8x%\u0016\u001cX\u000f\u001c;\u0011\u0007\tM\u0014jE\u0003J\tG\u0011\u0019\u000eE\u0004\u0005&\u0011-\u0002P!/\u000e\u0005\u0011\u001d\"\u0002\u0002C\u0015\u0003\u0003\tqA];oi&lW-\u0003\u0003\u0005.\u0011\u001d\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011AqD\u0001\ti>\u001cFO]5oOR\u00111qA\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0005s#I\u0004\u0003\u0004\u0003\"2\u0003\r\u0001_\u0001\bk:\f\u0007\u000f\u001d7z)\u0011!y\u0004\"\u0011\u0011\t}\u0014i\u0006\u001f\u0005\n\t\u0007j\u0015\u0011!a\u0001\u0005s\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003q\u0003")
public class ArrowConversionProcess
implements GeoMesaProcess,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ArrowConversionProcess arrowConversionProcess = this;
        synchronized (arrowConversionProcess) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @DescribeResult(description="Encoded feature collection")
    public java.util.Iterator<byte[]> execute(@DescribeParameter(name="features", description="Input feature collection to encode") SimpleFeatureCollection features, @DescribeParameter(name="includeFids", description="Include feature IDs in arrow file", min=0) Boolean includeFids, @DescribeParameter(name="proxyFids", description="Proxy feature IDs to ints instead of strings", min=0) Boolean proxyFids, @DescribeParameter(name="formatVersion", description="Arrow IPC format version", min=0) String formatVersion, @DescribeParameter(name="dictionaryFields", description="Attributes to dictionary encode", min=0, max=128, collectionType=String.class) List<String> dictionaryFields, @DescribeParameter(name="sortField", description="Attribute to sort by", min=0) String sortField, @DescribeParameter(name="sortReverse", description="Reverse the default sort order", min=0) Boolean sortReverse, @DescribeParameter(name="batchSize", description="Number of features to include in each record batch", min=0) Integer batchSize) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running arrow encoding for {}", new Object[]{features.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SimpleFeatureType sft = (SimpleFeatureType)features.getSchema();
        Seq toEncode = (Seq)Option$.MODULE$.apply(dictionaryFields).map((Function1 & Serializable & scala.Serializable)x$1 -> ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        toEncode.foreach((Function1 & Serializable & scala.Serializable)attribute -> {
            ArrowConversionProcess.$anonfun$execute$3(sft, attribute);
            return BoxedUnit.UNIT;
        });
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(includeFids == null || Predef$.MODULE$.Boolean2boolean(includeFids), proxyFids != null && Predef$.MODULE$.Boolean2boolean(proxyFids));
        String ipcVersion = (String)Option$.MODULE$.apply((Object)formatVersion).getOrElse((Function0 & Serializable & scala.Serializable)() -> package.FormatVersion$.MODULE$.ArrowFormatVersion().get());
        Option reverse = Option$.MODULE$.apply((Object)sortReverse).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2));
        int batch = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)batchSize).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(package.ArrowProperties$.MODULE$.BatchSize().get())).toInt()));
        ArrowVisitor visitor = new ArrowVisitor(sft, encoding, ipcVersion, (Seq<String>)toEncode, (Option<String>)Option$.MODULE$.apply((Object)sortField), (Option<Object>)reverse, false, batch);
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    public static final /* synthetic */ void $anonfun$execute$3(SimpleFeatureType sft$1, String attribute) {
        if (sft$1.indexOf(attribute) == -1) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Attribute ").append(attribute).append(" doesn't exist in ").append(sft$1).toString());
        }
    }

    public ArrowConversionProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }

    public static interface ArrowManualVisitor {
        public void visit(SimpleFeature var1);

        public Iterator<byte[]> results();
    }

    public static class ArrowResult
    extends AbstractCalcResult
    implements Product,
    scala.Serializable {
        private final java.util.Iterator<byte[]> results;

        public java.util.Iterator<byte[]> results() {
            return this.results;
        }

        public Object getValue() {
            return this.results();
        }

        public ArrowResult copy(java.util.Iterator<byte[]> results) {
            return new ArrowResult(results);
        }

        public java.util.Iterator<byte[]> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "ArrowResult";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ArrowResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ArrowResult)) return false;
            boolean bl = true;
            if (!bl) return false;
            ArrowResult arrowResult = (ArrowResult)((Object)x$1);
            java.util.Iterator<byte[]> iterator = this.results();
            java.util.Iterator<byte[]> iterator2 = arrowResult.results();
            if (iterator == null) {
                if (iterator2 != null) {
                    return false;
                }
            } else if (!iterator.equals(iterator2)) return false;
            if (!arrowResult.canEqual((Object)this)) return false;
            return true;
        }

        public ArrowResult(java.util.Iterator<byte[]> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class ArrowVisitor
    implements GeoMesaProcessVisitor,
    LazyLogging {
        private ArrowManualVisitor manualVisitor;
        private final SimpleFeatureType sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final String ipcVersion;
        private final Seq<String> dictionaryFields;
        private final Option<String> sortField;
        private final Option<Object> sortReverse;
        private final boolean preSorted;
        private final int batchSize;
        private Iterator<byte[]> result;
        private transient Logger logger;
        private volatile boolean bitmap$0;
        private volatile transient boolean bitmap$trans$0;

        public List<Expression> getExpressions() {
            return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
        }

        private Logger logger$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        private ArrowManualVisitor manualVisitor$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if (!this.bitmap$0) {
                    Option sort = this.sortField.map((Function1 & Serializable & scala.Serializable)s -> new Tuple2(s, $this.sortReverse.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)));
                    IpcOption ipcOpts = package.FormatVersion$.MODULE$.options(this.ipcVersion);
                    this.manualVisitor = this.dictionaryFields.isEmpty() && (this.sortField.isEmpty() || this.preSorted) ? new SimpleArrowManualVisitor(this.sft, this.encoding, ipcOpts, (Option<Tuple2<String, Object>>)sort, this.batchSize) : new ComplexArrowManualVisitor(this.sft, this.encoding, ipcOpts, this.dictionaryFields, (Option<Tuple2<String, Object>>)sort, this.preSorted, this.batchSize);
                    this.bitmap$0 = true;
                }
            }
            return this.manualVisitor;
        }

        private ArrowManualVisitor manualVisitor() {
            if (!this.bitmap$0) {
                return this.manualVisitor$lzycompute();
            }
            return this.manualVisitor;
        }

        private Iterator<byte[]> result() {
            return this.result;
        }

        private void result_$eq(Iterator<byte[]> x$1) {
            this.result = x$1;
        }

        public ArrowResult getResult() {
            if (this.result() != null) {
                return new ArrowResult((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.result()).asJava());
            }
            return new ArrowResult((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.manualVisitor().results()).asJava());
        }

        public void visit(Feature feature) {
            this.manualVisitor().visit((SimpleFeature)feature);
        }

        public void execute(SimpleFeatureSource source, Query query) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Visiting source type: {}", new Object[]{source.getClass().getName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_ENCODE(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_DICTIONARY_FIELDS(), (Object)this.dictionaryFields.mkString(","));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.fids().isDefined()));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_PROXY_FID(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.fids().contains((Object)SimpleFeatureVector.SimpleFeatureEncoding$.Encoding$.MODULE$.Min())));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_BATCH_SIZE(), (Object)BoxesRunTime.boxToInteger((int)this.batchSize));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_FORMAT_VERSION(), (Object)this.ipcVersion);
            this.sortField.foreach((Function1 & Serializable & scala.Serializable)x$4 -> query.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_FIELD(), x$4));
            this.sortReverse.foreach((Function1 & Serializable & scala.Serializable)x$5 -> ArrowVisitor.$anonfun$execute$9(query, BoxesRunTime.unboxToBoolean((Object)x$5)));
            SelfClosingIterator features = SelfClosingIterator$.MODULE$.apply(source.getFeatures(query));
            this.result_$eq((Iterator<byte[]>)features.map((Function1 & Serializable & scala.Serializable)x$6 -> (byte[])x$6.getAttribute(0)));
        }

        public static final /* synthetic */ Object $anonfun$execute$9(Query query$1, boolean x$5) {
            return query$1.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_REVERSE(), (Object)BoxesRunTime.boxToBoolean((boolean)x$5));
        }

        public ArrowVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, String ipcVersion, Seq<String> dictionaryFields, Option<String> sortField, Option<Object> sortReverse, boolean preSorted, int batchSize) {
            this.sft = sft;
            this.encoding = encoding;
            this.ipcVersion = ipcVersion;
            this.dictionaryFields = dictionaryFields;
            this.sortField = sortField;
            this.sortReverse = sortReverse;
            this.preSorted = preSorted;
            this.batchSize = batchSize;
            GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
            LazyLogging.$init$((LazyLogging)this);
        }
    }

    private static class ComplexArrowManualVisitor
    implements ArrowManualVisitor {
        private final SimpleFeatureType sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final IpcOption ipcOpts;
        private final Seq<String> dictionaryFields;
        private final Option<Tuple2<String, Object>> sort;
        private final boolean preSorted;
        private final int batchSize;
        private final ArrayBuffer<SimpleFeature> features;

        private ArrayBuffer<SimpleFeature> features() {
            return this.features;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.features().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeature[]{ScalaSimpleFeature$.MODULE$.copy(feature)}));
        }

        @Override
        public Iterator<byte[]> results() {
            Iterator iterator;
            None$ ordering;
            Map map;
            if (this.dictionaryFields.isEmpty()) {
                map = Predef$.MODULE$.Map().empty();
            } else {
                Seq indicesAndValues = (Seq)this.dictionaryFields.map((Function1 & Serializable & scala.Serializable)field -> new Tuple3(field, (Object)BoxesRunTime.boxToInteger((int)$this.sft.indexOf(field)), (Object)HashSet$.MODULE$.empty()), Seq$.MODULE$.canBuildFrom());
                this.features().foreach((Function1 & Serializable & scala.Serializable)f -> {
                    indicesAndValues.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ComplexArrowManualVisitor.$anonfun$results$3(f, x0$1)));
                    return BoxedUnit.UNIT;
                });
                map = ((TraversableOnce)indicesAndValues.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple3 tuple3 = x0$2;
                    if (tuple3 != null) {
                        String n = (String)tuple3._1();
                        int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
                        HashSet v = (HashSet)tuple3._3();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n), (Object)ArrowDictionary$.MODULE$.create($this.sft.getTypeName(), (long)i, (Object[])v.toArray(ClassTag$.MODULE$.AnyRef()), ClassTag$.MODULE$.apply($this.sft.getDescriptor(i).getType().getBinding())));
                    }
                    throw new MatchError((Object)tuple3);
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
            Map dictionaries = map;
            None$ none$ = ordering = this.preSorted ? None$.MODULE$ : this.sort.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    String field = (String)tuple2._1();
                    boolean reverse = tuple2._2$mcZ$sp();
                    return SimpleFeatureOrdering$.MODULE$.apply($this.sft, field, reverse);
                }
                throw new MatchError((Object)tuple2);
            });
            if (None$.MODULE$.equals(none$)) {
                iterator = this.features().iterator();
            } else if (none$ instanceof Some) {
                Some some = (Some)none$;
                Ordering o = (Ordering)some.value();
                iterator = ((IndexedSeqLike)this.features().sorted(o)).iterator();
            } else {
                throw new MatchError((Object)none$);
            }
            Iterator sorted = iterator;
            return this.buildResult((Map<String, ArrowDictionary>)dictionaries, (Iterator<SimpleFeature>)sorted);
        }

        private Iterator<byte[]> buildResult(Map<String, ArrowDictionary> dictionaries, Iterator<SimpleFeature> sorted) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ListBuffer bytes = (ListBuffer)ListBuffer$.MODULE$.empty();
            package.WithClose$.MODULE$.apply((Object)SimpleFeatureArrowFileWriter$.MODULE$.apply((OutputStream)out, this.sft, dictionaries, this.encoding, this.ipcOpts, this.sort), (Function1 & Serializable & scala.Serializable)writer -> {
                ComplexArrowManualVisitor.$anonfun$buildResult$1(this, sorted, bytes, out, writer);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            bytes.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{out.toByteArray()}));
            return bytes.iterator();
        }

        public static final /* synthetic */ boolean $anonfun$results$3(SimpleFeature f$1, Tuple3 x0$1) {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
                HashSet v = (HashSet)tuple3._3();
                return v.add(f$1.getAttribute(i));
            }
            throw new MatchError((Object)tuple3);
        }

        public static final /* synthetic */ void $anonfun$buildResult$1(ComplexArrowManualVisitor $this, Iterator sorted$1, ListBuffer bytes$1, ByteArrayOutputStream out$1, SimpleFeatureArrowFileWriter writer) {
            while (sorted$1.hasNext()) {
                for (int i = 0; i < $this.batchSize && sorted$1.hasNext(); ++i) {
                    writer.add((SimpleFeature)sorted$1.next());
                }
                writer.flush();
                bytes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{out$1.toByteArray()}));
                out$1.reset();
            }
        }

        public ComplexArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, IpcOption ipcOpts, Seq<String> dictionaryFields, Option<Tuple2<String, Object>> sort, boolean preSorted, int batchSize) {
            this.sft = sft;
            this.encoding = encoding;
            this.ipcOpts = ipcOpts;
            this.dictionaryFields = dictionaryFields;
            this.sort = sort;
            this.preSorted = preSorted;
            this.batchSize = batchSize;
            this.features = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        }
    }

    private static class SimpleArrowManualVisitor
    implements ArrowManualVisitor {
        private final int batchSize;
        private final ByteArrayOutputStream out;
        private final ListBuffer<byte[]> bytes;
        private long count;
        private final SimpleFeatureArrowFileWriter writer;

        private ByteArrayOutputStream out() {
            return this.out;
        }

        private ListBuffer<byte[]> bytes() {
            return this.bytes;
        }

        private long count() {
            return this.count;
        }

        private void count_$eq(long x$1) {
            this.count = x$1;
        }

        private SimpleFeatureArrowFileWriter writer() {
            return this.writer;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.writer().add(feature);
            this.count_$eq(this.count() + 1L);
            if (this.count() % (long)this.batchSize == 0L) {
                this.writer().flush();
                this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
                this.out().reset();
                return;
            }
        }

        @Override
        public Iterator<byte[]> results() {
            package.CloseWithLogging$.MODULE$.apply((Object)this.writer(), IsCloseable$.MODULE$.closeableIsCloseable());
            this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
            return this.bytes().iterator();
        }

        public SimpleArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, IpcOption ipcOpts, Option<Tuple2<String, Object>> sort, int batchSize) {
            this.batchSize = batchSize;
            this.out = new ByteArrayOutputStream();
            this.bytes = (ListBuffer)ListBuffer$.MODULE$.empty();
            this.count = 0L;
            this.writer = SimpleFeatureArrowFileWriter$.MODULE$.apply((OutputStream)this.out(), sft, Predef$.MODULE$.Map().empty(), encoding, ipcOpts, sort);
        }
    }
}

