/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import java.awt.image.WritableRaster;
import java.io.Serializable;
import javax.media.jai.RasterFactory;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.data.Query;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.BBOXExpandingFilterVisitor;
import org.geotools.process.vector.HeatmapSurface;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.iterators.DensityScan$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.analytic.DensityProcess$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.jts.geom.Envelope;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@DescribeProcess(title="Density Map", description="Computes a density map over a set of features stored in Geomesa")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001\u0002\u0006\f\u0001YAQa\t\u0001\u0005\u0002\u0011BQa\n\u0001\u0005\u0002!Bq!!\u0017\u0001\t\u0003\tYfB\u0004\u00028.A\t!!/\u0007\r)Y\u0001\u0012AA^\u0011\u0019\u0019S\u0001\"\u0001\u0002D\"I\u0011QY\u0003C\u0002\u0013\u0005\u0011q\u0019\u0005\t\u0003\u001f,\u0001\u0015!\u0003\u0002J\"9\u0011\u0011[\u0003\u0005\u0002\u0005M'A\u0004#f]NLG/\u001f)s_\u000e,7o\u001d\u0006\u0003\u00195\t\u0001\"\u00198bYf$\u0018n\u0019\u0006\u0003\u001d=\tq\u0001\u001d:pG\u0016\u001c8O\u0003\u0002\u0011#\u00059q-Z8nKN\f'B\u0001\n\u0014\u00031awnY1uS>tG/Z2i\u0015\u0005!\u0012aA8sO\u000e\u00011c\u0001\u0001\u0018?A\u0011\u0001$H\u0007\u00023)\u0011!dG\u0001\u0005Y\u0006twMC\u0001\u001d\u0003\u0011Q\u0017M^1\n\u0005yI\"AB(cU\u0016\u001cG\u000f\u0005\u0002!C5\tQ\"\u0003\u0002#\u001b\tqq)Z8NKN\f\u0007K]8dKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001&!\t1\u0003!D\u0001\f\u0003\u001d)\u00070Z2vi\u0016$B\"K\u001aK)2\u001c\u0018QAA\n\u0003C\u0001\"AK\u0019\u000e\u0003-R!\u0001L\u0017\u0002\t\u001d\u0014\u0018\u000e\u001a\u0006\u0003]=\n\u0001bY8wKJ\fw-\u001a\u0006\u0003aM\t\u0001bZ3pi>|Gn]\u0005\u0003e-\u0012ab\u0012:jI\u000e{g/\u001a:bO\u0016\u0014D\tC\u00035\u0005\u0001\u0007Q'A\u0006pEN4U-\u0019;ve\u0016\u001c\bC\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003\u0019\u0019\u0018.\u001c9mK*\u0011!hL\u0001\u0005I\u0006$\u0018-\u0003\u0002=o\t92+[7qY\u00164U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0015\u0007gy*ei\u0012%\u0011\u0005}\u001aU\"\u0001!\u000b\u0005\u0005\u0013\u0015a\u00024bGR|'/\u001f\u0006\u0003\u001d=J!\u0001\u0012!\u0003#\u0011+7o\u0019:jE\u0016\u0004\u0016M]1nKR,'/\u0001\u0003oC6,\u0017%\u0001\u001e\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0002\u0013\u0006q\u0011J\u001c9vi\u00022W-\u0019;ve\u0016\u001c\b\"B&\u0003\u0001\u0004a\u0015aD1sOJ\u000bG-[;t!&DX\r\\:\u0011\u0005ai\u0015B\u0001(\u001a\u0005\u001dIe\u000e^3hKJDcA\u0013 F!\u001e\u0013\u0016%A)\u0002\u0019I\fG-[;t!&DX\r\\:\"\u0003M\u000baEU1eSV\u001c\be\u001c4!i\",\u0007\u0005Z3og&$\u0018\u0010I6fe:,G\u000eI5oAAL\u00070\u001a7t\u0011\u0015)&\u00011\u0001W\u0003-\t'oZ$f_6\fE\u000f\u001e:\u0011\u0005]\u0003gB\u0001-_!\tIF,D\u0001[\u0015\tYV#\u0001\u0004=e>|GO\u0010\u0006\u0002;\u0006)1oY1mC&\u0011q\fX\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0014'AB*ue&twM\u0003\u0002`9\"RAKP#e\u000f\u001aD\u0017N[6\"\u0003\u0015\f\u0001bZ3p[\u0006#HO]\u0011\u0002O\u0006Ac*Y7fA=4\u0007\u0005\u001e5fA\u001d,w.\\3uef\u0004\u0013\r\u001e;sS\n,H/\u001a\u0011u_\u0002\u0012XM\u001c3fe\u0006\u0019Q.\u001b8\u001e\u0003\u0001\t1!\\1y;\u0005\t\u0001\"B7\u0003\u0001\u00041\u0016!D1sO^+\u0017n\u001a5u\u0003R$(\u000f\u000b\u0006m}\u0015{w)\u001d5jU.\f\u0013\u0001]\u0001\u000bo\u0016Lw\r\u001b;BiR\u0014\u0018%\u0001:\u0002e9\u000bW.\u001a\u0011pM\u0002\"\b.\u001a\u0011biR\u0014\u0018NY;uK\u0002\"x\u000eI;tK\u00022wN\u001d\u0011eCR\f\u0007\u0005]8j]R\u0004s/Z5hQRDQ\u0001\u001e\u0002A\u0002U\fA\"\u0019:h\u001fV$\b/\u001e;F]Z\u0004\"A^>\u000e\u0003]T!\u0001_=\u0002\u0007)$8O\u0003\u0002{_\u0005Aq-Z8nKR\u0014\u00180\u0003\u0002}o\n\u0011\"+\u001a4fe\u0016t7-\u001a3F]Z,Gn\u001c9fQ\u001d\u0019h(\u0012@H\u0003\u0003\t\u0013a`\u0001\u000b_V$\b/\u001e;C\u0005>C\u0016EAA\u0002\u0003i\u0011u.\u001e8eS:<\u0007EY8yA=4\u0007\u0005\u001e5fA=,H\u000f];u\u0011\u0019\t9A\u0001a\u0001\u0019\u0006q\u0011M]4PkR\u0004X\u000f^,jIRD\u0007&CA\u0003}\u0015\u000bYaRA\bC\t\ti!A\u0006pkR\u0004X\u000f^,jIRD\u0017EAA\t\u0003\u0001:\u0016\u000e\u001a;iA=4\u0007e\\;uaV$\bE]1ti\u0016\u0014\b%\u001b8!a&DX\r\\:\t\r\u0005U!\u00011\u0001M\u0003=\t'oZ(viB,H\u000fS3jO\"$\b&CA\n}\u0015\u000bIbRA\u000fC\t\tY\"\u0001\u0007pkR\u0004X\u000f\u001e%fS\u001eDG/\t\u0002\u0002 \u0005\t\u0003*Z5hQR\u0004sN\u001a\u0011pkR\u0004X\u000f\u001e\u0011sCN$XM\u001d\u0011j]\u0002\u0002\u0018\u000e_3mg\"9\u00111\u0005\u0002A\u0002\u0005\u0015\u0012aB7p]&$xN\u001d\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\u0011)H/\u001b7\u000b\u0007\u0005=r&A\u0002ba&LA!a\r\u0002*\t\u0001\u0002K]8he\u0016\u001c8\u000fT5ti\u0016tWM\u001d\u0015\n\u0005\u0005]R)!\u0010H\u0003\u0003\u00022aPA\u001d\u0013\r\tY\u0004\u0011\u0002\u000f\t\u0016\u001c8M]5cKJ+7/\u001e7uC\t\ty$\u0001\u0004sKN,H\u000e^\u0011\u0003\u0003\u0007\nQbT;uaV$\bE]1ti\u0016\u0014\b&\u0002\u0002\u0002H\u0005]\u0003CBA%\u0003\u0017\ny%D\u0001]\u0013\r\ti\u0005\u0018\u0002\u0007i\"\u0014xn^:\u0011\t\u0005E\u00131K\u0007\u0002\u0005&\u0019\u0011Q\u000b\"\u0003!A\u0013xnY3tg\u0016C8-\u001a9uS>t7EAA(\u0003-IgN^3siF+XM]=\u0015%\u0005u\u0013qMA8\u0003g\n9(a \u0002\b\u0006=\u00151\u0013\t\u0005\u0003?\n\u0019'\u0004\u0002\u0002b)\u0019!(!\f\n\t\u0005\u0015\u0014\u0011\r\u0002\u0006#V,'/\u001f\u0005\u0006\u0017\u000e\u0001\r\u0001\u0014\u0015\r\u0003OrT\tU$\u0002l!L'n[\u0011\u0003\u0003[\nADU1eSV\u001c\b\u0005^8!kN,\u0007EZ8sAQDW\rI6fe:,G\u000eC\u0003V\u0007\u0001\u0007a\u000bK\u0006\u0002py*Em\u00124iS*\\\u0007\"B7\u0004\u0001\u00041\u0006fCA:}\u0015{w)\u001d5jU.DQ\u0001^\u0002A\u0002UD\u0003\"a\u001e?\u000bz<\u00151P\u0011\u0003\u0003{\n\u0001fR3pe\u00164WM]3oG\u0016$\u0007EY8v]\u0012Lgn\u001a\u0011c_b\u0004sN\u001a\u0011uQ\u0016\u0004s.\u001e;qkRDa!a\u0002\u0004\u0001\u0004a\u0005&CA@}\u0015\u000bYaRABC\t\t))\u0001\u000eXS\u0012$\b\u000eI8gAQDW\rI8viB,H\u000f\t:bgR,'\u000f\u0003\u0004\u0002\u0016\r\u0001\r\u0001\u0014\u0015\n\u0003\u000fsT)!\u0007H\u0003\u0017\u000b#!!$\u00027!+\u0017n\u001a5uA=4\u0007\u0005\u001e5fA=,H\u000f];uAI\f7\u000f^3s\u0011\u001d\t\tj\u0001a\u0001\u0003;\n1\u0002^1sO\u0016$\u0018+^3ss\"9\u0011QS\u0002A\u0002\u0005]\u0015A\u0005;be\u001e,Go\u0012:jI\u001e+w.\\3uef\u0004B!!'\u0002 6\u0011\u00111\u0014\u0006\u0004Y\u0005u%b\u0001\u0018\u0002.%!\u0011\u0011UAN\u000519%/\u001b3HK>lW\r\u001e:zQ\u0015\u0019\u0011qIA,Q)\u0001\u0011qUAW\u0003_;\u00151\u0017\t\u0004\u007f\u0005%\u0016bAAV\u0001\nyA)Z:de&\u0014W\r\u0015:pG\u0016\u001c8/A\u0003uSRdW-\t\u0002\u00022\u0006YA)\u001a8tSRL\b%T1qC\t\t),A D_6\u0004X\u000f^3tA\u0005\u0004C-\u001a8tSRL\b%\\1qA=4XM\u001d\u0011bAM,G\u000fI8gA\u0019,\u0017\r^;sKN\u00043\u000f^8sK\u0012\u0004\u0013N\u001c\u0011HK>lWm]1\u0002\u001d\u0011+gn]5usB\u0013xnY3tgB\u0011a%B\n\u0004\u000b\u0005u\u0006\u0003BA%\u0003\u007fK1!!1]\u0005\u0019\te.\u001f*fMR\u0011\u0011\u0011X\u0001\u0014\t\u00164\u0017-\u001e7u%\u0006$\u0017.^:QSb,Gn]\u000b\u0003\u0003\u0013\u0004B!!\u0013\u0002L&\u0019\u0011Q\u001a/\u0003\u0007%sG/\u0001\u000bEK\u001a\fW\u000f\u001c;SC\u0012LWo\u001d)jq\u0016d7\u000fI\u0001\u0007M2L\u0007\u000fW-\u0015\t\u0005U\u00171\u001d\t\u0007\u0003\u0013\n9.a7\n\u0007\u0005eGLA\u0003BeJ\f\u0017\u0010\u0005\u0004\u0002J\u0005]\u0017Q\u001c\t\u0005\u0003\u0013\ny.C\u0002\u0002br\u0013QA\u00127pCRDa\u0001L\u0005A\u0002\u0005U\u0007")
public class DensityProcess
implements GeoMesaProcess {
    public static float[][] flipXY(float[][] fArray) {
        return DensityProcess$.MODULE$.flipXY(fArray);
    }

    public static int DefaultRadiusPixels() {
        return DensityProcess$.MODULE$.DefaultRadiusPixels();
    }

    @DescribeResult(name="result", description="Output raster")
    public GridCoverage2D execute(@DescribeParameter(name="data", description="Input features") SimpleFeatureCollection obsFeatures, @DescribeParameter(name="radiusPixels", description="Radius of the density kernel in pixels") Integer argRadiusPixels, @DescribeParameter(name="geomAttr", description="Name of the geometry attribute to render", min=0, max=1) String argGeomAttr, @DescribeParameter(name="weightAttr", description="Name of the attribute to use for data point weight", min=0, max=1) String argWeightAttr, @DescribeParameter(name="outputBBOX", description="Bounding box of the output") ReferencedEnvelope argOutputEnv, @DescribeParameter(name="outputWidth", description="Width of output raster in pixels") Integer argOutputWidth, @DescribeParameter(name="outputHeight", description="Height of output raster in pixels") Integer argOutputHeight, ProgressListener monitor) throws ProcessException {
        int pixels = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)argRadiusPixels).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> DensityProcess$.MODULE$.DefaultRadiusPixels()));
        int outputWidth = Predef$.MODULE$.Integer2int(argOutputWidth) + 2 * pixels;
        int outputHeight = Predef$.MODULE$.Integer2int(argOutputHeight) + 2 * pixels;
        double bufferWidth = (double)pixels * argOutputEnv.getWidth() / (double)Predef$.MODULE$.Integer2int(argOutputWidth);
        double bufferHeight = (double)pixels * argOutputEnv.getHeight() / (double)Predef$.MODULE$.Integer2int(argOutputHeight);
        ReferencedEnvelope envelope = new ReferencedEnvelope(argOutputEnv);
        envelope.expandBy(bufferWidth, bufferHeight);
        Function1 decode = DensityScan$.MODULE$.decodeResult((Envelope)envelope, outputWidth, outputHeight);
        HeatmapSurface heatMap = new HeatmapSurface(pixels, (Envelope)envelope, outputWidth, outputHeight);
        try {
            package.WithClose$.MODULE$.apply((Object)obsFeatures.features(), (Function1 & Serializable & scala.Serializable)features -> {
                DensityProcess.$anonfun$execute$3(decode, heatMap, features);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
        }
        catch (Exception e) {
            throw new ProcessException("Error processing heatmap", (Throwable)e);
        }
        float[][] heatMapGrid = DensityProcess$.MODULE$.flipXY(heatMap.computeSurface());
        WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)Predef$.MODULE$.Integer2int(argOutputWidth), (int)Predef$.MODULE$.Integer2int(argOutputHeight), (int)1, null);
        int i = pixels;
        for (int j = pixels; j < heatMapGrid.length - pixels; ++j) {
            float[] row = heatMapGrid[j];
            while (i < row.length - pixels) {
                raster.setSample(i - pixels, j - pixels, 0, row[i]);
                ++i;
            }
            i = pixels;
        }
        GridCoverageFactory gcf = CoverageFactoryFinder.getGridCoverageFactory((Hints)GeoTools.getDefaultHints());
        return gcf.create((CharSequence)"Process Results", raster, (Bounds)argOutputEnv);
    }

    public Query invertQuery(@DescribeParameter(name="radiusPixels", description="Radius to use for the kernel", min=0, max=1) Integer argRadiusPixels, @DescribeParameter(name="geomAttr", description="Name of the geometry attribute to render", min=0, max=1) String argGeomAttr, @DescribeParameter(name="weightAttr", description="Name of the attribute to use for data point weight", min=0, max=1) String argWeightAttr, @DescribeParameter(name="outputBBOX", description="Georeferenced bounding box of the output") ReferencedEnvelope argOutputEnv, @DescribeParameter(name="outputWidth", description="Width of the output raster") Integer argOutputWidth, @DescribeParameter(name="outputHeight", description="Height of the output raster") Integer argOutputHeight, Query targetQuery, GridGeometry targetGridGeometry) throws ProcessException {
        if (argOutputWidth == null || argOutputHeight == null) {
            throw new IllegalArgumentException("outputWidth and/or outputHeight not specified");
        }
        if (Predef$.MODULE$.Integer2int(argOutputWidth) < 0 || Predef$.MODULE$.Integer2int(argOutputHeight) < 0) {
            throw new IllegalArgumentException("outputWidth and outputHeight must both be positive");
        }
        int pixels = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)argRadiusPixels).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> DensityProcess$.MODULE$.DefaultRadiusPixels()));
        int outputWidth = Predef$.MODULE$.Integer2int(argOutputWidth) + 2 * pixels;
        int outputHeight = Predef$.MODULE$.Integer2int(argOutputHeight) + 2 * pixels;
        double bufferWidth = (double)pixels * argOutputEnv.getWidth() / (double)Predef$.MODULE$.Integer2int(argOutputWidth);
        double bufferHeight = (double)pixels * argOutputEnv.getHeight() / (double)Predef$.MODULE$.Integer2int(argOutputHeight);
        ReferencedEnvelope envelope = new ReferencedEnvelope(argOutputEnv);
        envelope.expandBy(bufferWidth, bufferHeight);
        double buf = package$.MODULE$.max(bufferWidth, bufferHeight);
        Filter filter = (Filter)targetQuery.getFilter().accept((FilterVisitor)new BBOXExpandingFilterVisitor(buf, buf, buf, buf), null);
        Query invertedQuery = new Query(targetQuery);
        invertedQuery.setFilter(filter);
        invertedQuery.setProperties(null);
        invertedQuery.getHints().put((Object)QueryHints$.MODULE$.DENSITY_BBOX(), (Object)envelope);
        invertedQuery.getHints().put((Object)QueryHints$.MODULE$.DENSITY_WIDTH(), (Object)BoxesRunTime.boxToInteger((int)outputWidth));
        invertedQuery.getHints().put((Object)QueryHints$.MODULE$.DENSITY_HEIGHT(), (Object)BoxesRunTime.boxToInteger((int)outputHeight));
        Object object = argGeomAttr != null ? invertedQuery.getHints().put((Object)QueryHints$.MODULE$.DENSITY_GEOM(), (Object)argGeomAttr) : BoxedUnit.UNIT;
        Object object2 = argWeightAttr != null ? invertedQuery.getHints().put((Object)QueryHints$.MODULE$.DENSITY_WEIGHT(), (Object)argWeightAttr) : BoxedUnit.UNIT;
        return invertedQuery;
    }

    public static final /* synthetic */ void $anonfun$execute$3(Function1 decode$1, HeatmapSurface heatMap$1, SimpleFeatureIterator features) {
        while (features.hasNext()) {
            Iterator pts = (Iterator)decode$1.apply((Object)features.next());
            while (pts.hasNext()) {
                Tuple3 tuple3 = (Tuple3)pts.next();
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                double x = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                double y = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                double weight = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)y), (Object)BoxesRunTime.boxToDouble((double)weight));
                double x2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                double y2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
                double weight2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
                heatMap$1.addPoint(x2, y2, weight2);
            }
        }
    }
}

