/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.filter.Filter;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.query.QueryVisitor;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DescribeProcess(title="Geomesa Query", description="Performs a Geomesa optimized query using spatiotemporal indexes")
@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\u0003\u0006\u0001AAQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005\u00021Bq\u0001\u001f\u0001\u0012\u0002\u0013\u0005\u0011P\u0001\u0007Rk\u0016\u0014\u0018\u0010\u0015:pG\u0016\u001c8O\u0003\u0002\u0007\u000f\u0005)\u0011/^3ss*\u0011\u0001\"C\u0001\baJ|7-Z:t\u0015\tQ1\"A\u0004hK>lWm]1\u000b\u00051i\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\t\u0012$\b\t\u0003%]i\u0011a\u0005\u0006\u0003)U\tA\u0001\\1oO*\ta#\u0001\u0003kCZ\f\u0017B\u0001\r\u0014\u0005\u0019y%M[3diB\u0011!dG\u0007\u0002\u000f%\u0011Ad\u0002\u0002\u000f\u000f\u0016|W*Z:b!J|7-Z:t!\tqR%D\u0001 \u0015\t\u0001\u0013%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002#G\u0005AA/\u001f9fg\u00064WMC\u0001%\u0003\r\u0019w.\\\u0005\u0003M}\u00111\u0002T1{s2{wmZ5oO\u00061A(\u001b8jiz\"\u0012!\u000b\t\u0003U\u0001i\u0011!B\u0001\bKb,7-\u001e;f)\u0011isGR+\u0011\u00059*T\"A\u0018\u000b\u0005A\n\u0014AB:j[BdWM\u0003\u00023g\u0005!A-\u0019;b\u0015\t!T\"\u0001\u0005hK>$xn\u001c7t\u0013\t1tFA\fTS6\u0004H.\u001a$fCR,(/Z\"pY2,7\r^5p]\")\u0001H\u0001a\u0001[\u0005Aa-Z1ukJ,7\u000f\u000b\u00048u\u0005\u00135\t\u0012\t\u0003w}j\u0011\u0001\u0010\u0006\u0003{y\nqAZ1di>\u0014\u0018P\u0003\u0002\tg%\u0011\u0001\t\u0010\u0002\u0012\t\u0016\u001c8M]5cKB\u000b'/Y7fi\u0016\u0014\u0018\u0001\u00028b[\u0016\f\u0013\u0001O\u0001\fI\u0016\u001c8M]5qi&|g.I\u0001F\u0003\u0005\"\u0006.\u001a\u0011gK\u0006$XO]3!g\u0016$\be\u001c8!o\"L7\r\u001b\u0011u_\u0002\nX/\u001a:z\u0011\u00159%\u00011\u0001I\u0003\u00191\u0017\u000e\u001c;feB\u0011\u0011*T\u0007\u0002\u0015*\u0011qi\u0013\u0006\u0003\u0019N\n1!\u00199j\u0013\tq%J\u0001\u0004GS2$XM\u001d\u0015\t\rj\n\u0005+\u0015*D'\u0006\nq)A\u0002nS:l\u0012\u0001A\u0011\u0002)\u0006iC\u000b[3!M&dG/\u001a:!i>\u0004\u0013\r\u001d9ms\u0002\"x\u000e\t;iK\u00022W-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8\t\u000fY\u0013\u0001\u0013!a\u0001/\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\u0007a[V,D\u0001Z\u0015\tQV#\u0001\u0003vi&d\u0017B\u0001/Z\u0005\u0011a\u0015n\u001d;\u0011\u0005y;gBA0f!\t\u00017-D\u0001b\u0015\t\u0011w\"\u0001\u0004=e>|GO\u0010\u0006\u0002I\u0006)1oY1mC&\u0011amY\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002gG\"bQKO!l#JcWN\\8Da\u0006\na+A\u0002nCbl\"\u0001\u0001A\u0002\u001d\r|G\u000e\\3di&|g\u000eV=qK\u000e\nQ,I\u0001r\u0003q\"\u0006.\u001a\u0011qe>\u0004XM\u001d;jKN|CO]1og\u001a|'/\\:!i>\u0004\u0013\r\u001d9ms\u0002\"x\u000e\t;iK\u00022W-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8)\t\t\u00198I\u001e\t\u0003wQL!!\u001e\u001f\u0003\u001d\u0011+7o\u0019:jE\u0016\u0014Vm];mi\u0006\nq/A\rPkR\u0004X\u000f\u001e\u0011gK\u0006$XO]3!G>dG.Z2uS>t\u0017!E3yK\u000e,H/\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\t!P\u000b\u0002Xw.\nA\u0010E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011!C;oG\",7m[3e\u0015\r\t\u0019aY\u0001\u000bC:tw\u000e^1uS>t\u0017bAA\u0004}\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3)\u0015\u0001\tY!!\u0005\u0002\u0014\r\u000b9\u0002E\u0002<\u0003\u001bI1!a\u0004=\u0005=!Um]2sS\n,\u0007K]8dKN\u001c\u0018!\u0002;ji2,\u0017EAA\u000b\u000359Um\\7fg\u0006\u0004\u0013+^3ss\u0006\u0012\u0011\u0011D\u0001@!\u0016\u0014hm\u001c:ng\u0002\n\u0007eR3p[\u0016\u001c\u0018\rI8qi&l\u0017N_3eAE,XM]=!kNLgn\u001a\u0011ta\u0006$\u0018n\u001c;f[B|'/\u00197!S:$W\r_3t\u0001")
public class QueryProcess
implements GeoMesaProcess,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        QueryProcess queryProcess = this;
        synchronized (queryProcess) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @DescribeResult(description="Output feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="The feature set on which to query") SimpleFeatureCollection features, @DescribeParameter(name="filter", min=0, description="The filter to apply to the feature collection") Filter filter, @DescribeParameter(name="properties", min=0, max=128, collectionType=String.class, description="The properties/transforms to apply to the feature collection") List<String> properties) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(33).append("Attempting Geomesa query on type ").append(features.getClass().getName()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String[] propsArray = (String[])Option$.MODULE$.apply(properties).map((Function1 & Serializable & scala.Serializable)x$1 -> (String[])x$1.toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)QueryProcess.$anonfun$execute$2(x$2))).orNull(Predef$.MODULE$.$conforms());
        QueryVisitor visitor = new QueryVisitor(features, (Filter)Option$.MODULE$.apply((Object)filter).getOrElse((Function0 & Serializable & scala.Serializable)() -> Filter.INCLUDE), propsArray);
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    public List<String> execute$default$3() {
        return null;
    }

    public static final /* synthetic */ boolean $anonfun$execute$2(String[] x$2) {
        return x$2.length > 0;
    }

    public QueryProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

