/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.query.RouteVisitor;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DescribeProcess(title="Route Search", description="Performs a search based on a route")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0002\u0005\u0001=AQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005\u0002-\u0012!CU8vi\u0016\u001cV-\u0019:dQB\u0013xnY3tg*\u0011QAB\u0001\u0006cV,'/\u001f\u0006\u0003\u000f!\tq\u0001\u001d:pG\u0016\u001c8O\u0003\u0002\n\u0015\u00059q-Z8nKN\f'BA\u0006\r\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u00111q\u0001\"!\u0005\f\u000e\u0003IQ!a\u0005\u000b\u0002\t1\fgn\u001a\u0006\u0002+\u0005!!.\u0019<b\u0013\t9\"C\u0001\u0004PE*,7\r\u001e\t\u00033ii\u0011AB\u0005\u00037\u0019\u0011abR3p\u001b\u0016\u001c\u0018\r\u0015:pG\u0016\u001c8\u000f\u0005\u0002\u001eI5\taD\u0003\u0002 A\u0005a1oY1mC2|wmZ5oO*\u0011\u0011EI\u0001\tif\u0004Xm]1gK*\t1%A\u0002d_6L!!\n\u0010\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\u000b\u0001\u000e\u0003\u0011\tq!\u001a=fGV$X\rF\u0005-m\u0015[EKW8v}B\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\u0007g&l\u0007\u000f\\3\u000b\u0005E\u0012\u0014\u0001\u00023bi\u0006T!a\r\u0007\u0002\u0011\u001d,w\u000e^8pYNL!!\u000e\u0018\u0003/MKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0007>dG.Z2uS>t\u0007\"B\u001c\u0003\u0001\u0004a\u0013\u0001\u00034fCR,(/Z:)\rYJ\u0004)\u0011\"D!\tQd(D\u0001<\u0015\taT(A\u0004gC\u000e$xN]=\u000b\u0005\u001d\u0011\u0014BA <\u0005E!Um]2sS\n,\u0007+\u0019:b[\u0016$XM]\u0001\u0005]\u0006lW-I\u00018\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0003\u0011\u000b!%\u00138qkR\u0004c-Z1ukJ,\u0007eY8mY\u0016\u001cG/[8oAQ|\u0007%];fef\u0004\u0003\"\u0002$\u0003\u0001\u0004a\u0013A\u0002:pkR,7\u000f\u000b\u0004Fs\u0001C%)S\u0011\u0002\r\u0006\n!*A\"S_V$Xm\u001d\u0011u_\u0002\u001aX-\u0019:dQ\u0002\nGn\u001c8h]\u00012U-\u0019;ve\u0016\u001c\b%\\;ti\u0002B\u0017M^3!C\u0002:Wm\\7fiJL\be\u001c4!\u0019&tWm\u0015;sS:<\u0007\"\u0002'\u0003\u0001\u0004i\u0015A\u00032vM\u001a,'oU5{KB\u0011\u0011CT\u0005\u0003\u001fJ\u0011a\u0001R8vE2,\u0007FB&:\u0001F\u0013%+I\u0001MC\u0005\u0019\u0016A\r\"vM\u001a,'\u000fI:ju\u0016\u0004\u0003&\u001b8![\u0016$XM]:*AQ|\u0007e]3be\u000eD\u0007%\u0019:pk:$\u0007\u0005\u001e5fAI|W\u000f^3\t\u000bU\u0013\u0001\u0019A'\u0002!!,\u0017\rZ5oORC'/Z:i_2$\u0007F\u0002+:\u0001^\u0013\u0005,I\u0001VC\u0005I\u0016\u0001\f+ie\u0016\u001c\bn\u001c7eA\u0019|'\u000fI2p[B\f'/\u001b8hA!,\u0017\rZ5oONd\u0003%\u001b8!I\u0016<'/Z3t\u0011\u0015Y&\u00011\u0001]\u00039\u0011x.\u001e;f\u000f\u0016|WNR5fY\u0012\u0004\"!\u00184\u000f\u0005y#\u0007CA0c\u001b\u0005\u0001'BA1\u000f\u0003\u0019a$o\\8u})\t1-A\u0003tG\u0006d\u0017-\u0003\u0002fE\u00061\u0001K]3eK\u001aL!a\u001a5\u0003\rM#(/\u001b8h\u0015\t)'\r\u000b\u0005[s\u0001S'i[7oC\u0005Y\u0016%\u00017\u0002\u0013\u0006#HO]5ckR,\u0007\u0005\u001e5bi\u0002:\u0018\u000e\u001c7!E\u0016\u0004S\r_1nS:,G\r\t4pe\u0002\u0012x.\u001e;fg\u0002\"x\u000eI7bi\u000eDg\u0006I'vgR\u0004#-\u001a\u0011bA1Kg.Z*ue&tw-A\u0002nS:l\u0012\u0001\u0001\u0005\u0006a\n\u0001\r\u0001X\u0001\nO\u0016|WNR5fY\u0012D\u0003b\\\u001dAe\n\u001bXN\\\u0011\u0002a\u0006\nA/\u0001%BiR\u0014\u0018NY;uK\u0002\"\b.\u0019;!o&dG\u000e\t2fA\u0015D\u0018-\\5oK\u0012\u0004cm\u001c:!e>,H/\u001a\u0011nCR\u001c\u0007.\u001b8h]\u0001jUo\u001d;!E\u0016\u0004\u0013\r\t'j]\u0016\u001cFO]5oO\")aO\u0001a\u0001o\u0006i!-\u001b3je\u0016\u001cG/[8oC2\u0004\"!\u0005=\n\u0005e\u0014\"a\u0002\"p_2,\u0017M\u001c\u0015\tkf\u00025P\u0011?n]\u0006\na/I\u0001~\u0003Yj\u0015\r^2iAQDW\r\t:pkR,\u0007\u0005Z5sK\u000e$\u0018n\u001c8!_J\u0004S.\u0019;dQ\u0002RWo\u001d;!i\",\u0007E]8vi\u0016\u0004\u0003/\u0019;i\u0011\u0015y(\u00011\u0001]\u00031AW-\u00193j]\u001e4\u0015.\u001a7eQ)q\u0018\bQA\u0002\u0005\u0006\u0015QN\\\u0011\u0002\u007f\u0006\u0012\u0011qA\u0001\u0002\u0004\u0005#HO]5ckR,\u0007\u0005\u001e5bi\u0002:\u0018\u000e\u001c7!E\u0016\u0004S\r_1nS:,G\r\t4pe\u0002BW-\u00193j]\u001e\u0004\u0013N\u001c\u0011uQ\u0016\u0004\u0013N\u001c9vi\u00022W-\u0019;ve\u0016\u001ch\u0006I%gA9|G\u000f\t9s_ZLG-\u001a3-A%t\u0007/\u001e;!M\u0016\fG/\u001e:fg\u0002:Wm\\7fiJLWm\u001d\u0011nkN$\bEY3!\u0019&tWm\u0015;sS:<7\u000f\u000b\u0004\u0003\u0003\u0017\u0011\u0015\u0011\u0003\t\u0004u\u00055\u0011bAA\bw\tqA)Z:de&\u0014WMU3tk2$\u0018EAA\n\u0003eyU\u000f\u001e9vi\u00022W-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8)\u0015\u0001\t9\"!\b\u0002 \t\u000b\u0019\u0003E\u0002;\u00033I1!a\u0007<\u0005=!Um]2sS\n,\u0007K]8dKN\u001c\u0018!\u0002;ji2,\u0017EAA\u0011\u00031\u0011v.\u001e;fAM+\u0017M]2iC\t\t)#\u0001\u0012QKJ4wN]7tA\u0005\u00043/Z1sG\"\u0004#-Y:fI\u0002zg\u000eI1!e>,H/\u001a")
public class RouteSearchProcess
implements GeoMesaProcess,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        RouteSearchProcess routeSearchProcess = this;
        synchronized (routeSearchProcess) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @DescribeResult(description="Output feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="Input feature collection to query ") SimpleFeatureCollection features, @DescribeParameter(name="routes", description="Routes to search along. Features must have a geometry of LineString") SimpleFeatureCollection routes, @DescribeParameter(name="bufferSize", description="Buffer size (in meters) to search around the route") Double bufferSize, @DescribeParameter(name="headingThreshold", description="Threshold for comparing headings, in degrees") Double headingThreshold, @DescribeParameter(name="routeGeomField", description="Attribute that will be examined for routes to match. Must be a LineString", min=0) String routeGeomField, @DescribeParameter(name="geomField", description="Attribute that will be examined for route matching. Must be a LineString", min=0) String geomField, @DescribeParameter(name="bidirectional", description="Match the route direction or match just the route path", min=0) Boolean bidirectional, @DescribeParameter(name="headingField", description="Attribute that will be examined for heading in the input features. If not provided, input features geometries must be LineStrings", min=0) String headingField) {
        String name;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Route searching on collection type {}", new Object[]{features.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Boolean bi = (Boolean)Option$.MODULE$.apply((Object)bidirectional).getOrElse((Function0 & Serializable & scala.Serializable)() -> Boolean.FALSE);
        SimpleFeatureType sft = (SimpleFeatureType)features.getSchema();
        String name2 = (String)Option$.MODULE$.apply((Object)geomField).getOrElse((Function0 & Serializable & scala.Serializable)() -> sft.getGeometryDescriptor().getLocalName());
        AttributeDescriptor descriptor = sft.getDescriptor(name2);
        if (descriptor == null) {
            throw new IllegalArgumentException(new StringBuilder(60).append("Geometry field '").append(name2).append("' does not exist in input feature collection").toString());
        }
        Class binding = descriptor.getType().getBinding();
        boolean isPoints = Point.class.isAssignableFrom(binding);
        if (!isPoints && !LineString.class.isAssignableFrom(binding)) {
            throw new IllegalArgumentException(new StringBuilder(47).append("Geometry field '").append(name2).append("' must be a Point or LineString").toString());
        }
        Tuple2 tuple2 = new Tuple2((Object)name2, (Object)BoxesRunTime.boxToBoolean((boolean)isPoints));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String geomAttribute = (String)tuple2._1();
        boolean isPoints2 = tuple2._2$mcZ$sp();
        Tuple2 tuple22 = new Tuple2((Object)geomAttribute, (Object)BoxesRunTime.boxToBoolean((boolean)isPoints2));
        String geomAttribute2 = (String)tuple22._1();
        boolean isPoints3 = tuple22._2$mcZ$sp();
        if (headingField == null && isPoints3) {
            throw new IllegalArgumentException("Heading must be specified unless input feature collection geometry is a LineString");
        }
        if (headingField != null && sft.indexOf(headingField) == -1) {
            throw new IllegalArgumentException(new StringBuilder(59).append("Heading field '").append(headingField).append("' does not exist in input feature collection").toString());
        }
        SimpleFeatureType sft2 = (SimpleFeatureType)routes.getSchema();
        int index = sft2.indexOf(name = (String)Option$.MODULE$.apply((Object)routeGeomField).getOrElse((Function0 & Serializable & scala.Serializable)() -> sft2.getGeometryDescriptor().getLocalName()));
        if (index == -1) {
            throw new IllegalArgumentException(new StringBuilder(60).append("Geometry field '").append(name).append("' does not exist in route feature collection").toString());
        }
        if (!LineString.class.isAssignableFrom(sft2.getDescriptor(index).getType().getBinding())) {
            throw new IllegalArgumentException(new StringBuilder(44).append("Route geometry field '").append(name).append("' must be a LineString").toString());
        }
        Seq routeGeoms = SelfClosingIterator$.MODULE$.apply(routes).map((Function1 & Serializable & scala.Serializable)x$2 -> (LineString)x$2.getAttribute(index)).toSeq();
        RouteVisitor visitor = new RouteVisitor(sft, (Seq<LineString>)routeGeoms, Predef$.MODULE$.Double2double(bufferSize), Predef$.MODULE$.Double2double(headingThreshold), Predef$.MODULE$.Boolean2boolean(bi), geomAttribute2, isPoints3, (Option<String>)Option$.MODULE$.apply((Object)headingField));
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    public RouteSearchProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

