/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.query;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ConcurrentHashMap;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.referencing.GeodeticCalculator;
import org.locationtech.geomesa.process.query.RouteVisitor$;
import org.locationtech.geomesa.process.query.RouteVisitor$$anon$2$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.operation.distance.DistanceOp;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.Map;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class RouteVisitor$ {
    public static RouteVisitor$ MODULE$;

    static {
        new RouteVisitor$();
    }

    public SimpleFeatureCollection matchRoutes(SimpleFeatureCollection input, Seq<LineString> routes, int geomIndex, boolean isPoints, Option<Object> headingIndex, double threshold, boolean bidirectional) {
        Function1 & Serializable & scala.Serializable intersect;
        ThreadLocal<GeodeticCalculator> calculator = new ThreadLocal<GeodeticCalculator>(){

            public GeodeticCalculator initialValue() {
                return new GeodeticCalculator();
            }
        };
        Map headingCache = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        Option<Object> option = headingIndex;
        if (option instanceof Some) {
            Some some = (Some)option;
            int index = BoxesRunTime.unboxToInt((Object)some.value());
            intersect = (Function1 & Serializable & scala.Serializable)sf -> BoxesRunTime.boxToDouble((double)RouteVisitor$.$anonfun$matchRoutes$4(index, sf));
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable & scala.Serializable)sf -> BoxesRunTime.boxToDouble((double)RouteVisitor$.$anonfun$matchRoutes$5(geomIndex, calculator, sf));
        } else {
            throw new MatchError(option);
        }
        Function1 & Serializable & scala.Serializable getFeatureHeading = intersect;
        Function1 & Serializable & scala.Serializable getComparisonPoint = isPoints ? (Function1 & Serializable & scala.Serializable)g -> (Point)g : (Function1 & Serializable & scala.Serializable)g -> ((LineString)g).getEndPoint();
        return new DecoratingSimpleFeatureCollection(input, geomIndex, getComparisonPoint, routes, headingCache, calculator, getFeatureHeading, threshold, bidirectional){
            public final SimpleFeatureCollection input$1;
            public final int geomIndex$1;
            public final Function1 getComparisonPoint$1;
            public final Seq routes$1;
            public final Map headingCache$1;
            public final ThreadLocal calculator$1;
            public final Function1 getFeatureHeading$1;
            public final double threshold$1;
            public final boolean bidirectional$1;

            public SimpleFeatureIterator features() {
                return new SimpleFeatureIterator(this){
                    private final CloseableIterator<SimpleFeature> delegate;
                    private final /* synthetic */ anon.2 $outer;

                    private CloseableIterator<SimpleFeature> delegate() {
                        return this.delegate;
                    }

                    public SimpleFeature next() {
                        return (SimpleFeature)this.delegate().next();
                    }

                    public boolean hasNext() {
                        return this.delegate().hasNext();
                    }

                    public void close() {
                        this.delegate().close();
                    }

                    public static final /* synthetic */ boolean $anonfun$delegate$1(anon$2$$anon$3 $this, SimpleFeature sf) {
                        return RouteVisitor$.MODULE$.org$locationtech$geomesa$process$query$RouteVisitor$$matchRoute$1(sf, $this.$outer.geomIndex$1, $this.$outer.getComparisonPoint$1, $this.$outer.routes$1, $this.$outer.headingCache$1, $this.$outer.calculator$1, $this.$outer.getFeatureHeading$1, $this.$outer.threshold$1, $this.$outer.bidirectional$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.delegate = CloseableIterator$.MODULE$.apply((FeatureIterator)$outer.input$1.features()).filter((Function1 & Serializable & scala.Serializable)sf -> BoxesRunTime.boxToBoolean((boolean)anon$2$$anon$3.$anonfun$delegate$1(this, sf)));
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$delegate$1$adapted(org.locationtech.geomesa.process.query.RouteVisitor$$anon$2$$anon$3 org.geotools.api.feature.simple.SimpleFeature )}, serializedLambda);
                    }
                };
            }
            {
                this.input$1 = input$1;
                this.geomIndex$1 = geomIndex$1;
                this.getComparisonPoint$1 = getComparisonPoint$1;
                this.routes$1 = routes$1;
                this.headingCache$1 = headingCache$1;
                this.calculator$1 = calculator$1;
                this.getFeatureHeading$1 = getFeatureHeading$1;
                this.threshold$1 = threshold$1;
                this.bidirectional$1 = bidirectional$1;
                super(input$1);
            }
        };
    }

    private Tuple2<LineString, Object> getClosestRoute(Point geom, Seq<LineString> routes) {
        Tuple3 tuple3 = (Tuple3)((TraversableOnce)routes.map((Function1 & Serializable & scala.Serializable)ls -> RouteVisitor$.closestPoint$1(ls, geom), Seq$.MODULE$.canBuildFrom())).minBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)RouteVisitor$.$anonfun$getClosestRoute$2(x$4)), (Ordering)Ordering.Double$.MODULE$);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        LineString route = (LineString)tuple3._2();
        int location = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple2 tuple2 = new Tuple2((Object)route, (Object)BoxesRunTime.boxToInteger((int)location));
        LineString route2 = (LineString)tuple2._1();
        int location2 = tuple2._2$mcI$sp();
        return new Tuple2((Object)route2, (Object)BoxesRunTime.boxToInteger((int)location2));
    }

    private double getRouteHeading(LineString route, int index, GeodeticCalculator calculator) {
        Coordinate[] coords = route.getCoordinates();
        Coordinate segment0 = coords[index];
        Coordinate segment1 = coords[index + 1];
        calculator.setStartingGeographicPoint(segment0.x, segment0.y);
        calculator.setDestinationGeographicPoint(segment1.x, segment1.y);
        double azimuth = calculator.getAzimuth();
        if (azimuth < 0.0) {
            return 360.0 + azimuth;
        }
        return azimuth;
    }

    public static final /* synthetic */ double $anonfun$matchRoutes$4(int index$2, SimpleFeature sf) {
        return BoxesRunTime.unboxToDouble((Object)FastConverter$.MODULE$.convert(sf.getAttribute(index$2), Double.TYPE));
    }

    public static final /* synthetic */ double $anonfun$matchRoutes$5(int geomIndex$1, ThreadLocal calculator$1, SimpleFeature sf) {
        LineString geom = (LineString)sf.getAttribute(geomIndex$1);
        return MODULE$.getRouteHeading(geom, geom.getNumPoints() - 2, (GeodeticCalculator)calculator$1.get());
    }

    public final boolean org$locationtech$geomesa$process$query$RouteVisitor$$matchRoute$1(SimpleFeature sf, int geomIndex$1, Function1 getComparisonPoint$1, Seq routes$1, Map headingCache$1, ThreadLocal calculator$1, Function1 getFeatureHeading$1, double threshold$1, boolean bidirectional$1) {
        Geometry geom = (Geometry)sf.getAttribute(geomIndex$1);
        Tuple2<LineString, Object> tuple2 = this.getClosestRoute((Point)getComparisonPoint$1.apply((Object)geom), (Seq<LineString>)routes$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        LineString route = (LineString)tuple2._1();
        int closestLocation = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)route, (Object)BoxesRunTime.boxToInteger((int)closestLocation));
        LineString route2 = (LineString)tuple22._1();
        int closestLocation2 = tuple22._2$mcI$sp();
        double routeHeading = BoxesRunTime.unboxToDouble((Object)headingCache$1.getOrElseUpdate((Object)new Tuple2((Object)route2, (Object)BoxesRunTime.boxToInteger((int)closestLocation2)), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> MODULE$.getRouteHeading(route2, closestLocation2, (GeodeticCalculator)calculator$1.get())));
        double featureHeading = BoxesRunTime.unboxToDouble((Object)getFeatureHeading$1.apply((Object)sf));
        double diff = package$.MODULE$.abs(routeHeading - featureHeading);
        if (diff > 180.0) {
            diff = package$.MODULE$.abs(diff - 360.0);
        }
        return diff <= threshold$1 || bidirectional$1 && package$.MODULE$.abs(diff - 180.0) <= threshold$1;
    }

    private static final Tuple3 closestPoint$1(LineString ls, Point geom$1) {
        DistanceOp op = new DistanceOp((Geometry)ls, (Geometry)geom$1);
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)op.distance()), (Object)ls, (Object)BoxesRunTime.boxToInteger((int)op.nearestLocations()[0].getSegmentIndex()));
    }

    public static final /* synthetic */ double $anonfun$getClosestRoute$2(Tuple3 x$4) {
        return BoxesRunTime.unboxToDouble((Object)x$4._1());
    }

    private RouteVisitor$() {
        MODULE$ = this;
    }
}

