/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.transform;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter$;
import org.locationtech.geomesa.arrow.io.package;
import org.locationtech.geomesa.arrow.package;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@DescribeProcess(title="Arrow Conversion", description="Converts a feature collection to arrow format")
@ScalaSignature(bytes="\u0006\u0001\u0011-c\u0001B(Q\u0001mCQA\u001d\u0001\u0005\u0002MDQA\u001e\u0001\u0005\u0002]<q!a:Q\u0011\u0003\tIO\u0002\u0004P!\"\u0005\u00111\u001e\u0005\u0007e\u0012!\t!a=\u0007\r\u0005UH\u0001AA|\u0011)\u00119A\u0002B\u0001B\u0003%!\u0011\u0002\u0005\u000b\u000571!\u0011!Q\u0001\n\tu\u0001B\u0003B$\r\t\u0005\t\u0015!\u0003\u0002h!Q\u0011q\u0011\u0004\u0003\u0002\u0003\u0006IA!\u0013\t\u0015\u0005\u0005fA!A!\u0002\u0013\u0011Y\u0006\u0003\u0006\u0002.\u001a\u0011\t\u0011)A\u0005\u0005CB!Ba\u001a\u0007\u0005\u0003\u0005\u000b\u0011\u0002B2\u0011)\tIL\u0002B\u0001B\u0003%!\u0011\u000e\u0005\u0007e\u001a!\tAa\u001c\t\u0015\t\u0015e\u0001#b\u0001\n\u0013\u00119\tC\u0006\u0003*\u001a\u0001\r\u00111A\u0005\n\t\r\u0006b\u0003BV\r\u0001\u0007\t\u0019!C\u0005\u0005[C1Ba-\u0007\u0001\u0004\u0005\t\u0015)\u0003\u0003&\"9!Q\u0017\u0004\u0005B\t]\u0006b\u0002BH\r\u0011\u00053\u0011\b\u0005\u0007m\u001a!\te!\u0012\u0007\u0013\t-E\u0001%A\u0012\u0002\t5\u0005b\u0002BH/\u0019\u0005!\u0011\u0013\u0005\b\u0005C;b\u0011\u0001BR\r\u0019\u0019y\u0006\u0002\u0003\u0004b!Q!q\u0001\u000e\u0003\u0002\u0003\u0006IA!\u0003\t\u0015\tm!D!A!\u0002\u0013\u0011i\u0002\u0003\u0006\u0004di\u0011\t\u0011)A\u0005\u0007KB!b! \u001b\u0005\u0003\u0005\u000b\u0011BB@\u0011)\tIL\u0007B\u0001B\u0003%!\u0011\u000e\u0005\u0007ej!\taa\"\t\u0013\rU%D1A\u0005\n\r]\u0005\u0002CBS5\u0001\u0006Ia!'\t\u0013\r\u001d&D1A\u0005\n\r%\u0006\u0002CB\\5\u0001\u0006Iaa+\t\u0013\re&\u00041A\u0005\n\rm\u0006\"CBb5\u0001\u0007I\u0011BBc\u0011!\u0019IM\u0007Q!\n\ru\u0006\"CBf5\t\u0007I\u0011BBg\u0011!\u0019IN\u0007Q\u0001\n\r=\u0007b\u0002BH5\u0011\u000531\u001c\u0005\b\u0005CSB\u0011\tBR\r\u0019\u0019y\u000e\u0002\u0003\u0004b\"Q!q\u0001\u0017\u0003\u0002\u0003\u0006IA!\u0003\t\u0015\tmAF!A!\u0002\u0013\u0011i\u0002\u0003\u0006\u0004d1\u0012\t\u0011)A\u0005\u0007KB!\"a\"-\u0005\u0003\u0005\u000b\u0011\u0002B%\u0011)\u0019i\b\fB\u0001B\u0003%1q\u0010\u0005\u000b\u0005Ob#\u0011!Q\u0001\n\t\r\u0004BCA]Y\t\u0005\t\u0015!\u0003\u0003j!1!\u000f\fC\u0001\u0007GD\u0011\"!\u0005-\u0005\u0004%Ia!>\t\u0011\ruH\u0006)A\u0005\u0007oDqAa$-\t\u0003\u001ay\u0010C\u0004\u0003\"2\"\tEa)\t\u000f\u0011\rA\u0006\"\u0003\u0005\u0006\u00191!1\u0018\u0003A\u0005{C!B!);\u0005+\u0007I\u0011\u0001Bm\u0011%\u0011YN\u000fB\tB\u0003%\u0001\u0010\u0003\u0004su\u0011\u0005!Q\u001c\u0005\b\u0005CTD\u0011\tBr\u0011%\u0011)OOA\u0001\n\u0003\u00119\u000fC\u0005\u0003lj\n\n\u0011\"\u0001\u0003n\"I11\u0001\u001e\u0002\u0002\u0013\u00053Q\u0001\u0005\n\u0007\u0017Q\u0014\u0011!C\u0001\u0007\u001bA\u0011ba\u0004;\u0003\u0003%\ta!\u0005\t\u0013\rm!(!A\u0005B\ru\u0001\"CB\u0015u\u0005\u0005I\u0011AB\u0016\u0011%\u0019yCOA\u0001\n\u0003\u001a\t\u0004C\u0005\u00044i\n\t\u0011\"\u0011\u00046\u001dIAq\u0004\u0003\u0002\u0002#\u0005A\u0011\u0005\u0004\n\u0005w#\u0011\u0011!E\u0001\tGAaA]%\u0005\u0002\u0011E\u0002\"\u0003C\u001a\u0013\u0006\u0005IQ\tC\u001b\u0011%!9$SA\u0001\n\u0003#I\u0004C\u0005\u0005>%\u000b\t\u0011\"!\u0005@!IAqI%\u0002\u0002\u0013%A\u0011\n\u0002\u0017\u0003J\u0014xn^\"p]Z,'o]5p]B\u0013xnY3tg*\u0011\u0011KU\u0001\niJ\fgn\u001d4pe6T!a\u0015+\u0002\u000fA\u0014xnY3tg*\u0011QKV\u0001\bO\u0016|W.Z:b\u0015\t9\u0006,\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001Z\u0003\ry'oZ\u0002\u0001'\u0011\u0001A\f\u001a5\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00027b]\u001eT\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\n1qJ\u00196fGR\u0004\"!\u001a4\u000e\u0003IK!a\u001a*\u0003\u001d\u001d+w.T3tCB\u0013xnY3tgB\u0011\u0011\u000e]\u0007\u0002U*\u00111\u000e\\\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003[:\f\u0001\u0002^=qKN\fg-\u001a\u0006\u0002_\u0006\u00191m\\7\n\u0005ET'a\u0003'bufdunZ4j]\u001e\fa\u0001P5oSRtD#\u0001;\u0011\u0005U\u0004Q\"\u0001)\u0002\u000f\u0015DXmY;uKR\t\u00020a\u0004\u0002B\u0005]\u00131MAC\u0003?\u000bY+a.\u0011\u0007edh0D\u0001{\u0015\tY\b-\u0001\u0003vi&d\u0017BA?{\u0005!IE/\u001a:bi>\u0014\b#B@\u0002\u0006\u0005%QBAA\u0001\u0015\t\t\u0019!A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\b\u0005\u0005!!B!se\u0006L\bcA@\u0002\f%!\u0011QBA\u0001\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005E!\u00011\u0001\u0002\u0014\u0005Aa-Z1ukJ,7\u000f\u0005\u0003\u0002\u0016\u0005\rRBAA\f\u0015\u0011\tI\"a\u0007\u0002\rMLW\u000e\u001d7f\u0015\u0011\ti\"a\b\u0002\t\u0011\fG/\u0019\u0006\u0004\u0003CA\u0016\u0001C4f_R|w\u000e\\:\n\t\u0005\u0015\u0012q\u0003\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:DC\"a\u0004\u0002*\u0005]\u0012\u0011HA\u001e\u0003{\u0001B!a\u000b\u000245\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0004gC\u000e$xN]=\u000b\u0007M\u000by\"\u0003\u0003\u00026\u00055\"!\u0005#fg\u000e\u0014\u0018NY3QCJ\fW.\u001a;fe\u0006!a.Y7fC\t\t\t\"A\u0006eKN\u001c'/\u001b9uS>t\u0017EAA \u0003\tJe\u000e];uA\u0019,\u0017\r^;sK\u0002\u001aw\u000e\u001c7fGRLwN\u001c\u0011u_\u0002*gnY8eK\"9\u00111\t\u0002A\u0002\u0005\u0015\u0013aC5oG2,H-\u001a$jIN\u00042!XA$\u0013\r\tIE\u0018\u0002\b\u0005>|G.Z1oQA\t\t%!\u000b\u00028\u00055\u00131HA(\u0003'\n)&\t\u0002\u0002D\u0005\u0012\u0011\u0011K\u0001\"\u0013:\u001cG.\u001e3fA\u0019,\u0017\r^;sK\u0002JEi\u001d\u0011j]\u0002\n'O]8xA\u0019LG.Z\u0001\u0004[&tW$\u0001\u0001\t\u000f\u0005e#\u00011\u0001\u0002F\u0005I\u0001O]8ys\u001aKGm\u001d\u0015\u0011\u0003/\nI#a\u000e\u0002^\u0005m\u0012qLA*\u0003+\n#!!\u0017\"\u0005\u0005\u0005\u0014\u0001\f)s_bL\bEZ3biV\u0014X\rI%Eg\u0002\"x\u000eI5oiN\u0004\u0013N\\:uK\u0006$\u0007e\u001c4!gR\u0014\u0018N\\4t\u0011\u001d\t)G\u0001a\u0001\u0003O\nQBZ8s[\u0006$h+\u001a:tS>t\u0007\u0003BA5\u0003orA!a\u001b\u0002tA!\u0011QNA\u0001\u001b\t\tyGC\u0002\u0002ri\u000ba\u0001\u0010:p_Rt\u0014\u0002BA;\u0003\u0003\ta\u0001\u0015:fI\u00164\u0017\u0002BA=\u0003w\u0012aa\u0015;sS:<'\u0002BA;\u0003\u0003A\u0003#a\u0019\u0002*\u0005]\u0012qPA\u001e\u0003\u0003\u000b\u0019&!\u0016\"\u0005\u0005\u0015\u0014EAAB\u0003a\t%O]8xA%\u00036\t\t4pe6\fG\u000f\t<feNLwN\u001c\u0005\b\u0003\u000f\u0013\u0001\u0019AAE\u0003A!\u0017n\u0019;j_:\f'/\u001f$jK2$7\u000fE\u0003z\u0003\u0017\u000b9'C\u0002\u0002\u000ej\u0014A\u0001T5ti\"B\u0012QQA\u0015\u0003o\t\t*a\u000f\u0002\u0014\u0006M\u0013QKAL\u00033\u000bY*!(\"\u0005\u0005\u001d\u0015EAAK\u0003}\tE\u000f\u001e:jEV$Xm\u001d\u0011u_\u0002\"\u0017n\u0019;j_:\f'/\u001f\u0011f]\u000e|G-Z\u0001\u0004[\u0006DXD\u0001\u0001\u0001\u00049\u0019w\u000e\u001c7fGRLwN\u001c+za\u0016\u001c#!a\u001a\t\u000f\u0005\u0005&\u00011\u0001\u0002h\u0005I1o\u001c:u\r&,G\u000e\u001a\u0015\u0011\u0003?\u000bI#a\u000e\u0002&\u0006m\u0012qUA*\u0003+\n#!!)\"\u0005\u0005%\u0016\u0001F!uiJL'-\u001e;fAQ|\u0007e]8si\u0002\u0012\u0017\u0010C\u0004\u0002.\n\u0001\r!!\u0012\u0002\u0017M|'\u000f\u001e*fm\u0016\u00148/\u001a\u0015\u0011\u0003W\u000bI#a\u000e\u00022\u0006m\u00121WA*\u0003+\n#!!,\"\u0005\u0005U\u0016A\b*fm\u0016\u00148/\u001a\u0011uQ\u0016\u0004C-\u001a4bk2$\be]8si\u0002z'\u000fZ3s\u0011\u001d\tIL\u0001a\u0001\u0003w\u000b\u0011BY1uG\"\u001c\u0016N_3\u0011\u0007u\u000bi,C\u0002\u0002@z\u0013q!\u00138uK\u001e,'\u000f\u000b\t\u00028\u0006%\u0012qGAb\u0003w\t)-a\u0015\u0002V\u0005\u0012\u0011\u0011X\u0011\u0003\u0003\u000f\f!GT;nE\u0016\u0014\be\u001c4!M\u0016\fG/\u001e:fg\u0002\"x\u000eI5oG2,H-\u001a\u0011j]\u0002*\u0017m\u00195!e\u0016\u001cwN\u001d3!E\u0006$8\r\u001b\u0015\b\u0005\u0005-\u00171HAi!\u0011\tY#!4\n\t\u0005=\u0017Q\u0006\u0002\u000f\t\u0016\u001c8M]5cKJ+7/\u001e7uC\t\t\u0019.\u0001\u000eF]\u000e|G-\u001a3!M\u0016\fG/\u001e:fA\r|G\u000e\\3di&|g\u000eK\u0006\u0001\u0003/\fi.a8\u0002<\u0005\r\b\u0003BA\u0016\u00033LA!a7\u0002.\tyA)Z:de&\u0014W\r\u0015:pG\u0016\u001c8/A\u0003uSRdW-\t\u0002\u0002b\u0006\u0001\u0012I\u001d:po\u0002\u001auN\u001c<feNLwN\\\u0011\u0003\u0003K\fQfQ8om\u0016\u0014Ho\u001d\u0011bA\u0019,\u0017\r^;sK\u0002\u001aw\u000e\u001c7fGRLwN\u001c\u0011u_\u0002\n'O]8xA\u0019|'/\\1u\u0003Y\t%O]8x\u0007>tg/\u001a:tS>t\u0007K]8dKN\u001c\bCA;\u0005'\r!\u0011Q\u001e\t\u0004\u007f\u0006=\u0018\u0002BAy\u0003\u0003\u0011a!\u00118z%\u00164GCAAu\u00051\t%O]8x-&\u001c\u0018\u000e^8s'\u00151A,!?i!\u0011\tYPa\u0001\u000e\u0005\u0005u(bA*\u0002\u0000*\u0019!\u0011\u0001+\u0002\u000b%tG-\u001a=\n\t\t\u0015\u0011Q \u0002\u0016\u000f\u0016|W*Z:b!J|7-Z:t-&\u001c\u0018\u000e^8s\u0003\r\u0019h\r\u001e\t\u0005\u0005\u0017\u00119\"\u0004\u0002\u0003\u000e)!\u0011\u0011\u0004B\b\u0015\u0011\u0011\tBa\u0005\u0002\u000f\u0019,\u0017\r^;sK*!!QCA\u0010\u0003\r\t\u0007/[\u0005\u0005\u00053\u0011iAA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016\f\u0001\"\u001a8d_\u0012Lgn\u001a\t\u0005\u0005?\u0011\tE\u0004\u0003\u0003\"\tmb\u0002\u0002B\u0012\u0005kqAA!\n\u000329!!q\u0005B\u0018\u001d\u0011\u0011IC!\f\u000f\t\u00055$1F\u0005\u00023&\u0011q\u000bW\u0005\u0003+ZK1Aa\rU\u0003\u0015\t'O]8x\u0013\u0011\u00119D!\u000f\u0002\rY,7\r^8s\u0015\r\u0011\u0019\u0004V\u0005\u0005\u0005{\u0011y$A\nTS6\u0004H.\u001a$fCR,(/\u001a,fGR|'O\u0003\u0003\u00038\te\u0012\u0002\u0002B\"\u0005\u000b\u0012QcU5na2,g)Z1ukJ,WI\\2pI&twM\u0003\u0003\u0003>\t}\u0012AC5qGZ+'o]5p]B1!1\nB+\u0003OrAA!\u0014\u0003R9!\u0011Q\u000eB(\u0013\t\t\u0019!\u0003\u0003\u0003T\u0005\u0005\u0011a\u00029bG.\fw-Z\u0005\u0005\u0005/\u0012IFA\u0002TKFTAAa\u0015\u0002\u0002A)qP!\u0018\u0002h%!!qLA\u0001\u0005\u0019y\u0005\u000f^5p]B)qP!\u0018\u0003dA\u0019qP!\u001a\n\t\u0005%\u0013\u0011A\u0001\naJ,7k\u001c:uK\u0012\u00042a B6\u0013\u0011\u0011i'!\u0001\u0003\u0007%sG\u000f\u0006\n\u0003r\tU$q\u000fB=\u0005w\u0012iHa \u0003\u0002\n\r\u0005c\u0001B:\r5\tA\u0001C\u0004\u0003\b=\u0001\rA!\u0003\t\u000f\tmq\u00021\u0001\u0003\u001e!9!qI\bA\u0002\u0005\u001d\u0004bBAD\u001f\u0001\u0007!\u0011\n\u0005\b\u0003C{\u0001\u0019\u0001B.\u0011\u001d\tik\u0004a\u0001\u0005CBqAa\u001a\u0010\u0001\u0004\u0011\u0019\u0007C\u0004\u0002:>\u0001\rA!\u001b\u0002\u001b5\fg.^1m-&\u001c\u0018\u000e^8s+\t\u0011I\tE\u0002\u0003t]\u0011!#\u0011:s_^l\u0015M\\;bYZK7/\u001b;peN\u0019q#!<\u0002\u000bYL7/\u001b;\u0015\t\tM%\u0011\u0014\t\u0004\u007f\nU\u0015\u0002\u0002BL\u0003\u0003\u0011A!\u00168ji\"9!\u0011\u0003\rA\u0002\tm\u0005\u0003\u0002B\u0006\u0005;KAAa(\u0003\u000e\ti1+[7qY\u00164U-\u0019;ve\u0016\fqA]3tk2$8/\u0006\u0002\u0003&B)!1\nBT}&\u0019QP!\u0017\u0002\rI,7/\u001e7u\u0003)\u0011Xm];mi~#S-\u001d\u000b\u0005\u0005'\u0013y\u000bC\u0005\u00032J\t\t\u00111\u0001\u0003&\u0006\u0019\u0001\u0010J\u0019\u0002\u000fI,7/\u001e7uA\u0005Iq-\u001a;SKN,H\u000e\u001e\u000b\u0003\u0005s\u00032Aa\u001d;\u0005-\t%O]8x%\u0016\u001cX\u000f\u001c;\u0014\u000fi\u0012yL!4\u0003TB!!\u0011\u0019Be\u001b\t\u0011\u0019M\u0003\u0003\u0003F\n\u001d\u0017a\u0002<jg&$xN\u001d\u0006\u0005\u0005#\ty\"\u0003\u0003\u0003L\n\r'AE!cgR\u0014\u0018m\u0019;DC2\u001c'+Z:vYR\u00042a Bh\u0013\u0011\u0011\t.!\u0001\u0003\u000fA\u0013x\u000eZ;diB\u0019qP!6\n\t\t]\u0017\u0011\u0001\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u000b\u0002q\u0006A!/Z:vYR\u001c\b\u0005\u0006\u0003\u0003:\n}\u0007B\u0002BQ{\u0001\u0007\u00010\u0001\u0005hKR4\u0016\r\\;f)\t\ti/\u0001\u0003d_BLH\u0003\u0002B]\u0005SD\u0001B!)@!\u0003\u0005\r\u0001_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011yOK\u0002y\u0005c\\#Aa=\u0011\t\tU(q`\u0007\u0003\u0005oTAA!?\u0003|\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0005{\f\t!\u0001\u0006b]:|G/\u0019;j_:LAa!\u0001\u0003x\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u00199\u0001E\u0002^\u0007\u0013I1!!\u001f_\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011I'\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\rM1\u0011\u0004\t\u0004\u007f\u000eU\u0011\u0002BB\f\u0003\u0003\u00111!\u00118z\u0011%\u0011\tlQA\u0001\u0002\u0004\u0011I'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019y\u0002\u0005\u0004\u0004\"\r\u001d21C\u0007\u0003\u0007GQAa!\n\u0002\u0002\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007u\u001c\u0019#\u0001\u0005dC:,\u0015/^1m)\u0011\u0011\u0019g!\f\t\u0013\tEV)!AA\u0002\rM\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\t%\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0003d\r]\u0002\"\u0003BY\u000f\u0006\u0005\t\u0019AB\n)\u0011\u0011\u0019ja\u000f\t\u000f\tEQ\u00031\u0001\u0004>A!1qHB!\u001b\t\u0011y!\u0003\u0003\u0004D\t=!a\u0002$fCR,(/\u001a\u000b\u0007\u0005'\u001b9e!\u0016\t\u000f\r%c\u00031\u0001\u0004L\u000511o\\;sG\u0016\u0004Ba!\u0014\u0004R5\u00111q\n\u0006\u0005\u0003;\u0011\u0019\"\u0003\u0003\u0004T\r=#aE*j[BdWMR3biV\u0014XmU8ve\u000e,\u0007bBB,-\u0001\u00071\u0011L\u0001\u0006cV,'/\u001f\t\u0005\u0007\u001b\u001aY&\u0003\u0003\u0004^\r=#!B)vKJL(\u0001G*j[BdW-\u0011:s_^l\u0015M\\;bYZK7/\u001b;peN)!$!<\u0003\n\u00069\u0011\u000e]2PaR\u001c\b\u0003BB4\u0007sj!a!\u001b\u000b\t\r-4QN\u0001\b[\u0016\u001c8/Y4f\u0015\u0011\u0019yg!\u001d\u0002\u0007%\u00048M\u0003\u0003\u00038\rM$\u0002\u0002B\u001a\u0007kR1aa\u001eY\u0003\u0019\t\u0007/Y2iK&!11PB5\u0005%I\u0005oY(qi&|g.\u0001\u0003t_J$\b#B@\u0003^\r\u0005\u0005cB@\u0004\u0004\u0006\u001d$1M\u0005\u0005\u0007\u000b\u000b\tA\u0001\u0004UkBdWM\r\u000b\r\u0007\u0013\u001bYi!$\u0004\u0010\u000eE51\u0013\t\u0004\u0005gR\u0002b\u0002B\u0004A\u0001\u0007!\u0011\u0002\u0005\b\u00057\u0001\u0003\u0019\u0001B\u000f\u0011\u001d\u0019\u0019\u0007\ta\u0001\u0007KBqa! !\u0001\u0004\u0019y\bC\u0004\u0002:\u0002\u0002\rA!\u001b\u0002\u0007=,H/\u0006\u0002\u0004\u001aB!11TBQ\u001b\t\u0019iJC\u0002\u0004 \u0002\f!![8\n\t\r\r6Q\u0014\u0002\u0016\u0005f$X-\u0011:sCf|U\u000f\u001e9viN#(/Z1n\u0003\u0011yW\u000f\u001e\u0011\u0002\u000b\tLH/Z:\u0016\u0005\r-\u0006#BBW\u0007gsXBABX\u0015\u0011\u0019\tla\t\u0002\u000f5,H/\u00192mK&!1QWBX\u0005)a\u0015n\u001d;Ck\u001a4WM]\u0001\u0007Ef$Xm\u001d\u0011\u0002\u000b\r|WO\u001c;\u0016\u0005\ru\u0006cA@\u0004@&!1\u0011YA\u0001\u0005\u0011auN\\4\u0002\u0013\r|WO\u001c;`I\u0015\fH\u0003\u0002BJ\u0007\u000fD\u0011B!-'\u0003\u0003\u0005\ra!0\u0002\r\r|WO\u001c;!\u0003\u00199(/\u001b;feV\u00111q\u001a\t\u0005\u0007#\u001c).\u0004\u0002\u0004T*!1q\u0014B\u001d\u0013\u0011\u00199na5\u00039MKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0003J\u0014xn\u001e$jY\u0016<&/\u001b;fe\u00069qO]5uKJ\u0004C\u0003\u0002BJ\u0007;DqA!\u0005+\u0001\u0004\u0011YJA\rD_6\u0004H.\u001a=BeJ|w/T1ok\u0006dg+[:ji>\u00148#\u0002\u0017\u0002n\n%E\u0003EBs\u0007O\u001cIoa;\u0004n\u000e=8\u0011_Bz!\r\u0011\u0019\b\f\u0005\b\u0005\u000f!\u0004\u0019\u0001B\u0005\u0011\u001d\u0011Y\u0002\u000ea\u0001\u0005;Aqaa\u00195\u0001\u0004\u0019)\u0007C\u0004\u0002\bR\u0002\rA!\u0013\t\u000f\ruD\u00071\u0001\u0004\u0000!9!q\r\u001bA\u0002\t\r\u0004bBA]i\u0001\u0007!\u0011N\u000b\u0003\u0007o\u0004ba!,\u0004z\nm\u0015\u0002BB~\u0007_\u00131\"\u0011:sCf\u0014UO\u001a4fe\u0006Ia-Z1ukJ,7\u000f\t\u000b\u0005\u0005'#\t\u0001C\u0004\u0003\u0012]\u0002\rAa'\u0002\u0017\t,\u0018\u000e\u001c3SKN,H\u000e\u001e\u000b\u0007\u0005K#9\u0001\"\u0007\t\u000f\u0011%\u0011\b1\u0001\u0005\f\u0005aA-[2uS>t\u0017M]5fgBA\u0011\u0011\u000eC\u0007\u0003O\"\t\"\u0003\u0003\u0005\u0010\u0005m$aA'baB!A1\u0003C\u000b\u001b\t\u0011y$\u0003\u0003\u0005\u0018\t}\"aD!se><H)[2uS>t\u0017M]=\t\u000f\u0011m\u0011\b1\u0001\u0005\u001e\u000511o\u001c:uK\u0012\u0004bAa\u0013\u0003(\nm\u0015aC!se><(+Z:vYR\u00042Aa\u001dJ'\u0015IEQ\u0005Bj!\u001d!9\u0003\"\fy\u0005sk!\u0001\"\u000b\u000b\t\u0011-\u0012\u0011A\u0001\beVtG/[7f\u0013\u0011!y\u0003\"\u000b\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0005\"\u0005AAo\\*ue&tw\r\u0006\u0002\u0004\b\u0005)\u0011\r\u001d9msR!!\u0011\u0018C\u001e\u0011\u0019\u0011\t\u000b\u0014a\u0001q\u00069QO\\1qa2LH\u0003\u0002C!\t\u0007\u0002Ba B/q\"IAQI'\u0002\u0002\u0003\u0007!\u0011X\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012\u0001\u0018")
public class ArrowConversionProcess
implements GeoMesaProcess,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ArrowConversionProcess arrowConversionProcess = this;
        synchronized (arrowConversionProcess) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @DescribeResult(description="Encoded feature collection")
    public java.util.Iterator<byte[]> execute(@DescribeParameter(name="features", description="Input feature collection to encode") SimpleFeatureCollection features, @DescribeParameter(name="includeFids", description="Include feature IDs in arrow file", min=0) Boolean includeFids, @DescribeParameter(name="proxyFids", description="Proxy feature IDs to ints instead of strings", min=0) Boolean proxyFids, @DescribeParameter(name="formatVersion", description="Arrow IPC format version", min=0) String formatVersion, @DescribeParameter(name="dictionaryFields", description="Attributes to dictionary encode", min=0, max=128, collectionType=String.class) List<String> dictionaryFields, @DescribeParameter(name="sortField", description="Attribute to sort by", min=0) String sortField, @DescribeParameter(name="sortReverse", description="Reverse the default sort order", min=0) Boolean sortReverse, @DescribeParameter(name="batchSize", description="Number of features to include in each record batch", min=0) Integer batchSize) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running arrow encoding for {}", new Object[]{features.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SimpleFeatureType sft = (SimpleFeatureType)features.getSchema();
        Seq toEncode = (Seq)Option$.MODULE$.apply(dictionaryFields).map((Function1 & Serializable & scala.Serializable)x$1 -> ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        toEncode.foreach((Function1 & Serializable & scala.Serializable)attribute -> {
            ArrowConversionProcess.$anonfun$execute$3(sft, attribute);
            return BoxedUnit.UNIT;
        });
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(includeFids == null || Predef$.MODULE$.Boolean2boolean(includeFids), proxyFids != null && Predef$.MODULE$.Boolean2boolean(proxyFids));
        String ipcVersion = (String)Option$.MODULE$.apply((Object)formatVersion).getOrElse((Function0 & Serializable & scala.Serializable)() -> package.FormatVersion$.MODULE$.ArrowFormatVersion().get());
        Option reverse = Option$.MODULE$.apply((Object)sortReverse).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2));
        int batch = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)batchSize).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(package.ArrowProperties$.MODULE$.BatchSize().get())).toInt()));
        ArrowVisitor visitor = new ArrowVisitor(sft, encoding, ipcVersion, (Seq<String>)toEncode, (Option<String>)Option$.MODULE$.apply((Object)sortField), (Option<Object>)reverse, false, batch);
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    public static final /* synthetic */ void $anonfun$execute$3(SimpleFeatureType sft$1, String attribute) {
        if (sft$1.indexOf(attribute) == -1) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Attribute ").append(attribute).append(" doesn't exist in ").append(sft$1).toString());
        }
    }

    public ArrowConversionProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }

    public static interface ArrowManualVisitor {
        public void visit(SimpleFeature var1);

        public Iterator<byte[]> results();
    }

    public static class ArrowResult
    extends AbstractCalcResult
    implements Product,
    scala.Serializable {
        private final java.util.Iterator<byte[]> results;

        public java.util.Iterator<byte[]> results() {
            return this.results;
        }

        public Object getValue() {
            return this.results();
        }

        public ArrowResult copy(java.util.Iterator<byte[]> results) {
            return new ArrowResult(results);
        }

        public java.util.Iterator<byte[]> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "ArrowResult";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ArrowResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ArrowResult)) return false;
            boolean bl = true;
            if (!bl) return false;
            ArrowResult arrowResult = (ArrowResult)((Object)x$1);
            java.util.Iterator<byte[]> iterator = this.results();
            java.util.Iterator<byte[]> iterator2 = arrowResult.results();
            if (iterator == null) {
                if (iterator2 != null) {
                    return false;
                }
            } else if (!iterator.equals(iterator2)) return false;
            if (!arrowResult.canEqual((Object)this)) return false;
            return true;
        }

        public ArrowResult(java.util.Iterator<byte[]> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class ArrowVisitor
    implements GeoMesaProcessVisitor,
    LazyLogging {
        private ArrowManualVisitor manualVisitor;
        private final SimpleFeatureType sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final String ipcVersion;
        private final Seq<String> dictionaryFields;
        private final Option<String> sortField;
        private final Option<Object> sortReverse;
        private final boolean preSorted;
        private final int batchSize;
        private Iterator<byte[]> result;
        private transient Logger logger;
        private volatile boolean bitmap$0;
        private volatile transient boolean bitmap$trans$0;

        public List<Expression> getExpressions() {
            return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
        }

        private Logger logger$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        private ArrowManualVisitor manualVisitor$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if (!this.bitmap$0) {
                    Option sort = this.sortField.map((Function1 & Serializable & scala.Serializable)s -> new Tuple2(s, $this.sortReverse.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)));
                    IpcOption ipcOpts = package.FormatVersion$.MODULE$.options(this.ipcVersion);
                    this.manualVisitor = this.dictionaryFields.isEmpty() && (this.sortField.isEmpty() || this.preSorted) ? new SimpleArrowManualVisitor(this.sft, this.encoding, ipcOpts, (Option<Tuple2<String, Object>>)sort, this.batchSize) : new ComplexArrowManualVisitor(this.sft, this.encoding, ipcOpts, this.dictionaryFields, (Option<Tuple2<String, Object>>)sort, this.preSorted, this.batchSize);
                    this.bitmap$0 = true;
                }
            }
            return this.manualVisitor;
        }

        private ArrowManualVisitor manualVisitor() {
            if (!this.bitmap$0) {
                return this.manualVisitor$lzycompute();
            }
            return this.manualVisitor;
        }

        private Iterator<byte[]> result() {
            return this.result;
        }

        private void result_$eq(Iterator<byte[]> x$1) {
            this.result = x$1;
        }

        public ArrowResult getResult() {
            if (this.result() != null) {
                return new ArrowResult((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.result()).asJava());
            }
            return new ArrowResult((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.manualVisitor().results()).asJava());
        }

        public void visit(Feature feature) {
            this.manualVisitor().visit((SimpleFeature)feature);
        }

        public void execute(SimpleFeatureSource source, Query query) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Visiting source type: {}", new Object[]{source.getClass().getName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_ENCODE(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_DICTIONARY_FIELDS(), (Object)this.dictionaryFields.mkString(","));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.fids().isDefined()));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_PROXY_FID(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.fids().contains((Object)SimpleFeatureVector.SimpleFeatureEncoding$.Encoding$.MODULE$.Min())));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_BATCH_SIZE(), (Object)BoxesRunTime.boxToInteger((int)this.batchSize));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_FORMAT_VERSION(), (Object)this.ipcVersion);
            this.sortField.foreach((Function1 & Serializable & scala.Serializable)x$4 -> query.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_FIELD(), x$4));
            this.sortReverse.foreach((Function1 & Serializable & scala.Serializable)x$5 -> ArrowVisitor.$anonfun$execute$9(query, BoxesRunTime.unboxToBoolean((Object)x$5)));
            SelfClosingIterator features = SelfClosingIterator$.MODULE$.apply(source.getFeatures(query));
            this.result_$eq((Iterator<byte[]>)features.map((Function1 & Serializable & scala.Serializable)x$6 -> (byte[])x$6.getAttribute(0)));
        }

        public static final /* synthetic */ Object $anonfun$execute$9(Query query$1, boolean x$5) {
            return query$1.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_REVERSE(), (Object)BoxesRunTime.boxToBoolean((boolean)x$5));
        }

        public ArrowVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, String ipcVersion, Seq<String> dictionaryFields, Option<String> sortField, Option<Object> sortReverse, boolean preSorted, int batchSize) {
            this.sft = sft;
            this.encoding = encoding;
            this.ipcVersion = ipcVersion;
            this.dictionaryFields = dictionaryFields;
            this.sortField = sortField;
            this.sortReverse = sortReverse;
            this.preSorted = preSorted;
            this.batchSize = batchSize;
            GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
            LazyLogging.$init$((LazyLogging)this);
        }
    }

    private static class ComplexArrowManualVisitor
    implements ArrowManualVisitor {
        private final SimpleFeatureType sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final IpcOption ipcOpts;
        private final Seq<String> dictionaryFields;
        private final Option<Tuple2<String, Object>> sort;
        private final boolean preSorted;
        private final int batchSize;
        private final ArrayBuffer<SimpleFeature> features;

        private ArrayBuffer<SimpleFeature> features() {
            return this.features;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.features().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeature[]{ScalaSimpleFeature$.MODULE$.copy(feature)}));
        }

        @Override
        public Iterator<byte[]> results() {
            Iterator iterator;
            None$ ordering;
            Map map;
            if (this.dictionaryFields.isEmpty()) {
                map = Predef$.MODULE$.Map().empty();
            } else {
                Seq indicesAndValues = (Seq)this.dictionaryFields.map((Function1 & Serializable & scala.Serializable)field -> new Tuple3(field, (Object)BoxesRunTime.boxToInteger((int)$this.sft.indexOf(field)), (Object)HashSet$.MODULE$.empty()), Seq$.MODULE$.canBuildFrom());
                this.features().foreach((Function1 & Serializable & scala.Serializable)f -> {
                    indicesAndValues.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ComplexArrowManualVisitor.$anonfun$results$3(f, x0$1)));
                    return BoxedUnit.UNIT;
                });
                map = ((TraversableOnce)indicesAndValues.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple3 tuple3 = x0$2;
                    if (tuple3 != null) {
                        String n = (String)tuple3._1();
                        int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
                        HashSet v = (HashSet)tuple3._3();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n), (Object)ArrowDictionary$.MODULE$.create($this.sft.getTypeName(), (long)i, (Object[])v.toArray(ClassTag$.MODULE$.AnyRef()), ClassTag$.MODULE$.apply($this.sft.getDescriptor(i).getType().getBinding())));
                    }
                    throw new MatchError((Object)tuple3);
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
            Map dictionaries = map;
            None$ none$ = ordering = this.preSorted ? None$.MODULE$ : this.sort.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    String field = (String)tuple2._1();
                    boolean reverse = tuple2._2$mcZ$sp();
                    return SimpleFeatureOrdering$.MODULE$.apply($this.sft, field, reverse);
                }
                throw new MatchError((Object)tuple2);
            });
            if (None$.MODULE$.equals(none$)) {
                iterator = this.features().iterator();
            } else if (none$ instanceof Some) {
                Some some = (Some)none$;
                Ordering o = (Ordering)some.value();
                iterator = ((IndexedSeqLike)this.features().sorted(o)).iterator();
            } else {
                throw new MatchError((Object)none$);
            }
            Iterator sorted = iterator;
            return this.buildResult((Map<String, ArrowDictionary>)dictionaries, (Iterator<SimpleFeature>)sorted);
        }

        private Iterator<byte[]> buildResult(Map<String, ArrowDictionary> dictionaries, Iterator<SimpleFeature> sorted) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ListBuffer bytes = (ListBuffer)ListBuffer$.MODULE$.empty();
            package.WithClose$.MODULE$.apply((Object)SimpleFeatureArrowFileWriter$.MODULE$.apply((OutputStream)out, this.sft, dictionaries, this.encoding, this.ipcOpts, this.sort), (Function1 & Serializable & scala.Serializable)writer -> {
                ComplexArrowManualVisitor.$anonfun$buildResult$1(this, sorted, bytes, out, writer);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            bytes.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{out.toByteArray()}));
            return bytes.iterator();
        }

        public static final /* synthetic */ boolean $anonfun$results$3(SimpleFeature f$1, Tuple3 x0$1) {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
                HashSet v = (HashSet)tuple3._3();
                return v.add(f$1.getAttribute(i));
            }
            throw new MatchError((Object)tuple3);
        }

        public static final /* synthetic */ void $anonfun$buildResult$1(ComplexArrowManualVisitor $this, Iterator sorted$1, ListBuffer bytes$1, ByteArrayOutputStream out$1, SimpleFeatureArrowFileWriter writer) {
            while (sorted$1.hasNext()) {
                for (int i = 0; i < $this.batchSize && sorted$1.hasNext(); ++i) {
                    writer.add((SimpleFeature)sorted$1.next());
                }
                writer.flush();
                bytes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{out$1.toByteArray()}));
                out$1.reset();
            }
        }

        public ComplexArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, IpcOption ipcOpts, Seq<String> dictionaryFields, Option<Tuple2<String, Object>> sort, boolean preSorted, int batchSize) {
            this.sft = sft;
            this.encoding = encoding;
            this.ipcOpts = ipcOpts;
            this.dictionaryFields = dictionaryFields;
            this.sort = sort;
            this.preSorted = preSorted;
            this.batchSize = batchSize;
            this.features = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        }
    }

    private static class SimpleArrowManualVisitor
    implements ArrowManualVisitor {
        private final int batchSize;
        private final ByteArrayOutputStream out;
        private final ListBuffer<byte[]> bytes;
        private long count;
        private final SimpleFeatureArrowFileWriter writer;

        private ByteArrayOutputStream out() {
            return this.out;
        }

        private ListBuffer<byte[]> bytes() {
            return this.bytes;
        }

        private long count() {
            return this.count;
        }

        private void count_$eq(long x$1) {
            this.count = x$1;
        }

        private SimpleFeatureArrowFileWriter writer() {
            return this.writer;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.writer().add(feature);
            this.count_$eq(this.count() + 1L);
            if (this.count() % (long)this.batchSize == 0L) {
                this.writer().flush();
                this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
                this.out().reset();
                return;
            }
        }

        @Override
        public Iterator<byte[]> results() {
            package.CloseWithLogging$.MODULE$.apply((Object)this.writer(), IsCloseable$.MODULE$.closeableIsCloseable());
            this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
            return this.bytes().iterator();
        }

        public SimpleArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, IpcOption ipcOpts, Option<Tuple2<String, Object>> sort, int batchSize) {
            this.batchSize = batchSize;
            this.out = new ByteArrayOutputStream();
            this.bytes = (ListBuffer)ListBuffer$.MODULE$.empty();
            this.count = 0L;
            this.writer = SimpleFeatureArrowFileWriter$.MODULE$.apply((OutputStream)this.out(), sft, Predef$.MODULE$.Map().empty(), encoding, ipcOpts, sort);
        }
    }
}

