/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.tube;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.process.tube.TubeBuilder;
import org.locationtech.jts.geom.Geometry;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4A\u0001C\u0005\u0001)!I1\u0005\u0001B\u0001B\u0003%AE\f\u0005\n_\u0001\u0011\t\u0011)A\u0005aYB\u0011b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001O\u001e\t\u000bq\u0002A\u0011A\u001f\t\u000b\t\u0003A\u0011A\"\t\u000b}\u0003A\u0011\u00011\t\u000bA\u0004A\u0011I9\u0003\u00139{w)\u00199GS2d'B\u0001\u0006\f\u0003\u0011!XOY3\u000b\u00051i\u0011a\u00029s_\u000e,7o\u001d\u0006\u0003\u001d=\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u0011#\u0005aAn\\2bi&|g\u000e^3dQ*\t!#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001+e\u0001\"AF\f\u000e\u0003%I!\u0001G\u0005\u0003\u0017Q+(-\u001a\"vS2$WM\u001d\t\u00035\u0005j\u0011a\u0007\u0006\u00039u\tAb]2bY\u0006dwnZ4j]\u001eT!AH\u0010\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001I\u0001\u0004G>l\u0017B\u0001\u0012\u001c\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\u0019Q,(-\u001a$fCR,(/Z:\u0011\u0005\u0015bS\"\u0001\u0014\u000b\u0005\u001dB\u0013AB:j[BdWM\u0003\u0002*U\u0005!A-\u0019;b\u0015\tY\u0013#\u0001\u0005hK>$xn\u001c7t\u0013\ticEA\fTS6\u0004H.\u001a$fCR,(/Z\"pY2,7\r^5p]&\u00111eF\u0001\u000fEV4g-\u001a:ESN$\u0018M\\2f!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u0019!u.\u001e2mK&\u0011qfF\u0001\b[\u0006D()\u001b8t!\t\t\u0014(\u0003\u0002;e\t\u0019\u0011J\u001c;\n\u0005]:\u0012A\u0002\u001fj]&$h\b\u0006\u0003?\u007f\u0001\u000b\u0005C\u0001\f\u0001\u0011\u0015\u0019C\u00011\u0001%\u0011\u0015yC\u00011\u00011\u0011\u00159D\u00011\u00019\u0003=!\u0018.\\3CS:\fe\u000eZ+oS>tGc\u0001#Z=B\u0019Q)\u0014)\u000f\u0005\u0019[eBA$K\u001b\u0005A%BA%\u0014\u0003\u0019a$o\\8u}%\t1'\u0003\u0002Me\u00059\u0001/Y2lC\u001e,\u0017B\u0001(P\u0005!IE/\u001a:bi>\u0014(B\u0001'3!\t\tv+D\u0001S\u0015\t93K\u0003\u0002U+\u00069a-Z1ukJ,'B\u0001,+\u0003\r\t\u0007/[\u0005\u00031J\u0013QbU5na2,g)Z1ukJ,\u0007\"\u0002.\u0006\u0001\u0004Y\u0016\u0001\u00034fCR,(/Z:\u0011\u0007\u0015c\u0006+\u0003\u0002^\u001f\nA\u0011\n^3sC\ndW\rC\u00038\u000b\u0001\u0007\u0001(A\u0007v]&|gNR3biV\u0014Xm\u001d\u000b\u0004!\u00064\u0007\"\u00022\u0007\u0001\u0004\u0019\u0017aD8sI\u0016\u0014X\r\u001a$fCR,(/Z:\u0011\u0007\u0015#\u0007+\u0003\u0002f\u001f\n\u00191+Z9\t\u000b\u001d4\u0001\u0019\u00015\u0002\u0005%$\u0007CA5n\u001d\tQ7\u000e\u0005\u0002He%\u0011ANM\u0001\u0007!J,G-\u001a4\n\u00059|'AB*ue&twM\u0003\u0002me\u0005Q1M]3bi\u0016$VOY3\u0016\u0003\u0011\u0003")
public class NoGapFill
extends TubeBuilder {
    public Iterator<SimpleFeature> timeBinAndUnion(Iterable<SimpleFeature> features, int maxBins) {
        int n;
        int numFeatures = features.size();
        if (numFeatures == 0) {
            return package$.MODULE$.Iterator().empty();
        }
        int n2 = maxBins;
        switch (n2) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = numFeatures;
                break;
            }
            default: {
                n = numFeatures / maxBins + (numFeatures % maxBins == 0 ? 0 : 1);
                break;
            }
        }
        int binSize = n;
        return features.grouped(binSize).zipWithIndex().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Iterable bin = (Iterable)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                return this.unionFeatures((Seq<SimpleFeature>)bin.toSeq(), Integer.toString(idx));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public SimpleFeature unionFeatures(Seq<SimpleFeature> orderedFeatures, String id) {
        Seq geoms = (Seq)orderedFeatures.map((Function1 & Serializable & scala.Serializable)sf -> this.getGeom((SimpleFeature)sf), Seq$.MODULE$.canBuildFrom());
        Geometry unionGeom = this.geoFac().buildGeometry((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(geoms).asJava()).union();
        Date min = this.getStartTime((SimpleFeature)orderedFeatures.head());
        Date max = this.getStartTime((SimpleFeature)orderedFeatures.last());
        this.builder().reset();
        return this.builder().buildFeature(id, new Object[]{unionGeom, min, max});
    }

    @Override
    public Iterator<SimpleFeature> createTube() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Creating tube with no gap filling");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Iterator<SimpleFeature> transformed = this.transform(super.tubeFeatures(), this.dtgField());
        Iterator<SimpleFeature> buffered = this.buffer(transformed, super.bufferDistance());
        Seq sortedTube = (Seq)buffered.toSeq().sortBy((Function1 & Serializable & scala.Serializable)sf -> BoxesRunTime.boxToLong((long)NoGapFill.$anonfun$createTube$1(this, sf)), (Ordering)Ordering.Long$.MODULE$);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("sorted tube size: {}", new Object[]{BoxesRunTime.boxToInteger((int)sortedTube.size())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.timeBinAndUnion((Iterable<SimpleFeature>)sortedTube, super.maxBins());
    }

    public static final /* synthetic */ long $anonfun$createTube$1(NoGapFill $this, SimpleFeature sf) {
        return $this.getStartTime(sf).getTime();
    }

    public NoGapFill(SimpleFeatureCollection tubeFeatures, double bufferDistance, int maxBins) {
        super(tubeFeatures, bufferDistance, maxBins);
    }
}

