/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.tube;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Date;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.EmptyFeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.tube.GapFill$;
import org.locationtech.geomesa.process.tube.InterpolatedGapFill;
import org.locationtech.geomesa.process.tube.LineGapFill;
import org.locationtech.geomesa.process.tube.NoGapFill;
import org.locationtech.geomesa.process.tube.TubeBuilder;
import org.locationtech.geomesa.process.tube.TubeResult;
import org.locationtech.geomesa.process.tube.TubeVisitor$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.iterators.DeduplicatingSimpleFeatureIterator;
import org.locationtech.geomesa.utils.iterators.DeduplicatingSimpleFeatureIterator$;
import org.locationtech.jts.geom.Geometry;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u0010!\u0001-B\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t#\u0002\u0011\t\u0011)A\u0005\u000f\"A!\u000b\u0001BC\u0002\u0013\u0005a\t\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003H\u0011!!\u0006A!b\u0001\n\u0003)\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001B\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tO\u0002\u0011)\u0019!C\u0001?\"A\u0001\u000e\u0001B\u0001B\u0003%\u0001\r\u0003\u0005j\u0001\t\u0015\r\u0011\"\u0001k\u0011!q\u0007A!A!\u0002\u0013Y\u0007\u0002C8\u0001\u0005\u000b\u0007I\u0011\u00019\t\u0011Q\u0004!\u0011!Q\u0001\nED\u0001\"\u001e\u0001\u0003\u0006\u0004%\tA\u001e\u0005\t\u007f\u0002\u0011\t\u0011)A\u0005o\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001\"CA\f\u0001\u0001\u0007I\u0011AA\r\u0011%\t\t\u0003\u0001a\u0001\n\u0003\t\u0019\u0003\u0003\u0005\u00020\u0001\u0001\u000b\u0015BA\u000e\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!a\u0011\u0001\t\u0003\n)\u0005\u0003\u0005\u0002V\u0001\u0011\r\u0011\"\u0003k\u0011\u001d\t9\u0006\u0001Q\u0001\n-Dq!!\u0017\u0001\t\u0003\nYfB\u0005\u0002v\u0001\n\t\u0011#\u0001\u0002x\u0019Aq\u0004IA\u0001\u0012\u0003\tI\bC\u0004\u0002\u0002m!\t!!!\t\u0013\u0005\r5$%A\u0005\u0002\u0005\u0015\u0005\"CAN7E\u0005I\u0011AAO\u0005-!VOY3WSNLGo\u001c:\u000b\u0005\u0005\u0012\u0013\u0001\u0002;vE\u0016T!a\t\u0013\u0002\u000fA\u0014xnY3tg*\u0011QEJ\u0001\bO\u0016|W.Z:b\u0015\t9\u0003&\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001*\u0003\ry'oZ\u0002\u0001'\u0011\u0001A\u0006N\u001e\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001\u00027b]\u001eT\u0011!M\u0001\u0005U\u00064\u0018-\u0003\u00024]\t1qJ\u00196fGR\u0004\"!N\u001d\u000e\u0003YR!aI\u001c\u000b\u0005a\"\u0013!B5oI\u0016D\u0018B\u0001\u001e7\u0005U9Um\\'fg\u0006\u0004&o\\2fgN4\u0016n]5u_J\u0004\"\u0001P\"\u000e\u0003uR!AP \u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0001\u000b\u0015\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\t\u000b1aY8n\u0013\t!UHA\u0006MCjLHj\\4hS:<\u0017\u0001\u0004;vE\u00164U-\u0019;ve\u0016\u001cX#A$\u0011\u0005!{U\"A%\u000b\u0005)[\u0015AB:j[BdWM\u0003\u0002M\u001b\u0006!A-\u0019;b\u0015\tq\u0005&\u0001\u0005hK>$xn\u001c7t\u0013\t\u0001\u0016JA\fTS6\u0004H.\u001a$fCR,(/Z\"pY2,7\r^5p]\u0006iA/\u001e2f\r\u0016\fG/\u001e:fg\u0002\n\u0011CZ3biV\u0014XmQ8mY\u0016\u001cG/[8o\u0003I1W-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0011\u0002\r\u0019LG\u000e^3s+\u00051\u0006CA,\\\u001b\u0005A&B\u0001+Z\u0015\tQV*A\u0002ba&L!\u0001\u0018-\u0003\r\u0019KG\u000e^3s\u0003\u001d1\u0017\u000e\u001c;fe\u0002\n\u0001\"\\1y'B,W\rZ\u000b\u0002AB\u0011\u0011\rZ\u0007\u0002E*\t1-A\u0003tG\u0006d\u0017-\u0003\u0002fE\n!Aj\u001c8h\u0003%i\u0017\r_*qK\u0016$\u0007%A\u0004nCb$\u0016.\\3\u0002\u00115\f\u0007\u0010V5nK\u0002\n!BY;gM\u0016\u00148+\u001b>f+\u0005Y\u0007CA1m\u0013\ti'M\u0001\u0004E_V\u0014G.Z\u0001\fEV4g-\u001a:TSj,\u0007%A\u0004nCb\u0014\u0015N\\:\u0016\u0003E\u0004\"!\u0019:\n\u0005M\u0014'aA%oi\u0006AQ.\u0019=CS:\u001c\b%A\u0004hCB4\u0015\u000e\u001c7\u0016\u0003]\u0004\"\u0001\u001f?\u000f\u0005eTX\"\u0001\u0011\n\u0005m\u0004\u0013aB$ba\u001aKG\u000e\\\u0005\u0003{z\u0014qaR1q\r&dGN\u0003\u0002|A\u0005Aq-\u00199GS2d\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003\u000b\t9!!\u0003\u0002\f\u00055\u0011qBA\t\u0003'\t)\u0002\u0005\u0002z\u0001!)Q)\u0005a\u0001\u000f\")!+\u0005a\u0001\u000f\"9A+\u0005I\u0001\u0002\u00041\u0006\"\u00020\u0012\u0001\u0004\u0001\u0007\"B4\u0012\u0001\u0004\u0001\u0007\"B5\u0012\u0001\u0004Y\u0007\"B8\u0012\u0001\u0004\t\bbB;\u0012!\u0003\u0005\ra^\u0001\u000be\u0016\u001cX\u000f\u001c;DC2\u001cWCAA\u000e!\rI\u0018QD\u0005\u0004\u0003?\u0001#A\u0003+vE\u0016\u0014Vm];mi\u0006q!/Z:vYR\u001c\u0015\r\\2`I\u0015\fH\u0003BA\u0013\u0003W\u00012!YA\u0014\u0013\r\tIC\u0019\u0002\u0005+:LG\u000fC\u0005\u0002.M\t\t\u00111\u0001\u0002\u001c\u0005\u0019\u0001\u0010J\u0019\u0002\u0017I,7/\u001e7u\u0007\u0006d7\rI\u0001\u0006m&\u001c\u0018\u000e\u001e\u000b\u0005\u0003K\t)\u0004C\u0004\u00028U\u0001\r!!\u000f\u0002\u000f\u0019,\u0017\r^;sKB!\u00111HA \u001b\t\tiDC\u0002\u00028eKA!!\u0011\u0002>\t9a)Z1ukJ,\u0017!C4fiJ+7/\u001e7u)\t\t9\u0005\u0005\u0003\u0002J\u0005ESBAA&\u0015\u0011\ti%a\u0014\u0002\u000fYL7/\u001b;pe*\u0019\u0011qG'\n\t\u0005M\u00131\n\u0002\u000b\u0007\u0006d7MU3tk2$\u0018A\u00042vM\u001a,'\u000fR5ti\u0006t7-Z\u0001\u0010EV4g-\u001a:ESN$\u0018M\\2fA\u00059Q\r_3dkR,GCBA\u0013\u0003;\nY\u0007C\u0004\u0002`e\u0001\r!!\u0019\u0002\rM|WO]2f!\u0011\t\u0019'a\u001a\u000e\u0005\u0005\u0015$B\u0001'Z\u0013\u0011\tI'!\u001a\u0003'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f'>,(oY3\t\u000f\u00055\u0014\u00041\u0001\u0002p\u0005)\u0011/^3ssB!\u00111MA9\u0013\u0011\t\u0019(!\u001a\u0003\u000bE+XM]=\u0002\u0017Q+(-\u001a,jg&$xN\u001d\t\u0003sn\u00192aGA>!\r\t\u0017QP\u0005\u0004\u0003\u007f\u0012'AB!osJ+g\r\u0006\u0002\u0002x\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a\"+\u0007Y\u000bIi\u000b\u0002\u0002\fB!\u0011QRAL\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015!C;oG\",7m[3e\u0015\r\t)JY\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAM\u0003\u001f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u0011\u0011q\u0014\u0016\u0004o\u0006%\u0005")
public class TubeVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private final SimpleFeatureCollection tubeFeatures;
    private final SimpleFeatureCollection featureCollection;
    private final Filter filter;
    private final long maxSpeed;
    private final long maxTime;
    private final double bufferSize;
    private final int maxBins;
    private final Enumeration.Value gapFill;
    private TubeResult resultCalc;
    private final double bufferDistance;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Enumeration.Value $lessinit$greater$default$8() {
        return TubeVisitor$.MODULE$.$lessinit$greater$default$8();
    }

    public static Filter $lessinit$greater$default$3() {
        return TubeVisitor$.MODULE$.$lessinit$greater$default$3();
    }

    public java.util.List<Expression> getExpressions() {
        return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
    }

    private Logger logger$lzycompute() {
        TubeVisitor tubeVisitor = this;
        synchronized (tubeVisitor) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public SimpleFeatureCollection tubeFeatures() {
        return this.tubeFeatures;
    }

    public SimpleFeatureCollection featureCollection() {
        return this.featureCollection;
    }

    public Filter filter() {
        return this.filter;
    }

    public long maxSpeed() {
        return this.maxSpeed;
    }

    public long maxTime() {
        return this.maxTime;
    }

    public double bufferSize() {
        return this.bufferSize;
    }

    public int maxBins() {
        return this.maxBins;
    }

    public Enumeration.Value gapFill() {
        return this.gapFill;
    }

    public TubeResult resultCalc() {
        return this.resultCalc;
    }

    public void resultCalc_$eq(TubeResult x$1) {
        this.resultCalc = x$1;
    }

    public void visit(Feature feature) {
    }

    public CalcResult getResult() {
        return this.resultCalc();
    }

    private double bufferDistance() {
        return this.bufferDistance;
    }

    public void execute(SimpleFeatureSource source, Query query) {
        TubeBuilder tubeBuilder;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(22).append("Visiting source type: ").append(source.getClass().getName()).toString());
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        PropertyName geomProperty = package$.MODULE$.ff().property(source.getSchema().getGeometryDescriptor().getName());
        PropertyName dateProperty = package$.MODULE$.ff().property((String)source.getSchema().getUserData().get(SimpleFeatureTypes.Configs$.MODULE$.DefaultDtgField()));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(29).append("Querying with date property: ").append(dateProperty).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(33).append("Querying with geometry property: ").append(geomProperty).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Enumeration.Value value = this.gapFill();
        Enumeration.Value value2 = GapFill$.MODULE$.LINE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            tubeBuilder = new LineGapFill(this.tubeFeatures(), this.bufferDistance(), this.maxBins());
        } else {
            Enumeration.Value value4 = GapFill$.MODULE$.INTERPOLATED();
            Enumeration.Value value5 = value;
            tubeBuilder = !(value4 != null ? !value4.equals(value5) : value5 != null) ? new InterpolatedGapFill(this.tubeFeatures(), this.bufferDistance(), this.maxBins()) : new NoGapFill(this.tubeFeatures(), this.bufferDistance(), this.maxBins());
        }
        LineGapFill tubeBuilder2 = tubeBuilder;
        Iterator<SimpleFeature> tube = ((TubeBuilder)tubeBuilder2).createTube();
        CloseableIterator queryResults = CloseableIterator$.MODULE$.apply(tube, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CloseableIterator$.MODULE$.apply$default$2()).flatMap((Function1 & Serializable & scala.Serializable)sf -> {
            long sfMin = tubeBuilder2.getStartTime((SimpleFeature)sf).getTime();
            Date minDate = new Date(sfMin - this.maxTime() * 1000L);
            long sfMax = tubeBuilder2.getEndTime((SimpleFeature)sf).getTime();
            Date maxDate = new Date(sfMax + this.maxTime() * 1000L);
            PropertyIsGreaterThan dtg1 = package$.MODULE$.ff().greater((Expression)dateProperty, (Expression)package$.MODULE$.ff().literal((Object)minDate));
            PropertyIsLessThan dtg2 = package$.MODULE$.ff().less((Expression)dateProperty, (Expression)package$.MODULE$.ff().literal((Object)maxDate));
            Geometry geom = (Geometry)sf.getDefaultGeometry();
            Iterator geoms = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), geom.getNumGeometries()).toIterator().map((Function1 & Serializable & scala.Serializable)x$1 -> geom.getGeometryN(BoxesRunTime.unboxToInt((Object)x$1)));
            return SelfClosingIterator$.MODULE$.apply(geoms, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SelfClosingIterator$.MODULE$.apply$default$2()).flatMap((Function1 & Serializable & scala.Serializable)g -> {
                Intersects geomFilter = package$.MODULE$.ff().intersects((Expression)geomProperty, (Expression)package$.MODULE$.ff().literal(g));
                And combinedFilter = package$.MODULE$.ff().and((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)query.getFilter(), (List)new .colon.colon((Object)geomFilter, (List)new .colon.colon((Object)dtg1, (List)new .colon.colon((Object)dtg2, (List)new .colon.colon((Object)this.filter(), (List)Nil$.MODULE$)))))).asJava());
                return SelfClosingIterator$.MODULE$.apply(source.getFeatures((Filter)combinedFilter).features());
            });
        });
        ListFeatureCollection collection = new ListFeatureCollection((SimpleFeatureType)source.getSchema());
        package.WithClose$.MODULE$.apply((Object)new DeduplicatingSimpleFeatureIterator(queryResults, DeduplicatingSimpleFeatureIterator$.MODULE$.$lessinit$greater$default$2(), DeduplicatingSimpleFeatureIterator$.MODULE$.$lessinit$greater$default$3()), (Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)collection$1.add(x$1)));
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
        this.resultCalc_$eq(new TubeResult((SimpleFeatureCollection)collection));
    }

    public TubeVisitor(SimpleFeatureCollection tubeFeatures, SimpleFeatureCollection featureCollection, Filter filter, long maxSpeed, long maxTime, double bufferSize, int maxBins, Enumeration.Value gapFill) {
        this.tubeFeatures = tubeFeatures;
        this.featureCollection = featureCollection;
        this.filter = filter;
        this.maxSpeed = maxSpeed;
        this.maxTime = maxTime;
        this.bufferSize = bufferSize;
        this.maxBins = maxBins;
        this.gapFill = gapFill;
        GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
        LazyLogging.$init$((LazyLogging)this);
        this.resultCalc = new TubeResult((SimpleFeatureCollection)new EmptyFeatureCollection((SimpleFeatureType)featureCollection.getSchema()));
        this.bufferDistance = bufferSize > 0.0 ? bufferSize : (double)(maxSpeed * maxTime);
    }
}

