/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.transform;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter$;
import org.locationtech.geomesa.arrow.io.package;
import org.locationtech.geomesa.arrow.package;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@DescribeProcess(title="Arrow Conversion", description="Converts a feature collection to arrow format")
@ScalaSignature(bytes="\u0006\u0001\u0011\rd\u0001\u0002*T\u0001yCQ!\u001e\u0001\u0005\u0002YDQ!\u001f\u0001\u0005\u0002i<q!!?T\u0011\u0003\tYP\u0002\u0004S'\"\u0005\u0011Q \u0005\u0007k\u0012!\tA!\u0002\u0007\r\t\u001dA\u0001\u0001B\u0005\u0011)\u0011IB\u0002B\u0001B\u0003%!1\u0004\u0005\u000b\u0005[1!\u0011!Q\u0001\n\t=\u0002B\u0003B-\r\t\u0005\t\u0015!\u0003\u0002n!Q\u0011Q\u0012\u0004\u0003\u0002\u0003\u0006IAa\u0017\t\u0015\u0005\u001dfA!A!\u0002\u0013\u0011i\u0007\u0003\u0006\u00024\u001a\u0011\t\u0011)A\u0005\u0005gB!B!\u001f\u0007\u0005\u0003\u0005\u000b\u0011\u0002B;\u0011)\tyL\u0002B\u0001B\u0003%!1\u0010\u0005\u000b\u0003#4!\u0011!Q\u0001\n\tU\u0004BB;\u0007\t\u0003\u0011\t\t\u0003\u0006\u0003\u001a\u001aA)\u0019!C\u0005\u00057C1B!0\u0007\u0001\u0004\u0005\r\u0011\"\u0003\u00038\"Y!q\u0018\u0004A\u0002\u0003\u0007I\u0011\u0002Ba\u0011-\u00119M\u0002a\u0001\u0002\u0003\u0006KA!/\t\u000f\t%g\u0001\"\u0011\u0003L\"9!1\u0015\u0004\u0005B\r5\u0003BB=\u0007\t\u0003\u001aIFB\u0005\u0003 \u0012\u0001\n1%\u0001\u0003\"\"9!1\u0015\r\u0007\u0002\t\u0015\u0006b\u0002B[1\u0019\u0005!q\u0017\u0004\u0007\u0007g\"Aa!\u001e\t\u0015\te1D!A!\u0002\u0013\u0011Y\u0002\u0003\u0006\u0003.m\u0011\t\u0011)A\u0005\u0005_A!ba\u001e\u001c\u0005\u0003\u0005\u000b\u0011BB=\u0011)\u0019\tj\u0007B\u0001B\u0003%11\u0013\u0005\u000b\u0003\u007f[\"\u0011!Q\u0001\n\tm\u0004BCAi7\t\u0005\t\u0015!\u0003\u0003v!1Qo\u0007C\u0001\u00077C\u0011ba+\u001c\u0005\u0004%Ia!,\t\u0011\rm6\u0004)A\u0005\u0007_C\u0011b!0\u001c\u0005\u0004%Iaa0\t\u0011\r57\u0004)A\u0005\u0007\u0003D\u0011ba4\u001c\u0001\u0004%Ia!5\t\u0013\re7\u00041A\u0005\n\rm\u0007\u0002CBp7\u0001\u0006Kaa5\t\u0013\r\u00058D1A\u0005\n\r\r\b\u0002CBx7\u0001\u0006Ia!:\t\u000f\t\r6\u0004\"\u0011\u0004r\"9!QW\u000e\u0005B\t]fABB{\t\u0011\u00199\u0010\u0003\u0006\u0003\u001a9\u0012\t\u0011)A\u0005\u00057A!B!\f/\u0005\u0003\u0005\u000b\u0011\u0002B\u0018\u0011)\u00199H\fB\u0001B\u0003%1\u0011\u0010\u0005\u000b\u0003\u001bs#\u0011!Q\u0001\n\tm\u0003BCBI]\t\u0005\t\u0015!\u0003\u0004\u0014\"Q!\u0011\u0010\u0018\u0003\u0002\u0003\u0006IA!\u001e\t\u0015\u0005}fF!A!\u0002\u0013\u0011Y\b\u0003\u0006\u0002R:\u0012\t\u0011)A\u0005\u0005kBa!\u001e\u0018\u0005\u0002\re\b\"CA\f]\t\u0007I\u0011\u0002C\u0007\u0011!!)B\fQ\u0001\n\u0011=\u0001b\u0002BR]\u0011\u0005Cq\u0003\u0005\b\u0005ksC\u0011\tB\\\u0011\u001d!YB\fC\u0005\t;1aAa4\u0005\u0001\nE\u0007B\u0003B[{\tU\r\u0011\"\u0001\u0003n\"I!q^\u001f\u0003\u0012\u0003\u0006Ia\u001f\u0005\u0007kv\"\tA!=\t\u000f\tUX\b\"\u0011\u0003x\"I!\u0011`\u001f\u0002\u0002\u0013\u0005!1 \u0005\n\u0005\u007fl\u0014\u0013!C\u0001\u0007\u0003A\u0011ba\u0006>\u0003\u0003%\te!\u0007\t\u0013\r}Q(!A\u0005\u0002\r\u0005\u0002\"CB\u0012{\u0005\u0005I\u0011AB\u0013\u0011%\u0019y#PA\u0001\n\u0003\u001a\t\u0004C\u0005\u0004>u\n\t\u0011\"\u0001\u0004@!I11I\u001f\u0002\u0002\u0013\u00053Q\t\u0005\n\u0007\u000fj\u0014\u0011!C!\u0007\u0013:\u0011\u0002b\u000e\u0005\u0003\u0003E\t\u0001\"\u000f\u0007\u0013\t=G!!A\t\u0002\u0011m\u0002BB;M\t\u0003!I\u0005C\u0005\u0005L1\u000b\t\u0011\"\u0012\u0005N!IAq\n'\u0002\u0002\u0013\u0005E\u0011\u000b\u0005\n\t+b\u0015\u0011!CA\t/B\u0011\u0002b\u0018M\u0003\u0003%I\u0001\"\u0019\u0003-\u0005\u0013(o\\<D_:4XM]:j_:\u0004&o\\2fgNT!\u0001V+\u0002\u0013Q\u0014\u0018M\\:g_Jl'B\u0001,X\u0003\u001d\u0001(o\\2fgNT!\u0001W-\u0002\u000f\u001d,w.\\3tC*\u0011!lW\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u00029\u0006\u0019qN]4\u0004\u0001M!\u0001aX4l!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0003mC:<'\"\u00013\u0002\t)\fg/Y\u0005\u0003M\u0006\u0014aa\u00142kK\u000e$\bC\u00015j\u001b\u0005)\u0016B\u00016V\u000599Um\\'fg\u0006\u0004&o\\2fgN\u0004\"\u0001\\:\u000e\u00035T!A\\8\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005A\f\u0018\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003I\f1aY8n\u0013\t!XNA\u0006MCjLHj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001x!\tA\b!D\u0001T\u0003\u001d)\u00070Z2vi\u0016$2c_A\u000b\u0003\u000f\ni&!\u001b\u0002\f\u0006\u0015\u0016\u0011WA_\u0003\u001f\u0004B\u0001`@\u0002\u00045\tQP\u0003\u0002\u007fG\u0006!Q\u000f^5m\u0013\r\t\t! \u0002\t\u0013R,'/\u0019;peB1\u0011QAA\u0006\u0003\u001fi!!a\u0002\u000b\u0005\u0005%\u0011!B:dC2\f\u0017\u0002BA\u0007\u0003\u000f\u0011Q!\u0011:sCf\u0004B!!\u0002\u0002\u0012%!\u00111CA\u0004\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005]!\u00011\u0001\u0002\u001a\u0005Aa-Z1ukJ,7\u000f\u0005\u0003\u0002\u001c\u0005%RBAA\u000f\u0015\u0011\ty\"!\t\u0002\rMLW\u000e\u001d7f\u0015\u0011\t\u0019#!\n\u0002\t\u0011\fG/\u0019\u0006\u0004\u0003OY\u0016\u0001C4f_R|w\u000e\\:\n\t\u0005-\u0012Q\u0004\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:DC\"!\u0006\u00020\u0005u\u0012qHA!\u0003\u0007\u0002B!!\r\u0002:5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$A\u0004gC\u000e$xN]=\u000b\u0007Y\u000b)#\u0003\u0003\u0002<\u0005M\"!\u0005#fg\u000e\u0014\u0018NY3QCJ\fW.\u001a;fe\u0006!a.Y7fC\t\t9\"A\u0006eKN\u001c'/\u001b9uS>t\u0017EAA#\u0003\tJe\u000e];uA\u0019,\u0017\r^;sK\u0002\u001aw\u000e\u001c7fGRLwN\u001c\u0011u_\u0002*gnY8eK\"9\u0011\u0011\n\u0002A\u0002\u0005-\u0013aC5oG2,H-\u001a$jIN\u00042\u0001YA'\u0013\r\ty%\u0019\u0002\b\u0005>|G.Z1oQA\t9%a\f\u0002>\u0005M\u0013\u0011IA+\u00033\nY&\t\u0002\u0002J\u0005\u0012\u0011qK\u0001\"\u0013:\u001cG.\u001e3fA\u0019,\u0017\r^;sK\u0002JEi\u001d\u0011j]\u0002\n'O]8xA\u0019LG.Z\u0001\u0004[&tW$\u0001\u0001\t\u000f\u0005}#\u00011\u0001\u0002L\u0005I\u0001O]8ys\u001aKGm\u001d\u0015\u0011\u0003;\ny#!\u0010\u0002d\u0005\u0005\u0013QMA-\u00037\n#!a\u0018\"\u0005\u0005\u001d\u0014\u0001\f)s_bL\bEZ3biV\u0014X\rI%Eg\u0002\"x\u000eI5oiN\u0004\u0013N\\:uK\u0006$\u0007e\u001c4!gR\u0014\u0018N\\4t\u0011\u001d\tYG\u0001a\u0001\u0003[\nQBZ8s[\u0006$h+\u001a:tS>t\u0007\u0003BA8\u0003{rA!!\u001d\u0002zA!\u00111OA\u0004\u001b\t\t)HC\u0002\u0002xu\u000ba\u0001\u0010:p_Rt\u0014\u0002BA>\u0003\u000f\ta\u0001\u0015:fI\u00164\u0017\u0002BA@\u0003\u0003\u0013aa\u0015;sS:<'\u0002BA>\u0003\u000fA\u0003#!\u001b\u00020\u0005u\u0012QQA!\u0003\u000f\u000bI&a\u0017\"\u0005\u0005-\u0014EAAE\u0003a\t%O]8xA%\u00036\t\t4pe6\fG\u000f\t<feNLwN\u001c\u0005\b\u0003\u001b\u0013\u0001\u0019AAH\u0003A!\u0017n\u0019;j_:\f'/\u001f$jK2$7\u000fE\u0003}\u0003#\u000bi'C\u0002\u0002\u0014v\u0014A\u0001T5ti\"B\u00121RA\u0018\u0003{\t9*!\u0011\u0002\u001a\u0006e\u00131LAO\u0003?\u000b\t+a)\"\u0005\u00055\u0015EAAN\u0003}\tE\u000f\u001e:jEV$Xm\u001d\u0011u_\u0002\"\u0017n\u0019;j_:\f'/\u001f\u0011f]\u000e|G-Z\u0001\u0004[\u0006DXD\u0001\u0001\u0001\u00049\u0019w\u000e\u001c7fGRLwN\u001c+za\u0016\u001c#!!\u001c\t\u000f\u0005\u001d&\u00011\u0001\u0002n\u0005I1o\u001c:u\r&,G\u000e\u001a\u0015\u0011\u0003K\u000by#!\u0010\u0002,\u0006\u0005\u0013QVA-\u00037\n#!a*\"\u0005\u0005=\u0016\u0001F!uiJL'-\u001e;fAQ|\u0007e]8si\u0002\u0012\u0017\u0010C\u0004\u00024\n\u0001\r!a\u0013\u0002\u0017M|'\u000f\u001e*fm\u0016\u00148/\u001a\u0015\u0011\u0003c\u000by#!\u0010\u00028\u0006\u0005\u0013\u0011XA-\u00037\n#!a-\"\u0005\u0005m\u0016A\b*fm\u0016\u00148/\u001a\u0011uQ\u0016\u0004C-\u001a4bk2$\be]8si\u0002z'\u000fZ3s\u0011\u001d\tyL\u0001a\u0001\u0003\u0003\f\u0011BY1uG\"\u001c\u0016N_3\u0011\u0007\u0001\f\u0019-C\u0002\u0002F\u0006\u0014q!\u00138uK\u001e,'\u000f\u000b\t\u0002>\u0006=\u0012QHAe\u0003\u0003\nY-!\u0017\u0002\\\u0005\u0012\u0011qX\u0011\u0003\u0003\u001b\f!GT;nE\u0016\u0014\be\u001c4!M\u0016\fG/\u001e:fg\u0002\"x\u000eI5oG2,H-\u001a\u0011j]\u0002*\u0017m\u00195!e\u0016\u001cwN\u001d3!E\u0006$8\r\u001b\u0005\b\u0003#\u0014\u0001\u0019AA&\u000351G.\u0019;uK:\u001cFO];di\"\u0002\u0012qZA\u0018\u0003{\t).!\u0011\u0002X\u0006e\u00131L\u0011\u0003\u0003#\f#!!7\u0002}I+Wn\u001c<fg\u0002\"\b.\u001a\u0011pkR,'\u000fI*G)\u0002\u001aHO];di\u0002J\u0018.\u001a7eS:<\u0007\u0005^8qA1,g/\u001a7!M\u0016\fG/\u001e:fA\u0005\u001c7-Z:tQ\u001d\u0011\u0011Q\\A!\u0003G\u0004B!!\r\u0002`&!\u0011\u0011]A\u001a\u00059!Um]2sS\n,'+Z:vYR\f#!!:\u00025\u0015s7m\u001c3fI\u00022W-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8)\u0017\u0001\tI/a<\u0002r\u0006\u0005\u0013Q\u001f\t\u0005\u0003c\tY/\u0003\u0003\u0002n\u0006M\"a\u0004#fg\u000e\u0014\u0018NY3Qe>\u001cWm]:\u0002\u000bQLG\u000f\\3\"\u0005\u0005M\u0018\u0001E!se><\beQ8om\u0016\u00148/[8oC\t\t90A\u0017D_:4XM\u001d;tA\u0005\u0004c-Z1ukJ,\u0007eY8mY\u0016\u001cG/[8oAQ|\u0007%\u0019:s_^\u0004cm\u001c:nCR\fa#\u0011:s_^\u001cuN\u001c<feNLwN\u001c)s_\u000e,7o\u001d\t\u0003q\u0012\u00192\u0001BA\u0000!\u0011\t)A!\u0001\n\t\t\r\u0011q\u0001\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005m(\u0001D!se><h+[:ji>\u00148#\u0002\u0004`\u0005\u0017Y\u0007\u0003\u0002B\u0007\u0005+i!Aa\u0004\u000b\u0007Y\u0013\tBC\u0002\u0003\u0014]\u000bQ!\u001b8eKbLAAa\u0006\u0003\u0010\t)r)Z8NKN\f\u0007K]8dKN\u001ch+[:ji>\u0014\u0018aA:giB!!Q\u0004B\u0015\u001b\t\u0011yB\u0003\u0003\u0002 \t\u0005\"\u0002\u0002B\u0012\u0005K\tqAZ3biV\u0014XM\u0003\u0003\u0003(\u0005\u0015\u0012aA1qS&!!1\u0006B\u0010\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0001\tK:\u001cw\u000eZ5oOB!!\u0011\u0007B*\u001d\u0011\u0011\u0019D!\u0014\u000f\t\tU\"q\t\b\u0005\u0005o\u0011\u0019E\u0004\u0003\u0003:\t\u0005c\u0002\u0002B\u001e\u0005\u007fqA!a\u001d\u0003>%\tA,\u0003\u0002[7&\u0011\u0001,W\u0005\u0004\u0005\u000b:\u0016!B1se><\u0018\u0002\u0002B%\u0005\u0017\naA^3di>\u0014(b\u0001B#/&!!q\nB)\u0003M\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKZ+7\r^8s\u0015\u0011\u0011IEa\u0013\n\t\tU#q\u000b\u0002\u0016'&l\u0007\u000f\\3GK\u0006$XO]3F]\u000e|G-\u001b8h\u0015\u0011\u0011yE!\u0015\u0002\u0015%\u00048MV3sg&|g\u000e\u0005\u0004\u0003^\t\u001d\u0014Q\u000e\b\u0005\u0005?\u0012\u0019G\u0004\u0003\u0002t\t\u0005\u0014BAA\u0005\u0013\u0011\u0011)'a\u0002\u0002\u000fA\f7m[1hK&!!\u0011\u000eB6\u0005\r\u0019V-\u001d\u0006\u0005\u0005K\n9\u0001\u0005\u0004\u0002\u0006\t=\u0014QN\u0005\u0005\u0005c\n9A\u0001\u0004PaRLwN\u001c\t\u0007\u0003\u000b\u0011yG!\u001e\u0011\t\u0005\u0015!qO\u0005\u0005\u0003\u001f\n9!A\u0005qe\u0016\u001cvN\u001d;fIB!\u0011Q\u0001B?\u0013\u0011\u0011y(a\u0002\u0003\u0007%sG\u000f\u0006\u000b\u0003\u0004\n\u001d%\u0011\u0012BF\u0005\u001b\u0013yI!%\u0003\u0014\nU%q\u0013\t\u0004\u0005\u000b3Q\"\u0001\u0003\t\u000f\te\u0001\u00031\u0001\u0003\u001c!9!Q\u0006\tA\u0002\t=\u0002b\u0002B-!\u0001\u0007\u0011Q\u000e\u0005\b\u0003\u001b\u0003\u0002\u0019\u0001B.\u0011\u001d\t9\u000b\u0005a\u0001\u0005[Bq!a-\u0011\u0001\u0004\u0011\u0019\bC\u0004\u0003zA\u0001\rA!\u001e\t\u000f\u0005}\u0006\u00031\u0001\u0003|!9\u0011\u0011\u001b\tA\u0002\tU\u0014!D7b]V\fGNV5tSR|'/\u0006\u0002\u0003\u001eB\u0019!Q\u0011\r\u0003%\u0005\u0013(o\\<NC:,\u0018\r\u001c,jg&$xN]\n\u00041\u0005}\u0018!\u0002<jg&$H\u0003\u0002BT\u0005[\u0003B!!\u0002\u0003*&!!1VA\u0004\u0005\u0011)f.\u001b;\t\u000f\t\r\u0012\u00041\u0001\u00030B!!Q\u0004BY\u0013\u0011\u0011\u0019La\b\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0003\u001d\u0011Xm];miN,\"A!/\u0011\r\tu#1XA\u0002\u0013\u0011\t\tAa\u001b\u0002\rI,7/\u001e7u\u0003)\u0011Xm];mi~#S-\u001d\u000b\u0005\u0005O\u0013\u0019\rC\u0005\u0003FN\t\t\u00111\u0001\u0003:\u0006\u0019\u0001\u0010J\u0019\u0002\u000fI,7/\u001e7uA\u0005Iq-\u001a;SKN,H\u000e\u001e\u000b\u0003\u0005\u001b\u00042A!\">\u0005-\t%O]8x%\u0016\u001cX\u000f\u001c;\u0014\u000fu\u0012\u0019N!9\u0003hB!!Q\u001bBo\u001b\t\u00119N\u0003\u0003\u0003Z\nm\u0017a\u0002<jg&$xN\u001d\u0006\u0005\u0005G\t)#\u0003\u0003\u0003`\n]'AE!cgR\u0014\u0018m\u0019;DC2\u001c'+Z:vYR\u0004B!!\u0002\u0003d&!!Q]A\u0004\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\u0002\u0003j&!!1^A\u0004\u00051\u0019VM]5bY&T\u0018M\u00197f+\u0005Y\u0018\u0001\u0003:fgVdGo\u001d\u0011\u0015\t\t5'1\u001f\u0005\u0007\u0005k\u0003\u0005\u0019A>\u0002\u0011\u001d,GOV1mk\u0016$\"!a@\u0002\t\r|\u0007/\u001f\u000b\u0005\u0005\u001b\u0014i\u0010\u0003\u0005\u00036\n\u0003\n\u00111\u0001|\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"aa\u0001+\u0007m\u001c)a\u000b\u0002\u0004\bA!1\u0011BB\n\u001b\t\u0019YA\u0003\u0003\u0004\u000e\r=\u0011!C;oG\",7m[3e\u0015\u0011\u0019\t\"a\u0002\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\u0016\r-!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"aa\u0007\u0011\u0007\u0001\u001ci\"C\u0002\u0002\u0000\u0005\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u001f\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!1qEB\u0017!\u0011\t)a!\u000b\n\t\r-\u0012q\u0001\u0002\u0004\u0003:L\b\"\u0003Bc\r\u0006\u0005\t\u0019\u0001B>\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB\u001a!\u0019\u0019)da\u000f\u0004(5\u00111q\u0007\u0006\u0005\u0007s\t9!\u0001\u0006d_2dWm\u0019;j_:LA!!\u0001\u00048\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0003v\r\u0005\u0003\"\u0003Bc\u0011\u0006\u0005\t\u0019AB\u0014\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B>\u0003\u0019)\u0017/^1mgR!!QOB&\u0011%\u0011)MSA\u0001\u0002\u0004\u00199\u0003\u0006\u0003\u0003(\u000e=\u0003b\u0002B\u0012-\u0001\u00071\u0011\u000b\t\u0005\u0007'\u001a)&\u0004\u0002\u0003\"%!1q\u000bB\u0011\u0005\u001d1U-\u0019;ve\u0016$bAa*\u0004\\\r%\u0004bBB//\u0001\u00071qL\u0001\u0007g>,(oY3\u0011\t\r\u00054QM\u0007\u0003\u0007GRA!a\t\u0003&%!1qMB2\u0005M\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKN{WO]2f\u0011\u001d\u0019Yg\u0006a\u0001\u0007[\nQ!];fef\u0004Ba!\u0019\u0004p%!1\u0011OB2\u0005\u0015\tV/\u001a:z\u0005a\u0019\u0016.\u001c9mK\u0006\u0013(o\\<NC:,\u0018\r\u001c,jg&$xN]\n\u00067\u0005}(QT\u0001\bSB\u001cw\n\u001d;t!\u0011\u0019Yh!$\u000e\u0005\ru$\u0002BB@\u0007\u0003\u000bq!\\3tg\u0006<WM\u0003\u0003\u0004\u0004\u000e\u0015\u0015aA5qG*!!\u0011JBD\u0015\u0011\u0011)e!#\u000b\u0007\r-5,\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0007\u001f\u001biHA\u0005Ja\u000e|\u0005\u000f^5p]\u0006!1o\u001c:u!\u0019\t)Aa\u001c\u0004\u0016BA\u0011QABL\u0003[\u0012)(\u0003\u0003\u0004\u001a\u0006\u001d!A\u0002+va2,'\u0007\u0006\b\u0004\u001e\u000e}5\u0011UBR\u0007K\u001b9k!+\u0011\u0007\t\u00155\u0004C\u0004\u0003\u001a\t\u0002\rAa\u0007\t\u000f\t5\"\u00051\u0001\u00030!91q\u000f\u0012A\u0002\re\u0004bBBIE\u0001\u000711\u0013\u0005\b\u0003\u007f\u0013\u0003\u0019\u0001B>\u0011\u001d\t\tN\ta\u0001\u0005k\n1a\\;u+\t\u0019y\u000b\u0005\u0003\u00042\u000e]VBABZ\u0015\r\u0019)lY\u0001\u0003S>LAa!/\u00044\n)\")\u001f;f\u0003J\u0014\u0018-_(viB,Ho\u0015;sK\u0006l\u0017\u0001B8vi\u0002\nQAY=uKN,\"a!1\u0011\r\r\r7\u0011ZA\u0002\u001b\t\u0019)M\u0003\u0003\u0004H\u000e]\u0012aB7vi\u0006\u0014G.Z\u0005\u0005\u0007\u0017\u001c)M\u0001\u0006MSN$()\u001e4gKJ\faAY=uKN\u0004\u0013!B2pk:$XCABj!\u0011\t)a!6\n\t\r]\u0017q\u0001\u0002\u0005\u0019>tw-A\u0005d_VtGo\u0018\u0013fcR!!qUBo\u0011%\u0011)\rKA\u0001\u0002\u0004\u0019\u0019.\u0001\u0004d_VtG\u000fI\u0001\u0007oJLG/\u001a:\u0016\u0005\r\u0015\b\u0003BBt\u0007Wl!a!;\u000b\t\rU&1J\u0005\u0005\u0007[\u001cIO\u0001\u000fTS6\u0004H.\u001a$fCR,(/Z!se><h)\u001b7f/JLG/\u001a:\u0002\u000f]\u0014\u0018\u000e^3sAQ!!qUBz\u0011\u001d\u0011\u0019\u0003\fa\u0001\u0005_\u0013\u0011dQ8na2,\u00070\u0011:s_^l\u0015M\\;bYZK7/\u001b;peN)a&a@\u0003\u001eR\u001121`B\u007f\u0007\u007f$\t\u0001b\u0001\u0005\u0006\u0011\u001dA\u0011\u0002C\u0006!\r\u0011)I\f\u0005\b\u000539\u0004\u0019\u0001B\u000e\u0011\u001d\u0011ic\u000ea\u0001\u0005_Aqaa\u001e8\u0001\u0004\u0019I\bC\u0004\u0002\u000e^\u0002\rAa\u0017\t\u000f\rEu\u00071\u0001\u0004\u0014\"9!\u0011P\u001cA\u0002\tU\u0004bBA`o\u0001\u0007!1\u0010\u0005\b\u0003#<\u0004\u0019\u0001B;+\t!y\u0001\u0005\u0004\u0004D\u0012E!qV\u0005\u0005\t'\u0019)MA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\u0018!\u00034fCR,(/Z:!)\u0011\u00119\u000b\"\u0007\t\u000f\t\r\"\b1\u0001\u00030\u0006Y!-^5mIJ+7/\u001e7u)\u0019\u0011I\fb\b\u00052!9A\u0011\u0005\u001fA\u0002\u0011\r\u0012\u0001\u00043jGRLwN\\1sS\u0016\u001c\b\u0003CA8\tK\ti\u0007\"\u000b\n\t\u0011\u001d\u0012\u0011\u0011\u0002\u0004\u001b\u0006\u0004\b\u0003\u0002C\u0016\t[i!A!\u0015\n\t\u0011=\"\u0011\u000b\u0002\u0010\u0003J\u0014xn\u001e#jGRLwN\\1ss\"9A1\u0007\u001fA\u0002\u0011U\u0012AB:peR,G\r\u0005\u0004\u0003^\tm&qV\u0001\f\u0003J\u0014xn\u001e*fgVdG\u000fE\u0002\u0003\u00062\u001bR\u0001\u0014C\u001f\u0005O\u0004r\u0001b\u0010\u0005Fm\u0014i-\u0004\u0002\u0005B)!A1IA\u0004\u0003\u001d\u0011XO\u001c;j[\u0016LA\u0001b\u0012\u0005B\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\u0011e\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\rm\u0011!B1qa2LH\u0003\u0002Bg\t'BaA!.P\u0001\u0004Y\u0018aB;oCB\u0004H.\u001f\u000b\u0005\t3\"Y\u0006E\u0003\u0002\u0006\t=4\u0010C\u0005\u0005^A\u000b\t\u00111\u0001\u0003N\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002?\u0002")
public class ArrowConversionProcess
implements GeoMesaProcess,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ArrowConversionProcess arrowConversionProcess = this;
        synchronized (arrowConversionProcess) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @DescribeResult(description="Encoded feature collection")
    public java.util.Iterator<byte[]> execute(@DescribeParameter(name="features", description="Input feature collection to encode") SimpleFeatureCollection features, @DescribeParameter(name="includeFids", description="Include feature IDs in arrow file", min=0) Boolean includeFids, @DescribeParameter(name="proxyFids", description="Proxy feature IDs to ints instead of strings", min=0) Boolean proxyFids, @DescribeParameter(name="formatVersion", description="Arrow IPC format version", min=0) String formatVersion, @DescribeParameter(name="dictionaryFields", description="Attributes to dictionary encode", min=0, max=128, collectionType=String.class) List<String> dictionaryFields, @DescribeParameter(name="sortField", description="Attribute to sort by", min=0) String sortField, @DescribeParameter(name="sortReverse", description="Reverse the default sort order", min=0) Boolean sortReverse, @DescribeParameter(name="batchSize", description="Number of features to include in each record batch", min=0) Integer batchSize, @DescribeParameter(name="flattenStruct", description="Removes the outer SFT struct yielding top level feature access", min=0) Boolean flattenStruct) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running arrow encoding for {}", new Object[]{features.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SimpleFeatureType sft = (SimpleFeatureType)features.getSchema();
        Seq toEncode = (Seq)Option$.MODULE$.apply(dictionaryFields).map((Function1 & Serializable & scala.Serializable)x$1 -> ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        toEncode.foreach((Function1 & Serializable & scala.Serializable)attribute -> {
            ArrowConversionProcess.$anonfun$execute$3(sft, attribute);
            return BoxedUnit.UNIT;
        });
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(includeFids == null || Predef$.MODULE$.Boolean2boolean(includeFids), proxyFids != null && Predef$.MODULE$.Boolean2boolean(proxyFids));
        String ipcVersion = (String)Option$.MODULE$.apply((Object)formatVersion).getOrElse((Function0 & Serializable & scala.Serializable)() -> package.FormatVersion$.MODULE$.ArrowFormatVersion().get());
        Option reverse = Option$.MODULE$.apply((Object)sortReverse).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2));
        int batch = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)batchSize).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(package.ArrowProperties$.MODULE$.BatchSize().get())).toInt()));
        ArrowVisitor visitor = new ArrowVisitor(sft, encoding, ipcVersion, (Seq<String>)toEncode, (Option<String>)Option$.MODULE$.apply((Object)sortField), (Option<Object>)reverse, false, batch, Predef$.MODULE$.Boolean2boolean(flattenStruct));
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    public static final /* synthetic */ void $anonfun$execute$3(SimpleFeatureType sft$1, String attribute) {
        if (sft$1.indexOf(attribute) == -1) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Attribute ").append(attribute).append(" doesn't exist in ").append(sft$1).toString());
        }
    }

    public ArrowConversionProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }

    public static interface ArrowManualVisitor {
        public void visit(SimpleFeature var1);

        public Iterator<byte[]> results();
    }

    public static class ArrowResult
    extends AbstractCalcResult
    implements Product,
    scala.Serializable {
        private final java.util.Iterator<byte[]> results;

        public java.util.Iterator<byte[]> results() {
            return this.results;
        }

        public Object getValue() {
            return this.results();
        }

        public ArrowResult copy(java.util.Iterator<byte[]> results) {
            return new ArrowResult(results);
        }

        public java.util.Iterator<byte[]> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "ArrowResult";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ArrowResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ArrowResult)) return false;
            boolean bl = true;
            if (!bl) return false;
            ArrowResult arrowResult = (ArrowResult)((Object)x$1);
            java.util.Iterator<byte[]> iterator = this.results();
            java.util.Iterator<byte[]> iterator2 = arrowResult.results();
            if (iterator == null) {
                if (iterator2 != null) {
                    return false;
                }
            } else if (!iterator.equals(iterator2)) return false;
            if (!arrowResult.canEqual((Object)this)) return false;
            return true;
        }

        public ArrowResult(java.util.Iterator<byte[]> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class ArrowVisitor
    implements GeoMesaProcessVisitor,
    LazyLogging {
        private ArrowManualVisitor manualVisitor;
        private final SimpleFeatureType sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final String ipcVersion;
        private final Seq<String> dictionaryFields;
        private final Option<String> sortField;
        private final Option<Object> sortReverse;
        private final boolean preSorted;
        private final int batchSize;
        private final boolean flattenStruct;
        private Iterator<byte[]> result;
        private transient Logger logger;
        private volatile boolean bitmap$0;
        private volatile transient boolean bitmap$trans$0;

        public List<Expression> getExpressions() {
            return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
        }

        private Logger logger$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        private ArrowManualVisitor manualVisitor$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if (!this.bitmap$0) {
                    Option sort = this.sortField.map((Function1 & Serializable & scala.Serializable)s -> new Tuple2(s, $this.sortReverse.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)));
                    IpcOption ipcOpts = package.FormatVersion$.MODULE$.options(this.ipcVersion);
                    this.manualVisitor = this.dictionaryFields.isEmpty() && (this.sortField.isEmpty() || this.preSorted) ? new SimpleArrowManualVisitor(this.sft, this.encoding, ipcOpts, (Option<Tuple2<String, Object>>)sort, this.batchSize, this.flattenStruct) : new ComplexArrowManualVisitor(this.sft, this.encoding, ipcOpts, this.dictionaryFields, (Option<Tuple2<String, Object>>)sort, this.preSorted, this.batchSize, this.flattenStruct);
                    this.bitmap$0 = true;
                }
            }
            return this.manualVisitor;
        }

        private ArrowManualVisitor manualVisitor() {
            if (!this.bitmap$0) {
                return this.manualVisitor$lzycompute();
            }
            return this.manualVisitor;
        }

        private Iterator<byte[]> result() {
            return this.result;
        }

        private void result_$eq(Iterator<byte[]> x$1) {
            this.result = x$1;
        }

        public ArrowResult getResult() {
            if (this.result() != null) {
                return new ArrowResult((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.result()).asJava());
            }
            return new ArrowResult((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.manualVisitor().results()).asJava());
        }

        public void visit(Feature feature) {
            this.manualVisitor().visit((SimpleFeature)feature);
        }

        public void execute(SimpleFeatureSource source, Query query) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Visiting source type: {}", new Object[]{source.getClass().getName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_ENCODE(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_DICTIONARY_FIELDS(), (Object)this.dictionaryFields.mkString(","));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.fids().isDefined()));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_PROXY_FID(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.fids().contains((Object)SimpleFeatureVector.SimpleFeatureEncoding$.Encoding$.MODULE$.Min())));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_BATCH_SIZE(), (Object)BoxesRunTime.boxToInteger((int)this.batchSize));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_FORMAT_VERSION(), (Object)this.ipcVersion);
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_FLATTEN_STRUCT(), (Object)BoxesRunTime.boxToBoolean((boolean)this.flattenStruct));
            this.sortField.foreach((Function1 & Serializable & scala.Serializable)x$4 -> query.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_FIELD(), x$4));
            this.sortReverse.foreach((Function1 & Serializable & scala.Serializable)x$5 -> ArrowVisitor.$anonfun$execute$9(query, BoxesRunTime.unboxToBoolean((Object)x$5)));
            SelfClosingIterator features = SelfClosingIterator$.MODULE$.apply(source.getFeatures(query));
            this.result_$eq((Iterator<byte[]>)features.map((Function1 & Serializable & scala.Serializable)x$6 -> (byte[])x$6.getAttribute(0)));
        }

        public static final /* synthetic */ Object $anonfun$execute$9(Query query$1, boolean x$5) {
            return query$1.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_REVERSE(), (Object)BoxesRunTime.boxToBoolean((boolean)x$5));
        }

        public ArrowVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, String ipcVersion, Seq<String> dictionaryFields, Option<String> sortField, Option<Object> sortReverse, boolean preSorted, int batchSize, boolean flattenStruct) {
            this.sft = sft;
            this.encoding = encoding;
            this.ipcVersion = ipcVersion;
            this.dictionaryFields = dictionaryFields;
            this.sortField = sortField;
            this.sortReverse = sortReverse;
            this.preSorted = preSorted;
            this.batchSize = batchSize;
            this.flattenStruct = flattenStruct;
            GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
            LazyLogging.$init$((LazyLogging)this);
        }
    }

    private static class ComplexArrowManualVisitor
    implements ArrowManualVisitor {
        private final SimpleFeatureType sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final IpcOption ipcOpts;
        private final Seq<String> dictionaryFields;
        private final Option<Tuple2<String, Object>> sort;
        private final boolean preSorted;
        private final int batchSize;
        private final boolean flattenStruct;
        private final ArrayBuffer<SimpleFeature> features;

        private ArrayBuffer<SimpleFeature> features() {
            return this.features;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.features().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeature[]{ScalaSimpleFeature$.MODULE$.copy(feature)}));
        }

        @Override
        public Iterator<byte[]> results() {
            Iterator iterator;
            None$ ordering;
            Map map;
            if (this.dictionaryFields.isEmpty()) {
                map = Predef$.MODULE$.Map().empty();
            } else {
                Seq indicesAndValues = (Seq)this.dictionaryFields.map((Function1 & Serializable & scala.Serializable)field -> new Tuple3(field, (Object)BoxesRunTime.boxToInteger((int)$this.sft.indexOf(field)), (Object)HashSet$.MODULE$.empty()), Seq$.MODULE$.canBuildFrom());
                this.features().foreach((Function1 & Serializable & scala.Serializable)f -> {
                    indicesAndValues.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ComplexArrowManualVisitor.$anonfun$results$3(f, x0$1)));
                    return BoxedUnit.UNIT;
                });
                map = ((TraversableOnce)indicesAndValues.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple3 tuple3 = x0$2;
                    if (tuple3 != null) {
                        String n = (String)tuple3._1();
                        int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
                        HashSet v = (HashSet)tuple3._3();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n), (Object)ArrowDictionary$.MODULE$.create($this.sft.getTypeName(), (long)i, (Object[])v.toArray(ClassTag$.MODULE$.AnyRef()), ClassTag$.MODULE$.apply($this.sft.getDescriptor(i).getType().getBinding())));
                    }
                    throw new MatchError((Object)tuple3);
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
            Map dictionaries = map;
            None$ none$ = ordering = this.preSorted ? None$.MODULE$ : this.sort.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    String field = (String)tuple2._1();
                    boolean reverse = tuple2._2$mcZ$sp();
                    return SimpleFeatureOrdering$.MODULE$.apply($this.sft, field, reverse);
                }
                throw new MatchError((Object)tuple2);
            });
            if (None$.MODULE$.equals(none$)) {
                iterator = this.features().iterator();
            } else if (none$ instanceof Some) {
                Some some = (Some)none$;
                Ordering o = (Ordering)some.value();
                iterator = ((IndexedSeqLike)this.features().sorted(o)).iterator();
            } else {
                throw new MatchError((Object)none$);
            }
            Iterator sorted = iterator;
            return this.buildResult((Map<String, ArrowDictionary>)dictionaries, (Iterator<SimpleFeature>)sorted);
        }

        private Iterator<byte[]> buildResult(Map<String, ArrowDictionary> dictionaries, Iterator<SimpleFeature> sorted) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ListBuffer bytes = (ListBuffer)ListBuffer$.MODULE$.empty();
            package.WithClose$.MODULE$.apply((Object)SimpleFeatureArrowFileWriter$.MODULE$.apply((OutputStream)out, this.sft, dictionaries, this.encoding, this.ipcOpts, this.sort, this.flattenStruct), (Function1 & Serializable & scala.Serializable)writer -> {
                ComplexArrowManualVisitor.$anonfun$buildResult$1(this, sorted, bytes, out, writer);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            bytes.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{out.toByteArray()}));
            return bytes.iterator();
        }

        public static final /* synthetic */ boolean $anonfun$results$3(SimpleFeature f$1, Tuple3 x0$1) {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
                HashSet v = (HashSet)tuple3._3();
                return v.add(f$1.getAttribute(i));
            }
            throw new MatchError((Object)tuple3);
        }

        public static final /* synthetic */ void $anonfun$buildResult$1(ComplexArrowManualVisitor $this, Iterator sorted$1, ListBuffer bytes$1, ByteArrayOutputStream out$1, SimpleFeatureArrowFileWriter writer) {
            while (sorted$1.hasNext()) {
                for (int i = 0; i < $this.batchSize && sorted$1.hasNext(); ++i) {
                    writer.add((SimpleFeature)sorted$1.next());
                }
                writer.flush();
                bytes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{out$1.toByteArray()}));
                out$1.reset();
            }
        }

        public ComplexArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, IpcOption ipcOpts, Seq<String> dictionaryFields, Option<Tuple2<String, Object>> sort, boolean preSorted, int batchSize, boolean flattenStruct) {
            this.sft = sft;
            this.encoding = encoding;
            this.ipcOpts = ipcOpts;
            this.dictionaryFields = dictionaryFields;
            this.sort = sort;
            this.preSorted = preSorted;
            this.batchSize = batchSize;
            this.flattenStruct = flattenStruct;
            this.features = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        }
    }

    private static class SimpleArrowManualVisitor
    implements ArrowManualVisitor {
        private final int batchSize;
        private final ByteArrayOutputStream out;
        private final ListBuffer<byte[]> bytes;
        private long count;
        private final SimpleFeatureArrowFileWriter writer;

        private ByteArrayOutputStream out() {
            return this.out;
        }

        private ListBuffer<byte[]> bytes() {
            return this.bytes;
        }

        private long count() {
            return this.count;
        }

        private void count_$eq(long x$1) {
            this.count = x$1;
        }

        private SimpleFeatureArrowFileWriter writer() {
            return this.writer;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.writer().add(feature);
            this.count_$eq(this.count() + 1L);
            if (this.count() % (long)this.batchSize == 0L) {
                this.writer().flush();
                this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
                this.out().reset();
                return;
            }
        }

        @Override
        public Iterator<byte[]> results() {
            package.CloseWithLogging$.MODULE$.apply((Object)this.writer(), IsCloseable$.MODULE$.closeableIsCloseable());
            this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
            return this.bytes().iterator();
        }

        public SimpleArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, IpcOption ipcOpts, Option<Tuple2<String, Object>> sort, int batchSize, boolean flattenStruct) {
            this.batchSize = batchSize;
            this.out = new ByteArrayOutputStream();
            this.bytes = (ListBuffer)ListBuffer$.MODULE$.empty();
            this.count = 0L;
            this.writer = SimpleFeatureArrowFileWriter$.MODULE$.apply((OutputStream)this.out(), sft, Predef$.MODULE$.Map().empty(), encoding, ipcOpts, sort, flattenStruct);
        }
    }
}

