/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.transform;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter$;
import org.locationtech.geomesa.arrow.io.package;
import org.locationtech.geomesa.arrow.package;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@DescribeProcess(title="Arrow Conversion", description="Converts a feature collection to arrow format")
@ScalaSignature(bytes="\u0006\u0001\u0011ud\u0001B*U\u0001}CQA\u001e\u0001\u0005\u0002]DQA\u001f\u0001\u0005\u0002mD\u0011\"a?\u0001#\u0003%\t!!@\b\u000f\t\u0015B\u000b#\u0001\u0003(\u001911\u000b\u0016E\u0001\u0005SAaA^\u0003\u0005\u0002\tEbA\u0002B\u001a\u000b\u0001\u0011)\u0004\u0003\u0006\u0003F\u001d\u0011\t\u0011)A\u0005\u0005\u000fB!B!\u0017\b\u0005\u0003\u0005\u000b\u0011\u0002B.\u0011)\u0011)i\u0002B\u0001B\u0003%\u0011q\u000e\u0005\u000b\u0003\u001f;!\u0011!Q\u0001\n\t\u001d\u0005BCAU\u000f\t\u0005\t\u0015!\u0003\u0003\u001a\"Q\u0011QW\u0004\u0003\u0002\u0003\u0006IAa(\t\u0015\t\u0015vA!A!\u0002\u0013\u0011\t\u000b\u0003\u0006\u0002B\u001e\u0011\t\u0011)A\u0005\u0005OC!\"a5\b\u0005\u0003\u0005\u000b\u0011\u0002BQ\u0011\u00191x\u0001\"\u0001\u0003.\"Q!QY\u0004\t\u0006\u0004%IAa2\t\u0017\t%x\u00011AA\u0002\u0013%!1\u001d\u0005\f\u0005W<\u0001\u0019!a\u0001\n\u0013\u0011i\u000fC\u0006\u0003t\u001e\u0001\r\u0011!Q!\n\t\u0015\bb\u0002B{\u000f\u0011\u0005#q\u001f\u0005\b\u0005\u001f<A\u0011IB4\u0011\u0019Qx\u0001\"\u0011\u0004t\u0019I!1Z\u0003\u0011\u0002G\u0005!Q\u001a\u0005\b\u0005\u001fLb\u0011\u0001Bi\u0011\u001d\u0011\t/\u0007D\u0001\u0005G4aa!$\u0006\t\r=\u0005B\u0003B#9\t\u0005\t\u0015!\u0003\u0003H!Q!\u0011\f\u000f\u0003\u0002\u0003\u0006IAa\u0017\t\u0015\rEED!A!\u0002\u0013\u0019\u0019\n\u0003\u0006\u0004,r\u0011\t\u0011)A\u0005\u0007[C!\"!1\u001d\u0005\u0003\u0005\u000b\u0011\u0002BT\u0011)\t\u0019\u000e\bB\u0001B\u0003%!\u0011\u0015\u0005\u0007mr!\ta!.\t\u0013\r\u0015GD1A\u0005\n\r\u001d\u0007\u0002CBk9\u0001\u0006Ia!3\t\u0013\r]GD1A\u0005\n\re\u0007\u0002CBt9\u0001\u0006Iaa7\t\u0013\r%H\u00041A\u0005\n\r-\b\"CBz9\u0001\u0007I\u0011BB{\u0011!\u0019I\u0010\bQ!\n\r5\b\"CB~9\t\u0007I\u0011BB\u007f\u0011!!I\u0001\bQ\u0001\n\r}\bb\u0002Bh9\u0011\u0005C1\u0002\u0005\b\u0005CdB\u0011\tBr\r\u0019!y!\u0002\u0003\u0005\u0012!Q!QI\u0018\u0003\u0002\u0003\u0006IAa\u0012\t\u0015\tesF!A!\u0002\u0013\u0011Y\u0006\u0003\u0006\u0004\u0012>\u0012\t\u0011)A\u0005\u0007'C!\"a$0\u0005\u0003\u0005\u000b\u0011\u0002BD\u0011)\u0019Yk\fB\u0001B\u0003%1Q\u0016\u0005\u000b\u0005K{#\u0011!Q\u0001\n\t\u0005\u0006BCAa_\t\u0005\t\u0015!\u0003\u0003(\"Q\u00111[\u0018\u0003\u0002\u0003\u0006IA!)\t\rY|C\u0011\u0001C\n\u0011%\tIb\fb\u0001\n\u0013!9\u0003\u0003\u0005\u00050=\u0002\u000b\u0011\u0002C\u0015\u0011\u001d\u0011ym\fC!\tcAqA!90\t\u0003\u0012\u0019\u000fC\u0004\u00056=\"I\u0001b\u000e\u0007\r\tmX\u0001\u0011B\u007f\u0011)\u0011\tO\u0010BK\u0002\u0013\u00051\u0011\u0004\u0005\n\u00077q$\u0011#Q\u0001\nqDaA\u001e \u0005\u0002\ru\u0001bBB\u0011}\u0011\u000531\u0005\u0005\n\u0007Kq\u0014\u0011!C\u0001\u0007OA\u0011ba\u000b?#\u0003%\ta!\f\t\u0013\rEb(!A\u0005B\rM\u0002\"CB\u001d}\u0005\u0005I\u0011AB\u001e\u0011%\u0019iDPA\u0001\n\u0003\u0019y\u0004C\u0005\u0004Jy\n\t\u0011\"\u0011\u0004L!I1q\u000b \u0002\u0002\u0013\u00051\u0011\f\u0005\n\u0007;r\u0014\u0011!C!\u0007?B\u0011b!\u0019?\u0003\u0003%\tea\u0019\b\u0013\u0011ES!!A\t\u0002\u0011Mc!\u0003B~\u000b\u0005\u0005\t\u0012\u0001C+\u0011\u00191X\n\"\u0001\u0005d!IAQM'\u0002\u0002\u0013\u0015Cq\r\u0005\n\tSj\u0015\u0011!CA\tWB\u0011\u0002b\u001cN\u0003\u0003%\t\t\"\u001d\t\u0013\u0011eT*!A\u0005\n\u0011m$AF!se><8i\u001c8wKJ\u001c\u0018n\u001c8Qe>\u001cWm]:\u000b\u0005U3\u0016!\u0003;sC:\u001chm\u001c:n\u0015\t9\u0006,A\u0004qe>\u001cWm]:\u000b\u0005eS\u0016aB4f_6,7/\u0019\u0006\u00037r\u000bA\u0002\\8dCRLwN\u001c;fG\"T\u0011!X\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0001DG\u000e\u0005\u0002bM6\t!M\u0003\u0002dI\u0006!A.\u00198h\u0015\u0005)\u0017\u0001\u00026bm\u0006L!a\u001a2\u0003\r=\u0013'.Z2u!\tI'.D\u0001W\u0013\tYgK\u0001\bHK>lUm]1Qe>\u001cWm]:\u0011\u00055$X\"\u00018\u000b\u0005=\u0004\u0018\u0001D:dC2\fGn\\4hS:<'BA9s\u0003!!\u0018\u0010]3tC\u001a,'\"A:\u0002\u0007\r|W.\u0003\u0002v]\nYA*\u0019>z\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0010\u0005\u0002z\u00015\tA+A\u0004fq\u0016\u001cW\u000f^3\u0015+q\f9\"!\u0013\u0002`\u0005-\u0014QRAT\u0003g\u000by,!5\u0002^B)Q0!\u0001\u0002\u00065\taP\u0003\u0002\u0000I\u0006!Q\u000f^5m\u0013\r\t\u0019A \u0002\t\u0013R,'/\u0019;peB1\u0011qAA\u0007\u0003#i!!!\u0003\u000b\u0005\u0005-\u0011!B:dC2\f\u0017\u0002BA\b\u0003\u0013\u0011Q!\u0011:sCf\u0004B!a\u0002\u0002\u0014%!\u0011QCA\u0005\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005e!\u00011\u0001\u0002\u001c\u0005Aa-Z1ukJ,7\u000f\u0005\u0003\u0002\u001e\u0005-RBAA\u0010\u0015\u0011\t\t#a\t\u0002\rMLW\u000e\u001d7f\u0015\u0011\t)#a\n\u0002\t\u0011\fG/\u0019\u0006\u0004\u0003Sa\u0016\u0001C4f_R|w\u000e\\:\n\t\u00055\u0012q\u0004\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:DC\"a\u0006\u00022\u0005}\u0012\u0011IA\"\u0003\u000b\u0002B!a\r\u0002<5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$A\u0004gC\u000e$xN]=\u000b\u0007]\u000b9#\u0003\u0003\u0002>\u0005U\"!\u0005#fg\u000e\u0014\u0018NY3QCJ\fW.\u001a;fe\u0006!a.Y7fC\t\tI\"A\u0006eKN\u001c'/\u001b9uS>t\u0017EAA$\u0003\tJe\u000e];uA\u0019,\u0017\r^;sK\u0002\u001aw\u000e\u001c7fGRLwN\u001c\u0011u_\u0002*gnY8eK\"9\u00111\n\u0002A\u0002\u00055\u0013aC5oG2,H-\u001a$jIN\u00042!YA(\u0013\r\t\tF\u0019\u0002\b\u0005>|G.Z1oQA\tI%!\r\u0002@\u0005U\u00131IA,\u00037\ni&\t\u0002\u0002L\u0005\u0012\u0011\u0011L\u0001\"\u0013:\u001cG.\u001e3fA\u0019,\u0017\r^;sK\u0002JEi\u001d\u0011j]\u0002\n'O]8xA\u0019LG.Z\u0001\u0004[&tW$\u0001\u0001\t\u000f\u0005\u0005$\u00011\u0001\u0002N\u0005I\u0001O]8ys\u001aKGm\u001d\u0015\u0011\u0003?\n\t$a\u0010\u0002f\u0005\r\u0013qMA.\u0003;\n#!!\u0019\"\u0005\u0005%\u0014\u0001\f)s_bL\bEZ3biV\u0014X\rI%Eg\u0002\"x\u000eI5oiN\u0004\u0013N\\:uK\u0006$\u0007e\u001c4!gR\u0014\u0018N\\4t\u0011\u001d\tiG\u0001a\u0001\u0003_\nQBZ8s[\u0006$h+\u001a:tS>t\u0007\u0003BA9\u0003\u007frA!a\u001d\u0002|A!\u0011QOA\u0005\u001b\t\t9HC\u0002\u0002zy\u000ba\u0001\u0010:p_Rt\u0014\u0002BA?\u0003\u0013\ta\u0001\u0015:fI\u00164\u0017\u0002BAA\u0003\u0007\u0013aa\u0015;sS:<'\u0002BA?\u0003\u0013A\u0003#a\u001b\u00022\u0005}\u0012qQA\"\u0003\u0013\u000bY&!\u0018\"\u0005\u00055\u0014EAAF\u0003a\t%O]8xA%\u00036\t\t4pe6\fG\u000f\t<feNLwN\u001c\u0005\b\u0003\u001f\u0013\u0001\u0019AAI\u0003A!\u0017n\u0019;j_:\f'/\u001f$jK2$7\u000fE\u0003~\u0003'\u000by'C\u0002\u0002\u0016z\u0014A\u0001T5ti\"B\u0012QRA\u0019\u0003\u007f\tI*a\u0011\u0002\u001c\u0006m\u0013QLAP\u0003C\u000b\u0019+!*\"\u0005\u0005=\u0015EAAO\u0003}\tE\u000f\u001e:jEV$Xm\u001d\u0011u_\u0002\"\u0017n\u0019;j_:\f'/\u001f\u0011f]\u000e|G-Z\u0001\u0004[\u0006DXD\u0001\u0001\u0001\u00049\u0019w\u000e\u001c7fGRLwN\u001c+za\u0016\u001c#!a\u001c\t\u000f\u0005%&\u00011\u0001\u0002p\u0005I1o\u001c:u\r&,G\u000e\u001a\u0015\u0011\u0003O\u000b\t$a\u0010\u0002.\u0006\r\u0013qVA.\u0003;\n#!!+\"\u0005\u0005E\u0016\u0001F!uiJL'-\u001e;fAQ|\u0007e]8si\u0002\u0012\u0017\u0010C\u0004\u00026\n\u0001\r!!\u0014\u0002\u0017M|'\u000f\u001e*fm\u0016\u00148/\u001a\u0015\u0011\u0003g\u000b\t$a\u0010\u0002:\u0006\r\u00131XA.\u0003;\n#!!.\"\u0005\u0005u\u0016A\b*fm\u0016\u00148/\u001a\u0011uQ\u0016\u0004C-\u001a4bk2$\be]8si\u0002z'\u000fZ3s\u0011\u001d\t\tM\u0001a\u0001\u0003\u0007\f\u0011BY1uG\"\u001c\u0016N_3\u0011\u0007\u0005\f)-C\u0002\u0002H\n\u0014q!\u00138uK\u001e,'\u000f\u000b\t\u0002@\u0006E\u0012qHAf\u0003\u0007\ni-a\u0017\u0002^\u0005\u0012\u0011\u0011Y\u0011\u0003\u0003\u001f\f!GT;nE\u0016\u0014\be\u001c4!M\u0016\fG/\u001e:fg\u0002\"x\u000eI5oG2,H-\u001a\u0011j]\u0002*\u0017m\u00195!e\u0016\u001cwN\u001d3!E\u0006$8\r\u001b\u0005\b\u0003'\u0014\u0001\u0019AA'\u000351G.\u0019;uK:\u001cFO];di\"\u0002\u0012\u0011[A\u0019\u0003\u007f\t9.a\u0011\u0002Z\u0006m\u0013QL\u0011\u0003\u0003'\f#!a7\u0002}I+Wn\u001c<fg\u0002\"\b.\u001a\u0011pkR,'\u000fI*G)\u0002\u001aHO];di\u0002J\u0018.\u001a7eS:<\u0007\u0005^8qA1,g/\u001a7!M\u0016\fG/\u001e:fA\u0005\u001c7-Z:t\u0011%\tyN\u0001I\u0001\u0002\u0004\ti%A\u0007gY&\u0004\u0018\t_5t\u001fJ$WM\u001d\u0015\u0015\u0003;\f\t$a\u0010\u0002d\u0006\r\u0013Q]A.\u0003;\nI/a;\"\u0005\u0005}\u0017EAAt\u0003\r4E.\u001b9!i\",\u0007%\u0019=jg\u0002z'\u000fZ3sA=4\u0007E]3ukJtW\r\u001a\u0011d_>\u0014H-\u001b8bi\u0016\u001c\bE\u001a:p[\u0002b\u0017\r^5uk\u0012,w\u0006\\8oO&$X\u000fZ3!Q\u0011,g-Y;mi&\u0002Co\u001c\u0011m_:<\u0017\u000e^;eK>b\u0017\r^5uk\u0012,\u0017\u0001\u00043fM\u0006,H\u000e\u001e,bYV,\u0017EAAw\u0003\u00151\u0017\r\\:fQ\u001d\u0011\u0011\u0011_A\"\u0003o\u0004B!a\r\u0002t&!\u0011Q_A\u001b\u00059!Um]2sS\n,'+Z:vYR\f#!!?\u00025\u0015s7m\u001c3fI\u00022W-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8\u0002%\u0015DXmY;uK\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0003\u007fTC!!\u0014\u0003\u0002-\u0012!1\u0001\t\u0005\u0005\u000b\u0011y!\u0004\u0002\u0003\b)!!\u0011\u0002B\u0006\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003\u000e\u0005%\u0011AC1o]>$\u0018\r^5p]&!!\u0011\u0003B\u0004\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\f\u0001\tU!1\u0004B\u000f\u0003\u0007\u0012\t\u0003\u0005\u0003\u00024\t]\u0011\u0002\u0002B\r\u0003k\u0011q\u0002R3tGJL'-\u001a)s_\u000e,7o]\u0001\u0006i&$H.Z\u0011\u0003\u0005?\t\u0001#\u0011:s_^\u00043i\u001c8wKJ\u001c\u0018n\u001c8\"\u0005\t\r\u0012!L\"p]Z,'\u000f^:!C\u00022W-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8!i>\u0004\u0013M\u001d:po\u00022wN]7bi\u00061\u0012I\u001d:po\u000e{gN^3sg&|g\u000e\u0015:pG\u0016\u001c8\u000f\u0005\u0002z\u000bM\u0019QAa\u000b\u0011\t\u0005\u001d!QF\u0005\u0005\u0005_\tIA\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005O\u0011A\"\u0011:s_^4\u0016n]5u_J\u001cRa\u00021\u000381\u0004BA!\u000f\u0003B5\u0011!1\b\u0006\u0004/\nu\"b\u0001B 1\u0006)\u0011N\u001c3fq&!!1\tB\u001e\u0005U9Um\\'fg\u0006\u0004&o\\2fgN4\u0016n]5u_J\f1a\u001d4u!\u0011\u0011IE!\u0016\u000e\u0005\t-#\u0002BA\u0011\u0005\u001bRAAa\u0014\u0003R\u00059a-Z1ukJ,'\u0002\u0002B*\u0003O\t1!\u00199j\u0013\u0011\u00119Fa\u0013\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X-\u0001\u0005f]\u000e|G-\u001b8h!\u0011\u0011iFa \u000f\t\t}#\u0011\u0010\b\u0005\u0005C\u0012\u0019H\u0004\u0003\u0003d\t=d\u0002\u0002B3\u0005[rAAa\u001a\u0003l9!\u0011Q\u000fB5\u0013\u0005i\u0016BA.]\u0013\tI&,C\u0002\u0003ra\u000bQ!\u0019:s_^LAA!\u001e\u0003x\u00051a/Z2u_JT1A!\u001dY\u0013\u0011\u0011YH! \u0002'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f-\u0016\u001cGo\u001c:\u000b\t\tU$qO\u0005\u0005\u0005\u0003\u0013\u0019IA\u000bTS6\u0004H.\u001a$fCR,(/Z#oG>$\u0017N\\4\u000b\t\tm$QP\u0001\u000bSB\u001cg+\u001a:tS>t\u0007C\u0002BE\u0005'\u000byG\u0004\u0003\u0003\f\n=e\u0002BA;\u0005\u001bK!!a\u0003\n\t\tE\u0015\u0011B\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Ja&\u0003\u0007M+\u0017O\u0003\u0003\u0003\u0012\u0006%\u0001CBA\u0004\u00057\u000by'\u0003\u0003\u0003\u001e\u0006%!AB(qi&|g\u000e\u0005\u0004\u0002\b\tm%\u0011\u0015\t\u0005\u0003\u000f\u0011\u0019+\u0003\u0003\u0002R\u0005%\u0011!\u00039sKN{'\u000f^3e!\u0011\t9A!+\n\t\t-\u0016\u0011\u0002\u0002\u0004\u0013:$H\u0003\u0006BX\u0005g\u0013)La.\u0003:\nm&Q\u0018B`\u0005\u0003\u0014\u0019\rE\u0002\u00032\u001ei\u0011!\u0002\u0005\b\u0005\u000b\n\u0002\u0019\u0001B$\u0011\u001d\u0011I&\u0005a\u0001\u00057BqA!\"\u0012\u0001\u0004\ty\u0007C\u0004\u0002\u0010F\u0001\rAa\"\t\u000f\u0005%\u0016\u00031\u0001\u0003\u001a\"9\u0011QW\tA\u0002\t}\u0005b\u0002BS#\u0001\u0007!\u0011\u0015\u0005\b\u0003\u0003\f\u0002\u0019\u0001BT\u0011\u001d\t\u0019.\u0005a\u0001\u0005C\u000bQ\"\\1ok\u0006dg+[:ji>\u0014XC\u0001Be!\r\u0011\t,\u0007\u0002\u0013\u0003J\u0014xn^'b]V\fGNV5tSR|'oE\u0002\u001a\u0005W\tQA^5tSR$BAa5\u0003ZB!\u0011q\u0001Bk\u0013\u0011\u00119.!\u0003\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005\u001fR\u0002\u0019\u0001Bn!\u0011\u0011IE!8\n\t\t}'1\n\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\u0002\u000fI,7/\u001e7ugV\u0011!Q\u001d\t\u0007\u0005\u0013\u00139/!\u0002\n\t\u0005\r!qS\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0002\u0015I,7/\u001e7u?\u0012*\u0017\u000f\u0006\u0003\u0003T\n=\b\"\u0003By)\u0005\u0005\t\u0019\u0001Bs\u0003\rAH%M\u0001\be\u0016\u001cX\u000f\u001c;!\u0003%9W\r\u001e*fgVdG\u000f\u0006\u0002\u0003zB\u0019!\u0011\u0017 \u0003\u0017\u0005\u0013(o\\<SKN,H\u000e^\n\b}\t}8QBB\n!\u0011\u0019\ta!\u0003\u000e\u0005\r\r!\u0002BB\u0003\u0007\u000f\tqA^5tSR|'O\u0003\u0003\u0003P\u0005\u001d\u0012\u0002BB\u0006\u0007\u0007\u0011!#\u00112tiJ\f7\r^\"bY\u000e\u0014Vm];miB!\u0011qAB\b\u0013\u0011\u0019\t\"!\u0003\u0003\u000fA\u0013x\u000eZ;diB!\u0011qAB\u000b\u0013\u0011\u00199\"!\u0003\u0003\u0019M+'/[1mSj\f'\r\\3\u0016\u0003q\f\u0001B]3tk2$8\u000f\t\u000b\u0005\u0005s\u001cy\u0002\u0003\u0004\u0003b\u0006\u0003\r\u0001`\u0001\tO\u0016$h+\u00197vKR\u0011!1F\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003\u0003z\u000e%\u0002\u0002\u0003Bq\u0007B\u0005\t\u0019\u0001?\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u00111q\u0006\u0016\u0004y\n\u0005\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u00046A\u0019\u0011ma\u000e\n\u0007\u0005\u0005%-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003(\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BB!\u0007\u000f\u0002B!a\u0002\u0004D%!1QIA\u0005\u0005\r\te.\u001f\u0005\n\u0005c<\u0015\u0011!a\u0001\u0005O\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007\u001b\u0002baa\u0014\u0004V\r\u0005SBAB)\u0015\u0011\u0019\u0019&!\u0003\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0004\rE\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t\u000561\f\u0005\n\u0005cL\u0015\u0011!a\u0001\u0007\u0003\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005O\u000ba!Z9vC2\u001cH\u0003\u0002BQ\u0007KB\u0011B!=L\u0003\u0003\u0005\ra!\u0011\u0015\t\tM7\u0011\u000e\u0005\b\u0005\u001f:\u0002\u0019AB6!\u0011\u0019iga\u001c\u000e\u0005\t5\u0013\u0002BB9\u0005\u001b\u0012qAR3biV\u0014X\r\u0006\u0004\u0003T\u000eU41\u0011\u0005\b\u0007oB\u0002\u0019AB=\u0003\u0019\u0019x.\u001e:dKB!11PB@\u001b\t\u0019iH\u0003\u0003\u0002&\tE\u0013\u0002BBA\u0007{\u00121cU5na2,g)Z1ukJ,7k\\;sG\u0016Dqa!\"\u0019\u0001\u0004\u00199)A\u0003rk\u0016\u0014\u0018\u0010\u0005\u0003\u0004|\r%\u0015\u0002BBF\u0007{\u0012Q!U;fef\u0014\u0001dU5na2,\u0017I\u001d:po6\u000bg.^1m-&\u001c\u0018\u000e^8s'\u0015a\"1\u0006Be\u0003\u001dI\u0007oY(qiN\u0004Ba!&\u0004(6\u00111q\u0013\u0006\u0005\u00073\u001bY*A\u0004nKN\u001c\u0018mZ3\u000b\t\ru5qT\u0001\u0004SB\u001c'\u0002\u0002B;\u0007CSAA!\u001d\u0004$*\u00191Q\u0015/\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\u0019Ika&\u0003\u0013%\u00038m\u00149uS>t\u0017\u0001B:peR\u0004b!a\u0002\u0003\u001c\u000e=\u0006\u0003CA\u0004\u0007c\u000byG!)\n\t\rM\u0016\u0011\u0002\u0002\u0007)V\u0004H.\u001a\u001a\u0015\u001d\r]6\u0011XB^\u0007{\u001byl!1\u0004DB\u0019!\u0011\u0017\u000f\t\u000f\t\u00153\u00051\u0001\u0003H!9!\u0011L\u0012A\u0002\tm\u0003bBBIG\u0001\u000711\u0013\u0005\b\u0007W\u001b\u0003\u0019ABW\u0011\u001d\t\tm\ta\u0001\u0005OCq!a5$\u0001\u0004\u0011\t+A\u0002pkR,\"a!3\u0011\t\r-7\u0011[\u0007\u0003\u0007\u001bT1aa4e\u0003\tIw.\u0003\u0003\u0004T\u000e5'!\u0006\"zi\u0016\f%O]1z\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\u0005_V$\b%A\u0003csR,7/\u0006\u0002\u0004\\B11Q\\Br\u0003\u000bi!aa8\u000b\t\r\u00058\u0011K\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0019)oa8\u0003\u00151K7\u000f\u001e\"vM\u001a,'/\u0001\u0004csR,7\u000fI\u0001\u0006G>,h\u000e^\u000b\u0003\u0007[\u0004B!a\u0002\u0004p&!1\u0011_A\u0005\u0005\u0011auN\\4\u0002\u0013\r|WO\u001c;`I\u0015\fH\u0003\u0002Bj\u0007oD\u0011B!=*\u0003\u0003\u0005\ra!<\u0002\r\r|WO\u001c;!\u0003\u00199(/\u001b;feV\u00111q \t\u0005\t\u0003!)!\u0004\u0002\u0005\u0004)!1q\u001aB<\u0013\u0011!9\u0001b\u0001\u00039MKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0003J\u0014xn\u001e$jY\u0016<&/\u001b;fe\u00069qO]5uKJ\u0004C\u0003\u0002Bj\t\u001bAqAa\u0014.\u0001\u0004\u0011YNA\rD_6\u0004H.\u001a=BeJ|w/T1ok\u0006dg+[:ji>\u00148#B\u0018\u0003,\t%GC\u0005C\u000b\t/!I\u0002b\u0007\u0005\u001e\u0011}A\u0011\u0005C\u0012\tK\u00012A!-0\u0011\u001d\u0011)\u0005\u000fa\u0001\u0005\u000fBqA!\u00179\u0001\u0004\u0011Y\u0006C\u0004\u0004\u0012b\u0002\raa%\t\u000f\u0005=\u0005\b1\u0001\u0003\b\"911\u0016\u001dA\u0002\r5\u0006b\u0002BSq\u0001\u0007!\u0011\u0015\u0005\b\u0003\u0003D\u0004\u0019\u0001BT\u0011\u001d\t\u0019\u000e\u000fa\u0001\u0005C+\"\u0001\"\u000b\u0011\r\ruG1\u0006Bn\u0013\u0011!ica8\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM]\u0001\nM\u0016\fG/\u001e:fg\u0002\"BAa5\u00054!9!qJ\u001eA\u0002\tm\u0017a\u00032vS2$'+Z:vYR$bA!:\u0005:\u0011-\u0003b\u0002C\u001e{\u0001\u0007AQH\u0001\rI&\u001cG/[8oCJLWm\u001d\t\t\u0003c\"y$a\u001c\u0005D%!A\u0011IAB\u0005\ri\u0015\r\u001d\t\u0005\t\u000b\"9%\u0004\u0002\u0003~%!A\u0011\nB?\u0005=\t%O]8x\t&\u001cG/[8oCJL\bb\u0002C'{\u0001\u0007AqJ\u0001\u0007g>\u0014H/\u001a3\u0011\r\t%%q\u001dBn\u0003-\t%O]8x%\u0016\u001cX\u000f\u001c;\u0011\u0007\tEVjE\u0003N\t/\u001a\u0019\u0002E\u0004\u0005Z\u0011}CP!?\u000e\u0005\u0011m#\u0002\u0002C/\u0003\u0013\tqA];oi&lW-\u0003\u0003\u0005b\u0011m#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011A1K\u0001\ti>\u001cFO]5oOR\u00111QG\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0005s$i\u0007\u0003\u0004\u0003bB\u0003\r\u0001`\u0001\bk:\f\u0007\u000f\u001d7z)\u0011!\u0019\b\"\u001e\u0011\u000b\u0005\u001d!1\u0014?\t\u0013\u0011]\u0014+!AA\u0002\te\u0018a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005\u0001\u0007")
public class ArrowConversionProcess
implements GeoMesaProcess,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ArrowConversionProcess arrowConversionProcess = this;
        synchronized (arrowConversionProcess) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @DescribeResult(description="Encoded feature collection")
    public java.util.Iterator<byte[]> execute(@DescribeParameter(name="features", description="Input feature collection to encode") SimpleFeatureCollection features, @DescribeParameter(name="includeFids", description="Include feature IDs in arrow file", min=0) Boolean includeFids, @DescribeParameter(name="proxyFids", description="Proxy feature IDs to ints instead of strings", min=0) Boolean proxyFids, @DescribeParameter(name="formatVersion", description="Arrow IPC format version", min=0) String formatVersion, @DescribeParameter(name="dictionaryFields", description="Attributes to dictionary encode", min=0, max=128, collectionType=String.class) List<String> dictionaryFields, @DescribeParameter(name="sortField", description="Attribute to sort by", min=0) String sortField, @DescribeParameter(name="sortReverse", description="Reverse the default sort order", min=0) Boolean sortReverse, @DescribeParameter(name="batchSize", description="Number of features to include in each record batch", min=0) Integer batchSize, @DescribeParameter(name="flattenStruct", description="Removes the outer SFT struct yielding top level feature access", min=0) Boolean flattenStruct, @DescribeParameter(name="flipAxisOrder", description="Flip the axis order of returned coordinates from latitude/longitude (default) to longitude/latitude", min=0, defaultValue="false") Boolean flipAxisOrder) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running arrow encoding for {}", new Object[]{features.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SimpleFeatureType sft = (SimpleFeatureType)features.getSchema();
        Seq toEncode = (Seq)Option$.MODULE$.apply(dictionaryFields).map((Function1 & Serializable & scala.Serializable)x$1 -> ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        toEncode.foreach((Function1 & Serializable & scala.Serializable)attribute -> {
            ArrowConversionProcess.$anonfun$execute$3(sft, attribute);
            return BoxedUnit.UNIT;
        });
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(includeFids == null || Predef$.MODULE$.Boolean2boolean(includeFids), proxyFids != null && Predef$.MODULE$.Boolean2boolean(proxyFids), Option$.MODULE$.apply((Object)flipAxisOrder).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2)));
        String ipcVersion = (String)Option$.MODULE$.apply((Object)formatVersion).getOrElse((Function0 & Serializable & scala.Serializable)() -> package.FormatVersion$.MODULE$.ArrowFormatVersion().get());
        Option reverse = Option$.MODULE$.apply((Object)sortReverse).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3));
        int batch = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)batchSize).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(package.ArrowProperties$.MODULE$.BatchSize().get())).toInt()));
        ArrowVisitor visitor = new ArrowVisitor(sft, encoding, ipcVersion, (Seq<String>)toEncode, (Option<String>)Option$.MODULE$.apply((Object)sortField), (Option<Object>)reverse, false, batch, Predef$.MODULE$.Boolean2boolean(flattenStruct));
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    public Boolean execute$default$10() {
        return Predef$.MODULE$.boolean2Boolean(false);
    }

    public static final /* synthetic */ void $anonfun$execute$3(SimpleFeatureType sft$1, String attribute) {
        if (sft$1.indexOf(attribute) == -1) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Attribute ").append(attribute).append(" doesn't exist in ").append(sft$1).toString());
        }
    }

    public ArrowConversionProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }

    public static interface ArrowManualVisitor {
        public void visit(SimpleFeature var1);

        public Iterator<byte[]> results();
    }

    public static class ArrowResult
    extends AbstractCalcResult
    implements Product,
    scala.Serializable {
        private final java.util.Iterator<byte[]> results;

        public java.util.Iterator<byte[]> results() {
            return this.results;
        }

        public Object getValue() {
            return this.results();
        }

        public ArrowResult copy(java.util.Iterator<byte[]> results) {
            return new ArrowResult(results);
        }

        public java.util.Iterator<byte[]> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "ArrowResult";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ArrowResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ArrowResult)) return false;
            boolean bl = true;
            if (!bl) return false;
            ArrowResult arrowResult = (ArrowResult)((Object)x$1);
            java.util.Iterator<byte[]> iterator = this.results();
            java.util.Iterator<byte[]> iterator2 = arrowResult.results();
            if (iterator == null) {
                if (iterator2 != null) {
                    return false;
                }
            } else if (!iterator.equals(iterator2)) return false;
            if (!arrowResult.canEqual((Object)this)) return false;
            return true;
        }

        public ArrowResult(java.util.Iterator<byte[]> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class ArrowVisitor
    implements GeoMesaProcessVisitor,
    LazyLogging {
        private ArrowManualVisitor manualVisitor;
        private final SimpleFeatureType sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final String ipcVersion;
        private final Seq<String> dictionaryFields;
        private final Option<String> sortField;
        private final Option<Object> sortReverse;
        private final boolean preSorted;
        private final int batchSize;
        private final boolean flattenStruct;
        private Iterator<byte[]> result;
        private transient Logger logger;
        private volatile boolean bitmap$0;
        private volatile transient boolean bitmap$trans$0;

        public List<Expression> getExpressions() {
            return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
        }

        private Logger logger$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        private ArrowManualVisitor manualVisitor$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if (!this.bitmap$0) {
                    Option sort = this.sortField.map((Function1 & Serializable & scala.Serializable)s -> new Tuple2(s, $this.sortReverse.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)));
                    IpcOption ipcOpts = package.FormatVersion$.MODULE$.options(this.ipcVersion);
                    this.manualVisitor = this.dictionaryFields.isEmpty() && (this.sortField.isEmpty() || this.preSorted) ? new SimpleArrowManualVisitor(this.sft, this.encoding, ipcOpts, (Option<Tuple2<String, Object>>)sort, this.batchSize, this.flattenStruct) : new ComplexArrowManualVisitor(this.sft, this.encoding, ipcOpts, this.dictionaryFields, (Option<Tuple2<String, Object>>)sort, this.preSorted, this.batchSize, this.flattenStruct);
                    this.bitmap$0 = true;
                }
            }
            return this.manualVisitor;
        }

        private ArrowManualVisitor manualVisitor() {
            if (!this.bitmap$0) {
                return this.manualVisitor$lzycompute();
            }
            return this.manualVisitor;
        }

        private Iterator<byte[]> result() {
            return this.result;
        }

        private void result_$eq(Iterator<byte[]> x$1) {
            this.result = x$1;
        }

        public ArrowResult getResult() {
            if (this.result() != null) {
                return new ArrowResult((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.result()).asJava());
            }
            return new ArrowResult((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.manualVisitor().results()).asJava());
        }

        public void visit(Feature feature) {
            this.manualVisitor().visit((SimpleFeature)feature);
        }

        public void execute(SimpleFeatureSource source, Query query) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Visiting source type: {}", new Object[]{source.getClass().getName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_ENCODE(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_DICTIONARY_FIELDS(), (Object)this.dictionaryFields.mkString(","));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.fids().isDefined()));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_PROXY_FID(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.fids().contains((Object)SimpleFeatureVector.SimpleFeatureEncoding$.Encoding$.MODULE$.Min())));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_BATCH_SIZE(), (Object)BoxesRunTime.boxToInteger((int)this.batchSize));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_FORMAT_VERSION(), (Object)this.ipcVersion);
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_FLATTEN_STRUCT(), (Object)BoxesRunTime.boxToBoolean((boolean)this.flattenStruct));
            query.getHints().put((Object)QueryHints$.MODULE$.FLIP_AXIS_ORDER(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.flipAxisOrder()));
            this.sortField.foreach((Function1 & Serializable & scala.Serializable)x$5 -> query.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_FIELD(), x$5));
            this.sortReverse.foreach((Function1 & Serializable & scala.Serializable)x$6 -> ArrowVisitor.$anonfun$execute$10(query, BoxesRunTime.unboxToBoolean((Object)x$6)));
            SelfClosingIterator features = SelfClosingIterator$.MODULE$.apply(source.getFeatures(query));
            this.result_$eq((Iterator<byte[]>)features.map((Function1 & Serializable & scala.Serializable)x$7 -> (byte[])x$7.getAttribute(0)));
        }

        public static final /* synthetic */ Object $anonfun$execute$10(Query query$1, boolean x$6) {
            return query$1.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_REVERSE(), (Object)BoxesRunTime.boxToBoolean((boolean)x$6));
        }

        public ArrowVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, String ipcVersion, Seq<String> dictionaryFields, Option<String> sortField, Option<Object> sortReverse, boolean preSorted, int batchSize, boolean flattenStruct) {
            this.sft = sft;
            this.encoding = encoding;
            this.ipcVersion = ipcVersion;
            this.dictionaryFields = dictionaryFields;
            this.sortField = sortField;
            this.sortReverse = sortReverse;
            this.preSorted = preSorted;
            this.batchSize = batchSize;
            this.flattenStruct = flattenStruct;
            GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
            LazyLogging.$init$((LazyLogging)this);
        }
    }

    private static class ComplexArrowManualVisitor
    implements ArrowManualVisitor {
        private final SimpleFeatureType sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final IpcOption ipcOpts;
        private final Seq<String> dictionaryFields;
        private final Option<Tuple2<String, Object>> sort;
        private final boolean preSorted;
        private final int batchSize;
        private final boolean flattenStruct;
        private final ArrayBuffer<SimpleFeature> features;

        private ArrayBuffer<SimpleFeature> features() {
            return this.features;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.features().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeature[]{ScalaSimpleFeature$.MODULE$.copy(feature)}));
        }

        @Override
        public Iterator<byte[]> results() {
            Iterator iterator;
            None$ ordering;
            Map map;
            if (this.dictionaryFields.isEmpty()) {
                map = Predef$.MODULE$.Map().empty();
            } else {
                Seq indicesAndValues = (Seq)this.dictionaryFields.map((Function1 & Serializable & scala.Serializable)field -> new Tuple3(field, (Object)BoxesRunTime.boxToInteger((int)$this.sft.indexOf(field)), (Object)HashSet$.MODULE$.empty()), Seq$.MODULE$.canBuildFrom());
                this.features().foreach((Function1 & Serializable & scala.Serializable)f -> {
                    indicesAndValues.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ComplexArrowManualVisitor.$anonfun$results$3(f, x0$1)));
                    return BoxedUnit.UNIT;
                });
                map = ((TraversableOnce)indicesAndValues.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple3 tuple3 = x0$2;
                    if (tuple3 != null) {
                        String n = (String)tuple3._1();
                        int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
                        HashSet v = (HashSet)tuple3._3();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)n), (Object)ArrowDictionary$.MODULE$.create($this.sft.getTypeName(), (long)i, (Object[])v.toArray(ClassTag$.MODULE$.AnyRef()), ClassTag$.MODULE$.apply($this.sft.getDescriptor(i).getType().getBinding())));
                    }
                    throw new MatchError((Object)tuple3);
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
            Map dictionaries = map;
            None$ none$ = ordering = this.preSorted ? None$.MODULE$ : this.sort.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    String field = (String)tuple2._1();
                    boolean reverse = tuple2._2$mcZ$sp();
                    return SimpleFeatureOrdering$.MODULE$.apply($this.sft, field, reverse);
                }
                throw new MatchError((Object)tuple2);
            });
            if (None$.MODULE$.equals(none$)) {
                iterator = this.features().iterator();
            } else if (none$ instanceof Some) {
                Some some = (Some)none$;
                Ordering o = (Ordering)some.value();
                iterator = ((IndexedSeqLike)this.features().sorted(o)).iterator();
            } else {
                throw new MatchError((Object)none$);
            }
            Iterator sorted = iterator;
            return this.buildResult((Map<String, ArrowDictionary>)dictionaries, (Iterator<SimpleFeature>)sorted);
        }

        private Iterator<byte[]> buildResult(Map<String, ArrowDictionary> dictionaries, Iterator<SimpleFeature> sorted) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ListBuffer bytes = (ListBuffer)ListBuffer$.MODULE$.empty();
            package.WithClose$.MODULE$.apply((Object)SimpleFeatureArrowFileWriter$.MODULE$.apply((OutputStream)out, this.sft, dictionaries, this.encoding, this.ipcOpts, this.sort, this.flattenStruct), (Function1 & Serializable & scala.Serializable)writer -> {
                ComplexArrowManualVisitor.$anonfun$buildResult$1(this, sorted, bytes, out, writer);
                return BoxedUnit.UNIT;
            }, IsCloseable$.MODULE$.closeableIsCloseable());
            bytes.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{out.toByteArray()}));
            return bytes.iterator();
        }

        public static final /* synthetic */ boolean $anonfun$results$3(SimpleFeature f$1, Tuple3 x0$1) {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                int i = BoxesRunTime.unboxToInt((Object)tuple3._2());
                HashSet v = (HashSet)tuple3._3();
                return v.add(f$1.getAttribute(i));
            }
            throw new MatchError((Object)tuple3);
        }

        public static final /* synthetic */ void $anonfun$buildResult$1(ComplexArrowManualVisitor $this, Iterator sorted$1, ListBuffer bytes$1, ByteArrayOutputStream out$1, SimpleFeatureArrowFileWriter writer) {
            while (sorted$1.hasNext()) {
                for (int i = 0; i < $this.batchSize && sorted$1.hasNext(); ++i) {
                    writer.add((SimpleFeature)sorted$1.next());
                }
                writer.flush();
                bytes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{out$1.toByteArray()}));
                out$1.reset();
            }
        }

        public ComplexArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, IpcOption ipcOpts, Seq<String> dictionaryFields, Option<Tuple2<String, Object>> sort, boolean preSorted, int batchSize, boolean flattenStruct) {
            this.sft = sft;
            this.encoding = encoding;
            this.ipcOpts = ipcOpts;
            this.dictionaryFields = dictionaryFields;
            this.sort = sort;
            this.preSorted = preSorted;
            this.batchSize = batchSize;
            this.flattenStruct = flattenStruct;
            this.features = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        }
    }

    private static class SimpleArrowManualVisitor
    implements ArrowManualVisitor {
        private final int batchSize;
        private final ByteArrayOutputStream out;
        private final ListBuffer<byte[]> bytes;
        private long count;
        private final SimpleFeatureArrowFileWriter writer;

        private ByteArrayOutputStream out() {
            return this.out;
        }

        private ListBuffer<byte[]> bytes() {
            return this.bytes;
        }

        private long count() {
            return this.count;
        }

        private void count_$eq(long x$1) {
            this.count = x$1;
        }

        private SimpleFeatureArrowFileWriter writer() {
            return this.writer;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.writer().add(feature);
            this.count_$eq(this.count() + 1L);
            if (this.count() % (long)this.batchSize == 0L) {
                this.writer().flush();
                this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
                this.out().reset();
                return;
            }
        }

        @Override
        public Iterator<byte[]> results() {
            package.CloseWithLogging$.MODULE$.apply((Object)this.writer(), IsCloseable$.MODULE$.closeableIsCloseable());
            this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
            return this.bytes().iterator();
        }

        public SimpleArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, IpcOption ipcOpts, Option<Tuple2<String, Object>> sort, int batchSize, boolean flattenStruct) {
            this.batchSize = batchSize;
            this.out = new ByteArrayOutputStream();
            this.bytes = (ListBuffer)ListBuffer$.MODULE$.empty();
            this.count = 0L;
            this.writer = SimpleFeatureArrowFileWriter$.MODULE$.apply((OutputStream)this.out(), sft, Predef$.MODULE$.Map().empty(), encoding, ipcOpts, sort, flattenStruct);
        }
    }
}

