/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.analytic.StatsVisitor;
import scala.Array$;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DescribeProcess(title="Stats Process", description="Gathers statistics for a data set")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0003\u0007\u0001EAQ\u0001\u000b\u0001\u0005\u0002%BQ\u0001\f\u0001\u0005\u00025Bqa\u001f\u0001\u0012\u0002\u0013\u0005A\u0010C\u0005\u0002\u0010\u0001\t\n\u0011\"\u0001\u0002\u0012\ta1\u000b^1ugB\u0013xnY3tg*\u0011q\u0001C\u0001\tC:\fG.\u001f;jG*\u0011\u0011BC\u0001\baJ|7-Z:t\u0015\tYA\"A\u0004hK>lWm]1\u000b\u00055q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0011\"D\b\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\tA\u0001\\1oO*\tq#\u0001\u0003kCZ\f\u0017BA\r\u0015\u0005\u0019y%M[3diB\u00111\u0004H\u0007\u0002\u0011%\u0011Q\u0004\u0003\u0002\u000f\u000f\u0016|W*Z:b!J|7-Z:t!\tyb%D\u0001!\u0015\t\t#%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002$I\u0005AA/\u001f9fg\u00064WMC\u0001&\u0003\r\u0019w.\\\u0005\u0003O\u0001\u00121\u0002T1{s2{wmZ5oO\u00061A(\u001b8jiz\"\u0012A\u000b\t\u0003W\u0001i\u0011AB\u0001\bKb,7-\u001e;f)\u0015q\u0003h\u0012.f!\tyc'D\u00011\u0015\t\t$'\u0001\u0004tS6\u0004H.\u001a\u0006\u0003gQ\nA\u0001Z1uC*\u0011QGD\u0001\tO\u0016|Go\\8mg&\u0011q\u0007\r\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:DQ!\u000f\u0002A\u00029\n\u0001BZ3biV\u0014Xm\u001d\u0015\u0007qm\u00125\tR#\u0011\u0005q\u0002U\"A\u001f\u000b\u0005yz\u0014a\u00024bGR|'/\u001f\u0006\u0003\u0013QJ!!Q\u001f\u0003#\u0011+7o\u0019:jE\u0016\u0004\u0016M]1nKR,'/\u0001\u0003oC6,\u0017%A\u001d\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0002\r\u0006\tC\u000b[3!M\u0016\fG/\u001e:fAM,G\u000fI8oA]D\u0017n\u00195!i>\u0004\u0013/^3ss\")\u0001J\u0001a\u0001\u0013\u0006Q1\u000f^1u'R\u0014\u0018N\\4\u0011\u0005)\u001bfBA&R!\tau*D\u0001N\u0015\tq\u0005#\u0001\u0004=e>|GO\u0010\u0006\u0002!\u0006)1oY1mC&\u0011!kT\u0001\u0007!J,G-\u001a4\n\u0005Q+&AB*ue&twM\u0003\u0002S\u001f\"2qi\u000f\"X\tb\u000b\u0013\u0001S\u0011\u00023\u0006yC\u000b[3!gR\u0014\u0018N\\4!S:$\u0017nY1uS:<\u0007e\u001e5bi\u0002\u001aH/\u0019;tAQ|\u0007%\u001b8ti\u0006tG/[1uK\"91L\u0001I\u0001\u0002\u0004a\u0016AB3oG>$W\r\u0005\u0002\u0014;&\u0011a\f\u0006\u0002\b\u0005>|G.Z1oQ!Q6H\u00111bE\u0012\u001b\u0017%A.\u0002\u00075Lg.H\u0001\u0001C\u0005!\u0017\u0001\n*fiV\u0014h\u000e\t;iK\u00022\u0018\r\\;fg\u0002*gnY8eK\u0012\u0004sN\u001d\u0011bg\u0002R7o\u001c8\t\u000f\u0019\u0014\u0001\u0013!a\u0001O\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\u0007!\\\u0017*D\u0001j\u0015\tQg#\u0001\u0003vi&d\u0017B\u00017j\u0005\u0011a\u0015n\u001d;)\u0019\u0015\\$I\\1c_B\f(\u000fR:\"\u0003\u0019\f1!\\1y;\t\u0001\u00011\u0001\bd_2dWm\u0019;j_:$\u0016\u0010]3$\u0003%\u000b\u0013\u0001^\u0001<)\",\u0007\u0005\u001d:pa\u0016\u0014H/[3tA=\u0002CO]1og\u001a|'/\\:!i>\u0004\u0013\r\u001d9ms\u0002\u0012WMZ8sK\u0002:\u0017\r\u001e5fe&tw\rI:uCR\u001c\b\u0006\u0002\u0002w\tf\u0004\"\u0001P<\n\u0005al$A\u0004#fg\u000e\u0014\u0018NY3SKN,H\u000e^\u0011\u0002u\u0006Ir*\u001e;qkR\u0004c-Z1ukJ,\u0007eY8mY\u0016\u001cG/[8o\u0003E)\u00070Z2vi\u0016$C-\u001a4bk2$HeM\u000b\u0002{*\u0012AL`\u0016\u0002\u007fB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011!C;oG\",7m[3e\u0015\r\tIaT\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0007\u0003\u0007\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003E)\u00070Z2vi\u0016$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003'Q#a\u001a@)\u0015\u0001\t9\"!\b\u0002 \u0011\u000b\u0019\u0003E\u0002=\u00033I1!a\u0007>\u0005=!Um]2sS\n,\u0007K]8dKN\u001c\u0018!\u0002;ji2,\u0017EAA\u0011\u00035\u0019F/\u0019;tAA\u0013xnY3tg\u0006\u0012\u0011QE\u0001\"\u000f\u0006$\b.\u001a:tAM$\u0018\r^5ti&\u001c7\u000f\t4pe\u0002\n\u0007\u0005Z1uC\u0002\u001aX\r\u001e")
public class StatsProcess
implements GeoMesaProcess,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        StatsProcess statsProcess = this;
        synchronized (statsProcess) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @DescribeResult(description="Output feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="The feature set on which to query") SimpleFeatureCollection features, @DescribeParameter(name="statString", description="The string indicating what stats to instantiate") String statString, @DescribeParameter(name="encode", min=0, description="Return the values encoded or as json") Boolean encode, @DescribeParameter(name="properties", min=0, max=128, collectionType=String.class, description="The properties / transforms to apply before gathering stats") List<String> properties) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Attempting stats iterator process on type {}", new Object[]{features.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String[] propsArray = (String[])Option$.MODULE$.apply(properties).map((Function1 & Serializable & scala.Serializable)x$1 -> (String[])x$1.toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StatsProcess.$anonfun$execute$2(x$2))).orNull(Predef$.MODULE$.$conforms());
        StatsVisitor visitor = new StatsVisitor(features, statString, Option$.MODULE$.apply((Object)encode).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3)), propsArray);
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    public Boolean execute$default$3() {
        return null;
    }

    public List<String> execute$default$4() {
        return null;
    }

    public static final /* synthetic */ boolean $anonfun$execute$2(String[] x$2) {
        return x$2.length > 0;
    }

    public StatsProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

