/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.query;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.features.TransformSimpleFeature;
import org.locationtech.geomesa.features.TransformSimpleFeature$;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.planning.QueryPlanner$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.FeatureResult;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u000b\u0017\u0001\u0005B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"Aa\n\u0001B\u0001B\u0003%q\nC\u0003a\u0001\u0011\u0005\u0011\r\u0003\u0006h\u0001A\u0005\t1!Q\u0001\n!Dqa\u001e\u0001C\u0002\u0013%\u0001\u0010\u0003\u0004z\u0001\u0001\u0006Ia\u001b\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u0011\u0019a\b\u0001)A\u0005e\"9Q\u0010\u0001b\u0001\n\u0013q\bbBA\u0006\u0001\u0001\u0006Ia \u0005\u000b\u0003\u001b\u0001\u0001R1A\u0005\n\u0005=\u0001\"CA\t\u0001\t\u0007I\u0011BA\n\u0011!\t\t\u0003\u0001Q\u0001\n\u0005U\u0001\"CA\u0012\u0001\u0001\u0007I\u0011BA\u0013\u0011%\ty\u0003\u0001a\u0001\n\u0013\t\t\u0004\u0003\u0005\u0002>\u0001\u0001\u000b\u0015BA\u0014\u0011\u001d\ty\u0004\u0001C!\u0003\u0003Bq!!\u0014\u0001\t\u0003\ny\u0005C\u0004\u0002R\u0001!\t%a\u0015\u0003\u0019E+XM]=WSNLGo\u001c:\u000b\u0005]A\u0012!B9vKJL(BA\r\u001b\u0003\u001d\u0001(o\\2fgNT!a\u0007\u000f\u0002\u000f\u001d,w.\\3tC*\u0011QDH\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002?\u0005\u0019qN]4\u0004\u0001M!\u0001A\t\u00162!\t\u0019\u0003&D\u0001%\u0015\t)c%\u0001\u0003mC:<'\"A\u0014\u0002\t)\fg/Y\u0005\u0003S\u0011\u0012aa\u00142kK\u000e$\bCA\u00160\u001b\u0005a#BA\r.\u0015\tq#$A\u0003j]\u0012,\u00070\u0003\u00021Y\t)r)Z8NKN\f\u0007K]8dKN\u001ch+[:ji>\u0014\bC\u0001\u001a:\u001b\u0005\u0019$B\u0001\u001b6\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t1t'\u0001\u0005usB,7/\u00194f\u0015\u0005A\u0014aA2p[&\u0011!h\r\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0005gK\u0006$XO]3t!\tiD)D\u0001?\u0015\ty\u0004)\u0001\u0004tS6\u0004H.\u001a\u0006\u0003\u0003\n\u000bA\u0001Z1uC*\u00111IH\u0001\tO\u0016|Go\\8mg&\u0011QI\u0010\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:\faAZ5mi\u0016\u0014\bC\u0001%M\u001b\u0005I%B\u0001$K\u0015\tY%)A\u0002ba&L!!T%\u0003\r\u0019KG\u000e^3s\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0004!N+V\"A)\u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0003\u000b\u0005\u0013(/Y=\u0011\u0005YkfBA,\\!\tA\u0016+D\u0001Z\u0015\tQ\u0006%\u0001\u0004=e>|GOP\u0005\u00039F\u000ba\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011A,U\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\t$WM\u001a\t\u0003G\u0002i\u0011A\u0006\u0005\u0006w\u0011\u0001\r\u0001\u0010\u0005\u0006\r\u0012\u0001\ra\u0012\u0005\u0006\u001d\u0012\u0001\raT\u0001\u0004q\u0012\u001a\u0004\u0003\u0002)jWJL!A[)\u0003\rQ+\b\u000f\\33!\ta\u0007/D\u0001n\u0015\tydN\u0003\u0002p\u0015\u00069a-Z1ukJ,\u0017BA9n\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\t\u0003gVl\u0011\u0001\u001e\u0006\u0003wiI!A\u001e;\u0003-Q\u0013\u0018M\\:g_Jl7+[7qY\u00164U-\u0019;ve\u0016\f1a\u001d4u+\u0005Y\u0017\u0001B:gi\u0002\n\u0001\u0003\u001e:b]N4wN]7GK\u0006$XO]3\u0016\u0003I\f\u0011\u0003\u001e:b]N4wN]7GK\u0006$XO]3!\u0003\u0019\u0011X\r^=qKV\tq\u0010E\u0004Q\u0003\u0003\t)!!\u0002\n\u0007\u0005\r\u0011KA\u0005Gk:\u001cG/[8ocA\u0019A.a\u0002\n\u0007\u0005%QNA\u0007TS6\u0004H.\u001a$fCR,(/Z\u0001\be\u0016$\u0018\u0010]3!\u00031i\u0017M\\;bY\u001aKG\u000e^3s+\u00059\u0015AE7b]V\fGNV5tSR\u0014Vm];miN,\"!!\u0006\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007A\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\tIBA\u000bMSN$h)Z1ukJ,7i\u001c7mK\u000e$\u0018n\u001c8\u0002'5\fg.^1m-&\u001c\u0018\u000e\u001e*fgVdGo\u001d\u0011\u0002\u0015I,7/\u001e7u\u0007\u0006d7-\u0006\u0002\u0002(A!\u0011\u0011FA\u0016\u001b\u0005A\u0012bAA\u00171\tia)Z1ukJ,'+Z:vYR\faB]3tk2$8)\u00197d?\u0012*\u0017\u000f\u0006\u0003\u00024\u0005e\u0002c\u0001)\u00026%\u0019\u0011qG)\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003w\u0001\u0012\u0011!a\u0001\u0003O\t1\u0001\u001f\u00132\u0003-\u0011Xm];mi\u000e\u000bGn\u0019\u0011\u0002\u000bYL7/\u001b;\u0015\t\u0005M\u00121\t\u0005\u0007_J\u0001\r!!\u0012\u0011\t\u0005\u001d\u0013\u0011J\u0007\u0002]&\u0019\u00111\n8\u0003\u000f\u0019+\u0017\r^;sK\u0006Iq-\u001a;SKN,H\u000e\u001e\u000b\u0003\u0003O\tq!\u001a=fGV$X\r\u0006\u0004\u00024\u0005U\u00131\r\u0005\b\u0003/\"\u0002\u0019AA-\u0003\u0019\u0019x.\u001e:dKB!\u00111LA0\u001b\t\tiF\u0003\u0002B\u0015&!\u0011\u0011MA/\u0005M\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKN{WO]2f\u0011\u00199B\u00031\u0001\u0002fA!\u00111LA4\u0013\u0011\tI'!\u0018\u0003\u000bE+XM]=")
public class QueryVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private Filter manualFilter;
    private SimpleFeatureCollection features;
    private final Filter filter;
    private final String[] properties;
    private final /* synthetic */ Tuple2 x$3;
    private final SimpleFeatureType sft;
    private final TransformSimpleFeature transformFeature;
    private final Function1<SimpleFeature, SimpleFeature> retype;
    private final ListFeatureCollection manualVisitResults;
    private FeatureResult resultCalc;
    private transient Logger logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public List<Expression> getExpressions() {
        return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
    }

    private Logger logger$lzycompute() {
        QueryVisitor queryVisitor = this;
        synchronized (queryVisitor) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private SimpleFeatureType sft() {
        return this.sft;
    }

    private TransformSimpleFeature transformFeature() {
        return this.transformFeature;
    }

    private Function1<SimpleFeature, SimpleFeature> retype() {
        return this.retype;
    }

    private Filter manualFilter$lzycompute() {
        QueryVisitor queryVisitor = this;
        synchronized (queryVisitor) {
            if (!this.bitmap$0) {
                this.manualFilter = FastFilterFactory$.MODULE$.optimize((SimpleFeatureType)this.features.getSchema(), this.filter);
                this.bitmap$0 = true;
            }
        }
        this.features = null;
        return this.manualFilter;
    }

    private Filter manualFilter() {
        if (!this.bitmap$0) {
            return this.manualFilter$lzycompute();
        }
        return this.manualFilter;
    }

    private ListFeatureCollection manualVisitResults() {
        return this.manualVisitResults;
    }

    private FeatureResult resultCalc() {
        return this.resultCalc;
    }

    private void resultCalc_$eq(FeatureResult x$1) {
        this.resultCalc = x$1;
    }

    public void visit(Feature feature) {
        SimpleFeature sf = (SimpleFeature)feature;
        if (this.manualFilter().evaluate((Object)sf)) {
            this.manualVisitResults().add((SimpleFeature)this.retype().apply((Object)sf));
            return;
        }
    }

    public FeatureResult getResult() {
        return this.resultCalc();
    }

    public void execute(SimpleFeatureSource source, Query query) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running Geomesa query on source type {}", new Object[]{source.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        query.setFilter(package$.MODULE$.mergeFilters(query.getFilter(), this.filter));
        if (this.properties != null && this.properties.length > 0) {
            BoxedUnit boxedUnit2;
            List list = query.getProperties();
            List list2 = Query.ALL_PROPERTIES;
            if (list == null ? list2 != null : !((Object)list).equals(list2)) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder(67).append("Overriding inner query's properties (").append(query.getProperties()).append(") ").append("with properties/transforms ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.properties)).mkString(",")).append(".").toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            query.setPropertyNames(this.properties);
        }
        this.resultCalc_$eq(new FeatureResult(source.getFeatures(query)));
    }

    public QueryVisitor(SimpleFeatureCollection features, Filter filter, String[] properties) {
        Tuple2 tuple2;
        this.features = features;
        this.filter = filter;
        this.properties = properties;
        GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
        LazyLogging.$init$((LazyLogging)this);
        if (properties == null) {
            tuple2 = new Tuple2((Object)features.getSchema(), null);
        } else {
            Some some;
            Tuple3 tuple3;
            Option option;
            SimpleFeatureType original = (SimpleFeatureType)features.getSchema();
            Query query = new Query(original.getTypeName(), (Filter)Filter.INCLUDE);
            if (properties != null) {
                query.setPropertyNames(properties);
            }
            if (None$.MODULE$.equals(option = QueryPlanner$.MODULE$.extractQueryTransforms(original, query))) {
                tuple2 = new Tuple2((Object)original, null);
            } else if (option instanceof Some && (tuple3 = (Tuple3)(some = (Some)option).value()) != null) {
                SimpleFeatureType tsft = (SimpleFeatureType)tuple3._1();
                Seq tdefs = (Seq)tuple3._2();
                tuple2 = new Tuple2((Object)tsft, (Object)TransformSimpleFeature$.MODULE$.apply(tsft, tdefs));
            } else {
                throw new MatchError((Object)option);
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        SimpleFeatureType sft = (SimpleFeatureType)tuple22._1();
        TransformSimpleFeature transformFeature = (TransformSimpleFeature)tuple22._2();
        this.x$3 = new Tuple2((Object)sft, (Object)transformFeature);
        this.sft = (SimpleFeatureType)this.x$3._1();
        this.transformFeature = (TransformSimpleFeature)this.x$3._2();
        this.retype = this.transformFeature() == null ? (Function1 & Serializable & scala.Serializable)sf -> sf : (Function1 & Serializable & scala.Serializable)sf -> {
            this.transformFeature().setFeature(sf);
            return ScalaSimpleFeature$.MODULE$.copy((SimpleFeature)this.transformFeature());
        };
        this.manualVisitResults = new ListFeatureCollection(this.sft());
        this.resultCalc = new FeatureResult((SimpleFeatureCollection)this.manualVisitResults());
    }
}

