/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.tube;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.filter.Filter;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.tube.GapFill$;
import org.locationtech.geomesa.process.tube.TubeResult;
import org.locationtech.geomesa.process.tube.TubeVisitor;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@DescribeProcess(title="Tube Select", description="Performs a tube select on a Geomesa feature collection based on another feature collection")
@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0002\u0005\u0001=AQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005\u0002-\u0012\u0011\u0003V;cKN+G.Z2u!J|7-Z:t\u0015\t)a!\u0001\u0003uk\n,'BA\u0004\t\u0003\u001d\u0001(o\\2fgNT!!\u0003\u0006\u0002\u000f\u001d,w.\\3tC*\u00111\u0002D\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\r\u001d!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003mC:<'\"A\u000b\u0002\t)\fg/Y\u0005\u0003/I\u0011aa\u00142kK\u000e$\bCA\r\u001b\u001b\u00051\u0011BA\u000e\u0007\u000599Um\\'fg\u0006\u0004&o\\2fgN\u0004\"!\b\u0013\u000e\u0003yQ!a\b\u0011\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0005\u0012\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\r\n1aY8n\u0013\t)cDA\u0006MCjLHj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u0005\u0003\u001d)\u00070Z2vi\u0016$\u0012\u0002\f\u001cF\u0017j\u001b\u0017N]>\u0011\u00055\"T\"\u0001\u0018\u000b\u0005=\u0002\u0014AB:j[BdWM\u0003\u00022e\u0005!A-\u0019;b\u0015\t\u0019D\"\u0001\u0005hK>$xn\u001c7t\u0013\t)dFA\fTS6\u0004H.\u001a$fCR,(/Z\"pY2,7\r^5p]\")qG\u0001a\u0001Y\u0005aA/\u001e2f\r\u0016\fG/\u001e:fg\"2a'\u000f!B\u0005\u000e\u0003\"A\u000f \u000e\u0003mR!\u0001P\u001f\u0002\u000f\u0019\f7\r^8ss*\u0011qAM\u0005\u0003\u007fm\u0012\u0011\u0003R3tGJL'-\u001a)be\u0006lW\r^3s\u0003\u0011q\u0017-\\3\"\u0003]\n1\u0002Z3tGJL\u0007\u000f^5p]\u0006\nA)\u0001\u001eJ]B,H\u000f\t4fCR,(/\u001a\u0011d_2dWm\u0019;j_:\u0004\u0003&\\;ti\u0002B\u0017M^3!O\u0016|W.\u001a;ss\u0002\ng\u000e\u001a\u0011eCR,G/[7fS!)aI\u0001a\u0001Y\u0005\tb-Z1ukJ,7i\u001c7mK\u000e$\u0018n\u001c8)\r\u0015K\u0004\t\u0013\"JC\u00051\u0015%\u0001&\u0002WQCW\r\t3bi\u0006\u00043/\u001a;!i>\u0004\u0013/^3ss\u00022wN\u001d\u0011nCR\u001c\u0007.\u001b8hA\u0019,\u0017\r^;sKNDQ\u0001\u0014\u0002A\u00025\u000baAZ5mi\u0016\u0014\bC\u0001(S\u001b\u0005y%B\u0001'Q\u0015\t\t&'A\u0002ba&L!aU(\u0003\r\u0019KG\u000e^3sQ!Y\u0015\bQ+W/\nC\u0016%\u0001'\u0002\u00075Lg.H\u0001\u0001C\u0005I\u0016\u0001\f+iK\u00022\u0017\u000e\u001c;fe\u0002\"x\u000eI1qa2L\b\u0005^8!i\",\u0007EZ3biV\u0014XmQ8mY\u0016\u001cG/[8o\u0011\u0015Y&\u00011\u0001]\u0003!i\u0017\r_*qK\u0016$\u0007CA\t^\u0013\tq&C\u0001\u0003M_:<\u0007\u0006\u0003.:\u0001\u00024vKQ1\"\u0003m\u000b\u0013AY\u0001A\u001b\u0006D\be\u001d9fK\u0012\u0004sN\u001a\u0011uQ\u0016\u0004sN\u00196fGR\u0004\u0013N\u001c\u0011n_M\u0004cm\u001c:!]>4\u0017\u000e\u001c7!M\u0001b\u0017N\\3!O\u0006\u0004h-\u001b7mA5,G\u000f[8eg\")AM\u0001a\u00019\u00069Q.\u0019=US6,\u0007\u0006C2:\u0001\u001a4vKQ4\"\u0003\u0011\f\u0013\u0001[\u00012)&lW\rI1tAM,7m\u001c8eg\u00022wN\u001d\u0011o_\u001aLG\u000e\u001c\u0011'A1Lg.\u001a\u0011hCB4\u0017\u000e\u001c7![\u0016$\bn\u001c3t\u0011\u0015Q'\u00011\u0001l\u0003)\u0011WO\u001a4feNK'0\u001a\t\u0003#1L!!\u001c\n\u0003\r\u0011{WO\u00197fQ!I\u0017\bQ8W/\n\u0003\u0018%\u00016\"\u0003E\fAIQ;gM\u0016\u0014\be]5{K\u0002Jg\u000eI7fi\u0016\u00148\u000f\t;pAU\u001cX\rI5ogR,\u0017\r\u001a\u0011pM\u0002j\u0017\r_*qK\u0016$w&\\1y)&lW\rI2bY\u000e,H.\u0019;j_:DQa\u001d\u0002A\u0002Q\fq!\\1y\u0005&t7\u000f\u0005\u0002\u0012k&\u0011aO\u0005\u0002\b\u0013:$XmZ3sQ!\u0011\u0018\b\u0011=W/\nK\u0018%A:\"\u0003i\f1IT;nE\u0016\u0014\be\u001c4!E&t7\u000f\t;pAU\u001cX\r\t4pe\u0002\u0012'/Z1lS:<\u0007%\u001e9!cV,'/\u001f\u0011j]R|\u0007%\u001b8eSZLG-^1mAE,XM]5fg\")AP\u0001a\u0001{\u00069q-\u00199GS2d\u0007c\u0001@\u0002\u00109\u0019q0a\u0003\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002\u000f\u0003\u0019a$o\\8u})\u0011\u0011\u0011B\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003\u001b\t9!\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003#\t\u0019B\u0001\u0004TiJLgn\u001a\u0006\u0005\u0003\u001b\t9\u0001\u000b\u0006|s\u0001\u000b9BV,C\u00033\t\u0013\u0001`\u0011\u0003\u00037\tA%T3uQ>$\u0007e\u001c4!M&dG.\u001b8hA\u001d\f\u0007\u000f\t\u0015o_\u001aLG\u000e\u001c\u0017!Y&tW-\u000b\u0015\u0007\u0005\u0005}!)!\n\u0011\u0007i\n\t#C\u0002\u0002$m\u0012a\u0002R3tGJL'-\u001a*fgVdG/\t\u0002\u0002(\u0005Ir*\u001e;qkR\u0004c-Z1ukJ,\u0007eY8mY\u0016\u001cG/[8oQ)\u0001\u00111FA\u0019\u0003g\u0011\u0015q\u0007\t\u0004u\u00055\u0012bAA\u0018w\tyA)Z:de&\u0014W\r\u0015:pG\u0016\u001c8/A\u0003uSRdW-\t\u0002\u00026\u0005YA+\u001e2fAM+G.Z2uC\t\tI$\u0001.QKJ4wN]7tA\u0005\u0004C/\u001e2fAM,G.Z2uA=t\u0007%\u0019\u0011HK>lWm]1!M\u0016\fG/\u001e:fA\r|G\u000e\\3di&|g\u000e\t2bg\u0016$\u0007e\u001c8!C:|G\u000f[3sA\u0019,\u0017\r^;sK\u0002\u001aw\u000e\u001c7fGRLwN\u001c")
public class TubeSelectProcess
implements GeoMesaProcess,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        TubeSelectProcess tubeSelectProcess = this;
        synchronized (tubeSelectProcess) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @DescribeResult(description="Output feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="tubeFeatures", description="Input feature collection (must have geometry and datetime)") SimpleFeatureCollection tubeFeatures, @DescribeParameter(name="featureCollection", description="The data set to query for matching features") SimpleFeatureCollection featureCollection, @DescribeParameter(name="filter", min=0, description="The filter to apply to the featureCollection") Filter filter, @DescribeParameter(name="maxSpeed", min=0, description="Max speed of the object in m/s for nofill & line gapfill methods") Long maxSpeed, @DescribeParameter(name="maxTime", min=0, description="Time as seconds for nofill & line gapfill methods") Long maxTime, @DescribeParameter(name="bufferSize", min=0, description="Buffer size in meters to use instead of maxSpeed/maxTime calculation") Double bufferSize, @DescribeParameter(name="maxBins", min=0, description="Number of bins to use for breaking up query into individual queries") Integer maxBins, @DescribeParameter(name="gapFill", min=0, description="Method of filling gap (nofill, line)") String gapFill) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(34).append("Tube selecting on collection type ").append(featureCollection.getClass().getName()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        TubeVisitor tubeVisitor = new TubeVisitor(tubeFeatures, featureCollection, (Filter)Option$.MODULE$.apply((Object)filter).getOrElse((Function0 & Serializable & scala.Serializable)() -> Filter.INCLUDE), BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)maxSpeed).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)maxTime).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)bufferSize).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0)), BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)maxBins).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)), (Enumeration.Value)Option$.MODULE$.apply((Object)gapFill).map((Function1 & Serializable & scala.Serializable)s -> GapFill$.MODULE$.withName((String)s)).getOrElse((Function0 & Serializable & scala.Serializable)() -> GapFill$.MODULE$.NOFILL()));
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)featureCollection, (FeatureVisitor)tubeVisitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return ((TubeResult)tubeVisitor.getResult()).results();
    }

    public TubeSelectProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

