/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.features.TransformSimpleFeature;
import org.locationtech.geomesa.features.TransformSimpleFeature$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.iterators.StatsScan$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.FeatureResult;
import org.locationtech.geomesa.utils.geotools.GeometryUtils$;
import org.locationtech.geomesa.utils.geotools.Transform;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\n\u0015\u0001}A\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003Y\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u001d\u0019\u0007A1A\u0005\n\u0011DaA\u001c\u0001!\u0002\u0013)\u0007\u0002C8\u0001\u0011\u000b\u0007I\u0011\u00029\t\u0013\u0005\r\u0001\u0001#b\u0001\n\u0013!\u0007BCA\u0003\u0001!\u0015\r\u0011\"\u0003\u0002\b!I\u00111\u0003\u0001\t\u0006\u0004%I\u0001\u001a\u0005\u000b\u0003+\u0001\u0001R1A\u0005\n\u0005]\u0001bCA\u0013\u0001\u0001\u0007\t\u0019!C\u0005\u0003OA1\"!\r\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00024!Y\u0011q\b\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0015\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007Bq!a\u0014\u0001\t\u0003\n\t\u0006C\u0004\u0002T\u0001!\t%!\u0016\u0003\u0019M#\u0018\r^:WSNLGo\u001c:\u000b\u0005U1\u0012\u0001C1oC2LH/[2\u000b\u0005]A\u0012a\u00029s_\u000e,7o\u001d\u0006\u00033i\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u001c9\u0005aAn\\2bi&|g\u000e^3dQ*\tQ$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001A!z\u0003CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\nAA[1wC&\u0011qE\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005%jS\"\u0001\u0016\u000b\u0005]Y#B\u0001\u0017\u0019\u0003\u0015Ig\u000eZ3y\u0013\tq#FA\u000bHK>lUm]1Qe>\u001cWm]:WSNLGo\u001c:\u0011\u0005A:T\"A\u0019\u000b\u0005I\u001a\u0014\u0001D:dC2\fGn\\4hS:<'B\u0001\u001b6\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u001c\u0002\u0007\r|W.\u0003\u00029c\tYA*\u0019>z\u0019><w-\u001b8h\u0003!1W-\u0019;ve\u0016\u001c\bCA\u001eC\u001b\u0005a$BA\u001f?\u0003\u0019\u0019\u0018.\u001c9mK*\u0011q\bQ\u0001\u0005I\u0006$\u0018M\u0003\u0002B9\u0005Aq-Z8u_>d7/\u0003\u0002Dy\t92+[7qY\u00164U-\u0019;ve\u0016\u001cu\u000e\u001c7fGRLwN\\\u0001\u000bgR\fGo\u0015;sS:<\u0007C\u0001$P\u001d\t9U\n\u0005\u0002I\u00176\t\u0011J\u0003\u0002K=\u00051AH]8pizR\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u000ba\u0001\u0015:fI\u00164\u0017B\u0001)R\u0005\u0019\u0019FO]5oO*\u0011ajS\u0001\u0007K:\u001cw\u000eZ3\u0011\u0005Q+V\"A&\n\u0005Y[%a\u0002\"p_2,\u0017M\\\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bc\u0001+Z\u000b&\u0011!l\u0013\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bu{\u0006-\u00192\u0011\u0005y\u0003Q\"\u0001\u000b\t\u000be*\u0001\u0019\u0001\u001e\t\u000b\u0011+\u0001\u0019A#\t\u000bI+\u0001\u0019A*\t\u000b]+\u0001\u0019\u0001-\u0002\u000f=\u0014\u0018nZ*giV\tQ\r\u0005\u0002gY6\tqM\u0003\u0002>Q*\u0011\u0011N[\u0001\bM\u0016\fG/\u001e:f\u0015\tY\u0007)A\u0002ba&L!!\\4\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X-\u0001\u0005pe&<7K\u001a;!\u0003Q!(/\u00198tM>\u0014X\u000eR3gS:LG/[8ogV\t\u0011\u000fE\u0002sojt!a];\u000f\u0005!#\u0018\"\u0001'\n\u0005Y\\\u0015a\u00029bG.\fw-Z\u0005\u0003qf\u00141aU3r\u0015\t18\n\u0005\u0002|\u007f6\tAP\u0003\u0002B{*\u0011a\u0010G\u0001\u0006kRLGn]\u0005\u0004\u0003\u0003a(!\u0003+sC:\u001chm\u001c:n\u00031!(/\u00198tM>\u0014Xn\u00154u\u0003-!(/\u00198tM>\u0014Xn\u00154\u0016\u0005\u0005%\u0001\u0003BA\u0006\u0003\u001fi!!!\u0004\u000b\u0005eB\u0012\u0002BA\t\u0003\u001b\u0011a\u0003\u0016:b]N4wN]7TS6\u0004H.\u001a$fCR,(/Z\u0001\bgR\fGo\u00154u\u0003\u0011\u0019H/\u0019;\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}Q0A\u0003ti\u0006$8/\u0003\u0003\u0002$\u0005u!\u0001B*uCR\f!B]3tk2$8)\u00197d+\t\tI\u0003\u0005\u0003\u0002,\u00055R\"\u0001\f\n\u0007\u0005=bCA\u0007GK\u0006$XO]3SKN,H\u000e^\u0001\u000fe\u0016\u001cX\u000f\u001c;DC2\u001cw\fJ3r)\u0011\t)$a\u000f\u0011\u0007Q\u000b9$C\u0002\u0002:-\u0013A!\u00168ji\"I\u0011Q\b\b\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\u0004q\u0012\n\u0014a\u0003:fgVdGoQ1mG\u0002\nQA^5tSR$B!!\u000e\u0002F!1\u0011\u000e\u0005a\u0001\u0003\u000f\u0002B!!\u0013\u0002L5\t\u0001.C\u0002\u0002N!\u0014qAR3biV\u0014X-A\u0005hKR\u0014Vm];miR\u0011\u0011\u0011F\u0001\bKb,7-\u001e;f)\u0019\t)$a\u0016\u0002f!9\u0011\u0011\f\nA\u0002\u0005m\u0013AB:pkJ\u001cW\r\u0005\u0003\u0002^\u0005\u0005TBAA0\u0015\ty$.\u0003\u0003\u0002d\u0005}#aE*j[BdWMR3biV\u0014XmU8ve\u000e,\u0007bBA4%\u0001\u0007\u0011\u0011N\u0001\u0006cV,'/\u001f\t\u0005\u0003;\nY'\u0003\u0003\u0002n\u0005}#!B)vKJL\b")
public class StatsVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private Seq<Transform> transformDefinitions;
    private SimpleFeatureType transformSft;
    private TransformSimpleFeature transformSf;
    private SimpleFeatureType statSft;
    private Stat stat;
    private final String statString;
    private final boolean encode;
    private final String[] properties;
    private final SimpleFeatureType origSft;
    private FeatureResult resultCalc;
    private transient Logger logger;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public List<Expression> getExpressions() {
        return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
    }

    private Logger logger$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private SimpleFeatureType origSft() {
        return this.origSft;
    }

    private Seq<Transform> transformDefinitions$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.transformDefinitions = Transform.Transforms$.MODULE$.apply(this.origSft(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.properties));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.transformDefinitions;
    }

    private Seq<Transform> transformDefinitions() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.transformDefinitions$lzycompute();
        }
        return this.transformDefinitions;
    }

    private SimpleFeatureType transformSft$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.transformSft = Transform.Transforms$.MODULE$.schema(this.origSft(), this.transformDefinitions());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.transformSft;
    }

    private SimpleFeatureType transformSft() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.transformSft$lzycompute();
        }
        return this.transformSft;
    }

    private TransformSimpleFeature transformSf$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.transformSf = TransformSimpleFeature$.MODULE$.apply(this.transformSft(), this.transformDefinitions());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.transformSf;
    }

    private TransformSimpleFeature transformSf() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.transformSf$lzycompute();
        }
        return this.transformSf;
    }

    private SimpleFeatureType statSft$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.statSft = this.properties == null ? this.origSft() : this.transformSft();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.statSft;
    }

    private SimpleFeatureType statSft() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.statSft$lzycompute();
        }
        return this.statSft;
    }

    private Stat stat$lzycompute() {
        StatsVisitor statsVisitor = this;
        synchronized (statsVisitor) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.stat = Stat$.MODULE$.apply(this.statSft(), this.statString);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.stat;
    }

    private Stat stat() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.stat$lzycompute();
        }
        return this.stat;
    }

    private FeatureResult resultCalc() {
        return this.resultCalc;
    }

    private void resultCalc_$eq(FeatureResult x$1) {
        this.resultCalc = x$1;
    }

    public void visit(Feature feature) {
        SimpleFeature sf = (SimpleFeature)feature;
        if (this.properties != null) {
            this.transformSf().setFeature(sf);
            this.stat().observe((SimpleFeature)this.transformSf());
            return;
        }
        this.stat().observe(sf);
    }

    public FeatureResult getResult() {
        if (this.resultCalc() != null) {
            return this.resultCalc();
        }
        String stats = this.encode ? (String)StatsScan$.MODULE$.encodeStat(this.statSft()).apply((Object)this.stat()) : this.stat().toJson();
        ScalaSimpleFeature sf = new ScalaSimpleFeature(StatsScan$.MODULE$.StatsSft(), "", new Object[]{stats, GeometryUtils$.MODULE$.zeroPoint()}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
        ListFeatureCollection manualVisitResults = new ListFeatureCollection(StatsScan$.MODULE$.StatsSft());
        manualVisitResults.add((SimpleFeature)sf);
        return new FeatureResult((SimpleFeatureCollection)manualVisitResults);
    }

    public void execute(SimpleFeatureSource source, Query query) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running Geomesa stats iterator process on source type {}", new Object[]{source.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.properties != null) {
            BoxedUnit boxedUnit2;
            List list = query.getProperties();
            List list2 = Query.ALL_PROPERTIES;
            if (list == null ? list2 != null : !((Object)list).equals(list2)) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder(67).append("Overriding inner query's properties (").append(query.getProperties()).append(") ").append("with properties/transforms ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.properties)).mkString(",")).append(".").toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            query.setPropertyNames(this.properties);
        }
        query.getHints().put((Object)QueryHints$.MODULE$.STATS_STRING(), (Object)this.statString);
        query.getHints().put((Object)QueryHints$.MODULE$.ENCODE_STATS(), (Object)new Boolean(this.encode));
        this.resultCalc_$eq(new FeatureResult(source.getFeatures(query)));
    }

    public StatsVisitor(SimpleFeatureCollection features, String statString, boolean encode, String[] properties) {
        this.statString = statString;
        this.encode = encode;
        this.properties = properties;
        GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
        LazyLogging.$init$((LazyLogging)this);
        this.origSft = (SimpleFeatureType)features.getSchema();
    }
}

