/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.tube;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.process.tube.TubeBuilder;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.NumericRange$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001Y4AAC\u0006\u0001-!IQ\u0005\u0001B\u0001B\u0003%a\u0005\r\u0005\nc\u0001\u0011\t\u0011)A\u0005eaB\u0011\"\u000f\u0001\u0003\u0002\u0003\u0006IAO\u001f\t\u000by\u0002A\u0011A \t\u000f\u0011\u0003!\u0019!C\u0001\u000b\"1!\u000b\u0001Q\u0001\n\u0019CQa\u0015\u0001\u0005\u0002QCQ\u0001\u0019\u0001\u0005B\u0005D1\u0002\u001e\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003vq\t\u0019\u0012J\u001c;feB|G.\u0019;fI\u001e\u000b\u0007OR5mY*\u0011A\"D\u0001\u0005iV\u0014WM\u0003\u0002\u000f\u001f\u00059\u0001O]8dKN\u001c(B\u0001\t\u0012\u0003\u001d9Wm\\7fg\u0006T!AE\n\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u00192\u0001A\f\u001c!\tA\u0012$D\u0001\f\u0013\tQ2BA\u0006Uk\n,')^5mI\u0016\u0014\bC\u0001\u000f$\u001b\u0005i\"B\u0001\u0010 \u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\u0001\u0013%\u0001\u0005usB,7/\u00194f\u0015\u0005\u0011\u0013aA2p[&\u0011A%\b\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0007uk\n,g)Z1ukJ,7\u000f\u0005\u0002(]5\t\u0001F\u0003\u0002*U\u000511/[7qY\u0016T!a\u000b\u0017\u0002\t\u0011\fG/\u0019\u0006\u0003[M\t\u0001bZ3pi>|Gn]\u0005\u0003_!\u0012qcU5na2,g)Z1ukJ,7i\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0015J\u0012A\u00042vM\u001a,'\u000fR5ti\u0006t7-\u001a\t\u0003gYj\u0011\u0001\u000e\u0006\u0002k\u0005)1oY1mC&\u0011q\u0007\u000e\u0002\u0007\t>,(\r\\3\n\u0005EJ\u0012aB7bq\nKgn\u001d\t\u0003gmJ!\u0001\u0010\u001b\u0003\u0007%sG/\u0003\u0002:3\u00051A(\u001b8jiz\"B\u0001Q!C\u0007B\u0011\u0001\u0004\u0001\u0005\u0006K\u0011\u0001\rA\n\u0005\u0006c\u0011\u0001\rA\r\u0005\u0006s\u0011\u0001\rAO\u0001\u0003S\u0012,\u0012A\u0012\t\u0003\u000fBk\u0011\u0001\u0013\u0006\u0003\u0013*\u000ba!\u0019;p[&\u001c'BA&M\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u001b:\u000bA!\u001e;jY*\tq*\u0001\u0003kCZ\f\u0017BA)I\u00055\tEo\\7jG&sG/Z4fe\u0006\u0019\u0011\u000e\u001a\u0011\u0002\r9,\u0007\u0010^%e+\u0005)\u0006C\u0001,^\u001d\t96\f\u0005\u0002Yi5\t\u0011L\u0003\u0002[+\u00051AH]8pizJ!\u0001\u0018\u001b\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039R\n!b\u0019:fCR,G+\u001e2f+\u0005\u0011\u0007cA2iW:\u0011AM\u001a\b\u00031\u0016L\u0011!N\u0005\u0003OR\nq\u0001]1dW\u0006<W-\u0003\u0002jU\nA\u0011\n^3sCR|'O\u0003\u0002hiA\u0011AN]\u0007\u0002[*\u0011\u0011F\u001c\u0006\u0003_B\fqAZ3biV\u0014XM\u0003\u0002rY\u0005\u0019\u0011\r]5\n\u0005Ml'!D*j[BdWMR3biV\u0014X-\u0001\u000btkB,'\u000f\n2vM\u001a,'\u000fR5ti\u0006t7-Z\u000b\u0002e\u0001")
public class InterpolatedGapFill
extends TubeBuilder {
    private final AtomicInteger id = new AtomicInteger(0);

    private /* synthetic */ double super$bufferDistance() {
        return super.bufferDistance();
    }

    public AtomicInteger id() {
        return this.id;
    }

    public String nextId() {
        return Integer.toString(this.id().getAndIncrement());
    }

    @Override
    public Iterator<SimpleFeature> createTube() {
        Iterator iterator;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Creating tube with line interpolated line gap fill");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Iterator<SimpleFeature> transformed = this.transform(super.tubeFeatures(), this.dtgField());
        Seq sortedTube = (Seq)transformed.toSeq().sortBy((Function1 & Serializable & scala.Serializable)sf -> BoxesRunTime.boxToLong((long)InterpolatedGapFill.$anonfun$createTube$5(this, sf)), (Ordering)Ordering.Long$.MODULE$);
        Seq pointsAndTimes = (Seq)sortedTube.map((Function1 & Serializable & scala.Serializable)sf -> new Tuple2((Object)Conversions.RichGeometry$.MODULE$.safeCentroid$extension(Conversions$.MODULE$.RichGeometry(this.getGeom((SimpleFeature)sf))), (Object)this.getStartTime((SimpleFeature)sf)), Seq$.MODULE$.canBuildFrom());
        if (pointsAndTimes.lengthCompare(1) == 0) {
            BoxedUnit boxedUnit2;
            Tuple2 tuple2 = (Tuple2)pointsAndTimes.head();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Point p1 = (Point)tuple2._1();
            Date t1 = (Date)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)p1, (Object)t1);
            Point p12 = (Point)tuple22._1();
            Date t12 = (Date)tuple22._2();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Only a single result - can't create a line");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeature[]{this.builder().buildFeature(this.nextId(), new Object[]{p12, t12, t12})}));
        } else {
            iterator = pointsAndTimes.sliding(2).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Seq seq = x0$1;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Tuple2 tuple2 = (Tuple2)((SeqLike)some.get()).apply(0);
                    Tuple2 tuple22 = (Tuple2)((SeqLike)some.get()).apply(1);
                    if (tuple2 != null) {
                        Point p1 = (Point)tuple2._1();
                        Date t1 = (Date)tuple2._2();
                        if (tuple22 != null) {
                            BoxedUnit boxedUnit;
                            Point geo;
                            Point p2 = (Point)tuple22._1();
                            Date t2 = (Date)tuple22._2();
                            this.calc().setStartingGeographicPoint(p1.getX(), p1.getY());
                            this.calc().setDestinationGeographicPoint(p2.getX(), p2.getY());
                            double dist = this.calc().getOrthodromicDistance();
                            long timeDiffMillis = t2.getTime() - t1.getTime();
                            int segCount = (int)(dist / this.super$bufferDistance());
                            long segDuration = timeDiffMillis / (long)segCount;
                            NumericRange.Inclusive timeSteps = NumericRange$.MODULE$.inclusive((Object)BoxesRunTime.boxToLong((long)t1.getTime()), (Object)BoxesRunTime.boxToLong((long)t2.getTime()), (Object)BoxesRunTime.boxToLong((long)segDuration), (Integral)Numeric.LongIsIntegral$.MODULE$);
                            if (dist > this.super$bufferDistance() && timeSteps.lengthCompare(1) > 0) {
                                double heading = this.calc().getAzimuth();
                                ObjectRef segStep = ObjectRef.create((Object)new Coordinate(p1.getX(), p1.getY(), 0.0));
                                return timeSteps.sliding(2).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                    IndexedSeq indexedSeq = x0$2;
                                    Some some = Seq$.MODULE$.unapplySeq((Seq)indexedSeq);
                                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                        long time0 = BoxesRunTime.unboxToLong((Object)((SeqLike)some.get()).apply(0));
                                        long time1 = BoxesRunTime.unboxToLong((Object)((SeqLike)some.get()).apply(1));
                                        Coordinate segP1 = (Coordinate)segStep$1.elem;
                                        this.calc().setStartingGeographicPoint(segP1.x, segP1.y);
                                        this.calc().setDirection(heading, this.super$bufferDistance());
                                        Point2D destPoint = this.calc().getDestinationGeographicPoint();
                                        segStep$1.elem = new Coordinate(destPoint.getX(), destPoint.getY(), 0.0);
                                        Geometry geo = this.makeIDLSafeLineString(segP1, (Coordinate)segStep$1.elem);
                                        return this.builder().buildFeature(this.nextId(), new Object[]{geo, new Date(time0), new Date(time1)});
                                    }
                                    throw new MatchError((Object)indexedSeq);
                                });
                            }
                            Object object = geo = p1.equals((Geometry)p2) ? p1 : this.makeIDLSafeLineString(p1.getCoordinate(), p2.getCoordinate());
                            if (this.logger().underlying().isDebugEnabled()) {
                                this.logger().underlying().debug(new StringBuilder(41).append("Created line-filled geometry: ").append(WKTUtils$.MODULE$.write((Geometry)geo)).append(" ").append("from ").append(WKTUtils$.MODULE$.write((Geometry)p1)).append(" and ").append(WKTUtils$.MODULE$.write((Geometry)p2)).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            return new .colon.colon((Object)this.builder().buildFeature(this.nextId(), new Object[]{geo, t1, t2}), (List)Nil$.MODULE$);
                        }
                    }
                }
                throw new MatchError((Object)seq);
            });
        }
        Iterator lineFeatures = iterator;
        return this.buffer((Iterator<SimpleFeature>)lineFeatures, super.bufferDistance());
    }

    public static final /* synthetic */ long $anonfun$createTube$5(InterpolatedGapFill $this, SimpleFeature sf) {
        return $this.getStartTime(sf).getTime();
    }

    public InterpolatedGapFill(SimpleFeatureCollection tubeFeatures, double bufferDistance, int maxBins) {
        super(tubeFeatures, bufferDistance, maxBins);
    }
}

