/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.index.attribute.AttributeIndex$;
import org.locationtech.geomesa.index.iterators.StatsScan$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.analytic.AttributeResult;
import org.locationtech.geomesa.process.analytic.AttributeVisitor$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.stats.EnumerationStat;
import org.locationtech.geomesa.utils.stats.Stat$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001\u0002\u0010 \u0001)B\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t!\u0012\u0005\t!\u0002\u0011\t\u0011)A\u0005\r\"A\u0011\u000b\u0001BC\u0002\u0013\u0005!\u000b\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003T\u0011!q\u0006A!b\u0001\n\u0003y\u0006\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u00111\u0004!\u0011!Q\u0001\n5DQ\u0001\u001d\u0001\u0005\u0002EDq\u0001\u001f\u0001C\u0002\u0013%\u0011\u0010\u0003\u0004~\u0001\u0001\u0006IA\u001f\u0005\b}\u0002\u0011\r\u0011\"\u0003\u0000\u0011!\ti\u0002\u0001Q\u0001\n\u0005\u0005\u0001\"CA\u0010\u0001\u0001\u0007I\u0011BA\u0011\u0011%\tI\u0003\u0001a\u0001\n\u0013\tY\u0003\u0003\u0005\u00028\u0001\u0001\u000b\u0015BA\u0012\u0011%\tI\u0004\u0001EC\u0002\u0013%q\fC\u0004\u0002<\u0001!I!!\u0010\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h!9\u00111\u000e\u0001\u0005\n\u00055\u0004\"CA9\u0001\t\u0007I\u0011BA:\u0011!\tY\b\u0001Q\u0001\n\u0005U\u0004bBA?\u0001\u0011\u0005\u0013q\u0010\u0005\b\u0003\u0017\u0003A\u0011IAG\u0011\u001d\t)\n\u0001C!\u0003/Cq!!-\u0001\t\u0013\t\u0019lB\u0004\u0002X~A\t!!7\u0007\ryy\u0002\u0012AAn\u0011\u0019\u00018\u0004\"\u0001\u0002^\"9\u0011q\\\u000e\u0005\u0002\u0005\u0005(\u0001E!uiJL'-\u001e;f-&\u001c\u0018\u000e^8s\u0015\t\u0001\u0013%\u0001\u0005b]\u0006d\u0017\u0010^5d\u0015\t\u00113%A\u0004qe>\u001cWm]:\u000b\u0005\u0011*\u0013aB4f_6,7/\u0019\u0006\u0003M\u001d\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011\u0001K\u0001\u0004_J<7\u0001A\n\u0005\u0001-\u001a$\b\u0005\u0002-c5\tQF\u0003\u0002/_\u0005!A.\u00198h\u0015\u0005\u0001\u0014\u0001\u00026bm\u0006L!AM\u0017\u0003\r=\u0013'.Z2u!\t!\u0004(D\u00016\u0015\t\u0011cG\u0003\u00028G\u0005)\u0011N\u001c3fq&\u0011\u0011(\u000e\u0002\u0016\u000f\u0016|W*Z:b!J|7-Z:t-&\u001c\u0018\u000e^8s!\tY$)D\u0001=\u0015\tid(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002@\u0001\u0006AA/\u001f9fg\u00064WMC\u0001B\u0003\r\u0019w.\\\u0005\u0003\u0007r\u00121\u0002T1{s2{wmZ5oO\u0006Aa-Z1ukJ,7/F\u0001G!\t9e*D\u0001I\u0015\tI%*\u0001\u0004tS6\u0004H.\u001a\u0006\u0003\u00172\u000bA\u0001Z1uC*\u0011QjJ\u0001\tO\u0016|Go\\8mg&\u0011q\n\u0013\u0002\u0018'&l\u0007\u000f\\3GK\u0006$XO]3D_2dWm\u0019;j_:\f\u0011BZ3biV\u0014Xm\u001d\u0011\u0002'\u0005$HO]5ckR,G)Z:de&\u0004Ho\u001c:\u0016\u0003M\u0003\"\u0001V.\u000e\u0003US!AV,\u0002\tQL\b/\u001a\u0006\u00031f\u000bqAZ3biV\u0014XM\u0003\u0002[\u0019\u0006\u0019\u0011\r]5\n\u0005q+&aE!uiJL'-\u001e;f\t\u0016\u001c8M]5qi>\u0014\u0018\u0001F1uiJL'-\u001e;f\t\u0016\u001c8M]5qi>\u0014\b%\u0001\u0004gS2$XM]\u000b\u0002AB\u0019\u0011\r\u001a4\u000e\u0003\tT\u0011aY\u0001\u0006g\u000e\fG.Y\u0005\u0003K\n\u0014aa\u00149uS>t\u0007CA4j\u001b\u0005A'B\u00010Z\u0013\tQ\u0007N\u0001\u0004GS2$XM]\u0001\bM&dG/\u001a:!\u0003%A\u0017n\u001d;pOJ\fW\u000e\u0005\u0002b]&\u0011qN\u0019\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q)!\u000f^;woB\u00111\u000fA\u0007\u0002?!)A\t\u0003a\u0001\r\")\u0011\u000b\u0003a\u0001'\")a\f\u0003a\u0001A\")A\u000e\u0003a\u0001[\u0006I\u0011\r\u001e;sS\n,H/Z\u000b\u0002uB\u0011Af_\u0005\u0003y6\u0012aa\u0015;sS:<\u0017AC1uiJL'-\u001e;fA\u0005aQO\\5rk\u00164\u0016\r\\;fgV\u0011\u0011\u0011\u0001\t\t\u0003\u0007\ti!!\u0005\u0002\u00185\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0004nkR\f'\r\\3\u000b\u0007\u0005-!-\u0001\u0006d_2dWm\u0019;j_:LA!a\u0004\u0002\u0006\t\u0019Q*\u00199\u0011\u0007\u0005\f\u0019\"C\u0002\u0002\u0016\t\u0014a!\u00118z%\u00164\u0007cA1\u0002\u001a%\u0019\u00111\u00042\u0003\t1{gnZ\u0001\u000ek:L\u0017/^3WC2,Xm\u001d\u0011\u0002\u0019\u0005$HO]5ckR,\u0017\n\u001a=\u0016\u0005\u0005\r\u0002cA1\u0002&%\u0019\u0011q\u00052\u0003\u0007%sG/\u0001\tbiR\u0014\u0018NY;uK&#\u0007p\u0018\u0013fcR!\u0011QFA\u001a!\r\t\u0017qF\u0005\u0004\u0003c\u0011'\u0001B+oSRD\u0011\"!\u000e\u000f\u0003\u0003\u0005\r!a\t\u0002\u0007a$\u0013'A\u0007biR\u0014\u0018NY;uK&#\u0007\u0010I\u0001\r[\u0006tW/\u00197GS2$XM]\u0001\rO\u0016$\u0018\t\u001e;sS\n,H/Z\u000b\u0005\u0003\u007f\t)\u0005\u0006\u0003\u0002B\u0005]\u0003\u0003BA\"\u0003\u000bb\u0001\u0001B\u0004\u0002HE\u0011\r!!\u0013\u0003\u0003Q\u000bB!a\u0013\u0002RA\u0019\u0011-!\u0014\n\u0007\u0005=#MA\u0004O_RD\u0017N\\4\u0011\u0007\u0005\f\u0019&C\u0002\u0002V\t\u00141!\u00118z\u0011\u001d\tI&\u0005a\u0001\u00037\n\u0011A\u001a\t\u0005\u0003;\n\t'\u0004\u0002\u0002`)\u0011\u0011jV\u0005\u0005\u0003G\nyFA\u0007TS6\u0004H.\u001a$fCR,(/Z\u0001\u0011C\u0012$7+\u001b8hk2\f'OV1mk\u0016$B!!\f\u0002j!9\u0011\u0011\f\nA\u0002\u0005m\u0013!D1eI6+H\u000e^5WC2,X\r\u0006\u0003\u0002.\u0005=\u0004bBA-'\u0001\u0007\u00111L\u0001\tC\u0012$g+\u00197vKV\u0011\u0011Q\u000f\t\bC\u0006]\u00141LA\u0017\u0013\r\tIH\u0019\u0002\n\rVt7\r^5p]F\n\u0011\"\u00193e-\u0006dW/\u001a\u0011\u0002\u000bYL7/\u001b;\u0015\t\u00055\u0012\u0011\u0011\u0005\u00071Z\u0001\r!a!\u0011\t\u0005\u0015\u0015qQ\u0007\u0002/&\u0019\u0011\u0011R,\u0003\u000f\u0019+\u0017\r^;sK\u0006Iq-\u001a;SKN,H\u000e\u001e\u000b\u0003\u0003\u001f\u00032a]AI\u0013\r\t\u0019j\b\u0002\u0010\u0003R$(/\u001b2vi\u0016\u0014Vm];mi\u00069Q\r_3dkR,GCBA\u0017\u00033\u000b9\u000bC\u0004\u0002\u001cb\u0001\r!!(\u0002\rM|WO]2f!\u0011\ty*a)\u000e\u0005\u0005\u0005&BA&Z\u0013\u0011\t)+!)\u0003'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f'>,(oY3\t\u000f\u0005%\u0006\u00041\u0001\u0002,\u0006)\u0011/^3ssB!\u0011qTAW\u0013\u0011\ty+!)\u0003\u000bE+XM]=\u0002\u0011Ut\u0017.];f-V\"b!!.\u0002T\u0006U\u0007CBA\\\u0003\u000f\fiM\u0004\u0003\u0002:\u0006\rg\u0002BA^\u0003\u0003l!!!0\u000b\u0007\u0005}\u0016&\u0001\u0004=e>|GOP\u0005\u0002G&\u0019\u0011Q\u00192\u0002\u000fA\f7m[1hK&!\u0011\u0011ZAf\u0005!IE/\u001a:bE2,'bAAcEB9\u0011-a4\u0002\u0012\u0005]\u0011bAAiE\n1A+\u001e9mKJBq!a'\u001a\u0001\u0004\ti\nC\u0004\u0002*f\u0001\r!a+\u0002!\u0005#HO]5ckR,g+[:ji>\u0014\bCA:\u001c'\rY\u0012\u0011\u0003\u000b\u0003\u00033\f\u0011dZ3u\u0013:\u001cG.\u001e3f\u0003R$(/\u001b2vi\u00164\u0015\u000e\u001c;feR\u0019a-a9\t\ral\u0002\u0019AAs!\u0011\t9/a<\u000f\t\u0005%\u00181\u001e\t\u0004\u0003w\u0013\u0017bAAwE\u00061\u0001K]3eK\u001aL1\u0001`Ay\u0015\r\tiO\u0019")
public class AttributeVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private Option<Filter> manualFilter;
    private final SimpleFeatureCollection features;
    private final AttributeDescriptor attributeDescriptor;
    private final Option<Filter> filter;
    private final String attribute;
    private final Map<Object, Object> uniqueValues;
    private int attributeIdx;
    private final Function1<SimpleFeature, BoxedUnit> addValue;
    private transient Logger logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Filter getIncludeAttributeFilter(String string) {
        return AttributeVisitor$.MODULE$.getIncludeAttributeFilter(string);
    }

    public java.util.List<Expression> getExpressions() {
        return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
    }

    private Logger logger$lzycompute() {
        AttributeVisitor attributeVisitor = this;
        synchronized (attributeVisitor) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public SimpleFeatureCollection features() {
        return this.features;
    }

    public AttributeDescriptor attributeDescriptor() {
        return this.attributeDescriptor;
    }

    public Option<Filter> filter() {
        return this.filter;
    }

    private String attribute() {
        return this.attribute;
    }

    private Map<Object, Object> uniqueValues() {
        return this.uniqueValues;
    }

    private int attributeIdx() {
        return this.attributeIdx;
    }

    private void attributeIdx_$eq(int x$1) {
        this.attributeIdx = x$1;
    }

    private Option<Filter> manualFilter$lzycompute() {
        AttributeVisitor attributeVisitor = this;
        synchronized (attributeVisitor) {
            if (!this.bitmap$0) {
                this.manualFilter = this.filter().map((Function1 & Serializable & scala.Serializable)x$8 -> FastFilterFactory$.MODULE$.optimize((SimpleFeatureType)this.features().getSchema(), x$8));
                this.bitmap$0 = true;
            }
        }
        return this.manualFilter;
    }

    private Option<Filter> manualFilter() {
        if (!this.bitmap$0) {
            return this.manualFilter$lzycompute();
        }
        return this.manualFilter;
    }

    private <T> T getAttribute(SimpleFeature f) {
        block0: {
            if (this.attributeIdx() != -1) break block0;
            this.attributeIdx_$eq(f.getType().indexOf(this.attribute()));
        }
        return (T)f.getAttribute(this.attributeIdx());
    }

    private void addSingularValue(SimpleFeature f) {
        Object value = this.getAttribute(f);
        if (value != null) {
            this.uniqueValues().update(value, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.uniqueValues().apply(value)) + 1L)));
            return;
        }
    }

    private void addMultiValue(SimpleFeature f) {
        Collection values = (Collection)this.getAttribute(f);
        if (values != null) {
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(values).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                AttributeVisitor.$anonfun$addMultiValue$1(this, x$9);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private Function1<SimpleFeature, BoxedUnit> addValue() {
        return this.addValue;
    }

    public void visit(Feature feature) {
        SimpleFeature f = (SimpleFeature)feature;
        if (this.manualFilter().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.evaluate((Object)f)))) {
            this.addValue().apply((Object)f);
            return;
        }
    }

    public AttributeResult getResult() {
        return new AttributeResult((scala.collection.immutable.Map<Object, Object>)this.uniqueValues().toMap(Predef$.MODULE$.$conforms()));
    }

    public void execute(SimpleFeatureSource source, Query query) {
        Iterable iterable;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running Geomesa histogram process on source type {}", new Object[]{source.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.filter().foreach((Function1 & Serializable & scala.Serializable)f -> {
            query.setFilter(package$.MODULE$.mergeFilters(query.getFilter(), f));
            return BoxedUnit.UNIT;
        });
        SimpleFeatureType sft = (SimpleFeatureType)source.getSchema();
        if (RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isMultiValued$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(this.attributeDescriptor()))) {
            iterable = this.uniqueV5(source, query);
        } else {
            EnumerationStat enumerationStat;
            query.getHints().put((Object)QueryHints$.MODULE$.STATS_STRING(), (Object)Stat$.MODULE$.Enumeration(this.attribute()));
            query.getHints().put((Object)QueryHints$.MODULE$.ENCODE_STATS(), (Object)Boolean.TRUE);
            try (SimpleFeatureIterator reader = source.getFeatures(query).features();){
                String encoded = (String)((SimpleFeature)reader.next()).getAttribute(0);
                enumerationStat = (EnumerationStat)StatsScan$.MODULE$.decodeStat(sft).apply((Object)encoded);
            }
            EnumerationStat enumeration = enumerationStat;
            iterable = enumeration.frequencies();
        }
        Iterable enumerated = iterable;
        this.uniqueValues().clear();
        enumerated.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                long v = tuple2._2$mcJ$sp();
                return this.uniqueValues().put(k, (Object)BoxesRunTime.boxToLong((long)v));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Iterable<Tuple2<Object, Object>> uniqueV5(SimpleFeatureSource source, Query query) {
        query.setPropertyNames((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.attribute(), (List)Nil$.MODULE$)).asJava());
        Filter filter = query.getFilter();
        IncludeFilter includeFilter = Filter.INCLUDE;
        if (!(filter != null ? !filter.equals(includeFilter) : includeFilter != null) && AttributeIndex$.MODULE$.indexed((SimpleFeatureType)this.features().getSchema(), this.attribute())) {
            query.setFilter(AttributeVisitor$.MODULE$.getIncludeAttributeFilter(this.attribute()));
        }
        SelfClosingIterator$.MODULE$.apply(source.getFeatures(query).features()).foreach(this.addValue());
        return this.uniqueValues().toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$addMultiValue$1(AttributeVisitor $this, Object x$9) {
        $this.uniqueValues().update(x$9, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)$this.uniqueValues().apply(x$9)) + 1L)));
    }

    public AttributeVisitor(SimpleFeatureCollection features, AttributeDescriptor attributeDescriptor, Option<Filter> filter, boolean histogram) {
        this.features = features;
        this.attributeDescriptor = attributeDescriptor;
        this.filter = filter;
        GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
        LazyLogging.$init$((LazyLogging)this);
        this.attribute = attributeDescriptor.getLocalName();
        this.uniqueValues = Map$.MODULE$.empty().withDefaultValue((Object)BoxesRunTime.boxToLong((long)0L));
        this.attributeIdx = -1;
        this.addValue = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(attributeDescriptor)) ? (Function1 & Serializable & scala.Serializable)f -> {
            this.addMultiValue(f);
            return BoxedUnit.UNIT;
        } : (Function1 & Serializable & scala.Serializable)f -> {
            this.addSingularValue(f);
            return BoxedUnit.UNIT;
        };
    }
}

