/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.Conversions;
import org.locationtech.geomesa.utils.geotools.Conversions$;
import org.locationtech.geomesa.utils.geotools.SchemaBuilder;
import org.locationtech.geomesa.utils.geotools.SchemaBuilder$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DescribeProcess(title="Point2PointProcess", description="Aggregates a collection of points into a collection of line segments")
@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001\u0002\u0005\n\u0001QAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u00044\u0001\u0001\u0006Ia\n\u0005\bi\u0001\u0011\r\u0011\"\u00036\u0011\u0019q\u0004\u0001)A\u0005m!)q\b\u0001C\u0001\u0001\"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\"A\u0005)pS:$(\u0007U8j]R\u0004&o\\2fgNT!AC\u0006\u0002\u0011\u0005t\u0017\r\\=uS\u000eT!\u0001D\u0007\u0002\u000fA\u0014xnY3tg*\u0011abD\u0001\bO\u0016|W.Z:b\u0015\t\u0001\u0012#\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\r\u0001Q#\b\t\u0003-mi\u0011a\u0006\u0006\u00031e\tA\u0001\\1oO*\t!$\u0001\u0003kCZ\f\u0017B\u0001\u000f\u0018\u0005\u0019y%M[3diB\u0011adH\u0007\u0002\u0017%\u0011\u0001e\u0003\u0002\u000f\u000f\u0016|W*Z:b!J|7-Z:t\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\t\u0011\"\u0001\u0005cCN,G+\u001f9f+\u00059\u0003C\u0001\u00152\u001b\u0005I#B\u0001\u0016,\u0003\u0019\u0019\u0018.\u001c9mK*\u0011A&L\u0001\bM\u0016\fG/\u001e:f\u0015\tqs&A\u0002ba&T!\u0001M\t\u0002\u0011\u001d,w\u000e^8pYNL!AM\u0015\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X-A\u0005cCN,G+\u001f9fA\u0005\u0011qMZ\u000b\u0002mA\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\u0005O\u0016|WN\u0003\u0002<\u001f\u0005\u0019!\u000e^:\n\u0005uB$aD$f_6,GO]=GC\u000e$xN]=\u0002\u0007\u001d4\u0007%A\u0004fq\u0016\u001cW\u000f^3\u0015\u0011\u0005Ce+[8{\u0003\u000f\u0001\"A\u0011$\u000e\u0003\rS!A\u000b#\u000b\u0005\u0015{\u0013\u0001\u00023bi\u0006L!aR\"\u0003/MKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0007>dG.Z2uS>t\u0007\"B#\u0007\u0001\u0004\t\u0005F\u0002%K#J\u001bF\u000b\u0005\u0002L\u001f6\tAJ\u0003\u0002N\u001d\u00069a-Y2u_JL(B\u0001\u00070\u0013\t\u0001FJA\tEKN\u001c'/\u001b2f!\u0006\u0014\u0018-\\3uKJ\fAA\\1nK\u0006\nQ)A\u0006eKN\u001c'/\u001b9uS>t\u0017%A+\u00021%s\u0007/\u001e;!M\u0016\fG/\u001e:fA\r|G\u000e\\3di&|g\u000eC\u0003X\r\u0001\u0007\u0001,A\u0007he>,\b/\u001b8h\r&,G\u000e\u001a\t\u00033\nt!A\u00171\u0011\u0005msV\"\u0001/\u000b\u0005u\u001b\u0012A\u0002\u001fs_>$hHC\u0001`\u0003\u0015\u00198-\u00197b\u0013\t\tg,\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u0014aa\u0015;sS:<'BA1_Q\u00191&*\u00154TO\u0006\nq+I\u0001i\u0003]1\u0015.\u001a7eA=t\u0007e\u001e5jG\"\u0004Co\u001c\u0011he>,\b\u000fC\u0003k\r\u0001\u0007\u0001,A\u0005t_J$h)[3mI\"2\u0011NS)m'6\f\u0013A[\u0011\u0002]\u0006Qc)[3mI\u0002zg\u000eI<iS\u000eD\u0007\u0005^8!g>\u0014H\u000f\t\u0015nkN$\bEY3!\t\u0006$X\r\t;za\u0016L\u0003\"\u00029\u0007\u0001\u0004\t\u0018!C7j]B{\u0017N\u001c;t!\t\u00118/D\u0001_\u0013\t!hLA\u0002J]RDca\u001c&RmNC\u0018%A<\u0002+5Lg.[7v[:+XNY3s\u001f\u001a\u0004v.\u001b8ug\u0006\n\u00110\u0001\rNS:LW.^7!]Vl'-\u001a:!_\u001a\u0004\u0003o\\5oiNDQa\u001f\u0004A\u0002q\f!B\u0019:fC.|e\u000eR1z!\t\u0011X0\u0003\u0002\u007f=\n9!i\\8mK\u0006t\u0007\u0006\u0003>K#\u0006\u00051+a\u0001\"\u0003m\f#!!\u0002\u0002=\t\u0013X-Y6!G>tg.Z2uS>t7\u000fI8oA\u0011\f\u0017\u0010I7be.\u001c\bBBA\u0005\r\u0001\u0007A0\u0001\u000bgS2$XM]*j]\u001e,H.\u0019:Q_&tGo\u001d\u0015\u000e\u0003\u000fQ\u0015+!\u0004T\u0003\u001f\t\u0019\"!\u0006\"\u0005\u0005%\u0011EAA\t\u0003=2\u0015\u000e\u001c;fe\u0002zW\u000f\u001e\u0011tK\u001elWM\u001c;tAQD\u0017\r\u001e\u0011gC2d\u0007e\u001c8!i\",\u0007e]1nK\u0002\u0002x.\u001b8u\u00031!WMZ1vYR4\u0016\r\\;fC\t\t9\"\u0001\u0003ueV,\u0007&\u0003\u0004\u0002\u001cE\u000b\tcUA\u0013!\rY\u0015QD\u0005\u0004\u0003?a%A\u0004#fg\u000e\u0014\u0018NY3SKN,H\u000e^\u0011\u0003\u0003G\taA]3tk2$\u0018EAA\u0014\u0003u\tum\u001a:fO\u0006$X\r\u001a\u0011gK\u0006$XO]3!G>dG.Z2uS>t\u0017\u0001D4fi\u0012\u000b\u0017p\u00144ZK\u0006\u0014H#B9\u0002.\u0005E\u0002BBA\u0018\u000f\u0001\u0007\u0011/\u0001\bt_J$h)[3mI&sG-\u001a=\t\u000f\u0005Mr\u00011\u0001\u00026\u0005\ta\rE\u0002)\u0003oI1!!\u000f*\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\"R\u0001!!\u0010\u0002D\u0005\u00153+!\u0013\u0011\u0007-\u000by$C\u0002\u0002B1\u0013q\u0002R3tGJL'-\u001a)s_\u000e,7o]\u0001\u0006i&$H.Z\u0011\u0003\u0003\u000f\n!\u0003U8j]R\u0014\u0004k\\5oiB\u0013xnY3tg\u0006\u0012\u00111J\u0001E\u0003\u001e<'/Z4bi\u0016\u001c\b%\u0019\u0011d_2dWm\u0019;j_:\u0004sN\u001a\u0011q_&tGo\u001d\u0011j]R|\u0007%\u0019\u0011d_2dWm\u0019;j_:\u0004sN\u001a\u0011mS:,\u0007e]3h[\u0016tGo\u001d")
public class Point2PointProcess
implements GeoMesaProcess {
    private final SimpleFeatureType baseType = SchemaBuilder$.MODULE$.toSchemaBuilder((SchemaBuilder.AttributeBuilder)SchemaBuilder$.MODULE$.builder().addLineString("geom", true)).build("point2point");
    private final GeometryFactory gf = JTSFactoryFinder.getGeometryFactory();

    private SimpleFeatureType baseType() {
        return this.baseType;
    }

    private GeometryFactory gf() {
        return this.gf;
    }

    @DescribeResult(name="result", description="Aggregated feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input feature collection") SimpleFeatureCollection data, @DescribeParameter(name="groupingField", description="Field on which to group") String groupingField, @DescribeParameter(name="sortField", description="Field on which to sort (must be Date type)") String sortField, @DescribeParameter(name="minimumNumberOfPoints", description="Minimum number of points") int minPoints, @DescribeParameter(name="breakOnDay", description="Break connections on day marks") boolean breakOnDay, @DescribeParameter(name="filterSingularPoints", description="Filter out segments that fall on the same point", defaultValue="true") boolean filterSingularPoints) {
        SimpleFeatureType queryType = (SimpleFeatureType)data.getSchema();
        SimpleFeatureTypeBuilder sftBuilder = new SimpleFeatureTypeBuilder();
        sftBuilder.init(this.baseType());
        int groupingFieldIndex = ((SimpleFeatureType)data.getSchema()).indexOf(groupingField);
        sftBuilder.add((AttributeDescriptor)queryType.getAttributeDescriptors().get(groupingFieldIndex));
        int sortFieldIndex = ((SimpleFeatureType)data.getSchema()).indexOf(sortField);
        AttributeDescriptor sortDesc = (AttributeDescriptor)queryType.getAttributeDescriptors().get(sortFieldIndex);
        String sortAttrName = sortDesc.getLocalName();
        Class sortType = sortDesc.getType().getBinding();
        sftBuilder.add(new StringBuilder(6).append(sortAttrName).append("_start").toString(), sortType);
        sftBuilder.add(new StringBuilder(4).append(sortAttrName).append("_end").toString(), sortType);
        SimpleFeatureType sft = sftBuilder.buildFeatureType();
        Iterable lineFeatures = (Iterable)((TraversableLike)SelfClosingIterator$.MODULE$.apply(data.features()).toList().groupBy((Function1 & Serializable & scala.Serializable)f -> String.valueOf(f.getAttribute(groupingFieldIndex))).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Point2PointProcess.$anonfun$execute$2(minPoints, x0$1)))).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> new ArrayOps.ofRef(Point2PointProcess.$anonfun$execute$3(this, sortFieldIndex, breakOnDay, groupingFieldIndex, sortAttrName, sft, filterSingularPoints, x0$2)), Iterable$.MODULE$.canBuildFrom());
        return new ListFeatureCollection(sft, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)lineFeatures.toList()).asJava());
    }

    public int getDayOfYear(int sortFieldIndex, SimpleFeature f) {
        return ZonedDateTime.ofInstant(((Date)f.getAttribute(sortFieldIndex)).toInstant(), ZoneOffset.UTC).getDayOfYear();
    }

    public static final /* synthetic */ boolean $anonfun$execute$2(int minPoints$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            List coll = (List)tuple2._2();
            return coll.lengthCompare(minPoints$1) > 0;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$execute$6(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            List g = (List)tuple2._2();
            return g.lengthCompare(2) >= 0;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Object[] $anonfun$execute$3(Point2PointProcess $this, int sortFieldIndex$1, boolean breakOnDay$1, int groupingFieldIndex$1, String sortAttrName$1, SimpleFeatureType sft$1, boolean filterSingularPoints$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            List coll = (List)tuple2._2();
            List globalSorted = (List)coll.sortBy((Function1 & Serializable & scala.Serializable)x$1 -> (Date)Conversions.RichSimpleFeature$.MODULE$.get$extension0(Conversions$.MODULE$.RichSimpleFeature(x$1), sortFieldIndex$1), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            List[] groups = !breakOnDay$1 ? (List[])((Object[])new List[]{globalSorted}) : (List[])((TraversableOnce)((TraversableLike)globalSorted.groupBy((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToInteger((int)$this.getDayOfYear(sortFieldIndex$1, f))).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)Point2PointProcess.$anonfun$execute$6(x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    List g = (List)tuple2._2();
                    return g;
                }
                throw new MatchError((Object)tuple2);
            }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(List.class));
            Tuple2[] results = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groups)).flatMap((Function1 & Serializable & scala.Serializable)sorted -> sorted.sliding(2).zipWithIndex().map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 != null) {
                    List ptLst = (List)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    List pts = (List)ptLst.map((Function1 & Serializable & scala.Serializable)x$2 -> Conversions.RichSimpleFeature$.MODULE$.point$extension(Conversions$.MODULE$.RichSimpleFeature(x$2)).getCoordinate(), List$.MODULE$.canBuildFrom());
                    double length = JTS.orthodromicDistance((Coordinate)((Coordinate)pts.head()), (Coordinate)((Coordinate)pts.last()), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                    Object group = ((SimpleFeature)ptLst.head()).getAttribute(groupingFieldIndex$1);
                    Object startDtg = ((SimpleFeature)ptLst.head()).getAttribute(sortAttrName$1);
                    Object endDtg = ((SimpleFeature)ptLst.last()).getAttribute(sortAttrName$1);
                    Object[] attrs = new Object[]{$this.gf().createLineString((Coordinate[])pts.toArray(ClassTag$.MODULE$.apply(Coordinate.class))), group, startDtg, endDtg};
                    ScalaSimpleFeature sf = new ScalaSimpleFeature(sft$1, new StringBuilder(1).append(group).append("-").append(idx).toString(), attrs, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
                    return new Tuple2((Object)BoxesRunTime.boxToDouble((double)length), (Object)sf);
                }
                throw new MatchError((Object)tuple2);
            }), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            if (filterSingularPoints$1) {
                return Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])results)).collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Tuple2<Object, ScalaSimpleFeature>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 != null) {
                            double length = A1._1$mcD$sp();
                            ScalaSimpleFeature sf = (ScalaSimpleFeature)A1._2();
                            if (length > 0.0) {
                                return (B1)sf;
                            }
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Tuple2<Object, ScalaSimpleFeature> x1) {
                        double length;
                        Tuple2<Object, ScalaSimpleFeature> tuple2 = x1;
                        return tuple2 != null && (length = tuple2._1$mcD$sp()) > 0.0;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaSimpleFeature.class))));
            }
            return Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])results)).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 != null) {
                    ScalaSimpleFeature sf = (ScalaSimpleFeature)tuple2._2();
                    return sf;
                }
                throw new MatchError((Object)tuple2);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaSimpleFeature.class))));
        }
        throw new MatchError((Object)tuple2);
    }
}

