/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.process.analytic.AttributeVisitor;
import org.locationtech.geomesa.process.analytic.UniqueProcess$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DescribeProcess(title="Geomesa Unique", description="Finds unique attributes values, optimized for GeoMesa")
@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001\u0002\b\u0010\u0001iAQ!\r\u0001\u0005\u0002IBQ!\u000e\u0001\u0005\u0002Y:q!!\u0011\u0010\u0011\u0003\t\u0019E\u0002\u0004\u000f\u001f!\u0005\u0011Q\t\u0005\u0007c\u0011!\t!a\u0014\t\u0013\u0005ECA1A\u0005\u0002\u0005M\u0003\u0002CA-\t\u0001\u0006I!!\u0016\t\u0013\u0005mCA1A\u0005\u0002\u0005M\u0003\u0002CA/\t\u0001\u0006I!!\u0016\t\u0013\u0005}CA1A\u0005\u0002\u0005M\u0003\u0002CA1\t\u0001\u0006I!!\u0016\t\u000f\u0005\rD\u0001\"\u0001\u0002f!9\u0011\u0011\u0016\u0003\u0005\u0002\u0005-&!D+oSF,X\r\u0015:pG\u0016\u001c8O\u0003\u0002\u0011#\u0005A\u0011M\\1msRL7M\u0003\u0002\u0013'\u00059\u0001O]8dKN\u001c(B\u0001\u000b\u0016\u0003\u001d9Wm\\7fg\u0006T!AF\f\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003a\t1a\u001c:h\u0007\u0001\u0019B\u0001A\u000e$OA\u0011A$I\u0007\u0002;)\u0011adH\u0001\u0005Y\u0006twMC\u0001!\u0003\u0011Q\u0017M^1\n\u0005\tj\"AB(cU\u0016\u001cG\u000f\u0005\u0002%K5\t\u0011#\u0003\u0002'#\tqq)Z8NKN\f\u0007K]8dKN\u001c\bC\u0001\u00150\u001b\u0005I#B\u0001\u0016,\u00031\u00198-\u00197bY><w-\u001b8h\u0015\taS&\u0001\u0005usB,7/\u00194f\u0015\u0005q\u0013aA2p[&\u0011\u0001'\u000b\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002gA\u0011A\u0007A\u0007\u0002\u001f\u00059Q\r_3dkR,GCC\u001cB!\u000e\u001480a\u0001\u0002\u0010A\u0011\u0001hP\u0007\u0002s)\u0011!hO\u0001\u0007g&l\u0007\u000f\\3\u000b\u0005qj\u0014\u0001\u00023bi\u0006T!AP\f\u0002\u0011\u001d,w\u000e^8pYNL!\u0001Q\u001d\u0003/MKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0007>dG.Z2uS>t\u0007\"\u0002\"\u0003\u0001\u00049\u0014\u0001\u00034fCR,(/Z:)\r\u0005#5\nT'O!\t)\u0015*D\u0001G\u0015\t9\u0005*A\u0004gC\u000e$xN]=\u000b\u0005Ii\u0014B\u0001&G\u0005E!Um]2sS\n,\u0007+\u0019:b[\u0016$XM]\u0001\u0005]\u0006lW-I\u0001C\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0003=\u000b\u0001$\u00138qkR\u0004c-Z1ukJ,\u0007eY8mY\u0016\u001cG/[8o\u0011\u0015\t&\u00011\u0001S\u0003%\tG\u000f\u001e:jEV$X\r\u0005\u0002T9:\u0011AK\u0017\t\u0003+bk\u0011A\u0016\u0006\u0003/f\ta\u0001\u0010:p_Rt$\"A-\u0002\u000bM\u001c\u0017\r\\1\n\u0005mC\u0016A\u0002)sK\u0012,g-\u0003\u0002^=\n11\u000b\u001e:j]\u001eT!a\u0017-)\rA#5\nY'bC\u0005\t\u0016%\u00012\u0002W\u0005#HO]5ckR,\u0007e\u001e5pg\u0016\u0004SO\\5rk\u0016\u0004c/\u00197vKN\u0004\u0013M]3!Kb$(/Y2uK\u0012DQ\u0001\u001a\u0002A\u0002\u0015\faAZ5mi\u0016\u0014\bC\u00014k\u001b\u00059'B\u00013i\u0015\tIW(A\u0002ba&L!a[4\u0003\r\u0019KG\u000e^3sQ!\u0019GiS7o_6\u0003\u0018%\u00013\u0002\u00075Lg.H\u0001\u0001C\u0005\t\u0018!\f+iK\u00022\u0017\u000e\u001c;fe\u0002\"x\u000eI1qa2L\b\u0005^8!i\",\u0007EZ3biV\u0014X\rI2pY2,7\r^5p]\")1O\u0001a\u0001i\u0006I\u0001.[:u_\u001e\u0014\u0018-\u001c\t\u00039UL!A^\u000f\u0003\u000f\t{w\u000e\\3b]\"B!\u000fR&y]>l\u00150I\u0001tC\u0005Q\u0018AJ\"sK\u0006$X\rI1!Q&\u001cHo\\4sC6\u0004sN\u001a\u0011biR\u0014\u0018NY;uK\u00022\u0018\r\\;fg\")AP\u0001a\u0001%\u0006!1o\u001c:uQ!YHi\u0013@o_6{\u0018%\u0001?\"\u0005\u0005\u0005\u0011\u0001K*peR\u0004#/Z:vYR\u001c\b%\f\u0011bY2|w/\u001a3!i>\u0004#-\u001a\u0011B'\u000e\u0003sN\u001d\u0011E\u000bN\u001b\u0005BBA\u0003\u0005\u0001\u0007A/A\u0006t_J$()_\"pk:$\bfCA\u0002\t.\u000bIA\\8N\u0003\u0017\t#!!\u0002\"\u0005\u00055\u0011\u0001N*peR\u0004#-\u001f\u0011iSN$xn\u001a:b[\u0002\u001aw.\u001e8ug\u0002Jgn\u001d;fC\u0012\u0004sN\u001a\u0011biR\u0014\u0018NY;uK\u00022\u0018\r\\;fg\"9\u0011\u0011\u0003\u0002A\u0002\u0005M\u0011\u0001\u00059s_\u001e\u0014Xm]:MSN$XM\\3s!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\rQ\u0006!Q\u000f^5m\u0013\u0011\ti\"a\u0006\u0003!A\u0013xn\u001a:fgNd\u0015n\u001d;f]\u0016\u0014\b&\u0003\u0002\u0002\"-\u000b9#TA\u0016!\r)\u00151E\u0005\u0004\u0003K1%A\u0004#fg\u000e\u0014\u0018NY3SKN,H\u000e^\u0011\u0003\u0003S\taA]3tk2$\u0018EAA\u0017\u0003\u00053U-\u0019;ve\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8!o&$\b\u000eI1oA\u0005$HO]5ckR,\u0007eY8oi\u0006Lg.\u001b8hAQDW\rI;oSF,X\r\t<bYV,7\u000f\u000b\u0006\u0001\u0003c\t9$!\u000fN\u0003{\u00012!RA\u001a\u0013\r\t)D\u0012\u0002\u0010\t\u0016\u001c8M]5cKB\u0013xnY3tg\u0006)A/\u001b;mK\u0006\u0012\u00111H\u0001\u000f\u000f\u0016|W.Z:bAUs\u0017.];fC\t\ty$A\u001bGS:$7\u000fI;oSF,X\rI1uiJL'-\u001e;fg\u00022\u0018\r\\;fg2\u0002s\u000e\u001d;j[&TX\r\u001a\u0011g_J\u0004s)Z8NKN\f\u0017!D+oSF,X\r\u0015:pG\u0016\u001c8\u000f\u0005\u00025\tM\u0019A!a\u0012\u0011\t\u0005%\u00131J\u0007\u00021&\u0019\u0011Q\n-\u0003\r\u0005s\u0017PU3g)\t\t\u0019%A\u0004TMRt\u0015-\\3\u0016\u0005\u0005U\u0003c\u0001\u000f\u0002X%\u0011Q,H\u0001\t'\u001a$h*Y7fA\u0005q\u0011\t\u001e;sS\n,H/\u001a,bYV,\u0017aD!uiJL'-\u001e;f-\u0006dW/\u001a\u0011\u0002\u001d\u0005#HO]5ckR,7i\\;oi\u0006y\u0011\t\u001e;sS\n,H/Z\"pk:$\b%\u0001\fde\u0016\fG/\u001a*fiV\u0014hnQ8mY\u0016\u001cG/[8o)-9\u0014qMA<\u00033\u000by*a*\t\u000f\u0005%D\u00021\u0001\u0002l\u0005aQO\\5rk\u00164\u0016\r\\;fgB91+!\u001c\u0002H\u0005E\u0014bAA8=\n\u0019Q*\u00199\u0011\t\u0005%\u00131O\u0005\u0004\u0003kB&\u0001\u0002'p]\u001eDq!!\u001f\r\u0001\u0004\tY(A\u0004cS:$\u0017N\\41\t\u0005u\u0014q\u0011\t\u0006'\u0006}\u00141Q\u0005\u0004\u0003\u0003s&!B\"mCN\u001c\b\u0003BAC\u0003\u000fc\u0001\u0001\u0002\u0007\u0002\n\u0006]\u0014\u0011!A\u0001\u0006\u0003\tYIA\u0002`IE\nB!!$\u0002\u0014B!\u0011\u0011JAH\u0013\r\t\t\n\u0017\u0002\b\u001d>$\b.\u001b8h!\u0011\tI%!&\n\u0007\u0005]\u0005LA\u0002B]fDaa\u001d\u0007A\u0002\u0005m\u0005\u0003BA%\u0003;K!A\u001e-\t\rqd\u0001\u0019AAQ!\u0015\tI%a)S\u0013\r\t)\u000b\u0017\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005\u0015A\u00021\u0001\u0002\u001c\u0006y1M]3bi\u0016,f.[9vKN3G\u000f\u0006\u0004\u0002.\u0006m\u0016q\u0019\t\u0005\u0003_\u000b9,\u0004\u0002\u00022*\u0019!(a-\u000b\u0007\u0005U\u0006.A\u0004gK\u0006$XO]3\n\t\u0005e\u0016\u0011\u0017\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007bBA=\u001b\u0001\u0007\u0011Q\u0018\u0019\u0005\u0003\u007f\u000b\u0019\rE\u0003T\u0003\u007f\n\t\r\u0005\u0003\u0002\u0006\u0006\rG\u0001DAc\u0003w\u000b\t\u0011!A\u0003\u0002\u0005-%aA0%e!11/\u0004a\u0001\u00037\u0003")
public class UniqueProcess
implements GeoMesaProcess,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static SimpleFeatureType createUniqueSft(Class<?> clazz, boolean bl) {
        return UniqueProcess$.MODULE$.createUniqueSft(clazz, bl);
    }

    public static SimpleFeatureCollection createReturnCollection(Map<Object, Object> map, Class<?> clazz, boolean bl, Option<String> option, boolean bl2) {
        return UniqueProcess$.MODULE$.createReturnCollection(map, clazz, bl, option, bl2);
    }

    public static String AttributeCount() {
        return UniqueProcess$.MODULE$.AttributeCount();
    }

    public static String AttributeValue() {
        return UniqueProcess$.MODULE$.AttributeValue();
    }

    public static String SftName() {
        return UniqueProcess$.MODULE$.SftName();
    }

    private Logger logger$lzycompute() {
        UniqueProcess uniqueProcess = this;
        synchronized (uniqueProcess) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @DescribeResult(name="result", description="Feature collection with an attribute containing the unique values")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="Input feature collection") SimpleFeatureCollection features, @DescribeParameter(name="attribute", description="Attribute whose unique values are extracted") String attribute, @DescribeParameter(name="filter", min=0, description="The filter to apply to the feature collection") Filter filter, @DescribeParameter(name="histogram", min=0, description="Create a histogram of attribute values") Boolean histogram, @DescribeParameter(name="sort", min=0, description="Sort results - allowed to be ASC or DESC") String sort, @DescribeParameter(name="sortByCount", min=0, description="Sort by histogram counts instead of attribute values") Boolean sortByCount, ProgressListener progressListener) {
        AttributeDescriptor attributeDescriptor = (AttributeDescriptor)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((SimpleFeatureType)features.getSchema()).getAttributeDescriptors()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UniqueProcess.$anonfun$execute$1(attribute, x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(44).append("Attribute ").append(attribute).append(" does not exist in feature schema.").toString());
        });
        boolean hist = Option$.MODULE$.apply((Object)histogram).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2));
        boolean sortBy = Option$.MODULE$.apply((Object)sortByCount).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3));
        AttributeVisitor visitor = new AttributeVisitor(features, attributeDescriptor, (Option<Filter>)Option$.MODULE$.apply((Object)filter).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)UniqueProcess.$anonfun$execute$5(x$4))), hist);
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, progressListener);
        Map<Object, Object> uniqueValues = visitor.getResult().attributes();
        Class binding = attributeDescriptor.getType().getBinding();
        return UniqueProcess$.MODULE$.createReturnCollection(uniqueValues, binding, hist, (Option<String>)Option$.MODULE$.apply((Object)sort), sortBy);
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(String attribute$1, AttributeDescriptor x$1) {
        String string = x$1.getLocalName();
        String string2 = attribute$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$execute$5(Filter x$4) {
        Filter filter = x$4;
        IncludeFilter includeFilter = Filter.INCLUDE;
        return filter == null ? includeFilter != null : !filter.equals(includeFilter);
    }

    public UniqueProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }
}

