/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.transform;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import org.apache.arrow.vector.ipc.message.IpcOption;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter$;
import org.locationtech.geomesa.arrow.io.package;
import org.locationtech.geomesa.arrow.package;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary$;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geotools.GeoMesaFeatureCollection$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.process.GeoMesaProcess;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors;
import org.locationtech.geomesa.utils.geotools.RichAttributeDescriptors$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeqLike;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@DescribeProcess(title="Arrow Conversion", description="Converts a feature collection to arrow format")
@ScalaSignature(bytes="\u0006\u0001\u0011}c\u0001\u0002*T\u0001yCQ!\u001e\u0001\u0005\u0002YDQ!\u001f\u0001\u0005\u0002iD\u0011\"!?\u0001#\u0003%\t!a?\b\u000f\t\r2\u000b#\u0001\u0003&\u00191!k\u0015E\u0001\u0005OAa!^\u0003\u0005\u0002\t=bA\u0002B\u0019\u000b\u0001\u0011\u0019\u0004\u0003\u0006\u0003D\u001d\u0011\t\u0011)A\u0005\u0005\u000bB!Ba\u0016\b\u0005\u0003\u0005\u000b\u0011\u0002B-\u0011)\u0011\u0019i\u0002B\u0001B\u0003%\u0011Q\u000e\u0005\u000b\u0003\u001b;!\u0011!Q\u0001\n\t\u0015\u0005BCAT\u000f\t\u0005\t\u0015!\u0003\u0003\u0018\"Q\u00111W\u0004\u0003\u0002\u0003\u0006IA!(\t\u0015\t\rvA!A!\u0002\u0013\u0011y\n\u0003\u0006\u0002@\u001e\u0011\t\u0011)A\u0005\u0005KC!\"!5\b\u0005\u0003\u0005\u000b\u0011\u0002BP\u0011\u0019)x\u0001\"\u0001\u0003,\"Q!1Y\u0004\t\u0006\u0004%IA!2\t\u0017\t\u001dx\u00011AA\u0002\u0013%!\u0011\u001d\u0005\f\u0005S<\u0001\u0019!a\u0001\n\u0013\u0011Y\u000fC\u0006\u0003r\u001e\u0001\r\u0011!Q!\n\t\r\bb\u0002Bz\u000f\u0011\u0005#Q\u001f\u0005\b\u0005\u001b<A\u0011IB3\u0011\u0019Ix\u0001\"\u0011\u0004r\u0019I!\u0011Z\u0003\u0011\u0002G\u0005!1\u001a\u0005\b\u0005\u001bLb\u0011\u0001Bh\u0011\u001d\u0011y.\u0007D\u0001\u0005C4aaa#\u0006\t\r5\u0005B\u0003B\"9\t\u0005\t\u0015!\u0003\u0003F!Q!q\u000b\u000f\u0003\u0002\u0003\u0006IA!\u0017\t\u0015\r=ED!A!\u0002\u0013\u0019\t\n\u0003\u0006\u0004*r\u0011\t\u0011)A\u0005\u0007WC!\"a0\u001d\u0005\u0003\u0005\u000b\u0011\u0002BS\u0011)\t\t\u000e\bB\u0001B\u0003%!q\u0014\u0005\u0007kr!\taa-\t\u0013\r\rGD1A\u0005\n\r\u0015\u0007\u0002CBj9\u0001\u0006Iaa2\t\u0013\rUGD1A\u0005\n\r]\u0007\u0002CBs9\u0001\u0006Ia!7\t\u0013\r\u001dH\u00041A\u0005\n\r%\b\"CBy9\u0001\u0007I\u0011BBz\u0011!\u00199\u0010\bQ!\n\r-\b\"CB}9\t\u0007I\u0011BB~\u0011!!9\u0001\bQ\u0001\n\ru\bb\u0002Bg9\u0011\u0005C\u0011\u0002\u0005\b\u0005?dB\u0011\tBq\r\u0019!i!\u0002\u0003\u0005\u0010!Q!1I\u0018\u0003\u0002\u0003\u0006IA!\u0012\t\u0015\t]sF!A!\u0002\u0013\u0011I\u0006\u0003\u0006\u0004\u0010>\u0012\t\u0011)A\u0005\u0007#C!\"!$0\u0005\u0003\u0005\u000b\u0011\u0002BC\u0011)\u0019Ik\fB\u0001B\u0003%11\u0016\u0005\u000b\u0005G{#\u0011!Q\u0001\n\t}\u0005BCA`_\t\u0005\t\u0015!\u0003\u0003&\"Q\u0011\u0011[\u0018\u0003\u0002\u0003\u0006IAa(\t\rU|C\u0011\u0001C\t\u0011%\t9b\fb\u0001\n\u0013!)\u0003\u0003\u0005\u0005.=\u0002\u000b\u0011\u0002C\u0014\u0011\u001d\u0011im\fC!\t_AqAa80\t\u0003\u0012\tO\u0002\u0004\u0003z\u0016\u0001%1 \u0005\u000b\u0005?l$Q3A\u0005\u0002\r]\u0001\"CB\r{\tE\t\u0015!\u0003|\u0011\u0019)X\b\"\u0001\u0004\u001c!91qD\u001f\u0005B\r\u0005\u0002\"CB\u0012{\u0005\u0005I\u0011AB\u0013\u0011%\u0019I#PI\u0001\n\u0003\u0019Y\u0003C\u0005\u00040u\n\t\u0011\"\u0011\u00042!I1qG\u001f\u0002\u0002\u0013\u00051\u0011\b\u0005\n\u0007wi\u0014\u0011!C\u0001\u0007{A\u0011ba\u0012>\u0003\u0003%\te!\u0013\t\u0013\rUS(!A\u0005\u0002\r]\u0003\"CB.{\u0005\u0005I\u0011IB/\u0011%\u0019y&PA\u0001\n\u0003\u001a\tgB\u0005\u00054\u0015\t\t\u0011#\u0001\u00056\u0019I!\u0011`\u0003\u0002\u0002#\u0005Aq\u0007\u0005\u0007k2#\t\u0001\"\u0012\t\u0013\u0011\u001dC*!A\u0005F\u0011%\u0003\"\u0003C&\u0019\u0006\u0005I\u0011\u0011C'\u0011%!\t\u0006TA\u0001\n\u0003#\u0019\u0006C\u0005\u0005\\1\u000b\t\u0011\"\u0003\u0005^\t1\u0012I\u001d:po\u000e{gN^3sg&|g\u000e\u0015:pG\u0016\u001c8O\u0003\u0002U+\u0006IAO]1og\u001a|'/\u001c\u0006\u0003-^\u000bq\u0001\u001d:pG\u0016\u001c8O\u0003\u0002Y3\u00069q-Z8nKN\f'B\u0001.\\\u00031awnY1uS>tG/Z2i\u0015\u0005a\u0016aA8sO\u000e\u00011\u0003\u0002\u0001`O.\u0004\"\u0001Y3\u000e\u0003\u0005T!AY2\u0002\t1\fgn\u001a\u0006\u0002I\u0006!!.\u0019<b\u0013\t1\u0017M\u0001\u0004PE*,7\r\u001e\t\u0003Q&l\u0011!V\u0005\u0003UV\u0013abR3p\u001b\u0016\u001c\u0018\r\u0015:pG\u0016\u001c8\u000f\u0005\u0002mg6\tQN\u0003\u0002o_\u0006a1oY1mC2|wmZ5oO*\u0011\u0001/]\u0001\tif\u0004Xm]1gK*\t!/A\u0002d_6L!\u0001^7\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0004\"\u0001\u001f\u0001\u000e\u0003M\u000bq!\u001a=fGV$X\rF\u000b|\u0003+\t9%!\u0018\u0002j\u0005-\u0015QUAY\u0003{\u000by-a7\u0011\tq|\u00181A\u0007\u0002{*\u0011apY\u0001\u0005kRLG.C\u0002\u0002\u0002u\u0014\u0001\"\u0013;fe\u0006$xN\u001d\t\u0007\u0003\u000b\tY!a\u0004\u000e\u0005\u0005\u001d!BAA\u0005\u0003\u0015\u00198-\u00197b\u0013\u0011\ti!a\u0002\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005\u0015\u0011\u0011C\u0005\u0005\u0003'\t9A\u0001\u0003CsR,\u0007bBA\f\u0005\u0001\u0007\u0011\u0011D\u0001\tM\u0016\fG/\u001e:fgB!\u00111DA\u0015\u001b\t\tiB\u0003\u0003\u0002 \u0005\u0005\u0012AB:j[BdWM\u0003\u0003\u0002$\u0005\u0015\u0012\u0001\u00023bi\u0006T1!a\n\\\u0003!9Wm\u001c;p_2\u001c\u0018\u0002BA\u0016\u0003;\u0011qcU5na2,g)Z1ukJ,7i\u001c7mK\u000e$\u0018n\u001c8)\u0019\u0005U\u0011qFA\u001f\u0003\u007f\t\t%a\u0011\u0011\t\u0005E\u0012\u0011H\u0007\u0003\u0003gQA!!\u000e\u00028\u00059a-Y2u_JL(b\u0001,\u0002&%!\u00111HA\u001a\u0005E!Um]2sS\n,\u0007+\u0019:b[\u0016$XM]\u0001\u0005]\u0006lW-\t\u0002\u0002\u0018\u0005YA-Z:de&\u0004H/[8oC\t\t)%\u0001\u0012J]B,H\u000f\t4fCR,(/\u001a\u0011d_2dWm\u0019;j_:\u0004Co\u001c\u0011f]\u000e|G-\u001a\u0005\b\u0003\u0013\u0012\u0001\u0019AA&\u0003-Ign\u00197vI\u00164\u0015\u000eZ:\u0011\u0007\u0001\fi%C\u0002\u0002P\u0005\u0014qAQ8pY\u0016\fg\u000e\u000b\t\u0002H\u0005=\u0012QHA*\u0003\u0003\n)&!\u0017\u0002\\\u0005\u0012\u0011\u0011J\u0011\u0003\u0003/\n\u0011%\u00138dYV$W\r\t4fCR,(/\u001a\u0011J\tN\u0004\u0013N\u001c\u0011beJ|w\u000f\t4jY\u0016\f1!\\5o;\u0005\u0001\u0001bBA0\u0005\u0001\u0007\u00111J\u0001\naJ|\u00070\u001f$jIND\u0003#!\u0018\u00020\u0005u\u00121MA!\u0003K\nI&a\u0017\"\u0005\u0005}\u0013EAA4\u00031\u0002&o\u001c=zA\u0019,\u0017\r^;sK\u0002JEi\u001d\u0011u_\u0002Jg\u000e^:!S:\u001cH/Z1eA=4\u0007e\u001d;sS:<7\u000fC\u0004\u0002l\t\u0001\r!!\u001c\u0002\u001b\u0019|'/\\1u-\u0016\u00148/[8o!\u0011\ty'! \u000f\t\u0005E\u0014\u0011\u0010\t\u0005\u0003g\n9!\u0004\u0002\u0002v)\u0019\u0011qO/\u0002\rq\u0012xn\u001c;?\u0013\u0011\tY(a\u0002\u0002\rA\u0013X\rZ3g\u0013\u0011\ty(!!\u0003\rM#(/\u001b8h\u0015\u0011\tY(a\u0002)!\u0005%\u0014qFA\u001f\u0003\u000b\u000b\t%a\"\u0002Z\u0005m\u0013EAA6C\t\tI)\u0001\rBeJ|w\u000fI%Q\u0007\u00022wN]7bi\u00022XM]:j_:Dq!!$\u0003\u0001\u0004\ty)\u0001\teS\u000e$\u0018n\u001c8bef4\u0015.\u001a7egB)A0!%\u0002n%\u0019\u00111S?\u0003\t1K7\u000f\u001e\u0015\u0019\u0003\u0017\u000by#!\u0010\u0002\u0018\u0006\u0005\u0013\u0011TA-\u00037\ni*a(\u0002\"\u0006\r\u0016EAAGC\t\tY*A\u0010BiR\u0014\u0018NY;uKN\u0004Co\u001c\u0011eS\u000e$\u0018n\u001c8bef\u0004SM\\2pI\u0016\f1!\\1y;\t\u0001\u00011\u0001\bd_2dWm\u0019;j_:$\u0016\u0010]3$\u0005\u00055\u0004bBAT\u0005\u0001\u0007\u0011QN\u0001\ng>\u0014HOR5fY\u0012D\u0003#!*\u00020\u0005u\u00121VA!\u0003[\u000bI&a\u0017\"\u0005\u0005\u001d\u0016EAAX\u0003Q\tE\u000f\u001e:jEV$X\r\t;pAM|'\u000f\u001e\u0011cs\"9\u00111\u0017\u0002A\u0002\u0005-\u0013aC:peR\u0014VM^3sg\u0016D\u0003#!-\u00020\u0005u\u0012qWA!\u0003s\u000bI&a\u0017\"\u0005\u0005M\u0016EAA^\u0003y\u0011VM^3sg\u0016\u0004C\u000f[3!I\u00164\u0017-\u001e7uAM|'\u000f\u001e\u0011pe\u0012,'\u000fC\u0004\u0002@\n\u0001\r!!1\u0002\u0013\t\fGo\u00195TSj,\u0007c\u00011\u0002D&\u0019\u0011QY1\u0003\u000f%sG/Z4fe\"\u0002\u0012QXA\u0018\u0003{\tI-!\u0011\u0002L\u0006e\u00131L\u0011\u0003\u0003\u007f\u000b#!!4\u0002e9+XNY3sA=4\u0007EZ3biV\u0014Xm\u001d\u0011u_\u0002Jgn\u00197vI\u0016\u0004\u0013N\u001c\u0011fC\u000eD\u0007E]3d_J$\u0007EY1uG\"Dq!!5\u0003\u0001\u0004\tY%A\u0007gY\u0006$H/\u001a8TiJ,8\r\u001e\u0015\u0011\u0003\u001f\fy#!\u0010\u0002V\u0006\u0005\u0013q[A-\u00037\n#!!5\"\u0005\u0005e\u0017A\u0010*f[>4Xm\u001d\u0011uQ\u0016\u0004s.\u001e;fe\u0002\u001af\t\u0016\u0011tiJ,8\r\u001e\u0011zS\u0016dG-\u001b8hAQ|\u0007\u000f\t7fm\u0016d\u0007EZ3biV\u0014X\rI1dG\u0016\u001c8\u000fC\u0005\u0002^\n\u0001\n\u00111\u0001\u0002L\u0005ia\r\\5q\u0003bL7o\u0014:eKJDC#a7\u00020\u0005u\u0012\u0011]A!\u0003G\fI&a\u0017\u0002h\u0006%\u0018EAAoC\t\t)/A2GY&\u0004\b\u0005\u001e5fA\u0005D\u0018n\u001d\u0011pe\u0012,'\u000fI8gAI,G/\u001e:oK\u0012\u00043m\\8sI&t\u0017\r^3tA\u0019\u0014x.\u001c\u0011mCRLG/\u001e3f_1|gnZ5uk\u0012,\u0007\u0005\u000b3fM\u0006,H\u000e^\u0015!i>\u0004Cn\u001c8hSR,H-Z\u0018mCRLG/\u001e3f\u00031!WMZ1vYR4\u0016\r\\;fC\t\tY/A\u0003gC2\u001cX\rK\u0004\u0003\u0003_\f\t%!>\u0011\t\u0005E\u0012\u0011_\u0005\u0005\u0003g\f\u0019D\u0001\bEKN\u001c'/\u001b2f%\u0016\u001cX\u000f\u001c;\"\u0005\u0005]\u0018AG#oG>$W\r\u001a\u0011gK\u0006$XO]3!G>dG.Z2uS>t\u0017AE3yK\u000e,H/\u001a\u0013eK\u001a\fW\u000f\u001c;%cA*\"!!@+\t\u0005-\u0013q`\u0016\u0003\u0005\u0003\u0001BAa\u0001\u0003\u000e5\u0011!Q\u0001\u0006\u0005\u0005\u000f\u0011I!A\u0005v]\u000eDWmY6fI*!!1BA\u0004\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001f\u0011)AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D3\u0002\u0001B\n\u00053\u0011Y\"!\u0011\u0003 A!\u0011\u0011\u0007B\u000b\u0013\u0011\u00119\"a\r\u0003\u001f\u0011+7o\u0019:jE\u0016\u0004&o\\2fgN\fQ\u0001^5uY\u0016\f#A!\b\u0002!\u0005\u0013(o\\<!\u0007>tg/\u001a:tS>t\u0017E\u0001B\u0011\u00035\u001auN\u001c<feR\u001c\b%\u0019\u0011gK\u0006$XO]3!G>dG.Z2uS>t\u0007\u0005^8!CJ\u0014xn\u001e\u0011g_Jl\u0017\r^\u0001\u0017\u0003J\u0014xn^\"p]Z,'o]5p]B\u0013xnY3tgB\u0011\u00010B\n\u0004\u000b\t%\u0002\u0003BA\u0003\u0005WIAA!\f\u0002\b\t1\u0011I\\=SK\u001a$\"A!\n\u0003\u0019\u0005\u0013(o\\<WSNLGo\u001c:\u0014\u000b\u001dy&QG6\u0011\t\t]\"qH\u0007\u0003\u0005sQ1A\u0016B\u001e\u0015\r\u0011idV\u0001\u0006S:$W\r_\u0005\u0005\u0005\u0003\u0012IDA\u000bHK>lUm]1Qe>\u001cWm]:WSNLGo\u001c:\u0002\u0007M4G\u000f\u0005\u0003\u0003H\tMSB\u0001B%\u0015\u0011\tyBa\u0013\u000b\t\t5#qJ\u0001\bM\u0016\fG/\u001e:f\u0015\u0011\u0011\t&!\n\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003V\t%#!E*j[BdWMR3biV\u0014X\rV=qK\u0006AQM\\2pI&tw\r\u0005\u0003\u0003\\\tud\u0002\u0002B/\u0005orAAa\u0018\u0003r9!!\u0011\rB7\u001d\u0011\u0011\u0019Ga\u001b\u000f\t\t\u0015$\u0011\u000e\b\u0005\u0003g\u00129'C\u0001]\u0013\tQ6,\u0003\u0002Y3&\u0019!qN,\u0002\u000b\u0005\u0014(o\\<\n\t\tM$QO\u0001\u0007m\u0016\u001cGo\u001c:\u000b\u0007\t=t+\u0003\u0003\u0003z\tm\u0014aE*j[BdWMR3biV\u0014XMV3di>\u0014(\u0002\u0002B:\u0005kJAAa \u0003\u0002\n)2+[7qY\u00164U-\u0019;ve\u0016,enY8eS:<'\u0002\u0002B=\u0005w\n!\"\u001b9d-\u0016\u00148/[8o!\u0019\u00119I!%\u0002n9!!\u0011\u0012BG\u001d\u0011\t\u0019Ha#\n\u0005\u0005%\u0011\u0002\u0002BH\u0003\u000f\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0014\nU%aA*fc*!!qRA\u0004!\u0019\t)A!'\u0002n%!!1TA\u0004\u0005\u0019y\u0005\u000f^5p]B1\u0011Q\u0001BM\u0005?\u0003B!!\u0002\u0003\"&!\u0011qJA\u0004\u0003%\u0001(/Z*peR,G\r\u0005\u0003\u0002\u0006\t\u001d\u0016\u0002\u0002BU\u0003\u000f\u00111!\u00138u)Q\u0011iK!-\u00034\nU&q\u0017B]\u0005w\u0013iLa0\u0003BB\u0019!qV\u0004\u000e\u0003\u0015AqAa\u0011\u0012\u0001\u0004\u0011)\u0005C\u0004\u0003XE\u0001\rA!\u0017\t\u000f\t\r\u0015\u00031\u0001\u0002n!9\u0011QR\tA\u0002\t\u0015\u0005bBAT#\u0001\u0007!q\u0013\u0005\b\u0003g\u000b\u0002\u0019\u0001BO\u0011\u001d\u0011\u0019+\u0005a\u0001\u0005?Cq!a0\u0012\u0001\u0004\u0011)\u000bC\u0004\u0002RF\u0001\rAa(\u0002\u001b5\fg.^1m-&\u001c\u0018\u000e^8s+\t\u00119\rE\u0002\u00030f\u0011!#\u0011:s_^l\u0015M\\;bYZK7/\u001b;peN\u0019\u0011D!\u000b\u0002\u000bYL7/\u001b;\u0015\t\tE'q\u001b\t\u0005\u0003\u000b\u0011\u0019.\u0003\u0003\u0003V\u0006\u001d!\u0001B+oSRDqA!\u0014\u001b\u0001\u0004\u0011I\u000e\u0005\u0003\u0003H\tm\u0017\u0002\u0002Bo\u0005\u0013\u0012QbU5na2,g)Z1ukJ,\u0017a\u0002:fgVdGo]\u000b\u0003\u0005G\u0004bAa\"\u0003f\u0006\r\u0011\u0002BA\u0001\u0005+\u000baA]3tk2$\u0018A\u0003:fgVdGo\u0018\u0013fcR!!\u0011\u001bBw\u0011%\u0011y\u000fFA\u0001\u0002\u0004\u0011\u0019/A\u0002yIE\nqA]3tk2$\b%A\u0005hKR\u0014Vm];miR\u0011!q\u001f\t\u0004\u0005_k$aC!se><(+Z:vYR\u001cr!\u0010B\u007f\u0007\u0017\u0019\t\u0002\u0005\u0003\u0003\u0000\u000e\u001dQBAB\u0001\u0015\u0011\u0019\u0019a!\u0002\u0002\u000fYL7/\u001b;pe*!!QJA\u0013\u0013\u0011\u0019Ia!\u0001\u0003%\u0005\u00137\u000f\u001e:bGR\u001c\u0015\r\\2SKN,H\u000e\u001e\t\u0005\u0003\u000b\u0019i!\u0003\u0003\u0004\u0010\u0005\u001d!a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u000b\u0019\u0019\"\u0003\u0003\u0004\u0016\u0005\u001d!\u0001D*fe&\fG.\u001b>bE2,W#A>\u0002\u0011I,7/\u001e7ug\u0002\"BAa>\u0004\u001e!1!q\u001c!A\u0002m\f\u0001bZ3u-\u0006dW/\u001a\u000b\u0003\u0005S\tAaY8qsR!!q_B\u0014\u0011!\u0011yN\u0011I\u0001\u0002\u0004Y\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0007[Q3a_A\u0000\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u001111\u0007\t\u0004A\u000eU\u0012bAA@C\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!QU\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0019yd!\u0012\u0011\t\u0005\u00151\u0011I\u0005\u0005\u0007\u0007\n9AA\u0002B]fD\u0011Ba<G\u0003\u0003\u0005\rA!*\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"aa\u0013\u0011\r\r531KB \u001b\t\u0019yE\u0003\u0003\u0004R\u0005\u001d\u0011AC2pY2,7\r^5p]&!\u0011\u0011AB(\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002BP\u00073B\u0011Ba<I\u0003\u0003\u0005\raa\u0010\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!*\u0002\r\u0015\fX/\u00197t)\u0011\u0011yja\u0019\t\u0013\t=(*!AA\u0002\r}B\u0003\u0002Bi\u0007OBqA!\u0014\u0018\u0001\u0004\u0019I\u0007\u0005\u0003\u0004l\r5TB\u0001B&\u0013\u0011\u0019yGa\u0013\u0003\u000f\u0019+\u0017\r^;sKR1!\u0011[B:\u0007\u0003Cqa!\u001e\u0019\u0001\u0004\u00199(\u0001\u0004t_V\u00148-\u001a\t\u0005\u0007s\u001ai(\u0004\u0002\u0004|)!\u00111\u0005B(\u0013\u0011\u0019yha\u001f\u0003'MKW\u000e\u001d7f\r\u0016\fG/\u001e:f'>,(oY3\t\u000f\r\r\u0005\u00041\u0001\u0004\u0006\u0006)\u0011/^3ssB!1\u0011PBD\u0013\u0011\u0019Iia\u001f\u0003\u000bE+XM]=\u00031MKW\u000e\u001d7f\u0003J\u0014xn^'b]V\fGNV5tSR|'oE\u0003\u001d\u0005S\u00119-A\u0004ja\u000e|\u0005\u000f^:\u0011\t\rM5QU\u0007\u0003\u0007+SAaa&\u0004\u001a\u00069Q.Z:tC\u001e,'\u0002BBN\u0007;\u000b1!\u001b9d\u0015\u0011\u0011\u0019ha(\u000b\t\t=4\u0011\u0015\u0006\u0004\u0007G[\u0016AB1qC\u000eDW-\u0003\u0003\u0004(\u000eU%!C%qG>\u0003H/[8o\u0003\u0011\u0019xN\u001d;\u0011\r\u0005\u0015!\u0011TBW!!\t)aa,\u0002n\t}\u0015\u0002BBY\u0003\u000f\u0011a\u0001V;qY\u0016\u0014DCDB[\u0007o\u001bIla/\u0004>\u000e}6\u0011\u0019\t\u0004\u0005_c\u0002b\u0002B\"G\u0001\u0007!Q\t\u0005\b\u0005/\u001a\u0003\u0019\u0001B-\u0011\u001d\u0019yi\ta\u0001\u0007#Cqa!+$\u0001\u0004\u0019Y\u000bC\u0004\u0002@\u000e\u0002\rA!*\t\u000f\u0005E7\u00051\u0001\u0003 \u0006\u0019q.\u001e;\u0016\u0005\r\u001d\u0007\u0003BBe\u0007\u001fl!aa3\u000b\u0007\r57-\u0001\u0002j_&!1\u0011[Bf\u0005U\u0011\u0015\u0010^3BeJ\f\u0017pT;uaV$8\u000b\u001e:fC6\fAa\\;uA\u0005)!-\u001f;fgV\u00111\u0011\u001c\t\u0007\u00077\u001c\t/a\u0001\u000e\u0005\ru'\u0002BBp\u0007\u001f\nq!\\;uC\ndW-\u0003\u0003\u0004d\u000eu'A\u0003'jgR\u0014UO\u001a4fe\u00061!-\u001f;fg\u0002\nQaY8v]R,\"aa;\u0011\t\u0005\u00151Q^\u0005\u0005\u0007_\f9A\u0001\u0003M_:<\u0017!C2pk:$x\fJ3r)\u0011\u0011\tn!>\t\u0013\t=\u0018&!AA\u0002\r-\u0018AB2pk:$\b%\u0001\u0004xe&$XM]\u000b\u0003\u0007{\u0004Baa@\u0005\u00045\u0011A\u0011\u0001\u0006\u0005\u0007\u001b\u0014)(\u0003\u0003\u0005\u0006\u0011\u0005!\u0001H*j[BdWMR3biV\u0014X-\u0011:s_^4\u0015\u000e\\3Xe&$XM]\u0001\boJLG/\u001a:!)\u0011\u0011\t\u000eb\u0003\t\u000f\t5S\u00061\u0001\u0003Z\nI2i\\7qY\u0016D\u0018I\u001d:po6\u000bg.^1m-&\u001c\u0018\u000e^8s'\u0015y#\u0011\u0006Bd)I!\u0019\u0002\"\u0006\u0005\u0018\u0011eA1\u0004C\u000f\t?!\t\u0003b\t\u0011\u0007\t=v\u0006C\u0004\u0003Da\u0002\rA!\u0012\t\u000f\t]\u0003\b1\u0001\u0003Z!91q\u0012\u001dA\u0002\rE\u0005bBAGq\u0001\u0007!Q\u0011\u0005\b\u0007SC\u0004\u0019ABV\u0011\u001d\u0011\u0019\u000b\u000fa\u0001\u0005?Cq!a09\u0001\u0004\u0011)\u000bC\u0004\u0002Rb\u0002\rAa(\u0016\u0005\u0011\u001d\u0002CBBn\tS\u0011I.\u0003\u0003\u0005,\ru'aC!se\u0006L()\u001e4gKJ\f\u0011BZ3biV\u0014Xm\u001d\u0011\u0015\t\tEG\u0011\u0007\u0005\b\u0005\u001bZ\u0004\u0019\u0001Bm\u0003-\t%O]8x%\u0016\u001cX\u000f\u001c;\u0011\u0007\t=FjE\u0003M\ts\u0019\t\u0002E\u0004\u0005<\u0011\u00053Pa>\u000e\u0005\u0011u\"\u0002\u0002C \u0003\u000f\tqA];oi&lW-\u0003\u0003\u0005D\u0011u\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011AQG\u0001\ti>\u001cFO]5oOR\u001111G\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0005o$y\u0005\u0003\u0004\u0003`>\u0003\ra_\u0001\bk:\f\u0007\u000f\u001d7z)\u0011!)\u0006b\u0016\u0011\u000b\u0005\u0015!\u0011T>\t\u0013\u0011e\u0003+!AA\u0002\t]\u0018a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005y\u0006")
public class ArrowConversionProcess
implements GeoMesaProcess,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        ArrowConversionProcess arrowConversionProcess = this;
        synchronized (arrowConversionProcess) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @DescribeResult(description="Encoded feature collection")
    public java.util.Iterator<byte[]> execute(@DescribeParameter(name="features", description="Input feature collection to encode") SimpleFeatureCollection features, @DescribeParameter(name="includeFids", description="Include feature IDs in arrow file", min=0) Boolean includeFids, @DescribeParameter(name="proxyFids", description="Proxy feature IDs to ints instead of strings", min=0) Boolean proxyFids, @DescribeParameter(name="formatVersion", description="Arrow IPC format version", min=0) String formatVersion, @DescribeParameter(name="dictionaryFields", description="Attributes to dictionary encode", min=0, max=128, collectionType=String.class) List<String> dictionaryFields, @DescribeParameter(name="sortField", description="Attribute to sort by", min=0) String sortField, @DescribeParameter(name="sortReverse", description="Reverse the default sort order", min=0) Boolean sortReverse, @DescribeParameter(name="batchSize", description="Number of features to include in each record batch", min=0) Integer batchSize, @DescribeParameter(name="flattenStruct", description="Removes the outer SFT struct yielding top level feature access", min=0) Boolean flattenStruct, @DescribeParameter(name="flipAxisOrder", description="Flip the axis order of returned coordinates from latitude/longitude (default) to longitude/latitude", min=0, defaultValue="false") Boolean flipAxisOrder) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running arrow encoding for {}", new Object[]{features.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SimpleFeatureType sft = (SimpleFeatureType)features.getSchema();
        Seq toEncode = (Seq)Option$.MODULE$.apply(dictionaryFields).map((Function1 & Serializable & scala.Serializable)x$1 -> ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        toEncode.foreach((Function1 & Serializable & scala.Serializable)attribute -> {
            ArrowConversionProcess.$anonfun$execute$3(sft, attribute);
            return BoxedUnit.UNIT;
        });
        SimpleFeatureVector.SimpleFeatureEncoding encoding = SimpleFeatureVector.SimpleFeatureEncoding$.MODULE$.min(includeFids == null || Predef$.MODULE$.Boolean2boolean(includeFids), proxyFids != null && Predef$.MODULE$.Boolean2boolean(proxyFids), Option$.MODULE$.apply((Object)flipAxisOrder).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2)));
        String ipcVersion = (String)Option$.MODULE$.apply((Object)formatVersion).getOrElse((Function0 & Serializable & scala.Serializable)() -> package.FormatVersion$.MODULE$.ArrowFormatVersion().get());
        Option reverse = Option$.MODULE$.apply((Object)sortReverse).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3));
        int batch = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)batchSize).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(package.ArrowProperties$.MODULE$.BatchSize().get())).toInt()));
        ArrowVisitor visitor = new ArrowVisitor(sft, encoding, ipcVersion, (Seq<String>)toEncode, (Option<String>)Option$.MODULE$.apply((Object)sortField), (Option<Object>)reverse, false, batch, Predef$.MODULE$.Boolean2boolean(flattenStruct));
        GeoMesaFeatureCollection$.MODULE$.visit((FeatureCollection)features, (FeatureVisitor)visitor, GeoMesaFeatureCollection$.MODULE$.visit$default$3());
        return visitor.getResult().results();
    }

    public Boolean execute$default$10() {
        return Predef$.MODULE$.boolean2Boolean(false);
    }

    public static final /* synthetic */ void $anonfun$execute$3(SimpleFeatureType sft$1, String attribute) {
        if (sft$1.indexOf(attribute) == -1) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Attribute ").append(attribute).append(" doesn't exist in ").append(sft$1).toString());
        }
    }

    public ArrowConversionProcess() {
        LazyLogging.$init$((LazyLogging)this);
    }

    public static interface ArrowManualVisitor {
        public void visit(SimpleFeature var1);

        public Iterator<byte[]> results();
    }

    public static class ArrowResult
    extends AbstractCalcResult
    implements Product,
    scala.Serializable {
        private final java.util.Iterator<byte[]> results;

        public java.util.Iterator<byte[]> results() {
            return this.results;
        }

        public Object getValue() {
            return this.results();
        }

        public ArrowResult copy(java.util.Iterator<byte[]> results) {
            return new ArrowResult(results);
        }

        public java.util.Iterator<byte[]> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "ArrowResult";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ArrowResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ArrowResult)) return false;
            boolean bl = true;
            if (!bl) return false;
            ArrowResult arrowResult = (ArrowResult)((Object)x$1);
            java.util.Iterator<byte[]> iterator = this.results();
            java.util.Iterator<byte[]> iterator2 = arrowResult.results();
            if (iterator == null) {
                if (iterator2 != null) {
                    return false;
                }
            } else if (!iterator.equals(iterator2)) return false;
            if (!arrowResult.canEqual((Object)this)) return false;
            return true;
        }

        public ArrowResult(java.util.Iterator<byte[]> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class ArrowVisitor
    implements GeoMesaProcessVisitor,
    LazyLogging {
        private ArrowManualVisitor manualVisitor;
        private final SimpleFeatureType sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final String ipcVersion;
        private final Seq<String> dictionaryFields;
        private final Option<String> sortField;
        private final Option<Object> sortReverse;
        private final boolean preSorted;
        private final int batchSize;
        private final boolean flattenStruct;
        private Iterator<byte[]> result;
        private transient Logger logger;
        private volatile boolean bitmap$0;
        private volatile transient boolean bitmap$trans$0;

        public List<Expression> getExpressions() {
            return GeoMesaProcessVisitor.getExpressions$((GeoMesaProcessVisitor)this);
        }

        private Logger logger$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        private ArrowManualVisitor manualVisitor$lzycompute() {
            ArrowVisitor arrowVisitor = this;
            synchronized (arrowVisitor) {
                if (!this.bitmap$0) {
                    Option sort = this.sortField.map((Function1 & Serializable & scala.Serializable)s -> new Tuple2(s, $this.sortReverse.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)));
                    IpcOption ipcOpts = package.FormatVersion$.MODULE$.options(this.ipcVersion);
                    this.manualVisitor = this.dictionaryFields.isEmpty() && (this.sortField.isEmpty() || this.preSorted) ? new SimpleArrowManualVisitor(this.sft, this.encoding, ipcOpts, (Option<Tuple2<String, Object>>)sort, this.batchSize, this.flattenStruct) : new ComplexArrowManualVisitor(this.sft, this.encoding, ipcOpts, this.dictionaryFields, (Option<Tuple2<String, Object>>)sort, this.preSorted, this.batchSize, this.flattenStruct);
                    this.bitmap$0 = true;
                }
            }
            return this.manualVisitor;
        }

        private ArrowManualVisitor manualVisitor() {
            if (!this.bitmap$0) {
                return this.manualVisitor$lzycompute();
            }
            return this.manualVisitor;
        }

        private Iterator<byte[]> result() {
            return this.result;
        }

        private void result_$eq(Iterator<byte[]> x$1) {
            this.result = x$1;
        }

        public ArrowResult getResult() {
            if (this.result() != null) {
                return new ArrowResult((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.result()).asJava());
            }
            return new ArrowResult((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.manualVisitor().results()).asJava());
        }

        public void visit(Feature feature) {
            this.manualVisitor().visit((SimpleFeature)feature);
        }

        public void execute(SimpleFeatureSource source, Query query) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Visiting source type: {}", new Object[]{source.getClass().getName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_ENCODE(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_DICTIONARY_FIELDS(), (Object)this.dictionaryFields.mkString(","));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.fids().isDefined()));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_PROXY_FID(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.fids().contains((Object)SimpleFeatureVector.SimpleFeatureEncoding$.Encoding$.MODULE$.Min())));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_BATCH_SIZE(), (Object)BoxesRunTime.boxToInteger((int)this.batchSize));
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_FORMAT_VERSION(), (Object)this.ipcVersion);
            query.getHints().put((Object)QueryHints$.MODULE$.ARROW_FLATTEN_STRUCT(), (Object)BoxesRunTime.boxToBoolean((boolean)this.flattenStruct));
            query.getHints().put((Object)QueryHints$.MODULE$.FLIP_AXIS_ORDER(), (Object)BoxesRunTime.boxToBoolean((boolean)this.encoding.flipAxisOrder()));
            this.sortField.foreach((Function1 & Serializable & scala.Serializable)x$5 -> query.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_FIELD(), x$5));
            this.sortReverse.foreach((Function1 & Serializable & scala.Serializable)x$6 -> ArrowVisitor.$anonfun$execute$10(query, BoxesRunTime.unboxToBoolean((Object)x$6)));
            SelfClosingIterator features = SelfClosingIterator$.MODULE$.apply(source.getFeatures(query));
            this.result_$eq((Iterator<byte[]>)features.map((Function1 & Serializable & scala.Serializable)x$7 -> (byte[])x$7.getAttribute(0)));
        }

        public static final /* synthetic */ Object $anonfun$execute$10(Query query$1, boolean x$6) {
            return query$1.getHints().put((Object)QueryHints$.MODULE$.ARROW_SORT_REVERSE(), (Object)BoxesRunTime.boxToBoolean((boolean)x$6));
        }

        public ArrowVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, String ipcVersion, Seq<String> dictionaryFields, Option<String> sortField, Option<Object> sortReverse, boolean preSorted, int batchSize, boolean flattenStruct) {
            this.sft = sft;
            this.encoding = encoding;
            this.ipcVersion = ipcVersion;
            this.dictionaryFields = dictionaryFields;
            this.sortField = sortField;
            this.sortReverse = sortReverse;
            this.preSorted = preSorted;
            this.batchSize = batchSize;
            this.flattenStruct = flattenStruct;
            GeoMesaProcessVisitor.$init$((GeoMesaProcessVisitor)this);
            LazyLogging.$init$((LazyLogging)this);
        }
    }

    private static class ComplexArrowManualVisitor
    implements ArrowManualVisitor {
        private final SimpleFeatureType sft;
        private final SimpleFeatureVector.SimpleFeatureEncoding encoding;
        private final IpcOption ipcOpts;
        private final Seq<String> dictionaryFields;
        private final Option<Tuple2<String, Object>> sort;
        private final boolean preSorted;
        private final int batchSize;
        private final boolean flattenStruct;
        private final ArrayBuffer<SimpleFeature> features;

        private ArrayBuffer<SimpleFeature> features() {
            return this.features;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.features().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleFeature[]{ScalaSimpleFeature$.MODULE$.copy(feature)}));
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Iterator<byte[]> results() {
            dictionaries = (Seq)this.dictionaryFields.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$results$1(org.locationtech.geomesa.process.transform.ArrowConversionProcess$ComplexArrowManualVisitor java.lang.String ), (Ljava/lang/String;)Lscala/Tuple2;)((ComplexArrowManualVisitor)this), Seq$.MODULE$.canBuildFrom());
            var4_2 = this.sort;
            if (!(var4_2 instanceof Some) || (var6_4 = (Tuple2)(var5_3 = (Some)var4_2).value()) == null) ** GOTO lbl-1000
            field = (String)var6_4._1();
            reverse = var6_4._2$mcZ$sp();
            if (!this.preSorted) {
                v0 = ((IndexedSeqLike)this.features().sorted(SimpleFeatureOrdering$.MODULE$.apply(this.sft, field, reverse))).iterator();
            } else lbl-1000:
            // 2 sources

            {
                v0 = this.features().iterator();
            }
            sorted = v0;
            out = new ByteArrayOutputStream();
            bytes = (ListBuffer)ListBuffer$.MODULE$.empty();
            package.WithClose$.MODULE$.apply((Object)SimpleFeatureArrowFileWriter$.MODULE$.apply((OutputStream)out, this.sft, dictionaries.toMap(Predef$.MODULE$.$conforms()), this.encoding, this.ipcOpts, this.sort, this.flattenStruct), (Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$results$4$adapted(org.locationtech.geomesa.process.transform.ArrowConversionProcess$ComplexArrowManualVisitor scala.collection.Iterator scala.collection.mutable.ListBuffer java.io.ByteArrayOutputStream org.locationtech.geomesa.arrow.io.SimpleFeatureArrowFileWriter ), (Lorg/locationtech/geomesa/arrow/io/SimpleFeatureArrowFileWriter;)Ljava/lang/Object;)((ComplexArrowManualVisitor)this, (Iterator)sorted, (ListBuffer)bytes, (ByteArrayOutputStream)out), IsCloseable$.MODULE$.closeableIsCloseable());
            bytes.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{out.toByteArray()}));
            return bytes.iterator();
        }

        public static final /* synthetic */ Tuple2 $anonfun$results$1(ComplexArrowManualVisitor $this, String field) {
            int i = $this.sft.indexOf(field);
            AttributeDescriptor descriptor = $this.sft.getDescriptor(i);
            boolean isList = RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.isList$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor));
            HashSet values = HashSet$.MODULE$.empty();
            $this.features().foreach((Function1 & Serializable & scala.Serializable)f -> {
                Object value = f.getAttribute(i);
                if (value != null) {
                    if (isList) {
                        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)value).asScala()).foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)values.add(elem)));
                        return BoxedUnit.UNIT;
                    }
                    return BoxesRunTime.boxToBoolean((boolean)values.add(value));
                }
                return BoxedUnit.UNIT;
            });
            Class binding = isList ? RichAttributeDescriptors.RichAttributeDescriptor$.MODULE$.getListType$extension(RichAttributeDescriptors$.MODULE$.RichAttributeDescriptor(descriptor)) : descriptor.getType().getBinding();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field), (Object)ArrowDictionary$.MODULE$.create($this.sft.getTypeName(), (long)i, (Object[])values.toArray(ClassTag$.MODULE$.AnyRef()), ClassTag$.MODULE$.apply(binding)));
        }

        public static final /* synthetic */ void $anonfun$results$4(ComplexArrowManualVisitor $this, Iterator sorted$1, ListBuffer bytes$1, ByteArrayOutputStream out$1, SimpleFeatureArrowFileWriter writer) {
            while (sorted$1.hasNext()) {
                for (int i = 0; i < $this.batchSize && sorted$1.hasNext(); ++i) {
                    writer.add((SimpleFeature)sorted$1.next());
                }
                writer.flush();
                bytes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{out$1.toByteArray()}));
                out$1.reset();
            }
        }

        public ComplexArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, IpcOption ipcOpts, Seq<String> dictionaryFields, Option<Tuple2<String, Object>> sort, boolean preSorted, int batchSize, boolean flattenStruct) {
            this.sft = sft;
            this.encoding = encoding;
            this.ipcOpts = ipcOpts;
            this.dictionaryFields = dictionaryFields;
            this.sort = sort;
            this.preSorted = preSorted;
            this.batchSize = batchSize;
            this.flattenStruct = flattenStruct;
            this.features = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        }

        public static final /* synthetic */ Object $anonfun$results$4$adapted(ComplexArrowManualVisitor $this, Iterator sorted$1, ListBuffer bytes$1, ByteArrayOutputStream out$1, SimpleFeatureArrowFileWriter writer) {
            ComplexArrowManualVisitor.$anonfun$results$4($this, sorted$1, bytes$1, out$1, writer);
            return BoxedUnit.UNIT;
        }
    }

    private static class SimpleArrowManualVisitor
    implements ArrowManualVisitor {
        private final int batchSize;
        private final ByteArrayOutputStream out;
        private final ListBuffer<byte[]> bytes;
        private long count;
        private final SimpleFeatureArrowFileWriter writer;

        private ByteArrayOutputStream out() {
            return this.out;
        }

        private ListBuffer<byte[]> bytes() {
            return this.bytes;
        }

        private long count() {
            return this.count;
        }

        private void count_$eq(long x$1) {
            this.count = x$1;
        }

        private SimpleFeatureArrowFileWriter writer() {
            return this.writer;
        }

        @Override
        public void visit(SimpleFeature feature) {
            this.writer().add(feature);
            this.count_$eq(this.count() + 1L);
            if (this.count() % (long)this.batchSize == 0L) {
                this.writer().flush();
                this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
                this.out().reset();
                return;
            }
        }

        @Override
        public Iterator<byte[]> results() {
            package.CloseWithLogging$.MODULE$.apply((Object)this.writer(), IsCloseable$.MODULE$.closeableIsCloseable());
            this.bytes().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.out().toByteArray()}));
            return this.bytes().iterator();
        }

        public SimpleArrowManualVisitor(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, IpcOption ipcOpts, Option<Tuple2<String, Object>> sort, int batchSize, boolean flattenStruct) {
            this.batchSize = batchSize;
            this.out = new ByteArrayOutputStream();
            this.bytes = (ListBuffer)ListBuffer$.MODULE$.empty();
            this.count = 0L;
            this.writer = SimpleFeatureArrowFileWriter$.MODULE$.apply((OutputStream)this.out(), sft, Predef$.MODULE$.Map().empty(), encoding, ipcOpts, sort, flattenStruct);
        }
    }
}

