/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.security;

import java.io.Serializable;
import java.util.List;
import org.apache.accumulo.access.AccessEvaluator;
import org.apache.accumulo.access.Authorizations;
import org.geotools.api.feature.simple.SimpleFeature;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.security.SecurityUtils;
import org.locationtech.geomesa.security.VisibilityUtils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005i<QAD\b\t\u0002a1QAG\b\t\u0002mAQAI\u0001\u0005\u0002\r*A\u0001J\u0001\u0001K!)q'\u0001C\u0001q!)1)\u0001C\u0005\t\u001a!q)\u0001\u0003I\u0011!IeA!A!\u0002\u0013Q\u0005\"\u0002\u0012\u0007\t\u0003i\u0006b\u00021\u0007\u0005\u0004%I!\u0019\u0005\u0007W\u001a\u0001\u000b\u0011\u00022\t\u000f14!\u0019!C\u0005[\"1aO\u0002Q\u0001\n9DQa\u001e\u0004\u0005Ba\fqBV5tS\nLG.\u001b;z+RLGn\u001d\u0006\u0003!E\t\u0001b]3dkJLG/\u001f\u0006\u0003%M\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u0015+\u0005aAn\\2bi&|g\u000e^3dQ*\ta#A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u001a\u00035\tqBA\bWSNL'-\u001b7jif,F/\u001b7t'\t\tA\u0004\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\u0011\u0011\"S:WSNL'\r\\3\u0011\tu1\u0003\u0006N\u0005\u0003Oy\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005%\u0012T\"\u0001\u0016\u000b\u0005-b\u0013AB:j[BdWM\u0003\u0002.]\u00059a-Z1ukJ,'BA\u00181\u0003\r\t\u0007/\u001b\u0006\u0003cU\t\u0001bZ3pi>|Gn]\u0005\u0003g)\u0012QbU5na2,g)Z1ukJ,\u0007CA\u000f6\u0013\t1dDA\u0004C_>dW-\u00198\u0002\u000fYL7/\u001b2mKR\u0011\u0011h\u000f\t\u0003u\ri\u0011!\u0001\u0005\u0006y\u0011\u0001\r!P\u0001\taJ|g/\u001b3feB\u0019QD\u0010!\n\u0005}r\"AB(qi&|g\u000e\u0005\u0002\u001a\u0003&\u0011!i\u0004\u0002\u0017\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8t!J|g/\u001b3fe\u0006)bn\\!vi\"4\u0016n]5cS2LG/_\"iK\u000e\\GC\u0001\u001bF\u0011\u00151U\u00011\u0001)\u0003\u00051'aE!vi\"4\u0016n]5cS2LG/_\"iK\u000e\\7c\u0001\u0004\u001dK\u0005)\u0011-\u001e;igB\u00191\n\u0015*\u000e\u00031S!!\u0014(\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u001f\u0006!!.\u0019<b\u0013\t\tFJ\u0001\u0003MSN$\bCA*[\u001d\t!\u0006\f\u0005\u0002V=5\taK\u0003\u0002X/\u00051AH]8pizJ!!\u0017\u0010\u0002\rA\u0013X\rZ3g\u0013\tYFL\u0001\u0004TiJLgn\u001a\u0006\u00033z!\"AX0\u0011\u0005i2\u0001\"B%\t\u0001\u0004Q\u0015AB1dG\u0016\u001c8/F\u0001c!\t\u0019\u0017.D\u0001e\u0015\t\u0001WM\u0003\u0002gO\u0006A\u0011mY2v[VdwN\u0003\u0002i+\u00051\u0011\r]1dQ\u0016L!A\u001b3\u0003\u001f\u0005\u001b7-Z:t\u000bZ\fG.^1u_J\fq!Y2dKN\u001c\b%A\u0003dC\u000eDW-F\u0001o!\u0011yGO\u0015\u001b\u000e\u0003AT!!\u001d:\u0002\u000f5,H/\u00192mK*\u00111OH\u0001\u000bG>dG.Z2uS>t\u0017BA;q\u0005\ri\u0015\r]\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005QJ\b\"\u0002$\u000e\u0001\u0004A\u0003")
public final class VisibilityUtils {
    public static Function1<SimpleFeature, Object> visible(Option<AuthorizationsProvider> provider) {
        return VisibilityUtils$.MODULE$.visible(provider);
    }

    private static class AuthVisibilityCheck
    implements Function1<SimpleFeature, Object> {
        private final AccessEvaluator access;
        private final Map<String, Object> cache;

        public boolean apply$mcZD$sp(double v1) {
            return Function1.apply$mcZD$sp$((Function1)this, (double)v1);
        }

        public double apply$mcDD$sp(double v1) {
            return Function1.apply$mcDD$sp$((Function1)this, (double)v1);
        }

        public float apply$mcFD$sp(double v1) {
            return Function1.apply$mcFD$sp$((Function1)this, (double)v1);
        }

        public int apply$mcID$sp(double v1) {
            return Function1.apply$mcID$sp$((Function1)this, (double)v1);
        }

        public long apply$mcJD$sp(double v1) {
            return Function1.apply$mcJD$sp$((Function1)this, (double)v1);
        }

        public void apply$mcVD$sp(double v1) {
            Function1.apply$mcVD$sp$((Function1)this, (double)v1);
        }

        public boolean apply$mcZF$sp(float v1) {
            return Function1.apply$mcZF$sp$((Function1)this, (float)v1);
        }

        public double apply$mcDF$sp(float v1) {
            return Function1.apply$mcDF$sp$((Function1)this, (float)v1);
        }

        public float apply$mcFF$sp(float v1) {
            return Function1.apply$mcFF$sp$((Function1)this, (float)v1);
        }

        public int apply$mcIF$sp(float v1) {
            return Function1.apply$mcIF$sp$((Function1)this, (float)v1);
        }

        public long apply$mcJF$sp(float v1) {
            return Function1.apply$mcJF$sp$((Function1)this, (float)v1);
        }

        public void apply$mcVF$sp(float v1) {
            Function1.apply$mcVF$sp$((Function1)this, (float)v1);
        }

        public boolean apply$mcZI$sp(int v1) {
            return Function1.apply$mcZI$sp$((Function1)this, (int)v1);
        }

        public double apply$mcDI$sp(int v1) {
            return Function1.apply$mcDI$sp$((Function1)this, (int)v1);
        }

        public float apply$mcFI$sp(int v1) {
            return Function1.apply$mcFI$sp$((Function1)this, (int)v1);
        }

        public int apply$mcII$sp(int v1) {
            return Function1.apply$mcII$sp$((Function1)this, (int)v1);
        }

        public long apply$mcJI$sp(int v1) {
            return Function1.apply$mcJI$sp$((Function1)this, (int)v1);
        }

        public void apply$mcVI$sp(int v1) {
            Function1.apply$mcVI$sp$((Function1)this, (int)v1);
        }

        public boolean apply$mcZJ$sp(long v1) {
            return Function1.apply$mcZJ$sp$((Function1)this, (long)v1);
        }

        public double apply$mcDJ$sp(long v1) {
            return Function1.apply$mcDJ$sp$((Function1)this, (long)v1);
        }

        public float apply$mcFJ$sp(long v1) {
            return Function1.apply$mcFJ$sp$((Function1)this, (long)v1);
        }

        public int apply$mcIJ$sp(long v1) {
            return Function1.apply$mcIJ$sp$((Function1)this, (long)v1);
        }

        public long apply$mcJJ$sp(long v1) {
            return Function1.apply$mcJJ$sp$((Function1)this, (long)v1);
        }

        public void apply$mcVJ$sp(long v1) {
            Function1.apply$mcVJ$sp$((Function1)this, (long)v1);
        }

        public <A> Function1<A, Object> compose(Function1<A, SimpleFeature> g) {
            return Function1.compose$((Function1)this, g);
        }

        public <A> Function1<SimpleFeature, A> andThen(Function1<Object, A> g) {
            return Function1.andThen$((Function1)this, g);
        }

        public String toString() {
            return Function1.toString$((Function1)this);
        }

        private AccessEvaluator access() {
            return this.access;
        }

        private Map<String, Object> cache() {
            return this.cache;
        }

        public boolean apply(SimpleFeature f) {
            String vis = SecurityUtils.getVisibility(f);
            return vis == null || BoxesRunTime.unboxToBoolean((Object)this.cache().getOrElseUpdate((Object)vis, (Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                boolean bl;
                try {
                    bl = this.access().canAccess(vis);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        bl = false;
                    }
                    throw throwable;
                }
                return bl;
            }));
        }

        public AuthVisibilityCheck(List<String> auths) {
            Function1.$init$((Function1)this);
            this.access = AccessEvaluator.of((Authorizations)Authorizations.of(auths));
            this.cache = (Map)Map$.MODULE$.empty();
        }
    }
}

