/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.converter;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.geotools.data.Query;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.convert.ConverterConfigLoader$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter$;
import org.locationtech.geomesa.jobs.mapreduce.ConverterInputFormat;
import org.locationtech.geomesa.jobs.mapreduce.ConverterInputFormat$;
import org.locationtech.geomesa.spark.SpatialRDD;
import org.locationtech.geomesa.spark.SpatialRDD$;
import org.locationtech.geomesa.spark.SpatialRDDProvider;
import org.locationtech.geomesa.spark.converter.ConverterSpatialRDDProvider$;
import org.locationtech.geomesa.utils.geotools.SftArgResolver$;
import org.locationtech.geomesa.utils.geotools.SftArgs;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeLoader$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u00015\u00111dQ8om\u0016\u0014H/\u001a:Ta\u0006$\u0018.\u00197S\t\u0012\u0003&o\u001c<jI\u0016\u0014(BA\u0002\u0005\u0003%\u0019wN\u001c<feR,'O\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002\u0006\r\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0005\u0013\t9BA\u0001\nTa\u0006$\u0018.\u00197S\t\u0012\u0003&o\u001c<jI\u0016\u0014\bCA\r!\u001b\u0005Q\"BA\u000e\u001d\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tib$\u0001\u0005usB,7/\u00194f\u0015\u0005y\u0012aA2p[&\u0011\u0011E\u0007\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\rC\u0003$\u0001\u0011\u0005A%\u0001\u0004=S:LGO\u0010\u000b\u0002KA\u0011a\u0005A\u0007\u0002\u0005!)\u0001\u0006\u0001C!S\u0005Q1-\u00198Qe>\u001cWm]:\u0015\u0005)j\u0003CA\b,\u0013\ta\u0003CA\u0004C_>dW-\u00198\t\u000b9:\u0003\u0019A\u0018\u0002\rA\f'/Y7t!\u0011\u0001Tg\u000e \u000e\u0003ER!AM\u001a\u0002\tU$\u0018\u000e\u001c\u0006\u0002i\u0005!!.\u0019<b\u0013\t1\u0014GA\u0002NCB\u0004\"\u0001O\u001e\u000f\u0005=I\u0014B\u0001\u001e\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011A(\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i\u0002\u0002CA C\u001b\u0005\u0001%BA!4\u0003\tIw.\u0003\u0002D\u0001\na1+\u001a:jC2L'0\u00192mK\")Q\t\u0001C!\r\u0006\u0019!\u000f\u001a3\u0015\u000b\u001dSU\u000bX0\u0011\u0005UA\u0015BA%\u0005\u0005)\u0019\u0006/\u0019;jC2\u0014F\t\u0012\u0005\u0006\u0017\u0012\u0003\r\u0001T\u0001\u0005G>tg\r\u0005\u0002N'6\taJ\u0003\u0002L\u001f*\u0011\u0001+U\u0001\u0007Q\u0006$wn\u001c9\u000b\u0005IS\u0011AB1qC\u000eDW-\u0003\u0002U\u001d\ni1i\u001c8gS\u001e,(/\u0019;j_:DQA\u0016#A\u0002]\u000b!a]2\u0011\u0005aSV\"A-\u000b\u0005\u0015\t\u0016BA.Z\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u0015qC\t1\u0001^!\u0011AdlN\u001c\n\u0005Yj\u0004\"\u00021E\u0001\u0004\t\u0017!B9vKJL\bC\u00012h\u001b\u0005\u0019'B\u00013f\u0003\u0011!\u0017\r^1\u000b\u0005\u0019T\u0011\u0001C4f_R|w\u000e\\:\n\u0005!\u001c'!B)vKJL\b\"\u00026\u0001\t\u0013Y\u0017\u0001E2p[B,H/Z*gi\u000e{gNZ5h)\ragp \t\u0005\u001f5|\u00170\u0003\u0002o!\t1A+\u001e9mKJ\u0002\"\u0001]<\u000e\u0003ET!A]:\u0002\rMLW\u000e\u001d7f\u0015\t!X/A\u0004gK\u0006$XO]3\u000b\u0005YT\u0011aB8qK:<\u0017n]\u0005\u0003qF\u0014\u0011cU5na2,g)Z1ukJ,G+\u001f9f!\tQX0D\u0001|\u0015\ta8'\u0001\u0003mC:<\u0017B\u0001\u001f|\u0011\u0015q\u0013\u000e1\u0001^\u0011\u0015\u0001\u0017\u000e1\u0001b\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000b\tq\u0002\\8pWV\u00048K\u001a;D_:4\u0017n\u001a\u000b\u0006Y\u0006\u001d\u0011\u0011\u0002\u0005\u0007]\u0005\u0005\u0001\u0019A/\t\r\u0001\f\t\u00011\u0001b\u0011\u001d\ti\u0001\u0001C!\u0003\u001f\tAa]1wKRA\u0011\u0011CA\f\u0003S\ti\u0003E\u0002\u0010\u0003'I1!!\u0006\u0011\u0005\u0011)f.\u001b;\t\u000f\u0015\u000bY\u00011\u0001\u0002\u001aA1\u00111DA\u0010\u0003Gi!!!\b\u000b\u0005\u0015K\u0016\u0002BA\u0011\u0003;\u00111A\u0015#E!\r\u0001\u0018QE\u0005\u0004\u0003O\t(!D*j[BdWMR3biV\u0014X\rC\u0004\u0002,\u0005-\u0001\u0019A/\u0002)]\u0014\u0018\u000e^3ECR\f7\u000b^8sKB\u000b'/Y7t\u0011\u001d\ty#a\u0003A\u0002]\nQb\u001e:ji\u0016$\u0016\u0010]3OC6,waBA\u001a\u0005!\u0005\u0011QG\u0001\u001c\u0007>tg/\u001a:uKJ\u001c\u0006/\u0019;jC2\u0014F\t\u0012)s_ZLG-\u001a:\u0011\u0007\u0019\n9D\u0002\u0004\u0002\u0005!\u0005\u0011\u0011H\n\u0004\u0003oq\u0001bB\u0012\u00028\u0011\u0005\u0011Q\b\u000b\u0003\u0003kA!\"!\u0011\u00028\t\u0007I\u0011AA\"\u00031\u0019uN\u001c<feR,'oS3z+\u0005I\b\u0002CA$\u0003o\u0001\u000b\u0011B=\u0002\u001b\r{gN^3si\u0016\u00148*Z=!\u0011)\tY%a\u000eC\u0002\u0013\u0005\u00111I\u0001\u000f\r\u0016\fG/\u001e:f\u001d\u0006lWmS3z\u0011!\ty%a\u000e!\u0002\u0013I\u0018a\u0004$fCR,(/\u001a(b[\u0016\\U-\u001f\u0011\t\u0015\u0005M\u0013q\u0007b\u0001\n\u0003\t\u0019%A\u0007J]B,HOR5mKN\\U-\u001f\u0005\t\u0003/\n9\u0004)A\u0005s\u0006q\u0011J\u001c9vi\u001aKG.Z:LKf\u0004\u0003BCA.\u0003o\u0011\r\u0011\"\u0001\u0002D\u000511K\u001a;LKfD\u0001\"a\u0018\u00028\u0001\u0006I!_\u0001\b'\u001a$8*Z=!\u0011)\t\u0019'a\u000eC\u0002\u0013\u0005\u00111I\u0001\u000e\u0013:<Wm\u001d;UsB,7*Z=\t\u0011\u0005\u001d\u0014q\u0007Q\u0001\ne\fa\"\u00138hKN$H+\u001f9f\u0017\u0016L\b\u0005")
public class ConverterSpatialRDDProvider
implements SpatialRDDProvider,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static String IngestTypeKey() {
        return ConverterSpatialRDDProvider$.MODULE$.IngestTypeKey();
    }

    public static String SftKey() {
        return ConverterSpatialRDDProvider$.MODULE$.SftKey();
    }

    public static String InputFilesKey() {
        return ConverterSpatialRDDProvider$.MODULE$.InputFilesKey();
    }

    public static String FeatureNameKey() {
        return ConverterSpatialRDDProvider$.MODULE$.FeatureNameKey();
    }

    public static String ConverterKey() {
        return ConverterSpatialRDDProvider$.MODULE$.ConverterKey();
    }

    private Logger logger$lzycompute() {
        ConverterSpatialRDDProvider converterSpatialRDDProvider = this;
        synchronized (converterSpatialRDDProvider) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public boolean canProcess(Map<String, Serializable> params) {
        return (params.containsKey(ConverterSpatialRDDProvider$.MODULE$.ConverterKey()) && params.containsKey(ConverterSpatialRDDProvider$.MODULE$.SftKey()) || params.containsKey(ConverterSpatialRDDProvider$.MODULE$.IngestTypeKey())) && params.containsKey(ConverterSpatialRDDProvider$.MODULE$.InputFilesKey());
    }

    public SpatialRDD rdd(Configuration conf, SparkContext sc, scala.collection.immutable.Map<String, String> params, Query query) {
        Tuple2<SimpleFeatureType, String> tuple2 = this.computeSftConfig(params, query);
        if (tuple2 != null) {
            Tuple2 tuple22;
            SimpleFeatureType sft = (SimpleFeatureType)tuple2._1();
            String converterConf = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)sft, (Object)converterConf);
            SimpleFeatureType sft2 = (SimpleFeatureType)tuple23._1();
            String converterConf2 = (String)tuple23._2();
            ConverterInputFormat$.MODULE$.setConverterConfig(conf, converterConf2);
            ConverterInputFormat$.MODULE$.setSft(conf, sft2);
            Job job = Job.getInstance((Configuration)conf);
            FileInputFormat.setInputPaths((Job)job, (String)((String)params.apply((Object)ConverterSpatialRDDProvider$.MODULE$.InputFilesKey())));
            conf.set("mapreduce.input.fileinputformat.inputdir", job.getConfiguration().get("mapreduce.input.fileinputformat.inputdir"));
            String[] queryProperties = query.getPropertyNames();
            Buffer sftProperties = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(sft2.getAttributeDescriptors()).map((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(AttributeDescriptor x$2) {
                    return x$2.getLocalName();
                }
            }, Buffer$.MODULE$.canBuildFrom());
            if (queryProperties != null && Predef$.MODULE$.refArrayOps((Object[])queryProperties).nonEmpty()) {
                Buffer buffer = sftProperties;
                Seq seq = Predef$.MODULE$.refArrayOps((Object[])queryProperties).toSeq();
                if (buffer == null ? seq != null : !buffer.equals(seq)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Query transform retyping results");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    SimpleFeatureType modifiedSft = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)sft2, (String[])query.getPropertyNames());
                    ConverterInputFormat$.MODULE$.setRetypeSft(conf, modifiedSft);
                }
            }
            if (query.getFilter() != null) {
                Filter filter = query.getFilter();
                IncludeFilter includeFilter = Filter.INCLUDE;
                if (filter == null ? includeFilter != null : !filter.equals(includeFilter)) {
                    ConverterInputFormat$.MODULE$.setFilter(conf, ECQL.toCQL((Filter)query.getFilter()));
                }
            }
            RDD rdd2 = sc.newAPIHadoopRDD(conf, ConverterInputFormat.class, LongWritable.class, SimpleFeature.class);
            return SpatialRDD$.MODULE$.apply(rdd2.map((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SimpleFeature apply(Tuple2<LongWritable, SimpleFeature> x$3) {
                    return (SimpleFeature)x$3._2();
                }
            }, ClassTag$.MODULE$.apply(SimpleFeature.class)), sft2);
        }
        throw new MatchError(tuple2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<SimpleFeatureType, String> computeSftConfig(scala.collection.immutable.Map<String, String> params, Query query) {
        Tuple2 tuple22;
        Tuple2<SimpleFeatureType, String> tuple2 = this.lookupSftConfig(params, query);
        if (tuple2 == null) throw new MatchError(tuple2);
        SimpleFeatureType sft = (SimpleFeatureType)tuple2._1();
        String converterConf = (String)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)sft, (Object)converterConf);
        SimpleFeatureType sft2 = (SimpleFeatureType)tuple23._1();
        String converterConf2 = (String)tuple23._2();
        try {
            SimpleFeatureConverter$.MODULE$.apply(sft2, ConfigFactory.parseString((String)converterConf2)).close();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new IllegalArgumentException("Could not resolve converter", e);
        }
        return new Tuple2((Object)sft2, (Object)converterConf2);
    }

    private Tuple2<SimpleFeatureType, String> lookupSftConfig(scala.collection.immutable.Map<String, String> params, Query query) {
        Either either;
        block6: {
            Tuple2 tuple2;
            block5: {
                SimpleFeatureType s;
                SimpleFeatureType simpleFeatureType;
                block4: {
                    Option option = params.get((Object)ConverterSpatialRDDProvider$.MODULE$.IngestTypeKey());
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    String sftName = (String)some.x();
                    SimpleFeatureType sft = (SimpleFeatureType)SimpleFeatureTypeLoader$.MODULE$.sftForName(sftName).getOrElse((Function0)new scala.Serializable(this, sftName){
                        public static final long serialVersionUID = 0L;
                        private final String sftName$1;

                        public final Nothing$ apply() {
                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not resolve Simple Feature Type by name for ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sftName$1})));
                        }
                        {
                            this.sftName$1 = sftName$1;
                        }
                    });
                    String convertConf = ((Config)ConverterConfigLoader$.MODULE$.confs().getOrElse((Object)sftName, (Function0)new scala.Serializable(this, sftName){
                        public static final long serialVersionUID = 0L;
                        private final String sftName$1;

                        public final Nothing$ apply() {
                            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not resolve Converter by name for ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sftName$1})));
                        }
                        {
                            this.sftName$1 = sftName$1;
                        }
                    })).root().render(ConfigRenderOptions.concise());
                    tuple2 = new Tuple2((Object)sft, (Object)convertConf);
                    break block5;
                }
                String sftName = (String)params.get((Object)ConverterSpatialRDDProvider$.MODULE$.FeatureNameKey()).orElse((Function0)new scala.Serializable(this, query){
                    public static final long serialVersionUID = 0L;
                    private final Query query$1;

                    public final Option<String> apply() {
                        return Option$.MODULE$.apply((Object)this.query$1.getTypeName());
                    }
                    {
                        this.query$1 = query$1;
                    }
                }).orNull(Predef$.MODULE$.$conforms());
                either = SftArgResolver$.MODULE$.getArg((Object)new SftArgs((String)params.apply((Object)ConverterSpatialRDDProvider$.MODULE$.SftKey()), sftName));
                if (!(either instanceof Right)) break block6;
                Right right = (Right)either;
                SimpleFeatureType sft = simpleFeatureType = (s = (SimpleFeatureType)right.b());
                String converterConf = (String)params.apply((Object)ConverterSpatialRDDProvider$.MODULE$.ConverterKey());
                tuple2 = new Tuple2((Object)sft, (Object)converterConf);
            }
            return tuple2;
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable e = (Throwable)left.a();
            throw new IllegalArgumentException("Could not resolve simple feature type", e);
        }
        throw new MatchError((Object)either);
    }

    public void save(RDD<SimpleFeature> rdd2, scala.collection.immutable.Map<String, String> writeDataStoreParams, String writeTypeName) {
        throw new NotImplementedError("Converter provider is read-only");
    }

    public ConverterSpatialRDDProvider() {
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

