/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.converter;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.geotools.data.Query;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.convert.ConverterConfigLoader$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter$;
import org.locationtech.geomesa.jobs.mapreduce.ConverterInputFormat;
import org.locationtech.geomesa.jobs.mapreduce.ConverterInputFormat$;
import org.locationtech.geomesa.spark.SpatialRDD;
import org.locationtech.geomesa.spark.SpatialRDD$;
import org.locationtech.geomesa.spark.SpatialRDDProvider;
import org.locationtech.geomesa.spark.converter.ConverterSpatialRDDProvider$;
import org.locationtech.geomesa.utils.geotools.SftArgResolver$;
import org.locationtech.geomesa.utils.geotools.SftArgs;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeLoader$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u00015\u00111dQ8om\u0016\u0014H/\u001a:Ta\u0006$\u0018.\u00197S\t\u0012\u0003&o\u001c<jI\u0016\u0014(BA\u0002\u0005\u0003%\u0019wN\u001c<feR,'O\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\bO\u0016|W.Z:b\u0015\tI!\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002\u0006\r\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0005\u0013\t9BA\u0001\nTa\u0006$\u0018.\u00197S\t\u0012\u0003&o\u001c<jI\u0016\u0014\bCA\r!\u001b\u0005Q\"BA\u000e\u001d\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tib$\u0001\u0005usB,7/\u00194f\u0015\u0005y\u0012aA2p[&\u0011\u0011E\u0007\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\rC\u0003$\u0001\u0011\u0005A%\u0001\u0004=S:LGO\u0010\u000b\u0002KA\u0011a\u0005A\u0007\u0002\u0005!)\u0001\u0006\u0001C!S\u0005Q1-\u00198Qe>\u001cWm]:\u0015\u0005)j\u0003CA\b,\u0013\ta\u0003CA\u0004C_>dW-\u00198\t\u000b9:\u0003\u0019A\u0018\u0002\rA\f'/Y7ta\t\u0001\u0014\t\u0005\u00032mazT\"\u0001\u001a\u000b\u0005M\"\u0014\u0001B;uS2T\u0011!N\u0001\u0005U\u00064\u0018-\u0003\u00028e\t\u0019Q*\u00199\u0011\u0005ebdBA\b;\u0013\tY\u0004#\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e\u0011!\t\u0001\u0015\t\u0004\u0001\u0005\u0013\tk\u0013\u0011!A\u0001\u0006\u0003\u0019%aA0%cE\u0011Ai\u0012\t\u0003\u001f\u0015K!A\u0012\t\u0003\u000f9{G\u000f[5oOB\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nN\u0001\u0003S>L!\u0001T%\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000b9\u0003A\u0011I(\u0002\u0007I$G\rF\u0003Q'z+\u0007\u000e\u0005\u0002\u0016#&\u0011!\u000b\u0002\u0002\u000b'B\fG/[1m%\u0012#\u0005\"\u0002+N\u0001\u0004)\u0016\u0001B2p]\u001a\u0004\"A\u0016/\u000e\u0003]S!\u0001\u0016-\u000b\u0005eS\u0016A\u00025bI>|\u0007O\u0003\u0002\\\u0015\u00051\u0011\r]1dQ\u0016L!!X,\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015yV\n1\u0001a\u0003\t\u00198\r\u0005\u0002bG6\t!M\u0003\u0002\u00065&\u0011AM\u0019\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006]5\u0003\rA\u001a\t\u0005s\u001dD\u0004(\u0003\u00028}!)\u0011.\u0014a\u0001U\u0006)\u0011/^3ssB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\u0005I\u0006$\u0018M\u0003\u0002p\u0015\u0005Aq-Z8u_>d7/\u0003\u0002rY\n)\u0011+^3ss\")1\u000f\u0001C!i\u0006\u00191O\u001a;\u0015\u000bU\f)!a\u0002\u0011\u0007=1\b0\u0003\u0002x!\t1q\n\u001d;j_:\u00042!_A\u0001\u001b\u0005Q(BA>}\u0003\u0019\u0019\u0018.\u001c9mK*\u0011QP`\u0001\bM\u0016\fG/\u001e:f\u0015\ty(\"A\u0004pa\u0016tw-[:\n\u0007\u0005\r!PA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016DQA\f:A\u0002\u0019Da!!\u0003s\u0001\u0004A\u0014\u0001\u0003;za\u0016t\u0015-\\3\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010\u0005!1/\u0019<f)!\t\t\"a\u0006\u0002*\u00055\u0002cA\b\u0002\u0014%\u0019\u0011Q\u0003\t\u0003\tUs\u0017\u000e\u001e\u0005\b\u001d\u0006-\u0001\u0019AA\r!\u0019\tY\"a\b\u0002$5\u0011\u0011Q\u0004\u0006\u0003\u001d\nLA!!\t\u0002\u001e\t\u0019!\u000b\u0012#\u0011\u0007e\f)#C\u0002\u0002(i\u0014QbU5na2,g)Z1ukJ,\u0007bBA\u0016\u0003\u0017\u0001\rAZ\u0001\u0015oJLG/\u001a#bi\u0006\u001cFo\u001c:f!\u0006\u0014\u0018-\\:\t\u000f\u0005=\u00121\u0002a\u0001q\u0005iqO]5uKRK\b/\u001a(b[\u0016Dq!a\r\u0001\t\u0013\t)$A\u0004m_\u0006$7K\u001a;\u0015\u000ba\f9$!\u000f\t\r9\n\t\u00041\u0001g\u0011\u001d\tI!!\rA\u0002aBq!!\u0010\u0001\t\u0013\ty$A\u0007m_\u0006$7i\u001c8wKJ$XM\u001d\u000b\u0006q\u0005\u0005\u00131\t\u0005\u0007g\u0006m\u0002\u0019\u0001=\t\r9\nY\u00041\u0001g\u000f\u001d\t9E\u0001E\u0001\u0003\u0013\n1dQ8om\u0016\u0014H/\u001a:Ta\u0006$\u0018.\u00197S\t\u0012\u0003&o\u001c<jI\u0016\u0014\bc\u0001\u0014\u0002L\u00191\u0011A\u0001E\u0001\u0003\u001b\u001a2!a\u0013\u000f\u0011\u001d\u0019\u00131\nC\u0001\u0003#\"\"!!\u0013\t\u0015\u0005U\u00131\nb\u0001\n\u0003\t9&\u0001\u0007D_:4XM\u001d;fe.+\u00170\u0006\u0002\u0002ZA!\u00111LA1\u001b\t\tiFC\u0002\u0002`Q\nA\u0001\\1oO&\u0019Q(!\u0018\t\u0013\u0005\u0015\u00141\nQ\u0001\n\u0005e\u0013!D\"p]Z,'\u000f^3s\u0017\u0016L\b\u0005\u0003\u0006\u0002j\u0005-#\u0019!C\u0001\u0003/\naBR3biV\u0014XMT1nK.+\u0017\u0010C\u0005\u0002n\u0005-\u0003\u0015!\u0003\u0002Z\u0005ya)Z1ukJ,g*Y7f\u0017\u0016L\b\u0005\u0003\u0006\u0002r\u0005-#\u0019!C\u0001\u0003/\nQ\"\u00138qkR4\u0015\u000e\\3t\u0017\u0016L\b\"CA;\u0003\u0017\u0002\u000b\u0011BA-\u00039Ie\u000e];u\r&dWm]&fs\u0002B!\"!\u001f\u0002L\t\u0007I\u0011AA,\u0003\u0019\u0019f\r^&fs\"I\u0011QPA&A\u0003%\u0011\u0011L\u0001\b'\u001a$8*Z=!\u0011)\t\t)a\u0013C\u0002\u0013\u0005\u0011qK\u0001\u000e\u0013:<Wm\u001d;UsB,7*Z=\t\u0013\u0005\u0015\u00151\nQ\u0001\n\u0005e\u0013AD%oO\u0016\u001cH\u000fV=qK.+\u0017\u0010\t")
public class ConverterSpatialRDDProvider
implements SpatialRDDProvider,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static String IngestTypeKey() {
        return ConverterSpatialRDDProvider$.MODULE$.IngestTypeKey();
    }

    public static String SftKey() {
        return ConverterSpatialRDDProvider$.MODULE$.SftKey();
    }

    public static String InputFilesKey() {
        return ConverterSpatialRDDProvider$.MODULE$.InputFilesKey();
    }

    public static String FeatureNameKey() {
        return ConverterSpatialRDDProvider$.MODULE$.FeatureNameKey();
    }

    public static String ConverterKey() {
        return ConverterSpatialRDDProvider$.MODULE$.ConverterKey();
    }

    private Logger logger$lzycompute() {
        ConverterSpatialRDDProvider converterSpatialRDDProvider = this;
        synchronized (converterSpatialRDDProvider) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public boolean canProcess(Map<String, ? extends Serializable> params) {
        return (params.containsKey(ConverterSpatialRDDProvider$.MODULE$.ConverterKey()) && params.containsKey(ConverterSpatialRDDProvider$.MODULE$.SftKey()) || params.containsKey(ConverterSpatialRDDProvider$.MODULE$.IngestTypeKey())) && params.containsKey(ConverterSpatialRDDProvider$.MODULE$.InputFilesKey());
    }

    public SpatialRDD rdd(Configuration conf, SparkContext sc, scala.collection.immutable.Map<String, String> params, Query query) {
        SimpleFeatureType sft = this.loadSft(params, query.getTypeName());
        String converterConf = this.loadConverter(sft, params);
        ConverterInputFormat$.MODULE$.setConverterConfig(conf, converterConf);
        ConverterInputFormat$.MODULE$.setSft(conf, sft);
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (String)((String)params.apply((Object)ConverterSpatialRDDProvider$.MODULE$.InputFilesKey())));
        conf.set("mapreduce.input.fileinputformat.inputdir", job.getConfiguration().get("mapreduce.input.fileinputformat.inputdir"));
        String[] queryProperties = query.getPropertyNames();
        Buffer sftProperties = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(AttributeDescriptor x$1) {
                return x$1.getLocalName();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        if (queryProperties != null && Predef$.MODULE$.refArrayOps((Object[])queryProperties).nonEmpty()) {
            Buffer buffer = sftProperties;
            Seq seq = Predef$.MODULE$.refArrayOps((Object[])queryProperties).toSeq();
            if (buffer == null ? seq != null : !buffer.equals(seq)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Query transform retyping results");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                SimpleFeatureType modifiedSft = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)sft, (String[])query.getPropertyNames());
                ConverterInputFormat$.MODULE$.setRetypeSft(conf, modifiedSft);
            }
        }
        if (query.getFilter() != null) {
            Filter filter = query.getFilter();
            IncludeFilter includeFilter = Filter.INCLUDE;
            if (filter == null ? includeFilter != null : !filter.equals(includeFilter)) {
                ConverterInputFormat$.MODULE$.setFilter(conf, ECQL.toCQL((Filter)query.getFilter()));
            }
        }
        RDD rdd2 = sc.newAPIHadoopRDD(conf, ConverterInputFormat.class, LongWritable.class, SimpleFeature.class);
        return SpatialRDD$.MODULE$.apply(rdd2.map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SimpleFeature apply(Tuple2<LongWritable, SimpleFeature> x$2) {
                return (SimpleFeature)x$2._2();
            }
        }, ClassTag$.MODULE$.apply(SimpleFeature.class)), sft);
    }

    public Option<SimpleFeatureType> sft(scala.collection.immutable.Map<String, String> params, String typeName) {
        return Option$.MODULE$.apply((Object)this.loadSft(params, typeName));
    }

    public void save(RDD<SimpleFeature> rdd2, scala.collection.immutable.Map<String, String> writeDataStoreParams, String writeTypeName) {
        throw new NotImplementedError("Converter provider is read-only");
    }

    private SimpleFeatureType loadSft(scala.collection.immutable.Map<String, String> params, String typeName) {
        Option option;
        block6: {
            Either either;
            block7: {
                SimpleFeatureType simpleFeatureType;
                block5: {
                    SimpleFeatureType s;
                    SimpleFeatureType simpleFeatureType2;
                    block4: {
                        option = params.get((Object)ConverterSpatialRDDProvider$.MODULE$.IngestTypeKey());
                        if (!(option instanceof Some)) break block4;
                        Some some = (Some)option;
                        String sftName = (String)some.x();
                        simpleFeatureType = (SimpleFeatureType)SimpleFeatureTypeLoader$.MODULE$.sftForName(sftName).getOrElse((Function0)new scala.Serializable(this, sftName){
                            public static final long serialVersionUID = 0L;
                            private final String sftName$1;

                            public final Nothing$ apply() {
                                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not resolve Simple Feature Type by name for ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sftName$1})));
                            }
                            {
                                this.sftName$1 = sftName$1;
                            }
                        });
                        break block5;
                    }
                    if (!None$.MODULE$.equals(option)) break block6;
                    String sftName = (String)params.get((Object)ConverterSpatialRDDProvider$.MODULE$.FeatureNameKey()).orElse((Function0)new scala.Serializable(this, typeName){
                        public static final long serialVersionUID = 0L;
                        private final String typeName$1;

                        public final Option<String> apply() {
                            return Option$.MODULE$.apply((Object)this.typeName$1);
                        }
                        {
                            this.typeName$1 = typeName$1;
                        }
                    }).orNull(Predef$.MODULE$.$conforms());
                    either = SftArgResolver$.MODULE$.getArg((Object)new SftArgs((String)params.apply((Object)ConverterSpatialRDDProvider$.MODULE$.SftKey()), sftName));
                    if (!(either instanceof Right)) break block7;
                    Right right = (Right)either;
                    simpleFeatureType = simpleFeatureType2 = (s = (SimpleFeatureType)right.b());
                }
                return simpleFeatureType;
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable e = (Throwable)left.a();
                throw new IllegalArgumentException("Could not resolve simple feature type", e);
            }
            throw new MatchError((Object)either);
        }
        throw new MatchError((Object)option);
    }

    private String loadConverter(SimpleFeatureType sft, scala.collection.immutable.Map<String, String> params) {
        Option option;
        block11: {
            String string;
            block10: {
                block9: {
                    option = params.get((Object)ConverterSpatialRDDProvider$.MODULE$.IngestTypeKey());
                    if (!(option instanceof Some)) break block9;
                    Some some = (Some)option;
                    String sftName = (String)some.x();
                    Config config = (Config)ConverterConfigLoader$.MODULE$.confs().getOrElse((Object)sftName, (Function0)new scala.Serializable(this, sftName){
                        public static final long serialVersionUID = 0L;
                        private final String sftName$2;

                        public final Nothing$ apply() {
                            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not resolve Converter by name for ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sftName$2})));
                        }
                        {
                            this.sftName$2 = sftName$2;
                        }
                    });
                    try {
                        SimpleFeatureConverter$.MODULE$.apply(sft, config).close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                        if (option2.isEmpty()) {
                            throw throwable;
                        }
                        Throwable e = (Throwable)option2.get();
                        throw new IllegalArgumentException("Could not resolve converter", e);
                    }
                    string = config.root().render(ConfigRenderOptions.concise());
                    break block10;
                }
                if (!None$.MODULE$.equals(option)) break block11;
                String config = (String)params.apply((Object)ConverterSpatialRDDProvider$.MODULE$.ConverterKey());
                try {
                    SimpleFeatureConverter$.MODULE$.apply(sft, ConfigFactory.parseString((String)config)).close();
                    string = config;
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    Option option3 = NonFatal$.MODULE$.unapply(throwable3);
                    if (option3.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option3.get();
                    throw new IllegalArgumentException("Could not resolve converter", e);
                }
            }
            return string;
        }
        throw new MatchError((Object)option);
    }

    public ConverterSpatialRDDProvider() {
        SpatialRDDProvider.class.$init$((SpatialRDDProvider)this);
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

