/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.converter;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.geotools.data.Query;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.convert.ConverterConfigLoader$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter$;
import org.locationtech.geomesa.jobs.mapreduce.ConverterInputFormat;
import org.locationtech.geomesa.jobs.mapreduce.ConverterInputFormat$;
import org.locationtech.geomesa.spark.SpatialRDD;
import org.locationtech.geomesa.spark.SpatialRDD$;
import org.locationtech.geomesa.spark.SpatialRDDProvider;
import org.locationtech.geomesa.spark.converter.ConverterSpatialRDDProvider$;
import org.locationtech.geomesa.utils.geotools.SftArgResolver$;
import org.locationtech.geomesa.utils.geotools.SftArgs;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeLoader$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u000b\u0017\u0001\u0005BQA\u000e\u0001\u0005\u0002]BQA\u000f\u0001\u0005BmBQa\u0019\u0001\u0005B\u0011Dq!a\u0004\u0001\t\u0003\n\t\u0002C\u0004\u00024\u0001!\t%!\u000e\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z!9\u0011q\f\u0001\u0005\n\u0005\u0005taBA4-!\u0005\u0011\u0011\u000e\u0004\u0007+YA\t!a\u001b\t\rYJA\u0011AA7\u0011%\ty'\u0003b\u0001\n\u0003\t\t\b\u0003\u0005\u0002~%\u0001\u000b\u0011BA:\u0011%\ty(\u0003b\u0001\n\u0003\t\t\b\u0003\u0005\u0002\u0002&\u0001\u000b\u0011BA:\u0011%\t\u0019)\u0003b\u0001\n\u0003\t\t\b\u0003\u0005\u0002\u0006&\u0001\u000b\u0011BA:\u0011%\t9)\u0003b\u0001\n\u0003\t\t\b\u0003\u0005\u0002\n&\u0001\u000b\u0011BA:\u0011%\tY)\u0003b\u0001\n\u0003\t\t\b\u0003\u0005\u0002\u000e&\u0001\u000b\u0011BA:\u0005m\u0019uN\u001c<feR,'o\u00159bi&\fGN\u0015#E!J|g/\u001b3fe*\u0011q\u0003G\u0001\nG>tg/\u001a:uKJT!!\u0007\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005ma\u0012aB4f_6,7/\u0019\u0006\u0003;y\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aH\u0001\u0004_J<7\u0001A\n\u0005\u0001\tBC\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S)j\u0011\u0001G\u0005\u0003Wa\u0011!c\u00159bi&\fGN\u0015#E!J|g/\u001b3feB\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003cI\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002g\u0005\u00191m\\7\n\u0005Ur#a\u0003'bufdunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u001d\u0011\u0005e\u0002Q\"\u0001\f\u0002\u0015\r\fg\u000e\u0015:pG\u0016\u001c8\u000f\u0006\u0002=\u007fA\u00111%P\u0005\u0003}\u0011\u0012qAQ8pY\u0016\fg\u000eC\u0003A\u0005\u0001\u0007\u0011)\u0001\u0004qCJ\fWn\u001d\u0019\u0003\u0005^\u0003Ba\u0011%K+6\tAI\u0003\u0002F\r\u0006!Q\u000f^5m\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013#\u0003\u00075\u000b\u0007\u000f\u0005\u0002L%:\u0011A\n\u0015\t\u0003\u001b\u0012j\u0011A\u0014\u0006\u0003\u001f\u0002\na\u0001\u0010:p_Rt\u0014BA)%\u0003\u0019\u0001&/\u001a3fM&\u00111\u000b\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E#\u0003C\u0001,X\u0019\u0001!\u0011\u0002W \u0002\u0002\u0003\u0005)\u0011A-\u0003\u0007}#\u0013'\u0005\u0002[;B\u00111eW\u0005\u00039\u0012\u0012qAT8uQ&tw\r\u0005\u0002_C6\tqL\u0003\u0002a\r\u0006\u0011\u0011n\\\u0005\u0003E~\u0013AbU3sS\u0006d\u0017N_1cY\u0016\f1A\u001d3e)\u0015)\u0007n\u001d>~!\tIc-\u0003\u0002h1\tQ1\u000b]1uS\u0006d'\u000b\u0012#\t\u000b%\u001c\u0001\u0019\u00016\u0002\t\r|gN\u001a\t\u0003WFl\u0011\u0001\u001c\u0006\u0003S6T!A\\8\u0002\r!\fGm\\8q\u0015\t\u0001h$\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003e2\u0014QbQ8oM&<WO]1uS>t\u0007\"\u0002;\u0004\u0001\u0004)\u0018AA:d!\t1\b0D\u0001x\u0015\tIr.\u0003\u0002zo\na1\u000b]1sW\u000e{g\u000e^3yi\")\u0001i\u0001a\u0001wB!1\n &K\u0013\tIE\u000bC\u0003\u007f\u0007\u0001\u0007q0A\u0003rk\u0016\u0014\u0018\u0010\u0005\u0003\u0002\u0002\u0005-QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\t\u0011\fG/\u0019\u0006\u0004\u0003\u0013q\u0012\u0001C4f_R|w\u000e\\:\n\t\u00055\u00111\u0001\u0002\u0006#V,'/_\u0001\u0004g\u001a$HCBA\n\u0003[\ty\u0003E\u0003$\u0003+\tI\"C\u0002\u0002\u0018\u0011\u0012aa\u00149uS>t\u0007\u0003BA\u000e\u0003Si!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0007g&l\u0007\u000f\\3\u000b\t\u0005\r\u0012QE\u0001\bM\u0016\fG/\u001e:f\u0015\r\t9CH\u0001\b_B,gnZ5t\u0013\u0011\tY#!\b\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X\rC\u0003A\t\u0001\u00071\u0010\u0003\u0004\u00022\u0011\u0001\rAS\u0001\tif\u0004XMT1nK\u0006!1/\u0019<f)!\t9$!\u0010\u0002P\u0005M\u0003cA\u0012\u0002:%\u0019\u00111\b\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0007G\u0016\u0001\r!a\u0010\u0011\r\u0005\u0005\u0013QIA%\u001b\t\t\u0019E\u0003\u0002do&!\u0011qIA\"\u0005\r\u0011F\t\u0012\t\u0005\u00037\tY%\u0003\u0003\u0002N\u0005u!!D*j[BdWMR3biV\u0014X\r\u0003\u0004\u0002R\u0015\u0001\ra_\u0001\u0015oJLG/\u001a#bi\u0006\u001cFo\u001c:f!\u0006\u0014\u0018-\\:\t\r\u0005US\u00011\u0001K\u000359(/\u001b;f)f\u0004XMT1nK\u00069An\\1e'\u001a$HCBA\r\u00037\ni\u0006C\u0003A\r\u0001\u00071\u0010\u0003\u0004\u00022\u0019\u0001\rAS\u0001\u000eY>\fGmQ8om\u0016\u0014H/\u001a:\u0015\u000b)\u000b\u0019'!\u001a\t\u000f\u0005=q\u00011\u0001\u0002\u001a!)\u0001i\u0002a\u0001w\u0006Y2i\u001c8wKJ$XM]*qCRL\u0017\r\u001c*E\tB\u0013xN^5eKJ\u0004\"!O\u0005\u0014\u0005%\u0011CCAA5\u00031\u0019uN\u001c<feR,'oS3z+\t\t\u0019\b\u0005\u0003\u0002v\u0005mTBAA<\u0015\r\tIHR\u0001\u0005Y\u0006tw-C\u0002T\u0003o\nQbQ8om\u0016\u0014H/\u001a:LKf\u0004\u0013A\u0004$fCR,(/\u001a(b[\u0016\\U-_\u0001\u0010\r\u0016\fG/\u001e:f\u001d\u0006lWmS3zA\u0005i\u0011J\u001c9vi\u001aKG.Z:LKf\fa\"\u00138qkR4\u0015\u000e\\3t\u0017\u0016L\b%\u0001\u0004TMR\\U-_\u0001\b'\u001a$8*Z=!\u00035IenZ3tiRK\b/Z&fs\u0006q\u0011J\\4fgR$\u0016\u0010]3LKf\u0004\u0003")
public class ConverterSpatialRDDProvider
implements SpatialRDDProvider,
LazyLogging {
    private Logger logger;
    private volatile boolean bitmap$0;

    public static String IngestTypeKey() {
        return ConverterSpatialRDDProvider$.MODULE$.IngestTypeKey();
    }

    public static String SftKey() {
        return ConverterSpatialRDDProvider$.MODULE$.SftKey();
    }

    public static String InputFilesKey() {
        return ConverterSpatialRDDProvider$.MODULE$.InputFilesKey();
    }

    public static String FeatureNameKey() {
        return ConverterSpatialRDDProvider$.MODULE$.FeatureNameKey();
    }

    public static String ConverterKey() {
        return ConverterSpatialRDDProvider$.MODULE$.ConverterKey();
    }

    private Logger logger$lzycompute() {
        ConverterSpatialRDDProvider converterSpatialRDDProvider = this;
        synchronized (converterSpatialRDDProvider) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public boolean canProcess(Map<String, ? extends Serializable> params) {
        return (params.containsKey(ConverterSpatialRDDProvider$.MODULE$.ConverterKey()) && params.containsKey(ConverterSpatialRDDProvider$.MODULE$.SftKey()) || params.containsKey(ConverterSpatialRDDProvider$.MODULE$.IngestTypeKey())) && params.containsKey(ConverterSpatialRDDProvider$.MODULE$.InputFilesKey());
    }

    public SpatialRDD rdd(Configuration conf, SparkContext sc, scala.collection.immutable.Map<String, String> params, Query query) {
        SimpleFeatureType sft = this.loadSft(params, query.getTypeName());
        String converterConf = this.loadConverter(sft, params);
        ConverterInputFormat$.MODULE$.setConverterConfig(conf, converterConf);
        ConverterInputFormat$.MODULE$.setSft(conf, sft);
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (String)((String)params.apply((Object)ConverterSpatialRDDProvider$.MODULE$.InputFilesKey())));
        conf.set("mapreduce.input.fileinputformat.inputdir", job.getConfiguration().get("mapreduce.input.fileinputformat.inputdir"));
        String[] queryProperties = query.getPropertyNames();
        Buffer sftProperties = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getLocalName(), Buffer$.MODULE$.canBuildFrom());
        if (queryProperties != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queryProperties)).nonEmpty()) {
            Buffer buffer = sftProperties;
            Seq seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queryProperties)).toSeq();
            if (buffer == null ? seq != null : !buffer.equals(seq)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Query transform retyping results");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                SimpleFeatureType modifiedSft = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)sft, (String[])query.getPropertyNames());
                ConverterInputFormat$.MODULE$.setRetypeSft(conf, modifiedSft);
            }
        }
        if (query.getFilter() != null) {
            Filter filter = query.getFilter();
            IncludeFilter includeFilter = Filter.INCLUDE;
            if (filter == null ? includeFilter != null : !filter.equals(includeFilter)) {
                ConverterInputFormat$.MODULE$.setFilter(conf, ECQL.toCQL((Filter)query.getFilter()));
            }
        }
        RDD rdd = sc.newAPIHadoopRDD(conf, ConverterInputFormat.class, LongWritable.class, SimpleFeature.class);
        return SpatialRDD$.MODULE$.apply(rdd.map((Function1 & Serializable & scala.Serializable)x$2 -> (SimpleFeature)x$2._2(), ClassTag$.MODULE$.apply(SimpleFeature.class)), sft);
    }

    public Option<SimpleFeatureType> sft(scala.collection.immutable.Map<String, String> params, String typeName) {
        return Option$.MODULE$.apply((Object)this.loadSft(params, typeName));
    }

    public void save(RDD<SimpleFeature> rdd, scala.collection.immutable.Map<String, String> writeDataStoreParams, String writeTypeName) {
        throw new NotImplementedError("Converter provider is read-only");
    }

    private SimpleFeatureType loadSft(scala.collection.immutable.Map<String, String> params, String typeName) {
        SimpleFeatureType simpleFeatureType;
        Option option = params.get((Object)ConverterSpatialRDDProvider$.MODULE$.IngestTypeKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            String sftName = (String)some.value();
            simpleFeatureType = (SimpleFeatureType)SimpleFeatureTypeLoader$.MODULE$.sftForName(sftName).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(51).append("Could not resolve Simple Feature Type by name for ").append(sftName).append(".").toString());
            });
        } else if (None$.MODULE$.equals(option)) {
            SimpleFeatureType s;
            String sftName = (String)params.get((Object)ConverterSpatialRDDProvider$.MODULE$.FeatureNameKey()).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)typeName)).orNull(Predef$.MODULE$.$conforms());
            Either either = SftArgResolver$.MODULE$.getArg((Object)new SftArgs((String)params.apply((Object)ConverterSpatialRDDProvider$.MODULE$.SftKey()), sftName));
            if (!(either instanceof Right)) {
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Throwable e = (Throwable)left.value();
                    throw new IllegalArgumentException("Could not resolve simple feature type", e);
                }
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            SimpleFeatureType simpleFeatureType2 = s = (SimpleFeatureType)right.value();
            simpleFeatureType = simpleFeatureType2;
        } else {
            throw new MatchError((Object)option);
        }
        return simpleFeatureType;
    }

    private String loadConverter(SimpleFeatureType sft, scala.collection.immutable.Map<String, String> params) {
        String string;
        Option option = params.get((Object)ConverterSpatialRDDProvider$.MODULE$.IngestTypeKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            String sftName = (String)some.value();
            Config config = (Config)ConverterConfigLoader$.MODULE$.confs().getOrElse((Object)sftName, (Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception(new StringBuilder(41).append("Could not resolve Converter by name for ").append(sftName).append(".").toString());
            });
            try {
                SimpleFeatureConverter$.MODULE$.apply(sft, config).close();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (!option2.isEmpty()) {
                    Throwable e = (Throwable)option2.get();
                    throw new IllegalArgumentException("Could not resolve converter", e);
                }
                throw throwable;
            }
            string = config.root().render(ConfigRenderOptions.concise());
        } else if (None$.MODULE$.equals(option)) {
            String config = (String)params.apply((Object)ConverterSpatialRDDProvider$.MODULE$.ConverterKey());
            try {
                SimpleFeatureConverter$.MODULE$.apply(sft, ConfigFactory.parseString((String)config)).close();
            }
            catch (Throwable throwable) {
                Throwable throwable3 = throwable;
                Option option3 = NonFatal$.MODULE$.unapply(throwable3);
                if (!option3.isEmpty()) {
                    Throwable e = (Throwable)option3.get();
                    throw new IllegalArgumentException("Could not resolve converter", e);
                }
                throw throwable;
            }
            string = config;
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    public ConverterSpatialRDDProvider() {
        SpatialRDDProvider.$init$((SpatialRDDProvider)this);
        LazyLogging.$init$((LazyLogging)this);
    }
}

