/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.converter;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.convert.ConverterConfigLoader$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter$;
import org.locationtech.geomesa.jobs.mapreduce.ConverterInputFormat;
import org.locationtech.geomesa.jobs.mapreduce.ConverterInputFormat$;
import org.locationtech.geomesa.spark.SpatialRDD;
import org.locationtech.geomesa.spark.SpatialRDD$;
import org.locationtech.geomesa.spark.SpatialRDDProvider;
import org.locationtech.geomesa.spark.converter.ConverterSpatialRDDProvider$;
import org.locationtech.geomesa.utils.geotools.SftArgResolver$;
import org.locationtech.geomesa.utils.geotools.SftArgs;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeLoader$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u000b\u0017\u0001\u0005BQA\u000e\u0001\u0005\u0002]BQA\u000f\u0001\u0005BmBQa\u0019\u0001\u0005B\u0011Dq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u00024\u0001!\t%!\u000e\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z!9\u0011q\f\u0001\u0005\n\u0005\u0005taBA4-!\u0005\u0011\u0011\u000e\u0004\u0007+YA\t!a\u001b\t\rYJA\u0011AA7\u0011%\ty'\u0003b\u0001\n\u0003\t\t\b\u0003\u0005\u0002~%\u0001\u000b\u0011BA:\u0011%\ty(\u0003b\u0001\n\u0003\t\t\b\u0003\u0005\u0002\u0002&\u0001\u000b\u0011BA:\u0011%\t\u0019)\u0003b\u0001\n\u0003\t\t\b\u0003\u0005\u0002\u0006&\u0001\u000b\u0011BA:\u0011%\t9)\u0003b\u0001\n\u0003\t\t\b\u0003\u0005\u0002\n&\u0001\u000b\u0011BA:\u0011%\tY)\u0003b\u0001\n\u0003\t\t\b\u0003\u0005\u0002\u000e&\u0001\u000b\u0011BA:\u0005m\u0019uN\u001c<feR,'o\u00159bi&\fGN\u0015#E!J|g/\u001b3fe*\u0011q\u0003G\u0001\nG>tg/\u001a:uKJT!!\u0007\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005ma\u0012aB4f_6,7/\u0019\u0006\u0003;y\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aH\u0001\u0004_J<7\u0001A\n\u0005\u0001\tBC\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S)j\u0011\u0001G\u0005\u0003Wa\u0011!c\u00159bi&\fGN\u0015#E!J|g/\u001b3feB\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003cI\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002g\u0005\u00191m\\7\n\u0005Ur#a\u0003'bufdunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u001d\u0011\u0005e\u0002Q\"\u0001\f\u0002\u0015\r\fg\u000e\u0015:pG\u0016\u001c8\u000f\u0006\u0002=\u007fA\u00111%P\u0005\u0003}\u0011\u0012qAQ8pY\u0016\fg\u000eC\u0003A\u0005\u0001\u0007\u0011)\u0001\u0004qCJ\fWn\u001d\u0019\u0003\u0005^\u0003Ba\u0011%K+6\tAI\u0003\u0002F\r\u0006!Q\u000f^5m\u0015\u00059\u0015\u0001\u00026bm\u0006L!!\u0013#\u0003\u00075\u000b\u0007\u000f\u0005\u0002L%:\u0011A\n\u0015\t\u0003\u001b\u0012j\u0011A\u0014\u0006\u0003\u001f\u0002\na\u0001\u0010:p_Rt\u0014BA)%\u0003\u0019\u0001&/\u001a3fM&\u00111\u000b\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005E#\u0003C\u0001,X\u0019\u0001!\u0011\u0002W \u0002\u0002\u0003\u0005)\u0011A-\u0003\u0007}#\u0013'\u0005\u0002[;B\u00111eW\u0005\u00039\u0012\u0012qAT8uQ&tw\r\u0005\u0002_C6\tqL\u0003\u0002a\r\u0006\u0011\u0011n\\\u0005\u0003E~\u0013AbU3sS\u0006d\u0017N_1cY\u0016\f1A\u001d3e)\u0015)\u0007n\u001d>~!\tIc-\u0003\u0002h1\tQ1\u000b]1uS\u0006d'\u000b\u0012#\t\u000b%\u001c\u0001\u0019\u00016\u0002\t\r|gN\u001a\t\u0003WFl\u0011\u0001\u001c\u0006\u0003S6T!A\\8\u0002\r!\fGm\\8q\u0015\t\u0001h$\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003e2\u0014QbQ8oM&<WO]1uS>t\u0007\"\u0002;\u0004\u0001\u0004)\u0018AA:d!\t1\b0D\u0001x\u0015\tIr.\u0003\u0002zo\na1\u000b]1sW\u000e{g\u000e^3yi\")\u0001i\u0001a\u0001wB!1\n &K\u0013\tIE\u000bC\u0003\u007f\u0007\u0001\u0007q0A\u0003rk\u0016\u0014\u0018\u0010\u0005\u0003\u0002\u0002\u0005=QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\t\u0011\fG/\u0019\u0006\u0005\u0003\u0013\tY!A\u0002ba&T1!!\u0004\u001f\u0003!9Wm\u001c;p_2\u001c\u0018\u0002BA\t\u0003\u0007\u0011Q!U;fef\f1a\u001d4u)\u0019\t9\"!\f\u00020A)1%!\u0007\u0002\u001e%\u0019\u00111\u0004\u0013\u0003\r=\u0003H/[8o!\u0011\ty\"!\u000b\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\taa]5na2,'\u0002BA\u0014\u0003\u000f\tqAZ3biV\u0014X-\u0003\u0003\u0002,\u0005\u0005\"!E*j[BdWMR3biV\u0014X\rV=qK\")\u0001\t\u0002a\u0001w\"1\u0011\u0011\u0007\u0003A\u0002)\u000b\u0001\u0002^=qK:\u000bW.Z\u0001\u0005g\u00064X\r\u0006\u0005\u00028\u0005u\u0012qJA*!\r\u0019\u0013\u0011H\u0005\u0004\u0003w!#\u0001B+oSRDaaY\u0003A\u0002\u0005}\u0002CBA!\u0003\u000b\nI%\u0004\u0002\u0002D)\u00111m^\u0005\u0005\u0003\u000f\n\u0019EA\u0002S\t\u0012\u0003B!a\b\u0002L%!\u0011QJA\u0011\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\"1\u0011\u0011K\u0003A\u0002m\fAc\u001e:ji\u0016$\u0015\r^1Ti>\u0014X\rU1sC6\u001c\bBBA+\u000b\u0001\u0007!*A\u0007xe&$X\rV=qK:\u000bW.Z\u0001\bY>\fGm\u00154u)\u0019\ti\"a\u0017\u0002^!)\u0001I\u0002a\u0001w\"1\u0011\u0011\u0007\u0004A\u0002)\u000bQ\u0002\\8bI\u000e{gN^3si\u0016\u0014H#\u0002&\u0002d\u0005\u0015\u0004bBA\n\u000f\u0001\u0007\u0011Q\u0004\u0005\u0006\u0001\u001e\u0001\ra_\u0001\u001c\u0007>tg/\u001a:uKJ\u001c\u0006/\u0019;jC2\u0014F\t\u0012)s_ZLG-\u001a:\u0011\u0005eJ1CA\u0005#)\t\tI'\u0001\u0007D_:4XM\u001d;fe.+\u00170\u0006\u0002\u0002tA!\u0011QOA>\u001b\t\t9HC\u0002\u0002z\u0019\u000bA\u0001\\1oO&\u00191+a\u001e\u0002\u001b\r{gN^3si\u0016\u00148*Z=!\u000391U-\u0019;ve\u0016t\u0015-\\3LKf\fqBR3biV\u0014XMT1nK.+\u0017\u0010I\u0001\u000e\u0013:\u0004X\u000f\u001e$jY\u0016\u001c8*Z=\u0002\u001d%s\u0007/\u001e;GS2,7oS3zA\u000511K\u001a;LKf\fqa\u00154u\u0017\u0016L\b%A\u0007J]\u001e,7\u000f\u001e+za\u0016\\U-_\u0001\u000f\u0013:<Wm\u001d;UsB,7*Z=!\u0001")
public class ConverterSpatialRDDProvider
implements SpatialRDDProvider,
LazyLogging {
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static String IngestTypeKey() {
        return ConverterSpatialRDDProvider$.MODULE$.IngestTypeKey();
    }

    public static String SftKey() {
        return ConverterSpatialRDDProvider$.MODULE$.SftKey();
    }

    public static String InputFilesKey() {
        return ConverterSpatialRDDProvider$.MODULE$.InputFilesKey();
    }

    public static String FeatureNameKey() {
        return ConverterSpatialRDDProvider$.MODULE$.FeatureNameKey();
    }

    public static String ConverterKey() {
        return ConverterSpatialRDDProvider$.MODULE$.ConverterKey();
    }

    private Logger logger$lzycompute() {
        ConverterSpatialRDDProvider converterSpatialRDDProvider = this;
        synchronized (converterSpatialRDDProvider) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public boolean canProcess(Map<String, ? extends Serializable> params) {
        return (params.containsKey(ConverterSpatialRDDProvider$.MODULE$.ConverterKey()) && params.containsKey(ConverterSpatialRDDProvider$.MODULE$.SftKey()) || params.containsKey(ConverterSpatialRDDProvider$.MODULE$.IngestTypeKey())) && params.containsKey(ConverterSpatialRDDProvider$.MODULE$.InputFilesKey());
    }

    public SpatialRDD rdd(Configuration conf, SparkContext sc, scala.collection.immutable.Map<String, String> params, Query query) {
        SimpleFeatureType sft = this.loadSft(params, query.getTypeName());
        String converterConf = this.loadConverter(sft, params);
        ConverterInputFormat$.MODULE$.setConverterConfig(conf, converterConf);
        ConverterInputFormat$.MODULE$.setSft(conf, sft);
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (String)((String)params.apply((Object)ConverterSpatialRDDProvider$.MODULE$.InputFilesKey())));
        conf.set("mapreduce.input.fileinputformat.inputdir", job.getConfiguration().get("mapreduce.input.fileinputformat.inputdir"));
        String[] queryProperties = query.getPropertyNames();
        Buffer sftProperties = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getLocalName(), Buffer$.MODULE$.canBuildFrom());
        if (queryProperties != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queryProperties)).nonEmpty()) {
            Buffer buffer = sftProperties;
            Seq seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queryProperties)).toSeq();
            if (buffer == null ? seq != null : !buffer.equals(seq)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Query transform retyping results");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                SimpleFeatureType modifiedSft = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)sft, (String[])query.getPropertyNames());
                ConverterInputFormat$.MODULE$.setRetypeSft(conf, modifiedSft);
            }
        }
        if (query.getFilter() != null) {
            Filter filter = query.getFilter();
            IncludeFilter includeFilter = Filter.INCLUDE;
            if (filter == null ? includeFilter != null : !filter.equals(includeFilter)) {
                ConverterInputFormat$.MODULE$.setFilter(conf, ECQL.toCQL((Filter)query.getFilter()));
            }
        }
        RDD rdd = sc.newAPIHadoopRDD(conf, ConverterInputFormat.class, LongWritable.class, SimpleFeature.class);
        return SpatialRDD$.MODULE$.apply(rdd.map((Function1 & Serializable & scala.Serializable)x$2 -> (SimpleFeature)x$2._2(), ClassTag$.MODULE$.apply(SimpleFeature.class)), sft);
    }

    public Option<SimpleFeatureType> sft(scala.collection.immutable.Map<String, String> params, String typeName) {
        return Option$.MODULE$.apply((Object)this.loadSft(params, typeName));
    }

    public void save(RDD<SimpleFeature> rdd, scala.collection.immutable.Map<String, String> writeDataStoreParams, String writeTypeName) {
        throw new UnsupportedOperationException("Converter provider is read-only");
    }

    private SimpleFeatureType loadSft(scala.collection.immutable.Map<String, String> params, String typeName) {
        Option option = params.get((Object)ConverterSpatialRDDProvider$.MODULE$.IngestTypeKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            String sftName = (String)some.value();
            return (SimpleFeatureType)SimpleFeatureTypeLoader$.MODULE$.sftForName(sftName).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException(new StringBuilder(51).append("Could not resolve Simple Feature Type by name for ").append(sftName).append(".").toString());
            });
        }
        if (None$.MODULE$.equals(option)) {
            String sftName = (String)params.get((Object)ConverterSpatialRDDProvider$.MODULE$.FeatureNameKey()).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)typeName)).orNull(Predef$.MODULE$.$conforms());
            Either either = SftArgResolver$.MODULE$.getArg((Object)new SftArgs((String)params.apply((Object)ConverterSpatialRDDProvider$.MODULE$.SftKey()), sftName));
            if (either instanceof Right) {
                Right right = (Right)either;
                SimpleFeatureType s = (SimpleFeatureType)right.value();
                return s;
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable e = (Throwable)left.value();
                throw new IllegalArgumentException("Could not resolve simple feature type", e);
            }
            throw new MatchError((Object)either);
        }
        throw new MatchError((Object)option);
    }

    private String loadConverter(SimpleFeatureType sft, scala.collection.immutable.Map<String, String> params) {
        Option option = params.get((Object)ConverterSpatialRDDProvider$.MODULE$.IngestTypeKey());
        if (option instanceof Some) {
            Some some = (Some)option;
            String sftName = (String)some.value();
            Config config = (Config)ConverterConfigLoader$.MODULE$.confs().getOrElse((Object)sftName, (Function0 & Serializable & scala.Serializable)() -> {
                throw new Exception(new StringBuilder(41).append("Could not resolve Converter by name for ").append(sftName).append(".").toString());
            });
            try {
                SimpleFeatureConverter$.MODULE$.apply(sft, config).close();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (!option2.isEmpty()) {
                    Throwable e = (Throwable)option2.get();
                    throw new IllegalArgumentException("Could not resolve converter", e);
                }
                throw throwable;
            }
            return config.root().render(ConfigRenderOptions.concise());
        }
        if (None$.MODULE$.equals(option)) {
            String config = (String)params.apply((Object)ConverterSpatialRDDProvider$.MODULE$.ConverterKey());
            try {
                SimpleFeatureConverter$.MODULE$.apply(sft, ConfigFactory.parseString((String)config)).close();
            }
            catch (Throwable throwable) {
                Throwable throwable3 = throwable;
                Option option3 = NonFatal$.MODULE$.unapply(throwable3);
                if (!option3.isEmpty()) {
                    Throwable e = (Throwable)option3.get();
                    throw new IllegalArgumentException("Could not resolve converter", e);
                }
                throw throwable;
            }
            return config;
        }
        throw new MatchError((Object)option);
    }

    public ConverterSpatialRDDProvider() {
        SpatialRDDProvider.$init$((SpatialRDDProvider)this);
        LazyLogging.$init$((LazyLogging)this);
    }
}

