/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.geotools;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.locationtech.geomesa.spark.CaseInsensitiveMapFix$;
import org.locationtech.geomesa.spark.SpatialRDD;
import org.locationtech.geomesa.spark.SpatialRDD$;
import org.locationtech.geomesa.spark.SpatialRDDProvider;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.io.CloseQuietly$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u00015\u0011!dR3p)>|Gn]*qCRL\u0017\r\u001c*E\tB\u0013xN^5eKJT!a\u0001\u0003\u0002\u0011\u001d,w\u000e^8pYNT!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011aB4f_6,7/\u0019\u0006\u0003\u0013)\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019!\u0002\u0004\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011\u0001B\u0005\u0003/\u0011\u0011!c\u00159bi&\fGN\u0015#E!J|g/\u001b3feB\u0011\u0011\u0004I\u0007\u00025)\u00111\u0004H\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003;y\t\u0001\u0002^=qKN\fg-\u001a\u0006\u0002?\u0005\u00191m\\7\n\u0005\u0005R\"a\u0003'bufdunZ4j]\u001eDQa\t\u0001\u0005\u0002\u0011\na\u0001P5oSRtD#A\u0013\u0011\u0005\u0019\u0002Q\"\u0001\u0002\t\u000b!\u0002A\u0011I\u0015\u0002\u0015\r\fg\u000e\u0015:pG\u0016\u001c8\u000f\u0006\u0002+[A\u0011qbK\u0005\u0003YA\u0011qAQ8pY\u0016\fg\u000eC\u0003/O\u0001\u0007q&\u0001\u0004qCJ\fWn\u001d\t\u0005aU:d(D\u00012\u0015\t\u00114'\u0001\u0003vi&d'\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003mE\u00121!T1q!\tA4H\u0004\u0002\u0010s%\u0011!\bE\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;!A\u0011qHQ\u0007\u0002\u0001*\u0011\u0011iM\u0001\u0003S>L!a\u0011!\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000b\u0015\u0003A\u0011\t$\u0002\u0007I$G\rF\u0003H\u0015Vcv\f\u0005\u0002\u0016\u0011&\u0011\u0011\n\u0002\u0002\u000b'B\fG/[1m%\u0012#\u0005\"B&E\u0001\u0004a\u0015\u0001B2p]\u001a\u0004\"!T*\u000e\u00039S!aS(\u000b\u0005A\u000b\u0016A\u00025bI>|\u0007O\u0003\u0002S\u0015\u00051\u0011\r]1dQ\u0016L!\u0001\u0016(\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u00151F\t1\u0001X\u0003\t\u00198\r\u0005\u0002Y56\t\u0011L\u0003\u0002\u0006#&\u00111,\u0017\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006]\u0011\u0003\r!\u0018\t\u0005qy;t'\u0003\u00027{!)\u0001\r\u0012a\u0001C\u0006)\u0011/^3ssB\u0011!MZ\u0007\u0002G*\u0011A-Z\u0001\u0005I\u0006$\u0018M\u0003\u0002\u0004\u0015%\u0011qm\u0019\u0002\u0006#V,'/\u001f\u0005\u0006S\u0002!\tE[\u0001\u0005g\u00064X\r\u0006\u0003l]z|\bCA\bm\u0013\ti\u0007C\u0001\u0003V]&$\b\"B#i\u0001\u0004y\u0007c\u00019si6\t\u0011O\u0003\u0002F3&\u00111/\u001d\u0002\u0004%\u0012#\u0005CA;}\u001b\u00051(BA<y\u0003\u0019\u0019\u0018.\u001c9mK*\u0011\u0011P_\u0001\bM\u0016\fG/\u001e:f\u0015\tY(\"A\u0004pa\u0016tw-[:\n\u0005u4(!D*j[BdWMR3biV\u0014X\rC\u0003/Q\u0002\u0007Q\f\u0003\u0004\u0002\u0002!\u0004\raN\u0001\tif\u0004XMT1nK\u0002")
public class GeoToolsSpatialRDDProvider
implements SpatialRDDProvider,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        GeoToolsSpatialRDDProvider geoToolsSpatialRDDProvider = this;
        synchronized (geoToolsSpatialRDDProvider) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public boolean canProcess(java.util.Map<String, Serializable> params) {
        return params.containsKey("geotools") && JavaConversions$.MODULE$.asScalaIterator(DataStoreFinder.getAllDataStores()).exists((Function1)new scala.Serializable(this, params){
            public static final long serialVersionUID = 0L;
            private final java.util.Map params$1;

            public final boolean apply(DataStoreFactorySpi x$1) {
                return x$1.canProcess(this.params$1);
            }
            {
                this.params$1 = params$1;
            }
        });
    }

    public SpatialRDD rdd(Configuration conf, SparkContext sc, scala.collection.immutable.Map<String, String> params, Query query) {
        DataStore ds = DataStoreFinder.getDataStore((java.util.Map)CaseInsensitiveMapFix$.MODULE$.mapAsJavaMap(params));
        FeatureReader fr = ds.getFeatureReader(query, Transaction.AUTO_COMMIT);
        SimpleFeatureType sft = (SimpleFeatureType)fr.getFeatureType();
        RDD rdd = sc.parallelize((Seq)SelfClosingIterator$.MODULE$.apply(fr).toList(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(SimpleFeature.class));
        ds.dispose();
        return SpatialRDD$.MODULE$.apply(rdd, sft);
    }

    /*
     * WARNING - void declaration
     */
    public void save(RDD<SimpleFeature> rdd, scala.collection.immutable.Map<String, String> params, String typeName) {
        DataStore ds = DataStoreFinder.getDataStore((java.util.Map)CaseInsensitiveMapFix$.MODULE$.mapAsJavaMap(params));
        try {
            Predef$.MODULE$.require(ds.getSchema(typeName) != null, (Function0)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Feature type must exist before calling save.  Call createSchema on the DataStore first.";
                }
            });
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.dispose();
            throw throwable;
        }
        ds.dispose();
        rdd.foreachPartition((Function1)new scala.Serializable(this, params, typeName){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map params$2;
            private final String typeName$1;

            /*
             * WARNING - void declaration
             */
            public final void apply(Iterator<SimpleFeature> iter) {
                DataStore ds = DataStoreFinder.getDataStore((java.util.Map)CaseInsensitiveMapFix$.MODULE$.mapAsJavaMap((Map)this.params$2));
                FeatureWriter featureWriter = ds.getFeatureWriterAppend(this.typeName$1, Transaction.AUTO_COMMIT);
                try {
                    iter.foreach((Function1)new scala.Serializable(this, featureWriter){
                        public static final long serialVersionUID = 0L;
                        private final FeatureWriter featureWriter$1;

                        public final void apply(SimpleFeature sf) {
                            FeatureUtils$.MODULE$.copyToWriter(this.featureWriter$1, sf, true);
                            this.featureWriter$1.write();
                        }
                        {
                            this.featureWriter$1 = featureWriter$1;
                        }
                    });
                }
                catch (Throwable throwable) {
                    void var2_2;
                    void var3_3;
                    CloseQuietly$.MODULE$.apply((Object)var3_3);
                    var2_2.dispose();
                    throw throwable;
                }
                CloseQuietly$.MODULE$.apply((Object)featureWriter);
                ds.dispose();
            }
            {
                this.params$2 = params$2;
                this.typeName$1 = typeName$1;
            }
        });
    }

    public GeoToolsSpatialRDDProvider() {
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

