/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.jts.udf;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.geojson.GeoJsonWriter;
import org.apache.spark.sql.SQLContext;
import org.locationtech.geomesa.spark.jts.udf.GeometricOutputFunctions$;
import org.locationtech.geomesa.spark.jts.util.GeoHashUtils$;
import org.locationtech.geomesa.spark.jts.util.SQLFunctionHelper$;
import org.locationtech.geomesa.spark.jts.util.WKBUtils$;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

public final class GeometricOutputFunctions$ {
    public static final GeometricOutputFunctions$ MODULE$;
    private final ThreadLocal<GeoJsonWriter> org$locationtech$geomesa$spark$jts$udf$GeometricOutputFunctions$$geomJSON;
    private final Function1<Geometry, byte[]> ST_AsBinary;
    private final Function1<Geometry, String> ST_AsGeoJSON;
    private final Function1<Point, String> ST_AsLatLonText;
    private final Function1<Geometry, String> ST_AsText;
    private final Function2<Geometry, Object, String> ST_GeoHash;
    private final Map<Object, String> outputNames;

    static {
        new GeometricOutputFunctions$();
    }

    public ThreadLocal<GeoJsonWriter> org$locationtech$geomesa$spark$jts$udf$GeometricOutputFunctions$$geomJSON() {
        return this.org$locationtech$geomesa$spark$jts$udf$GeometricOutputFunctions$$geomJSON;
    }

    public Function1<Geometry, byte[]> ST_AsBinary() {
        return this.ST_AsBinary;
    }

    public Function1<Geometry, String> ST_AsGeoJSON() {
        return this.ST_AsGeoJSON;
    }

    public Function1<Point, String> ST_AsLatLonText() {
        return this.ST_AsLatLonText;
    }

    public Function1<Geometry, String> ST_AsText() {
        return this.ST_AsText;
    }

    public Function2<Geometry, Object, String> ST_GeoHash() {
        return this.ST_GeoHash;
    }

    public Map<Object, String> outputNames() {
        return this.outputNames;
    }

    public void registerFunctions(SQLContext sqlContext) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Byte").asType().toTypeConstructor()})));
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator1$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("com.vividsolutions.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator2$1() {
            }
        }
        sqlContext.udf().register((String)this.outputNames().apply(this.ST_AsBinary()), this.ST_AsBinary(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator2$1()));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator3$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("com.vividsolutions.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator4$1() {
            }
        }
        sqlContext.udf().register((String)this.outputNames().apply(this.ST_AsGeoJSON()), this.ST_AsGeoJSON(), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator3$1()), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator4$1()));
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u6 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator5$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("com.vividsolutions.jts.geom.Point").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator6$1() {
            }
        }
        sqlContext.udf().register((String)this.outputNames().apply(this.ST_AsLatLonText()), this.ST_AsLatLonText(), ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator5$1()), ((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator6$1()));
        JavaUniverse $u7 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m7 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u8 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m8 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator7$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator7$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator8$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("com.vividsolutions.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator8$1() {
            }
        }
        sqlContext.udf().register((String)this.outputNames().apply(this.ST_AsText()), this.ST_AsText(), ((TypeTags)$u7).TypeTag().apply((Mirror)$m7, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator7$1()), ((TypeTags)$u8).TypeTag().apply((Mirror)$m8, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator8$1()));
        JavaUniverse $u9 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m9 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u10 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m10 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator9$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator9$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("com.vividsolutions.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator10$1() {
            }
        }
        sqlContext.udf().register((String)this.outputNames().apply(this.ST_GeoHash()), this.ST_GeoHash(), ((TypeTags)$u9).TypeTag().apply((Mirror)$m9, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator9$1()), ((TypeTags)$u10).TypeTag().apply((Mirror)$m10, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricOutputFunctions$$typecreator10$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
    }

    public String org$locationtech$geomesa$spark$jts$udf$GeometricOutputFunctions$$toLatLonString(Point point) {
        Coordinate coordinate = point.getCoordinate();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.latLonFormat(coordinate.y, true), this.latLonFormat(coordinate.x, false)}));
    }

    private String latLonFormat(double value, boolean lat) {
        String string;
        double degrees = RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(value));
        double decimal = value - degrees;
        double minutes = RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(decimal * (double)60));
        double seconds = (decimal * (double)60 - minutes) * (double)60;
        if (lat) {
            double arg$macro$1 = RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(degrees));
            double arg$macro$2 = minutes;
            double arg$macro$3 = seconds;
            string = new StringBuilder().append((Object)new StringOps("%1.0f\u00b0%1.0f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1), BoxesRunTime.boxToDouble((double)arg$macro$2)}))).append((Object)"'").append((Object)new StringOps("%1.3f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3)}))).append((Object)"\"").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{degrees < 0.0 ? "S" : "N"}))).toString();
        } else {
            double arg$macro$4 = RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(degrees));
            double arg$macro$5 = minutes;
            double arg$macro$6 = seconds;
            string = new StringBuilder().append((Object)new StringOps("%1.0f\u00b0%1.0f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$4), BoxesRunTime.boxToDouble((double)arg$macro$5)}))).append((Object)"'").append((Object)new StringOps("%1.3f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$6)}))).append((Object)"\"").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{degrees < 0.0 ? "W" : "E"}))).toString();
        }
        return string;
    }

    private GeometricOutputFunctions$() {
        MODULE$ = this;
        this.org$locationtech$geomesa$spark$jts$udf$GeometricOutputFunctions$$geomJSON = new ThreadLocal<GeoJsonWriter>(){

            /*
             * WARNING - void declaration
             */
            public GeoJsonWriter initialValue() {
                void var1_1;
                GeoJsonWriter writer = new GeoJsonWriter();
                writer.setEncodeCRS(false);
                return var1_1;
            }
        };
        this.ST_AsBinary = SQLFunctionHelper$.MODULE$.nullableUDF(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Geometry geom) {
                return WKBUtils$.MODULE$.write(geom);
            }
        });
        this.ST_AsGeoJSON = SQLFunctionHelper$.MODULE$.nullableUDF(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Geometry geom) {
                return GeometricOutputFunctions$.MODULE$.org$locationtech$geomesa$spark$jts$udf$GeometricOutputFunctions$$geomJSON().get().write(geom);
            }
        });
        this.ST_AsLatLonText = SQLFunctionHelper$.MODULE$.nullableUDF(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Point point) {
                return GeometricOutputFunctions$.MODULE$.org$locationtech$geomesa$spark$jts$udf$GeometricOutputFunctions$$toLatLonString(point);
            }
        });
        this.ST_AsText = SQLFunctionHelper$.MODULE$.nullableUDF(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Geometry geom) {
                return geom.toText();
            }
        });
        this.ST_GeoHash = SQLFunctionHelper$.MODULE$.nullableUDF(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Geometry geom, int prec) {
                return GeoHashUtils$.MODULE$.encode(geom, prec);
            }
        });
        this.outputNames = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.ST_AsBinary()), (Object)"st_asBinary"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.ST_AsGeoJSON()), (Object)"st_asGeoJSON"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.ST_AsLatLonText()), (Object)"st_asLatLonText"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.ST_AsText()), (Object)"st_asText"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.ST_GeoHash()), (Object)"st_geoHash")}));
    }
}

