/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.jts.util;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import org.locationtech.geomesa.spark.jts.util.Bounds;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

public final class GeoHash$ {
    public static final GeoHash$ MODULE$;
    private final int MAX_PRECISION;
    private final Bounds latBounds;
    private final Bounds lonBounds;
    private double org$locationtech$geomesa$spark$jts$util$GeoHash$$latRange;
    private double org$locationtech$geomesa$spark$jts$util$GeoHash$$lonRange;
    private Map<Object, Object> org$locationtech$geomesa$spark$jts$util$GeoHash$$powersOf2Map;
    private Map<Object, Object> latDeltaMap;
    private Map<Object, Object> lonDeltaMap;
    private final double lonMax;
    private final double latMax;
    private final int[] org$locationtech$geomesa$spark$jts$util$GeoHash$$bits;
    private final String base32;
    private final Map<Object, scala.collection.BitSet> org$locationtech$geomesa$spark$jts$util$GeoHash$$characterMap;
    private GeometryFactory latLonGeoFactory;
    private volatile byte bitmap$0;

    static {
        new GeoHash$();
    }

    private double org$locationtech$geomesa$spark$jts$util$GeoHash$$latRange$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.org$locationtech$geomesa$spark$jts$util$GeoHash$$latRange = this.latBounds().high() - this.latBounds().low();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.org$locationtech$geomesa$spark$jts$util$GeoHash$$latRange;
        }
    }

    private double org$locationtech$geomesa$spark$jts$util$GeoHash$$lonRange$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$locationtech$geomesa$spark$jts$util$GeoHash$$lonRange = this.lonBounds().high() - this.lonBounds().low();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.org$locationtech$geomesa$spark$jts$util$GeoHash$$lonRange;
        }
    }

    private Map org$locationtech$geomesa$spark$jts$util$GeoHash$$powersOf2Map$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.org$locationtech$geomesa$spark$jts$util$GeoHash$$powersOf2Map = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.MAX_PRECISION()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(int i) {
                        return new Tuple2.mcIJ.sp(i, 1L << i);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.org$locationtech$geomesa$spark$jts$util$GeoHash$$powersOf2Map;
        }
    }

    private Map latDeltaMap$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.latDeltaMap = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.MAX_PRECISION()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(int i) {
                        return new Tuple2.mcID.sp(i, GeoHash$.MODULE$.org$locationtech$geomesa$spark$jts$util$GeoHash$$latRange() / (double)BoxesRunTime.unboxToLong((Object)GeoHash$.MODULE$.org$locationtech$geomesa$spark$jts$util$GeoHash$$powersOf2Map().apply((Object)BoxesRunTime.boxToInteger((int)(i / 2)))));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.latDeltaMap;
        }
    }

    private Map lonDeltaMap$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.lonDeltaMap = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.MAX_PRECISION()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(int i) {
                        return new Tuple2.mcID.sp(i, GeoHash$.MODULE$.org$locationtech$geomesa$spark$jts$util$GeoHash$$lonRange() / (double)BoxesRunTime.unboxToLong((Object)GeoHash$.MODULE$.org$locationtech$geomesa$spark$jts$util$GeoHash$$powersOf2Map().apply((Object)BoxesRunTime.boxToInteger((int)(i / 2 + i % 2)))));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.lonDeltaMap;
        }
    }

    private GeometryFactory latLonGeoFactory$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.latLonGeoFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
            return this.latLonGeoFactory;
        }
    }

    public int MAX_PRECISION() {
        return this.MAX_PRECISION;
    }

    private Bounds latBounds() {
        return this.latBounds;
    }

    private Bounds lonBounds() {
        return this.lonBounds;
    }

    public double org$locationtech$geomesa$spark$jts$util$GeoHash$$latRange() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.org$locationtech$geomesa$spark$jts$util$GeoHash$$latRange$lzycompute() : this.org$locationtech$geomesa$spark$jts$util$GeoHash$$latRange;
    }

    public double org$locationtech$geomesa$spark$jts$util$GeoHash$$lonRange() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$locationtech$geomesa$spark$jts$util$GeoHash$$lonRange$lzycompute() : this.org$locationtech$geomesa$spark$jts$util$GeoHash$$lonRange;
    }

    public Map<Object, Object> org$locationtech$geomesa$spark$jts$util$GeoHash$$powersOf2Map() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.org$locationtech$geomesa$spark$jts$util$GeoHash$$powersOf2Map$lzycompute() : this.org$locationtech$geomesa$spark$jts$util$GeoHash$$powersOf2Map;
    }

    private Map<Object, Object> latDeltaMap() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.latDeltaMap$lzycompute() : this.latDeltaMap;
    }

    private Map<Object, Object> lonDeltaMap() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.lonDeltaMap$lzycompute() : this.lonDeltaMap;
    }

    public double latitudeDeltaForPrecision(int prec) {
        this.checkPrecision(prec);
        return BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
    }

    public double longitudeDeltaForPrecision(int prec) {
        this.checkPrecision(prec);
        return BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
    }

    private double lonMax() {
        return this.lonMax;
    }

    private double latMax() {
        return this.latMax;
    }

    public int[] org$locationtech$geomesa$spark$jts$util$GeoHash$$bits() {
        return this.org$locationtech$geomesa$spark$jts$util$GeoHash$$bits;
    }

    public String base32() {
        return this.base32;
    }

    public Map<Object, scala.collection.BitSet> org$locationtech$geomesa$spark$jts$util$GeoHash$$characterMap() {
        return this.org$locationtech$geomesa$spark$jts$util$GeoHash$$characterMap;
    }

    public GeometryFactory latLonGeoFactory() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.latLonGeoFactory$lzycompute() : this.latLonGeoFactory;
    }

    private Envelope envFromIndiciesDeltas(long lonIndex, long latIndex, double lonDelta, double latDelta) {
        return new Envelope(this.lonBounds().low() + lonDelta * (double)lonIndex, this.lonBounds().low() + lonDelta * (double)(lonIndex + 1L), this.latBounds().low() + latDelta * (double)latIndex, this.latBounds().low() + latDelta * (double)(latIndex + 1L));
    }

    private long interleaveReverseBits(long first, long second, int numBits) {
        Tuple2.mcJJ.sp sp2;
        boolean even = (numBits & 1) == 0;
        Tuple2.mcJJ.sp sp3 = sp2 = even ? new Tuple2.mcJJ.sp(second, first) : new Tuple2.mcJJ.sp(first, second);
        if (sp2 != null) {
            Tuple2.mcJJ.sp sp4;
            long actualFirst = sp2._1$mcJ$sp();
            long actualSecond = sp2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp5 = sp4 = new Tuple2.mcJJ.sp(actualFirst, actualSecond);
            long actualFirst2 = sp5._1$mcJ$sp();
            long actualSecond2 = sp5._2$mcJ$sp();
            int numPairs = numBits >> 1;
            LongRef result = LongRef.create((long)0L);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPairs).foreach$mVc$sp((Function1)new Serializable(actualFirst2, actualSecond2, result){
                public static final long serialVersionUID = 0L;
                private final long actualFirst$1;
                private final long actualSecond$1;
                private final LongRef result$1;

                public final void apply(int pairNum) {
                    this.apply$mcVI$sp(pairNum);
                }

                public void apply$mcVI$sp(int pairNum) {
                    this.result$1.elem = this.result$1.elem << 1 | this.actualFirst$1 >> pairNum & 1L;
                    this.result$1.elem = this.result$1.elem << 1 | this.actualSecond$1 >> pairNum & 1L;
                }
                {
                    this.actualFirst$1 = actualFirst$1;
                    this.actualSecond$1 = actualSecond$1;
                    this.result$1 = result$1;
                }
            });
            return even ? result.elem : result.elem << 1 | actualFirst2 >> numPairs & 1L;
        }
        throw new MatchError((Object)sp2);
    }

    private Tuple2<Object, Object> extractReverseBits(long value, int numBits) {
        int numPairs = numBits >> 1;
        LongRef first = LongRef.create((long)0L);
        LongRef second = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPairs).foreach$mVc$sp((Function1)new Serializable(value, first, second){
            public static final long serialVersionUID = 0L;
            private final long value$1;
            private final LongRef first$1;
            private final LongRef second$1;

            public final void apply(int pairNum) {
                this.apply$mcVI$sp(pairNum);
            }

            public void apply$mcVI$sp(int pairNum) {
                this.first$1.elem = this.first$1.elem << 1 | this.value$1 >> pairNum * 2 & 1L;
                this.second$1.elem = this.second$1.elem << 1 | this.value$1 >> pairNum * 2 + 1 & 1L;
            }
            {
                this.value$1 = value$1;
                this.first$1 = first$1;
                this.second$1 = second$1;
            }
        });
        return new Tuple2.mcJJ.sp((numBits & 1) == 1 ? first.elem << 1 | value >> numBits - 1 & 1L : first.elem, second.elem);
    }

    public scala.collection.BitSet org$locationtech$geomesa$spark$jts$util$GeoHash$$shift(int n, scala.collection.BitSet bs) {
        return (scala.collection.BitSet)bs.map((Function1)new Serializable(n){
            public static final long serialVersionUID = 0L;
            private final int n$1;

            public final int apply(int x$2) {
                return this.apply$mcII$sp(x$2);
            }

            public int apply$mcII$sp(int x$2) {
                return x$2 + this.n$1;
            }
            {
                this.n$1 = n$1;
            }
        }, scala.collection.BitSet$.MODULE$.canBuildFrom());
    }

    public scala.collection.BitSet org$locationtech$geomesa$spark$jts$util$GeoHash$$bitSetFromBase32Character(long charIndex) {
        return scala.collection.BitSet$.MODULE$.apply((Seq)((TraversableLike)((TraversableLike)new StringOps(Predef$.MODULE$.augmentString(this.toPaddedBinaryString(charIndex, 5))).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    char c = tuple2._1$mcC$sp();
                    boolean bl = c == '1';
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Object> x$3) {
                return x$3._2$mcI$sp();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()));
    }

    private String toPaddedBinaryString(long i, int length) {
        return String.format(new StringBuilder().append((Object)"%").append((Object)BoxesRunTime.boxToInteger((int)length)).append((Object)"s").toString(), RichLong$.MODULE$.toBinaryString$extension(Predef$.MODULE$.longWrapper(i))).replace(' ', '0');
    }

    private String toBase32(scala.collection.BitSet bitset, int prec) {
        int n;
        int numLeftoverBits;
        int n2 = numLeftoverBits = prec % 5;
        switch (n2) {
            default: {
                n = 5 - numLeftoverBits;
                break;
            }
            case 0: {
                n = 0;
            }
        }
        int precision = prec + n;
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), precision).grouped(5).map((Function1)new Serializable(bitset){
            public static final long serialVersionUID = 0L;
            private final scala.collection.BitSet bitset$1;

            public final char apply(scala.collection.immutable.IndexedSeq<Object> i) {
                return GeoHash$.MODULE$.org$locationtech$geomesa$spark$jts$util$GeoHash$$ch((IndexedSeq<Object>)i, this.bitset$1);
            }
            {
                this.bitset$1 = bitset$1;
            }
        }).mkString();
    }

    public char org$locationtech$geomesa$spark$jts$util$GeoHash$$ch(IndexedSeq<Object> v, scala.collection.BitSet bitset) {
        return StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.base32()), BoxesRunTime.unboxToInt((Object)v.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(bitset){
            public static final long serialVersionUID = 0L;
            private final scala.collection.BitSet bitset$2;

            public final int apply(int cur, int i) {
                return this.apply$mcIII$sp(cur, i);
            }

            public int apply$mcIII$sp(int cur, int i) {
                return cur + (this.bitset$2.apply((Object)BoxesRunTime.boxToInteger((int)i)) ? GeoHash$.MODULE$.org$locationtech$geomesa$spark$jts$util$GeoHash$$bits()[i % GeoHash$.MODULE$.org$locationtech$geomesa$spark$jts$util$GeoHash$$bits().length] : 0);
            }
            {
                this.bitset$2 = bitset$2;
            }
        })));
    }

    public void checkPrecision(int precision) {
        Predef$.MODULE$.require(precision <= this.MAX_PRECISION(), (Function0)new Serializable(precision){
            public static final long serialVersionUID = 0L;
            private final int precision$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GeoHash precision of ", " requested, but precisions above ", " are not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.precision$1), BoxesRunTime.boxToInteger((int)GeoHash$.MODULE$.MAX_PRECISION())}));
            }
            {
                this.precision$1 = precision$1;
            }
        });
    }

    public String encode(double lon, double lat, int prec) {
        Predef$.MODULE$.require(lon >= -180.0 && lon <= 180.0);
        Predef$.MODULE$.require(lat >= -90.0 && lat <= 90.0);
        this.checkPrecision(prec);
        double lonDelta = BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
        double latDelta = BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
        long lonIndex = lon == 180.0 ? (long)(this.lonMax() / lonDelta) : (long)((lon - this.lonBounds().low()) / lonDelta);
        long latIndex = lat == 90.0 ? (long)(this.latMax() / latDelta) : (long)((lat - this.latBounds().low()) / latDelta);
        BitSet bitSet = BitSet$.MODULE$.fromBitMaskNoCopy(new long[]{this.interleaveReverseBits(lonIndex, latIndex, prec)});
        return this.toBase32((scala.collection.BitSet)bitSet, prec);
    }

    public int encode$default$3() {
        return 25;
    }

    public Geometry decode(String string, Option<Object> precisionOption) {
        scala.collection.BitSet bitSet;
        int prec = BoxesRunTime.unboxToInt((Object)precisionOption.getOrElse((Function0)new Serializable(string){
            public static final long serialVersionUID = 0L;
            private final String string$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 5 * this.string$1.length();
            }
            {
                this.string$1 = string$1;
            }
        }));
        this.checkPrecision(prec);
        scala.collection.immutable.IndexedSeq bitsets = (scala.collection.immutable.IndexedSeq)((TraversableLike)new StringOps(Predef$.MODULE$.augmentString(string)).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.BitSet apply(Tuple2<Object, Object> x0$3) {
                Tuple2<Object, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    char c = tuple2._1$mcC$sp();
                    int i = tuple2._2$mcI$sp();
                    char c2 = c;
                    int n = i;
                    scala.collection.BitSet bitSet = GeoHash$.MODULE$.org$locationtech$geomesa$spark$jts$util$GeoHash$$shift(n * 5, (scala.collection.BitSet)GeoHash$.MODULE$.org$locationtech$geomesa$spark$jts$util$GeoHash$$characterMap().apply((Object)BoxesRunTime.boxToCharacter((char)c2)));
                    return bitSet;
                }
                throw new MatchError(tuple2);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        int n = bitsets.size();
        switch (n) {
            default: {
                bitSet = (scala.collection.BitSet)bitsets.reduce((Function2)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final scala.collection.BitSet apply(scala.collection.BitSet x$4, scala.collection.BitSet x$5) {
                        return (scala.collection.BitSet)x$4.$bar(x$5);
                    }
                });
                break;
            }
            case 1: {
                bitSet = (scala.collection.BitSet)bitsets.apply(0);
                break;
            }
            case 0: {
                bitSet = scala.collection.BitSet$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        }
        scala.collection.BitSet finalBitset = bitSet;
        Tuple2<Object, Object> tuple2 = this.extractReverseBits(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(finalBitset.toBitMask()).head()), prec);
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2;
            long lonIndex = tuple2._1$mcJ$sp();
            long latIndex = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(lonIndex, latIndex);
            long lonIndex2 = sp3._1$mcJ$sp();
            long latIndex2 = sp3._2$mcJ$sp();
            Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec))), BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec))));
            if (sp4 != null) {
                Tuple2.mcDD.sp sp5;
                double lonDelta = sp4._1$mcD$sp();
                double latDelta = sp4._2$mcD$sp();
                Tuple2.mcDD.sp sp6 = sp5 = new Tuple2.mcDD.sp(lonDelta, latDelta);
                double lonDelta2 = sp6._1$mcD$sp();
                double latDelta2 = sp6._2$mcD$sp();
                Envelope envelope = this.envFromIndiciesDeltas(lonIndex2, latIndex2, lonDelta2, latDelta2);
                return this.latLonGeoFactory().toGeometry(envelope);
            }
            throw new MatchError((Object)sp4);
        }
        throw new MatchError(tuple2);
    }

    public Option<Object> decode$default$2() {
        return None$.MODULE$;
    }

    private GeoHash$() {
        MODULE$ = this;
        this.MAX_PRECISION = 63;
        this.latBounds = new Bounds(-90.0, 90.0);
        this.lonBounds = new Bounds(-180.0, 180.0);
        this.lonMax = (double)360 - package$.MODULE$.pow(0.5, 32.0);
        this.latMax = (double)180 - package$.MODULE$.pow(0.5, 32.0);
        this.org$locationtech$geomesa$spark$jts$util$GeoHash$$bits = new int[]{16, 8, 4, 2, 1};
        this.base32 = "0123456789bcdefghjkmnpqrstuvwxyz";
        this.org$locationtech$geomesa$spark$jts$util$GeoHash$$characterMap = ((TraversableOnce)((TraversableLike)new StringOps(Predef$.MODULE$.augmentString(this.base32())).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, scala.collection.BitSet> apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    char c = tuple2._1$mcC$sp();
                    int i = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)c)), (Object)GeoHash$.MODULE$.org$locationtech$geomesa$spark$jts$util$GeoHash$$bitSetFromBase32Character(i));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }
}

