/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.jts;

import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.junit.runner.RunWith;
import org.locationtech.geomesa.spark.jts.TestEnvironment;
import org.locationtech.geomesa.spark.jts.package$;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.specs2.matcher.MatchResult$;
import org.specs2.mutable.Specification;
import org.specs2.runner.JUnitRunner;
import org.specs2.specification.core.AsExecution$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001u3A\u0001C\u0005\u0001)!)\u0011\u0005\u0001C\u0001E!IA\u0005\u0001a\u0001\u0002\u0004%\t!\n\u0005\n{\u0001\u0001\r\u00111A\u0005\u0002yB\u0011b\u0012\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0014\t\u0013!\u0003\u0001\u0019!a\u0001\n\u0003)\u0003\"C%\u0001\u0001\u0004\u0005\r\u0011\"\u0001K\u0011%a\u0005\u00011A\u0001B\u0003&aE\u0001\u0007K)N\u000bV/\u001a:z)\u0016\u001cHO\u0003\u0002\u000b\u0017\u0005\u0019!\u000e^:\u000b\u00051i\u0011!B:qCJ\\'B\u0001\b\u0010\u0003\u001d9Wm\\7fg\u0006T!\u0001E\t\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003I\t1a\u001c:h\u0007\u0001\u00192\u0001A\u000b\u001e!\t12$D\u0001\u0018\u0015\tA\u0012$A\u0004nkR\f'\r\\3\u000b\u0005i\t\u0012AB:qK\u000e\u001c('\u0003\u0002\u001d/\ti1\u000b]3dS\u001aL7-\u0019;j_:\u0004\"AH\u0010\u000e\u0003%I!\u0001I\u0005\u0003\u001fQ+7\u000f^#om&\u0014xN\\7f]R\fa\u0001P5oSRtD#A\u0012\u0011\u0005y\u0001\u0011A\u00013g+\u00051\u0003CA\u0014;\u001d\tAsG\u0004\u0002*i9\u0011!F\r\b\u0003WAr!\u0001L\u0018\u000e\u00035R!AL\n\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0012BA\u0019\u0012\u0003\u0019\t\u0007/Y2iK&\u0011Ab\r\u0006\u0003cEI!!\u000e\u001c\u0002\u0007M\fHN\u0003\u0002\rg%\u0011\u0001(O\u0001\ba\u0006\u001c7.Y4f\u0015\t)d'\u0003\u0002<y\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0003qe\na\u0001\u001a4`I\u0015\fHCA F!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0011)f.\u001b;\t\u000f\u0019\u001b\u0011\u0011!a\u0001M\u0005\u0019\u0001\u0010J\u0019\u0002\u0007\u00114\u0007%A\u0003oK^$e)A\u0005oK^$ei\u0018\u0013fcR\u0011qh\u0013\u0005\b\r\u001a\t\t\u00111\u0001'\u0003\u0019qWm\u001e#GA!\"\u0001A\u0014,X!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0004sk:tWM\u001d\u0006\u0003'F\tQA[;oSRL!!\u0016)\u0003\u000fI+hnV5uQ\u0006)a/\u00197vK\u000e\n\u0001\f\u0005\u0002Z76\t!L\u0003\u0002R3%\u0011AL\u0017\u0002\f\u0015Vs\u0017\u000e\u001e*v]:,'\u000f")
public class JTSQueryTest
extends Specification
implements TestEnvironment {
    private Dataset<Row> df;
    private Dataset<Row> newDF;
    private SparkSession spark;
    private SQLContext sc;
    private volatile byte bitmap$0;

    @Override
    public Dataset<Row> dfBlank(SparkSession spark) {
        return TestEnvironment.dfBlank$(this, spark);
    }

    private SparkSession spark$lzycompute() {
        JTSQueryTest jTSQueryTest = this;
        synchronized (jTSQueryTest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.spark = TestEnvironment.spark$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.spark;
    }

    @Override
    public SparkSession spark() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.spark$lzycompute() : this.spark;
    }

    private SQLContext sc$lzycompute() {
        JTSQueryTest jTSQueryTest = this;
        synchronized (jTSQueryTest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sc = TestEnvironment.sc$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sc;
    }

    @Override
    public SQLContext sc() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sc$lzycompute() : this.sc;
    }

    public Dataset<Row> df() {
        return this.df;
    }

    public void df_$eq(Dataset<Row> x$1) {
        this.df = x$1;
    }

    public Dataset<Row> newDF() {
        return this.newDF;
    }

    public void newDF_$eq(Dataset<Row> x$1) {
        this.newDF = x$1;
    }

    public JTSQueryTest() {
        TestEnvironment.$init$(this);
        this.sequential();
        this.step((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = new StructType((StructField[])((Object[])new StructField[]{new StructField("name", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("pointText", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("polygonText", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("latitude", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("longitude", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}));
            String dataFile = this.getClass().getClassLoader().getResource("jts-example.csv").getPath();
            this.df_$eq((Dataset<Row>)this.spark().read().schema(schema).option("sep", "-").option("timestampFormat", "yyyy/MM/dd HH:mm:ss ZZ").csv(dataFile));
        });
        this.blockExample("spark jts module").should((Function0 & Serializable & scala.Serializable)() -> {
            this.blockExample("have rows with user defined types").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.newDF_$eq((Dataset<Row>)this.df().withColumn("point", (Column)package$.MODULE$.st_pointFromText(functions$.MODULE$.col("pointText"))).withColumn("polygon", (Column)package$.MODULE$.st_polygonFromText(functions$.MODULE$.col("polygonText"))).withColumn("pointB", (Column)package$.MODULE$.st_makePoint(functions$.MODULE$.col("latitude"), functions$.MODULE$.col("longitude"))));
                this.newDF().createOrReplaceTempView("example");
                Row row = (Row)this.newDF().first();
                GeometryFactory gf = new GeometryFactory();
                this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> row.get(5) instanceof Point).mustEqual((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true);
                this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> row.get(6) instanceof Polygon).mustEqual((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true);
                return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> row.get(7) instanceof Point).mustEqual((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("create a df from sequence of points").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                Point[] points = (Point[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.newDF().collect())).map((Function1 & Serializable & scala.Serializable)r -> (Point)r.getAs(5), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Point.class)));
                Dataset testDF = this.spark().createDataset((Seq)Predef$.MODULE$.wrapRefArray((Object[])points), package$.MODULE$.jtsPointEncoder()).toDF();
                return this.theValue((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> testDF.count()).mustEqual((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.df().count());
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            return this.blockExample("udfs intergrate with dataframe api").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                long countSQL = this.sc().sql("select * from example where st_contains(st_makeBBOX(0.0, 0.0, 90.0, 90.0), point)").count();
                long countDF = this.newDF().where((Column)package$.MODULE$.st_contains((Column)package$.MODULE$.st_makeBBOX(functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.0)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.0)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)90.0)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)90.0))), functions$.MODULE$.col("point"))).count();
                return this.theValue((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> countSQL).mustEqual((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> countDF);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
        });
        this.step((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.spark().stop());
    }
}

