/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.jts.udf;

import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.junit.runner.RunWith;
import org.locationtech.geomesa.spark.jts.TestEnvironment;
import org.locationtech.geomesa.spark.jts.package$;
import org.locationtech.geomesa.spark.jts.util.WKTUtils$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.specs2.matcher.MatchResult$;
import org.specs2.mutable.Specification;
import org.specs2.runner.JUnitRunner;
import org.specs2.specification.core.AsExecution$;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001E2AAA\u0002\u0001!!)Q\u0004\u0001C\u0001=\t\u0001s)Z8nKR\u0014\u0018n\u0019)s_\u000e,7o]5oO\u001a+hn\u0019;j_:\u001cH+Z:u\u0015\t!Q!A\u0002vI\u001aT!AB\u0004\u0002\u0007)$8O\u0003\u0002\t\u0013\u0005)1\u000f]1sW*\u0011!bC\u0001\bO\u0016|W.Z:b\u0015\taQ\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u000f\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011#\u0007\t\u0003%]i\u0011a\u0005\u0006\u0003)U\tq!\\;uC\ndWM\u0003\u0002\u0017\u001b\u000511\u000f]3dgJJ!\u0001G\n\u0003\u001bM\u0003XmY5gS\u000e\fG/[8o!\tQ2$D\u0001\u0006\u0013\taRAA\bUKN$XI\u001c<je>tW.\u001a8u\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t1\u0001\u000b\u0003\u0001E)Z\u0003CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0019\u0011XO\u001c8fe*\u0011q%D\u0001\u0006UVt\u0017\u000e^\u0005\u0003S\u0011\u0012qAU;o/&$\b.A\u0003wC2,XmI\u0001-!\tis&D\u0001/\u0015\t)S#\u0003\u00021]\tY!*\u00168jiJ+hN\\3s\u0001")
public class GeometricProcessingFunctionsTest
extends Specification
implements TestEnvironment {
    private SparkSession spark;
    private SQLContext sc;
    private volatile byte bitmap$0;

    @Override
    public Dataset<Row> dfBlank(SparkSession spark) {
        return TestEnvironment.dfBlank$(this, spark);
    }

    private SparkSession spark$lzycompute() {
        GeometricProcessingFunctionsTest geometricProcessingFunctionsTest = this;
        synchronized (geometricProcessingFunctionsTest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.spark = TestEnvironment.spark$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.spark;
    }

    @Override
    public SparkSession spark() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.spark$lzycompute() : this.spark;
    }

    private SQLContext sc$lzycompute() {
        GeometricProcessingFunctionsTest geometricProcessingFunctionsTest = this;
        synchronized (geometricProcessingFunctionsTest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sc = TestEnvironment.sc$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sc;
    }

    @Override
    public SQLContext sc() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sc$lzycompute() : this.sc;
    }

    public GeometricProcessingFunctionsTest() {
        TestEnvironment.$init$(this);
        this.blockExample("sql geometry constructors").should((Function0 & Serializable & scala.Serializable)() -> {
            this.sequential();
            this.step((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                SparkSession sparkSession = this.spark();
            });
            this.blockExample("st_bufferPoint").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("should handle nulls").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_bufferPoint(null, null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_bufferPoint(functions$.MODULE$.lit(null), functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("should return a point buffered in meters").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Object buf = ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_bufferPoint(st_makePoint(0,0), 10)").collect())).head()).get(0);
                    Geometry dfBuf = (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_bufferPoint((Column)package$.MODULE$.st_makePoint(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0))), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)10)))).first();
                    Geometry bufferedPoly = WKTUtils$.MODULE$.read(new StringOps(Predef$.MODULE$.augmentString("\n          |POLYGON ((0.0000899320367762 0, 0.0000897545764446 0.0000056468793115, 0.0000892228958048 0.0000112714729702, 0.0000883390931573 0.0000168515832745, 0.0000871066564674 0.0000223651880784, 0.0000855304495997 0.0000277905277026, 0.0000836166931225 0.0000331061908102, 0.0000813729397584 0.0000382911989076, 0.0000788080445769 0.0000433250891364, 0.0000759321300474 0.0000481879950317, 0.0000727565460907 0.0000528607249257, 0.0000692938252858 0.0000573248376881, 0.0000655576334099 0.0000615627155054, 0.0000615627155054 0.0000655576334099, 0.0000573248376881 0.0000692938252858, 0.0000528607249257 0.0000727565460907, 0.0000481879950317 0.0000759321300474, 0.0000433250891364 0.0000788080445769, 0.0000382911989076 0.0000813729397584, 0.0000331061908102 0.0000836166931225, 0.0000277905277026 0.0000855304495997, 0.0000223651880784 0.0000871066564674, 0.0000168515832745 0.0000883390931573, 0.0000112714729702 0.0000892228958048, 0.0000056468793115 0.0000897545764446, -0 0.0000899320367762, -0.0000056468793115 0.0000897545764446, -0.0000112714729702 0.0000892228958048, -0.0000168515832745 0.0000883390931573, -0.0000223651880784 0.0000871066564674, -0.0000277905277026 0.0000855304495997, -0.0000331061908102 0.0000836166931225, -0.0000382911989076 0.0000813729397584, -0.0000433250891364 0.0000788080445769, -0.0000481879950317 0.0000759321300474, -0.0000528607249257 0.0000727565460907, -0.0000573248376881 0.0000692938252858, -0.0000615627155054 0.0000655576334099, -0.0000655576334099 0.0000615627155054, -0.0000692938252858 0.0000573248376881, -0.0000727565460907 0.0000528607249257, -0.0000759321300474 0.0000481879950317, -0.0000788080445769 0.0000433250891364, -0.0000813729397584 0.0000382911989076, -0.0000836166931225 0.0000331061908102, -0.0000855304495997 0.0000277905277026, -0.0000871066564674 0.0000223651880784, -0.0000883390931573 0.0000168515832745, -0.0000892228958048 0.0000112714729702, -0.0000897545764446 0.0000056468793115, -0.0000899320367762 -0, -0.0000897545764446 -0.0000056468793115, -0.0000892228958048 -0.0000112714729702, -0.0000883390931573 -0.0000168515832745, -0.0000871066564674 -0.0000223651880784, -0.0000855304495997 -0.0000277905277026, -0.0000836166931225 -0.0000331061908102, -0.0000813729397584 -0.0000382911989076, -0.0000788080445769 -0.0000433250891364, -0.0000759321300474 -0.0000481879950317, -0.0000727565460907 -0.0000528607249257, -0.0000692938252858 -0.0000573248376881, -0.0000655576334099 -0.0000615627155054, -0.0000615627155054 -0.0000655576334099, -0.0000573248376881 -0.0000692938252858, -0.0000528607249257 -0.0000727565460907, -0.0000481879950317 -0.0000759321300474, -0.0000433250891364 -0.0000788080445769, -0.0000382911989076 -0.0000813729397584, -0.0000331061908102 -0.0000836166931225, -0.0000277905277026 -0.0000855304495997, -0.0000223651880784 -0.0000871066564674, -0.0000168515832745 -0.0000883390931573, -0.0000112714729702 -0.0000892228958048, -0.0000056468793115 -0.0000897545764446, -0 -0.0000899320367762, 0.0000056468793115 -0.0000897545764446, 0.0000112714729702 -0.0000892228958048, 0.0000168515832745 -0.0000883390931573, 0.0000223651880784 -0.0000871066564674, 0.0000277905277026 -0.0000855304495997, 0.0000331061908102 -0.0000836166931225, 0.0000382911989076 -0.0000813729397584, 0.0000433250891364 -0.0000788080445769, 0.0000481879950317 -0.0000759321300474, 0.0000528607249257 -0.0000727565460907, 0.0000573248376881 -0.0000692938252858, 0.0000615627155054 -0.0000655576334099, 0.0000655576334099 -0.0000615627155054, 0.0000692938252858 -0.0000573248376881, 0.0000727565460907 -0.0000528607249257, 0.0000759321300474 -0.0000481879950317, 0.0000788080445769 -0.0000433250891364, 0.0000813729397584 -0.0000382911989076, 0.0000836166931225 -0.0000331061908102, 0.0000855304495997 -0.0000277905277026, 0.0000871066564674 -0.0000223651880784, 0.0000883390931573 -0.0000168515832745, 0.0000892228958048 -0.0000112714729702, 0.0000897545764446 -0.0000056468793115, 0.0000899320367762 0))\n        ")).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Polygon)buf).equalsExact(bufferedPoly, 1.0E-6)).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Polygon)dfBuf).equalsExact(bufferedPoly, 1.0E-6)).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("should handle antimeridian").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Geometry buf = (Geometry)((Row)this.sc().sql("select st_bufferPoint(st_makePoint(-180, 50), 100000)").first()).getAs(0);
                    Geometry dfBuf = (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_bufferPoint((Column)package$.MODULE$.st_makePoint(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)-180)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)50))), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)100000)))).first();
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> buf.contains(WKTUtils$.MODULE$.read("POINT(-179.9 50)"))).mustEqual((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true);
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> buf.contains(WKTUtils$.MODULE$.read("POINT(179.9 50)"))).mustEqual((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true);
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> dfBuf.contains(WKTUtils$.MODULE$.read("POINT(-179.9 50)"))).mustEqual((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true);
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> dfBuf.contains(WKTUtils$.MODULE$.read("POINT(179.9 50)"))).mustEqual((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            return this.blockExample("st_antimeridianSafeGeom").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("should handle nulls").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_antimeridianSafeGeom(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_antimeridianSafeGeom(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("should split a geom that spans the antimeridian").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String wkt = "POLYGON((-190 50, -190 60, -170 60, -170 50, -190 50))";
                    String geom = new StringBuilder(18).append("st_geomFromWKT('").append(wkt).append("')").toString();
                    Geometry decomposed = (Geometry)((Row)this.sc().sql(new StringBuilder(32).append("select st_antimeridianSafeGeom(").append(geom).append(")").toString()).first()).getAs(0);
                    Geometry dfDecomposed = (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_antimeridianSafeGeom((Column)package$.MODULE$.st_geomFromWKT(functions$.MODULE$.lit((Object)wkt)))).first();
                    Geometry expected = WKTUtils$.MODULE$.read("MULTIPOLYGON (((-180 50, -180 60, -170 60, -170 50, -180 50)), ((180 60, 180 50, 170 50, 170 60, 180 60)))");
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> decomposed).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> dfDecomposed).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
        });
    }
}

