/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.jts.udf;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.junit.runner.RunWith;
import org.locationtech.geomesa.spark.jts.TestEnvironment;
import org.locationtech.geomesa.spark.jts.package$;
import org.locationtech.geomesa.spark.jts.udf.GeometricConstructorFunctions$;
import org.locationtech.geomesa.spark.jts.udf.GeometricConstructorFunctionsTest$;
import org.locationtech.geomesa.spark.jts.util.WKTUtils$;
import org.locationtech.geomesa.spark.jts.util.util.package;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.specs2.matcher.MatchResult$;
import org.specs2.mutable.Specification;
import org.specs2.runner.JUnitRunner;
import org.specs2.specification.core.AsExecution$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001E2AAA\u0002\u0001!!)Q\u0004\u0001C\u0001=\t\ts)Z8nKR\u0014\u0018nY\"p]N$(/^2u_J4UO\\2uS>t7\u000fV3ti*\u0011A!B\u0001\u0004k\u00124'B\u0001\u0004\b\u0003\rQGo\u001d\u0006\u0003\u0011%\tQa\u001d9be.T!AC\u0006\u0002\u000f\u001d,w.\\3tC*\u0011A\"D\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u001d\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!E\r\u0011\u0005I9R\"A\n\u000b\u0005Q)\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0003-5\taa\u001d9fGN\u0014\u0014B\u0001\r\u0014\u00055\u0019\u0006/Z2jM&\u001c\u0017\r^5p]B\u0011!dG\u0007\u0002\u000b%\u0011A$\u0002\u0002\u0010)\u0016\u001cH/\u00128wSJ|g.\\3oi\u00061A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011a\u0001\u0015\u0005\u0001\tR3\u0006\u0005\u0002$Q5\tAE\u0003\u0002&M\u00051!/\u001e8oKJT!aJ\u0007\u0002\u000b),h.\u001b;\n\u0005%\"#a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0002YA\u0011QfL\u0007\u0002])\u0011Q%F\u0005\u0003a9\u00121BS+oSR\u0014VO\u001c8fe\u0002")
public class GeometricConstructorFunctionsTest
extends Specification
implements TestEnvironment {
    private SparkSession spark;
    private SQLContext sc;
    private volatile byte bitmap$0;

    @Override
    public Dataset<Row> dfBlank(SparkSession spark) {
        return TestEnvironment.dfBlank$(this, spark);
    }

    private SparkSession spark$lzycompute() {
        GeometricConstructorFunctionsTest geometricConstructorFunctionsTest = this;
        synchronized (geometricConstructorFunctionsTest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.spark = TestEnvironment.spark$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.spark;
    }

    @Override
    public SparkSession spark() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.spark$lzycompute() : this.spark;
    }

    private SQLContext sc$lzycompute() {
        GeometricConstructorFunctionsTest geometricConstructorFunctionsTest = this;
        synchronized (geometricConstructorFunctionsTest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sc = TestEnvironment.sc$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sc;
    }

    @Override
    public SQLContext sc() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sc$lzycompute() : this.sc;
    }

    public GeometricConstructorFunctionsTest() {
        TestEnvironment.$init$(this);
        this.blockExample("sql geometry constructors").should((Function0 & Serializable & scala.Serializable)() -> {
            this.sequential();
            this.step((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                SparkSession sparkSession = this.spark();
            });
            this.blockExample("st_box2DFromGeoHash").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_box2DFromGeoHash(null, null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n           |select st_box2DFromGeoHash('ezs42', 25)\n          ")).stripMargin());
                Coordinate[] boxCoords = ((Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).getCoordinates();
                Coordinate ll = boxCoords[0];
                Coordinate ur = boxCoords[2];
                this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> boxCoords.length).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 5);
                this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> ll$1.x).must((Function0 & Serializable & scala.Serializable)() -> this.beCloseTo(BoxesRunTime.boxToDouble((double)-5.625), BoxesRunTime.boxToDouble((double)0.022), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
                this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> ll$1.y).must((Function0 & Serializable & scala.Serializable)() -> this.beCloseTo(BoxesRunTime.boxToDouble((double)42.583), BoxesRunTime.boxToDouble((double)0.022), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
                this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> ur$1.x).must((Function0 & Serializable & scala.Serializable)() -> this.beCloseTo(BoxesRunTime.boxToDouble((double)-5.581), BoxesRunTime.boxToDouble((double)0.022), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
                return this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> ur$1.y).must((Function0 & Serializable & scala.Serializable)() -> this.beCloseTo(BoxesRunTime.boxToDouble((double)42.627), BoxesRunTime.boxToDouble((double)0.022), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_geomFromGeoHash").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_geomFromGeoHash(null, null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_geomFromGeoHash(functions$.MODULE$.lit(null), functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                String geohash = "ezs42";
                int precision = 25;
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(55).append("\n           |select st_geomFromGeoHash('").append(geohash).append("', ").append(precision).append(")\n          ").toString())).stripMargin());
                Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)-5.625), (Object)BoxesRunTime.boxToDouble((double)42.583), (Object)BoxesRunTime.boxToDouble((double)-5.581), (Object)BoxesRunTime.boxToDouble((double)42.627));
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                double minLon = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                double minLat = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                double maxLon = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                double maxLat = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)minLon), (Object)BoxesRunTime.boxToDouble((double)minLat), (Object)BoxesRunTime.boxToDouble((double)maxLon), (Object)BoxesRunTime.boxToDouble((double)maxLat));
                Tuple4 tuple43 = tuple42;
                double minLon2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
                double minLat2 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
                double maxLon2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
                double maxLat2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
                double delta = 0.022;
                Coordinate[] dfBoxCoords = ((Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_geomFromGeoHash(functions$.MODULE$.lit((Object)geohash), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)precision)))).first()).getCoordinates();
                Coordinate dfLowerLeft = dfBoxCoords[0];
                Coordinate dfUpperRight = dfBoxCoords[2];
                this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> dfLowerLeft$1.x).must((Function0 & Serializable & scala.Serializable)() -> this.beCloseTo(BoxesRunTime.boxToDouble((double)minLon2), BoxesRunTime.boxToDouble((double)delta), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
                this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> dfLowerLeft$1.y).must((Function0 & Serializable & scala.Serializable)() -> this.beCloseTo(BoxesRunTime.boxToDouble((double)minLat2), BoxesRunTime.boxToDouble((double)delta), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
                this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> dfUpperRight$1.x).must((Function0 & Serializable & scala.Serializable)() -> this.beCloseTo(BoxesRunTime.boxToDouble((double)maxLon2), BoxesRunTime.boxToDouble((double)delta), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
                this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> dfUpperRight$1.y).must((Function0 & Serializable & scala.Serializable)() -> this.beCloseTo(BoxesRunTime.boxToDouble((double)maxLat2), BoxesRunTime.boxToDouble((double)delta), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
                Coordinate[] geomboxCoords = ((Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).getCoordinates();
                Coordinate ll = geomboxCoords[0];
                Coordinate ur = geomboxCoords[2];
                this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> geomboxCoords.length).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 5);
                this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> ll$2.x).must((Function0 & Serializable & scala.Serializable)() -> this.beCloseTo(BoxesRunTime.boxToDouble((double)minLon2), BoxesRunTime.boxToDouble((double)delta), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
                this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> ll$2.y).must((Function0 & Serializable & scala.Serializable)() -> this.beCloseTo(BoxesRunTime.boxToDouble((double)minLat2), BoxesRunTime.boxToDouble((double)delta), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
                this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> ur$2.x).must((Function0 & Serializable & scala.Serializable)() -> this.beCloseTo(BoxesRunTime.boxToDouble((double)maxLon2), BoxesRunTime.boxToDouble((double)delta), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
                return this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> ur$2.y).must((Function0 & Serializable & scala.Serializable)() -> this.beCloseTo(BoxesRunTime.boxToDouble((double)maxLat2), BoxesRunTime.boxToDouble((double)delta), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_geomFromGeoJSON").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_geomFromGeoJSON(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_geomFromWKT(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                String point = "POINT(-37.23456 18.12345)";
                String pointInGeoJson = "{\"type\":\"Point\",\"coordinates\":[-37.23456, 18.12345]}";
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(51).append("\n           |select st_geomFromGeoJSON('").append(pointInGeoJson).append("')\n        ").toString())).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read(point);
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_geomFromGeoJSON(pointInGeoJson)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_pointFromGeoHash").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_pointFromGeoHash(null, null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_pointFromGeoHash(functions$.MODULE$.lit(null), functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                String geohash = "ezs42";
                int precision = 25;
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(54).append("\n           |select st_pointFromGeoHash('").append(geohash).append("', ").append(precision).append(")\n        ").toString())).stripMargin());
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(-5.603, 42.605);
                if (sp2 == null) {
                    throw new MatchError((Object)sp2);
                }
                double x = sp2._1$mcD$sp();
                double y = sp2._2$mcD$sp();
                Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(x, y);
                Tuple2.mcDD.sp sp4 = sp3;
                double x2 = sp4._1$mcD$sp();
                double y2 = sp4._2$mcD$sp();
                double delta = 0.022;
                Point dfPoint = (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_pointFromGeoHash(functions$.MODULE$.lit((Object)geohash), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)precision)))).first();
                this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> dfPoint.getX()).must((Function0 & Serializable & scala.Serializable)() -> this.beCloseTo(BoxesRunTime.boxToDouble((double)x2), BoxesRunTime.boxToDouble((double)delta), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
                this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> dfPoint.getY()).must((Function0 & Serializable & scala.Serializable)() -> this.beCloseTo(BoxesRunTime.boxToDouble((double)y2), BoxesRunTime.boxToDouble((double)delta), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
                Point point = (Point)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0);
                this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> point.getX()).must((Function0 & Serializable & scala.Serializable)() -> this.beCloseTo(BoxesRunTime.boxToDouble((double)x2), BoxesRunTime.boxToDouble((double)delta), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
                return this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> point.getY()).must((Function0 & Serializable & scala.Serializable)() -> this.beCloseTo(BoxesRunTime.boxToDouble((double)y2), BoxesRunTime.boxToDouble((double)delta), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_geomFromWKT").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_geomFromWKT(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_geomFromWKT(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                String point = "POINT(0 0)";
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(46).append("\n          |select st_geomFromWKT('").append(point).append("')\n        ").toString())).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read(point);
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_geomFromWKT(point)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_geomFromWKT With Z Value").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                String point = "POINT(1 1 1)";
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(47).append("\n           |select st_geomFromWKT('").append(point).append("')\n        ").toString())).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read(point);
                return this.foreach((Traversable)new .colon.colon((Object)((Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)), (List)new .colon.colon((Object)((Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_geomFromWKT(point)).first()), (List)Nil$.MODULE$)), (Function1 & Serializable & scala.Serializable)actual -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> actual).must((Function0 & Serializable & scala.Serializable)() -> this.beAnInstanceOf(ClassTag$.MODULE$.apply(Point.class)));
                    return this.theValue((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> ((Point)actual).getCoordinate().getZ()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1);
                }, MatchResult$.MODULE$.matchResultAsResult());
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_geometryFromText").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_geometryFromText(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n          |select st_geometryFromText('POINT(0 0)')\n        ")).stripMargin());
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> WKTUtils$.MODULE$.read("POINT(0 0)"));
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_geomFromWKB").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_geomFromWKB(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_geomFromWKB(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                byte[] geomArr = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 0, 3, 0, 0, 0, 1, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}), ClassTag$.MODULE$.Byte());
                Dataset r = this.sc().sql(new StringBuilder(39).append("select st_geomFromWKB(st_byteArray('").append(new String(geomArr)).append("'))").toString());
                Geometry expected = WKTUtils$.MODULE$.read("POLYGON((0 0, 2 0, 2 2, 0 2, 0 0))");
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_geomFromWKB((Column)package$.MODULE$.st_byteArray(functions$.MODULE$.lit((Object)new String(geomArr))))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_geomFromWKB(geomArr)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_lineFromText").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_lineFromText(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (LineString)this.dfBlank(this.spark()).select(package$.MODULE$.st_lineFromText(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                String line = "LINESTRING(0 0, 1 1, 2 2)";
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(47).append("\n          |select st_lineFromText('").append(line).append("')\n        ").toString())).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read(line);
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (LineString)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (LineString)this.dfBlank(this.spark()).select(package$.MODULE$.st_lineFromText(line)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_makeBBOX").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_makeBBOX(null, null, null, null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_makeBBOX(functions$.MODULE$.lit(null), functions$.MODULE$.lit(null), functions$.MODULE$.lit(null), functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n          |select st_makeBBOX(0.0, 0.0, 2.0, 2.0)\n        ")).stripMargin());
                GeometryFactory fact = new GeometryFactory();
                Geometry expected = fact.toGeometry(new Envelope(0.0, 2.0, 0.0, 2.0));
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_makeBBOX(0.0, 0.0, 2.0, 2.0)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_makeBox2D").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_makeBox2D(null, null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_makeBox2D(functions$.MODULE$.lit(null), functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n          |select st_makeBox2D(st_castToPoint(st_geomFromWKT('POINT(0 0)')),\n          |                    st_castToPoint(st_geomFromWKT('POINT(2 2)')))\n        ")).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read("POLYGON((0.0 0.0, 0.0 2.0, 2.0 2.0, 2.0 0.0, 0.0 0.0))");
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_makeBox2D((Column)package$.MODULE$.st_castToPoint((Column)package$.MODULE$.st_geomFromWKT("POINT(0 0)")), (Column)package$.MODULE$.st_castToPoint((Column)package$.MODULE$.st_geomFromWKT("POINT(2 2)")))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                Point p1 = (Point)GeometricConstructorFunctions$.MODULE$.ST_MakePoint().apply((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0));
                Point p2 = (Point)GeometricConstructorFunctions$.MODULE$.ST_MakePoint().apply((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)2.0));
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_makeBox2D(p1, p2)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_makePolygon").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_makePolygon(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Polygon)this.dfBlank(this.spark()).select(package$.MODULE$.st_makePolygon(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                String line = "LINESTRING(0 0, 2 2, 5 4, 7 2, 5 2, 3 0, 0 0)";
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(101).append("\n           |select st_makePolygon(st_castToLineString(\n           |    st_geomFromWKT('").append(line).append("')))\n        ").toString())).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read("POLYGON((0 0, 2 2, 5 4, 7 2, 5 2, 3 0, 0 0))");
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Polygon)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Polygon)this.dfBlank(this.spark()).select(package$.MODULE$.st_makePolygon((Column)package$.MODULE$.st_castToLineString((Column)package$.MODULE$.st_geomFromWKT(line)))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                LineString lineInst = (LineString)WKTUtils$.MODULE$.read(line);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Polygon)this.dfBlank(this.spark()).select(package$.MODULE$.st_makePolygon(lineInst)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_makePoint").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_makePoint(null, null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_makePoint(functions$.MODULE$.lit(null), functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n          |select st_makePoint(0, 1) geom\n        ")).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read("POINT(0 1)");
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_makePoint(0.0, 1.0)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> this.theValue((Function0 & Serializable & scala.Serializable)() -> {
                    JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(GeometricConstructorFunctionsTest.class.getClassLoader());
                    public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctionsTest$$typecreator4$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("org")), (Symbols.SymbolApi)$m.staticPackage("org.locationtech")), (Symbols.SymbolApi)$m.staticPackage("org.locationtech.geomesa")), (Symbols.SymbolApi)$m.staticPackage("org.locationtech.geomesa.spark")), (Symbols.SymbolApi)$m.staticPackage("org.locationtech.geomesa.spark.jts")), (Symbols.SymbolApi)$m.staticPackage("org.locationtech.geomesa.spark.jts.util")), (Symbols.SymbolApi)$m.staticPackage("org.locationtech.geomesa.spark.jts.util.util")), (Symbols.SymbolApi)$m.staticModule("org.locationtech.geomesa.spark.jts.util.util.package")), (Symbols.SymbolApi)$m.staticClass("org.locationtech.geomesa.spark.jts.util.util.GeometryContainer"), (List)Nil$.MODULE$);
                        }

                        public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctionsTest$$typecreator4$1(GeometricConstructorFunctionsTest $outer) {
                        }
                    }
                    return (package.GeometryContainer)r.as(this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctionsTest$$typecreator4$1(null)))).head();
                }).must((Function0 & Serializable & scala.Serializable)() -> this.haveClass(ClassTag$.MODULE$.apply(package.GeometryContainer.class)))).must((Function0 & Serializable & scala.Serializable)() -> this.throwAn(ClassTag$.MODULE$.apply(AnalysisException.class)));
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_makePointM").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_makePointM(null, null, null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_makePointM(functions$.MODULE$.lit(null), functions$.MODULE$.lit(null), functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n          |select st_makePointM(0, 0, 1)\n        ")).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read("POINT(0 0 1)");
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_makePointM(0.0, 0.0, 1.0)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_makeLine").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_makeLine(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (LineString)this.dfBlank(this.spark()).select(package$.MODULE$.st_makeLine(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                Point p1 = (Point)GeometricConstructorFunctions$.MODULE$.ST_MakePoint().apply((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0));
                Point p2 = (Point)GeometricConstructorFunctions$.MODULE$.ST_MakePoint().apply((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)2.0));
                Point p3 = (Point)GeometricConstructorFunctions$.MODULE$.ST_MakePoint().apply((Object)BoxesRunTime.boxToDouble((double)5.0), (Object)BoxesRunTime.boxToDouble((double)2.0));
                Geometry expected = WKTUtils$.MODULE$.read("LINESTRING(0 0, 2 2, 5 2)");
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (LineString)this.dfBlank(this.spark()).select(package$.MODULE$.st_makeLine((Seq)new .colon.colon((Object)p1, (List)new .colon.colon((Object)p2, (List)new .colon.colon((Object)p3, (List)Nil$.MODULE$))))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (LineString)this.dfBlank(this.spark()).select(package$.MODULE$.st_makeLine(functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{package$.MODULE$.pointLit(p1), package$.MODULE$.pointLit(p2), package$.MODULE$.pointLit(p3)})))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_mLineFromText").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_mLineFromText(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (MultiLineString)this.dfBlank(this.spark()).select(package$.MODULE$.st_mLineFromText(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                String line = "MULTILINESTRING((0 0, 1 1, 2 2), (0 1, 1 2, 2 3))";
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(48).append("\n          |select st_mLineFromText('").append(line).append("')\n        ").toString())).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read("MULTILINESTRING((0 0, 1 1, 2 2), (0 1, 1 2, 2 3))");
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (MultiLineString)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (MultiLineString)this.dfBlank(this.spark()).select(package$.MODULE$.st_mLineFromText(line)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_mPointFromText").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_mPointFromText(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (MultiPoint)this.dfBlank(this.spark()).select(package$.MODULE$.st_mPointFromText(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                String point = "MULTIPOINT((0 0), (1 1))";
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(49).append("\n          |select st_mPointFromText('").append(point).append("')\n        ").toString())).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read("MULTIPOINT((0 0), (1 1))");
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (MultiPoint)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (MultiPoint)this.dfBlank(this.spark()).select(package$.MODULE$.st_mPointFromText(point)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_mPolyFromText").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_mPolyFromText(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (MultiPolygon)this.dfBlank(this.spark()).select(package$.MODULE$.st_mPolyFromText(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                String poly = "MULTIPOLYGON((( -1 -1, 0 1, 1 -1, -1 -1 )),((-4 4, 4 4, 4 -4, -4 -4, -4 4), (2 2, -2 2, -2 -2, 2 -2, 2 2)))";
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(48).append("\n          |select st_mPolyFromText('").append(poly).append("')\n        ").toString())).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read(poly);
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (MultiPolygon)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (MultiPolygon)this.dfBlank(this.spark()).select(package$.MODULE$.st_mPolyFromText(poly)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_point(null, null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_point(functions$.MODULE$.lit(null), functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n          |select st_point(0, 0)\n        ")).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read("POINT(0 0)");
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_point(0.0, 0.0)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_pointFromText").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_pointFromText(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_pointFromText(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                String point = "Point(0 0)";
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(48).append("\n          |select st_pointFromText('").append(point).append("')\n        ").toString())).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read(point);
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_pointFromText(point)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_pointFromWKB").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_pointFromWKB(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_pointFromWKB(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                byte[] pointArr = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}), ClassTag$.MODULE$.Byte());
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(62).append("\n           |select st_pointFromWKB(st_byteArray('").append(new String(pointArr)).append("'))\n        ").toString())).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read("POINT(0 0)");
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_pointFromWKB(pointArr)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_polygon").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_polygon(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Polygon)this.dfBlank(this.spark()).select(package$.MODULE$.st_polygon(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                String line = "LINESTRING(0 0, 2 2, 5 2, 3 0, 0 0)";
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(97).append("\n           |select st_polygon(st_castToLineString(\n           |    st_geomFromWKT('").append(line).append("')))\n        ").toString())).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read("POLYGON((0 0, 2 2, 5 2, 3 0, 0 0))");
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Polygon)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Polygon)this.dfBlank(this.spark()).select(package$.MODULE$.st_polygon((Column)package$.MODULE$.st_castToLineString((Column)package$.MODULE$.st_geomFromWKT(line)))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                LineString lineInst = (LineString)WKTUtils$.MODULE$.read(line);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Polygon)this.dfBlank(this.spark()).select(package$.MODULE$.st_makePolygon(lineInst)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_polygonFromText").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_polygonFromText(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Polygon)this.dfBlank(this.spark()).select(package$.MODULE$.st_polygonFromText(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                String poly = "POLYGON((0 0, 2 0, 2 2, 0 2, 0 0))";
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(50).append("\n          |select st_polygonFromText('").append(poly).append("')\n        ").toString())).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read("POLYGON((0.0 0.0, 2.0 0.0, 2.0 2.0, 0.0 2.0, 0.0 0.0))");
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Polygon)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Polygon)this.dfBlank(this.spark()).select(package$.MODULE$.st_polygonFromText(poly)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("geometry literals").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                GeometryFactory fact = new GeometryFactory();
                Coordinate c1 = new Coordinate(1.0, 2.0);
                Coordinate c2 = new Coordinate(3.0, 4.0);
                Coordinate c3 = new Coordinate(5.0, 6.0);
                Point point = fact.createPoint(c1);
                LineString line = fact.createLineString((Coordinate[])((Object[])new Coordinate[]{c1, c2}));
                Polygon poly = fact.createPolygon((Coordinate[])((Object[])new Coordinate[]{c1, c2, c3, c1}));
                MultiPoint mpoint = fact.createMultiPoint((Point[])((Object[])new Point[]{point, point, point}));
                MultiLineString mline = fact.createMultiLineString((LineString[])((Object[])new LineString[]{line, line, line}));
                MultiPolygon mpoly = fact.createMultiPolygon((Polygon[])((Object[])new Polygon[]{poly, poly, poly}));
                GeometryCollection coll = fact.createGeometryCollection((Geometry[])((Object[])new Geometry[]{point, line, poly, mpoint, mline, mpoly}));
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.pointLit(point)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> point);
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (LineString)this.dfBlank(this.spark()).select(package$.MODULE$.lineLit(line)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> line);
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Polygon)this.dfBlank(this.spark()).select(package$.MODULE$.polygonLit(poly)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> poly);
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (MultiPoint)this.dfBlank(this.spark()).select(package$.MODULE$.mPointLit(mpoint)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> mpoint);
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (MultiLineString)this.dfBlank(this.spark()).select(package$.MODULE$.mLineLit(mline)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> mline);
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (MultiPolygon)this.dfBlank(this.spark()).select(package$.MODULE$.mPolygonLit(mpoly)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> mpoly);
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (GeometryCollection)this.dfBlank(this.spark()).select(package$.MODULE$.geomCollLit(coll)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> coll);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.geomLit((Geometry)coll)).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> coll);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            return this.step((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.spark().stop());
        });
    }
}

