/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.jts.udf;

import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.junit.runner.RunWith;
import org.locationtech.geomesa.spark.jts.TestEnvironment;
import org.locationtech.geomesa.spark.jts.package$;
import org.locationtech.geomesa.spark.jts.util.WKTUtils$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.specs2.matcher.MatchResult$;
import org.specs2.mutable.Specification;
import org.specs2.runner.JUnitRunner;
import org.specs2.specification.core.AsExecution$;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001E2AAA\u0002\u0001!!)Q\u0004\u0001C\u0001=\tqr)Z8nKR\u0014\u0018nY!dG\u0016\u001c8o\u001c:Gk:\u001cG/[8ogR+7\u000f\u001e\u0006\u0003\t\u0015\t1!\u001e3g\u0015\t1q!A\u0002kiNT!\u0001C\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Y\u0011aB4f_6,7/\u0019\u0006\u0003\u00195\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011AD\u0001\u0004_J<7\u0001A\n\u0004\u0001EI\u0002C\u0001\n\u0018\u001b\u0005\u0019\"B\u0001\u000b\u0016\u0003\u001diW\u000f^1cY\u0016T!AF\u0007\u0002\rM\u0004XmY:3\u0013\tA2CA\u0007Ta\u0016\u001c\u0017NZ5dCRLwN\u001c\t\u00035mi\u0011!B\u0005\u00039\u0015\u0011q\u0002V3ti\u0016sg/\u001b:p]6,g\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\rAC\u0001\u0001\u0012+WA\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0007eVtg.\u001a:\u000b\u0005\u001dj\u0011!\u00026v]&$\u0018BA\u0015%\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c\u0013\u0001\f\t\u0003[=j\u0011A\f\u0006\u0003KUI!\u0001\r\u0018\u0003\u0017)+f.\u001b;Sk:tWM\u001d")
public class GeometricAccessorFunctionsTest
extends Specification
implements TestEnvironment {
    private SparkSession spark;
    private SQLContext sc;
    private volatile byte bitmap$0;

    @Override
    public Dataset<Row> dfBlank(SparkSession spark) {
        return TestEnvironment.dfBlank$(this, spark);
    }

    private SparkSession spark$lzycompute() {
        GeometricAccessorFunctionsTest geometricAccessorFunctionsTest = this;
        synchronized (geometricAccessorFunctionsTest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.spark = TestEnvironment.spark$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.spark;
    }

    @Override
    public SparkSession spark() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.spark$lzycompute() : this.spark;
    }

    private SQLContext sc$lzycompute() {
        GeometricAccessorFunctionsTest geometricAccessorFunctionsTest = this;
        synchronized (geometricAccessorFunctionsTest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sc = TestEnvironment.sc$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sc;
    }

    @Override
    public SQLContext sc() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sc$lzycompute() : this.sc;
    }

    public GeometricAccessorFunctionsTest() {
        TestEnvironment.$init$(this);
        this.sequential();
        this.step((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession sparkSession = this.spark();
        });
        this.blockExample("sql geometry accessors").should((Function0 & Serializable & scala.Serializable)() -> {
            this.blockExample("st_boundary").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_boundary(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_boundary(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                String line = "LINESTRING(1 1, 0 0, -1 1)";
                Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n          |select st_boundary(st_geomFromWKT('").append(line).append("'))\n        ").toString())).stripMargin());
                Geometry expected = WKTUtils$.MODULE$.read("MULTIPOINT(1 1, -1 1)");
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_boundary((Column)package$.MODULE$.st_geomFromWKT(line))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_coordDim").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_coordDim(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (Integer)this.dfBlank(this.spark()).select(package$.MODULE$.st_coordDim(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n          |select st_coordDim(st_geomFromWKT('POINT(0 0)'))\n        ")).stripMargin());
                this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 2);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Integer)this.dfBlank(this.spark()).select(package$.MODULE$.st_coordDim((Column)package$.MODULE$.st_geomFromWKT("POINT(0 0)"))).first()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 2);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_dimension").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_dimension(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Integer)this.dfBlank(this.spark()).select(package$.MODULE$.st_dimension(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_dimension(st_geomFromWKT('POINT(0 0)'))\n          ")).stripMargin());
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Integer)this.dfBlank(this.spark()).select(package$.MODULE$.st_dimension((Column)package$.MODULE$.st_geomFromWKT("POINT(0 0)"))).first()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("linestring").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "LINESTRING(1 1, 0 0, -1 1)";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n            |select st_dimension(st_geomFromWKT('").append(line).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Integer)this.dfBlank(this.spark()).select(package$.MODULE$.st_dimension((Column)package$.MODULE$.st_geomFromWKT(line))).first()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("polygon").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String poly = "POLYGON((30 10, 40 40, 20 40, 10 20, 30 10))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n            |select st_dimension(st_geomFromWKT('").append(poly).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 2);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Integer)this.dfBlank(this.spark()).select(package$.MODULE$.st_dimension((Column)package$.MODULE$.st_geomFromWKT(poly))).first()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 2);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("geometrycollection").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String geom = "GEOMETRYCOLLECTION(LINESTRING(1 1,0 0),POINT(0 0))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n             |select st_dimension(st_geomFromWKT('").append(geom).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Integer)this.dfBlank(this.spark()).select(package$.MODULE$.st_dimension((Column)package$.MODULE$.st_geomFromWKT(geom))).first()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            this.blockExample("st_envelope").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_envelope(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_envelope(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_envelope(st_geomFromWKT('POINT(0 0)'))\n          ")).stripMargin());
                    Geometry expected = WKTUtils$.MODULE$.read("POINT(0 0)");
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_envelope((Column)package$.MODULE$.st_geomFromWKT("POINT(0 0)"))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("linestring").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_envelope(st_geomFromWKT('LINESTRING(0 0, 1 3)'))\n          ")).stripMargin());
                    Geometry expected = WKTUtils$.MODULE$.read("POLYGON((0 0,0 3,1 3,1 0,0 0))");
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_envelope((Column)package$.MODULE$.st_geomFromWKT("LINESTRING(0 0, 1 3)"))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("polygon").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String poly = "POLYGON((0 0, 0 1, 1.0000001 1, 1.0000001 0, 0 0))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n            |select st_envelope(st_geomFromWKT('").append(poly).append("'))\n          ").toString())).stripMargin());
                    Geometry expected = WKTUtils$.MODULE$.read("POLYGON((0 0, 0 1, 1.0000001 1, 1.0000001 0, 0 0))");
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_envelope((Column)package$.MODULE$.st_geomFromWKT(poly))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            this.blockExample("st_exteriorRing").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_exteriorRing(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (LineString)this.dfBlank(this.spark()).select(package$.MODULE$.st_exteriorRing(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_exteriorRing(st_geomFromWKT('POINT(0 0)'))\n          ")).stripMargin());
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (LineString)this.dfBlank(this.spark()).select(package$.MODULE$.st_exteriorRing((Column)package$.MODULE$.st_geomFromWKT("POINT(0 0)"))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("polygon without an interior ring").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String poly = "POLYGON((30 10, 40 40, 20 40, 10 20, 30 10))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(68).append("\n             |select st_exteriorRing(st_geomFromWKT('").append(poly).append("'))\n          ").toString())).stripMargin());
                    Geometry expected = WKTUtils$.MODULE$.read("LINESTRING(30 10, 40 40, 20 40, 10 20, 30 10)");
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (LineString)this.dfBlank(this.spark()).select(package$.MODULE$.st_exteriorRing((Column)package$.MODULE$.st_geomFromWKT(poly))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("polygon with an interior ring").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String poly = "POLYGON ((35 10, 45 45, 15 40, 10 20, 35 10), (20 30, 35 35, 30 20, 20 30))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(67).append("\n            |select st_exteriorRing(st_geomFromWKT('").append(poly).append("'))\n          ").toString())).stripMargin());
                    Geometry expected = WKTUtils$.MODULE$.read("LINESTRING(35 10, 45 45, 15 40, 10 20, 35 10)");
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (LineString)this.dfBlank(this.spark()).select(package$.MODULE$.st_exteriorRing((Column)package$.MODULE$.st_geomFromWKT(poly))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            this.blockExample("st_geometryN").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_geometryN(null, null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_geometryN(functions$.MODULE$.lit(null), functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_geometryN(st_geomFromWKT('POINT(0 0)'), 1)\n          ")).stripMargin());
                    Geometry expected = WKTUtils$.MODULE$.read("POINT(0 0)");
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_geometryN((Column)package$.MODULE$.st_geomFromWKT("POINT(0 0)"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("multilinestring").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String geom = "MULTILINESTRING ((10 10, 20 20, 10 40),(40 40, 30 30, 40 20, 30 10))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(68).append("\n             |select st_geometryN(st_geomFromWKT('").append(geom).append("'), 1)\n          ").toString())).stripMargin());
                    Geometry expected = WKTUtils$.MODULE$.read("LINESTRING(10 10, 20 20, 10 40)");
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_geometryN((Column)package$.MODULE$.st_geomFromWKT(geom), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("geometrycollection").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String geom = "GEOMETRYCOLLECTION(LINESTRING(1 1,0 0),POINT(0 0))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(67).append("\n            |select st_geometryN(st_geomFromWKT('").append(geom).append("'), 1)\n          ").toString())).stripMargin());
                    Geometry expected = WKTUtils$.MODULE$.read("LINESTRING(1 1,0 0)");
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_geometryN((Column)package$.MODULE$.st_geomFromWKT(geom), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            this.blockExample("st_geometryType").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_geometryType(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_geomFromWKT(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_geometryType(st_geomFromWKT('POINT(0 0)'))\n          ")).stripMargin());
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> "Point");
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)this.dfBlank(this.spark()).select(package$.MODULE$.st_geometryType((Column)package$.MODULE$.st_geomFromWKT("POINT(0 0)"))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> "Point");
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("linestring").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_geometryType(st_geomFromWKT('LINESTRING(0 0, 1 3)'))\n          ")).stripMargin());
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> "LineString");
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)this.dfBlank(this.spark()).select(package$.MODULE$.st_geometryType((Column)package$.MODULE$.st_geomFromWKT("LINESTRING(0 0, 1 3)"))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> "LineString");
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("geometrycollection").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String geom = "GEOMETRYCOLLECTION(LINESTRING(1 1,0 0),POINT(0 0))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(67).append("\n            |select st_geometryType(st_geomFromWKT('").append(geom).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> "GeometryCollection");
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)this.dfBlank(this.spark()).select(package$.MODULE$.st_geometryType((Column)package$.MODULE$.st_geomFromWKT(geom))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> "GeometryCollection");
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            this.blockExample("st_interiorRingN").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_interiorRingN(null, null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_interiorRingN(functions$.MODULE$.lit(null), functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_interiorRingN(st_geomFromWKT('POINT(0 0)'), 1)\n          ")).stripMargin());
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_interiorRingN((Column)package$.MODULE$.st_geomFromWKT("POINT(0 0)"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("polygon with a valid int").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String poly = "POLYGON ((35 10, 45 45, 15 40, 10 20, 35 10),(20 30, 35 35, 30 20, 20 30))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(71).append("\n            |select st_interiorRingN(st_geomFromWKT('").append(poly).append("'), 1)\n          ").toString())).stripMargin());
                    Geometry expected = WKTUtils$.MODULE$.read("LINESTRING(20 30, 35 35, 30 20, 20 30)");
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_interiorRingN((Column)package$.MODULE$.st_geomFromWKT(poly), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("polygon with an invalid int").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String poly = "POLYGON ((35 10, 45 45, 15 40, 10 20, 35 10), (20 30, 35 35, 30 20, 20 30))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(71).append("\n            |select st_interiorRingN(st_geomFromWKT('").append(poly).append("'), 5)\n          ").toString())).stripMargin());
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)this.dfBlank(this.spark()).select(package$.MODULE$.st_interiorRingN((Column)package$.MODULE$.st_geomFromWKT(poly), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)5)))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            this.blockExample("st_isClosed").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_isClosed(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isClosed(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("open linestring").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "LINESTRING(0 0, 1 1)";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n            |select st_isClosed(st_geomFromWKT('").append(line).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isClosed((Column)package$.MODULE$.st_geomFromWKT(line))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("closed linestring").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "LINESTRING(0 0, 0 1, 1 1, 0 0)";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n            |select st_isClosed(st_geomFromWKT('").append(line).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isClosed((Column)package$.MODULE$.st_geomFromWKT(line))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("open multilinestring").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "MULTILINESTRING((0 0, 0 1, 1 1, 0 0),(0 0, 1 1))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n             |select st_isClosed(st_geomFromWKT('").append(line).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isClosed((Column)package$.MODULE$.st_geomFromWKT(line))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("closed multilinestring").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "MULTILINESTRING((0 0, 0 1, 1 1, 0 0),(0 0, 1 1, 0 0))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n             |select st_isClosed(st_geomFromWKT('").append(line).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isClosed((Column)package$.MODULE$.st_geomFromWKT(line))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            this.blockExample("st_isCollection").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_isCollection(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isCollection(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_isCollection(st_geomFromWKT('POINT(0 0)'))\n          ")).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isCollection((Column)package$.MODULE$.st_geomFromWKT("POINT(0 0)"))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("multipoint").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String point = "MULTIPOINT((0 0), (42 42))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(68).append("\n             |select st_isCollection(st_geomFromWKT('").append(point).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isCollection((Column)package$.MODULE$.st_geomFromWKT(point))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("geometrycollection").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String geom = "GEOMETRYCOLLECTION(POINT(0 0))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(67).append("\n            |select st_isCollection(st_geomFromWKT('").append(geom).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isCollection((Column)package$.MODULE$.st_geomFromWKT(geom))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            this.blockExample("st_isEmpty").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_isEmpty(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull()), AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("empty geometrycollection").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_isEmpty(st_geomFromWKT('GEOMETRYCOLLECTION EMPTY'))\n          ")).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isEmpty((Column)package$.MODULE$.st_geomFromWKT("GEOMETRYCOLLECTION EMPTY"))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("non-empty point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_isEmpty(st_geomFromWKT('POINT(0 0)'))\n          ")).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isEmpty((Column)package$.MODULE$.st_geomFromWKT("POINT(0 0)"))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            this.blockExample("st_isRing").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_isRing(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isRing(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("closed and simple linestring").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "LINESTRING(0 0, 0 1, 1 1, 1 0, 0 0)";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(62).append("\n             |select st_isRing(st_geomFromWKT('").append(line).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isRing((Column)package$.MODULE$.st_geomFromWKT(line))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("closed and non-simple linestring").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "LINESTRING(0 0, 0 1, 1 0, 1 1, 0 0)";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(62).append("\n             |select st_isRing(st_geomFromWKT('").append(line).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isRing((Column)package$.MODULE$.st_geomFromWKT(line))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            this.blockExample("st_isSimple").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_isSimple(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isSimple(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("simple point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_isSimple(st_geomFromWKT('POINT(0 0)'))\n          ")).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isSimple((Column)package$.MODULE$.st_geomFromWKT("POINT(0 0)"))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("simple linestring").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "LINESTRING(0 0, 0 1, 1 1, 1 0, 0 0)";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n             |select st_isSimple(st_geomFromWKT('").append(line).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isSimple((Column)package$.MODULE$.st_geomFromWKT(line))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("non-simple linestring").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "LINESTRING(1 1,2 2,2 3.5,1 3,1 2,2 1)";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n             |select st_isSimple(st_geomFromWKT('").append(line).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isSimple((Column)package$.MODULE$.st_geomFromWKT(line))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("non-simple polygon").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String poly = "POLYGON((1 2, 3 4, 5 6, 1 2))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n            |select st_isSimple(st_geomFromWKT('").append(poly).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isSimple((Column)package$.MODULE$.st_geomFromWKT(poly))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            this.blockExample("st_isValid").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_isValid(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isValid(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("valid linestring").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "LINESTRING(0 0, 1 1)";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n             |select st_isValid(st_geomFromWKT('").append(line).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isValid((Column)package$.MODULE$.st_geomFromWKT(line))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beTrue());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("invalid polygon").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String poly = "POLYGON((0 0, 1 1, 1 2, 1 1, 0 0))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(62).append("\n            |select st_isValid(st_geomFromWKT('").append(poly).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                    return this.theValue((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> (Boolean)this.dfBlank(this.spark()).select(package$.MODULE$.st_isValid((Column)package$.MODULE$.st_geomFromWKT(poly))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beFalse());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            this.blockExample("st_numGeometries").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_numGeometries(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Integer)this.dfBlank(this.spark()).select(package$.MODULE$.st_numGeometries(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_numGeometries(st_geomFromWKT('POINT(0 0)'))\n          ")).stripMargin());
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Integer)this.dfBlank(this.spark()).select(package$.MODULE$.st_numGeometries((Column)package$.MODULE$.st_geomFromWKT("POINT(0 0)"))).first()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("linestring").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "LINESTRING(0 0, 0 1, 1 1, 1 0, 0 0)";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append("\n             |select st_numGeometries(st_geomFromWKT('").append(line).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Integer)this.dfBlank(this.spark()).select(package$.MODULE$.st_numGeometries((Column)package$.MODULE$.st_geomFromWKT(line))).first()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("geometrycollection").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String geom = "GEOMETRYCOLLECTION(MULTIPOINT(-2 3,-2 2), LINESTRING(5 5,10 10), POLYGON((-7 4.2,-7.1 5,-7.1 4.3,-7 4.2)))";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append("\n             |select st_numGeometries(st_geomFromWKT('").append(geom).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 3);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Integer)this.dfBlank(this.spark()).select(package$.MODULE$.st_numGeometries((Column)package$.MODULE$.st_geomFromWKT(geom))).first()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 3);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            this.blockExample("st_numPoints").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_numPoints(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Integer)this.dfBlank(this.spark()).select(package$.MODULE$.st_numPoints(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_numPoints(st_geomFromWKT('POINT(0 0)'))\n          ")).stripMargin());
                    return this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("multipoint").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String point = "MULTIPOINT(-2 3,-2 2)";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n             |select st_numPoints(st_geomFromWKT('").append(point).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 2);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Integer)this.dfBlank(this.spark()).select(package$.MODULE$.st_numPoints((Column)package$.MODULE$.st_geomFromWKT(point))).first()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 2);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("multipoint").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String geom = "LINESTRING(0 0, 0 1, 1 1, 1 0, 0 0)";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n             |select st_numPoints(st_geomFromWKT('").append(geom).append("'))\n          ").toString())).stripMargin());
                    this.theValue((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0))).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 5);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Integer)this.dfBlank(this.spark()).select(package$.MODULE$.st_numPoints((Column)package$.MODULE$.st_geomFromWKT(geom))).first()).mustEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 5);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            this.blockExample("st_pointN").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_pointN(null, null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_pointN(functions$.MODULE$.lit(null), functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("first point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "LINESTRING(0 0, 0 1, 1 1, 1 0, 0 2)";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n             |select st_pointN(st_geomFromWKT('").append(line).append("'), 1)\n          ").toString())).stripMargin());
                    Geometry expected = WKTUtils$.MODULE$.read("POINT(0 0)");
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_pointN((Column)package$.MODULE$.st_geomFromWKT(line), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1)))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("last point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "LINESTRING(0 0, 0 1, 1 1, 1 0, 0 2)";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n            |select st_pointN(st_geomFromWKT('").append(line).append("'), 5)\n          ").toString())).stripMargin());
                    Geometry expected = WKTUtils$.MODULE$.read("POINT(0 2)");
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_pointN((Column)package$.MODULE$.st_geomFromWKT(line), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)5)))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("first point using a negative index").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "LINESTRING(0 0, 0 1, 1 1, 1 0, 0 2)";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(65).append("\n            |select st_pointN(st_geomFromWKT('").append(line).append("'), -5)\n          ").toString())).stripMargin());
                    Geometry expected = WKTUtils$.MODULE$.read("POINT(0 0)");
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_pointN((Column)package$.MODULE$.st_geomFromWKT(line), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)-5)))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("last point using a negative index").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "LINESTRING(0 0, 0 1, 1 1, 1 0, 0 2)";
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(66).append("\n             |select st_pointN(st_geomFromWKT('").append(line).append("'), -1)\n          ").toString())).stripMargin());
                    Geometry expected = WKTUtils$.MODULE$.read("POINT(0 2)");
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Geometry)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Point)this.dfBlank(this.spark()).select(package$.MODULE$.st_pointN((Column)package$.MODULE$.st_geomFromWKT(line), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)-1)))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            this.blockExample("st_x").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_x(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Float)this.dfBlank(this.spark()).select(package$.MODULE$.st_x(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_x(st_geomFromWKT('POINT(0 1)'))\n          ")).stripMargin());
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Float)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Float)this.dfBlank(this.spark()).select(package$.MODULE$.st_x((Column)package$.MODULE$.st_geomFromWKT("POINT(0 1)"))).first()).mustEqual((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("non-point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_x(st_geomFromWKT('LINESTRING(0 0, 0 1, 1 1, 1 0, 0 0)'))\n          ")).stripMargin());
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Float)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Float)this.dfBlank(this.spark()).select(package$.MODULE$.st_x((Column)package$.MODULE$.st_geomFromWKT("LINESTRING(0 0, 0 1, 1 1, 1 0, 0 0)"))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            return this.blockExample("st_y").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_y(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Float)this.dfBlank(this.spark()).select(package$.MODULE$.st_y(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_y(st_geomFromWKT('POINT(0 1)'))\n          ")).stripMargin());
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Float)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).mustEqual((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 1.0f);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Float)this.dfBlank(this.spark()).select(package$.MODULE$.st_y((Column)package$.MODULE$.st_geomFromWKT("POINT(0 1)"))).first()).mustEqual((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 1.0f);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("non-point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset result = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_y(st_geomFromWKT('LINESTRING(0 0, 0 1, 1 1, 1 0, 0 0)'))\n          ")).stripMargin());
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (Float)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.collect())).head()).getAs(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (Float)this.dfBlank(this.spark()).select(package$.MODULE$.st_y((Column)package$.MODULE$.st_geomFromWKT("LINESTRING(0 0, 0 1, 1 1, 1 0, 0 0)"))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
        });
        this.step((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.spark().stop());
    }
}

