/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.jts.udf;

import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.junit.runner.RunWith;
import org.locationtech.geomesa.spark.jts.TestEnvironment;
import org.locationtech.geomesa.spark.jts.package$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.specs2.matcher.MatchResult$;
import org.specs2.mutable.Specification;
import org.specs2.runner.JUnitRunner;
import org.specs2.specification.core.AsExecution$;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001E2AAA\u0002\u0001!!)Q\u0004\u0001C\u0001=\tar)Z8nKR\u0014\u0018nY(viB,HOR;oGRLwN\\:UKN$(B\u0001\u0003\u0006\u0003\r)HM\u001a\u0006\u0003\r\u001d\t1A\u001b;t\u0015\tA\u0011\"A\u0003ta\u0006\u00148N\u0003\u0002\u000b\u0017\u00059q-Z8nKN\f'B\u0001\u0007\u000e\u00031awnY1uS>tG/Z2i\u0015\u0005q\u0011aA8sO\u000e\u00011c\u0001\u0001\u00123A\u0011!cF\u0007\u0002')\u0011A#F\u0001\b[V$\u0018M\u00197f\u0015\t1R\"\u0001\u0004ta\u0016\u001c7OM\u0005\u00031M\u0011Qb\u00159fG&4\u0017nY1uS>t\u0007C\u0001\u000e\u001c\u001b\u0005)\u0011B\u0001\u000f\u0006\u0005=!Vm\u001d;F]ZL'o\u001c8nK:$\u0018A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0004Q\u0011\u0001!EK\u0016\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013A\u0002:v]:,'O\u0003\u0002(\u001b\u0005)!.\u001e8ji&\u0011\u0011\u0006\n\u0002\b%Vtw+\u001b;i\u0003\u00151\u0018\r\\;fG\u0005a\u0003CA\u00170\u001b\u0005q#BA\u0013\u0016\u0013\t\u0001dFA\u0006K+:LGOU;o]\u0016\u0014\b")
public class GeometricOutputFunctionsTest
extends Specification
implements TestEnvironment {
    private SparkSession spark;
    private SQLContext sc;
    private volatile byte bitmap$0;

    @Override
    public Dataset<Row> dfBlank(SparkSession spark) {
        return TestEnvironment.dfBlank$(this, spark);
    }

    private SparkSession spark$lzycompute() {
        GeometricOutputFunctionsTest geometricOutputFunctionsTest = this;
        synchronized (geometricOutputFunctionsTest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.spark = TestEnvironment.spark$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.spark;
    }

    @Override
    public SparkSession spark() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.spark$lzycompute() : this.spark;
    }

    private SQLContext sc$lzycompute() {
        GeometricOutputFunctionsTest geometricOutputFunctionsTest = this;
        synchronized (geometricOutputFunctionsTest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sc = TestEnvironment.sc$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sc;
    }

    @Override
    public SQLContext sc() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sc$lzycompute() : this.sc;
    }

    public GeometricOutputFunctionsTest() {
        TestEnvironment.$init$(this);
        this.blockExample("sql geometry constructors").should((Function0 & Serializable & scala.Serializable)() -> {
            this.sequential();
            this.step((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                SparkSession sparkSession = this.spark();
            });
            this.blockExample("st_asBinary").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_asBinary(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (byte[])this.dfBlank(this.spark()).select(package$.MODULE$.st_asBinary(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n          |select st_asBinary(st_geomFromWKT('POLYGON((0 0, 2 0, 2 2, 0 2, 0 0))'))\n        ")).stripMargin());
                byte[] expected = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, 0, 0, 0, 3, 0, 0, 0, 1, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}), ClassTag$.MODULE$.Byte());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (byte[])((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (byte[])this.dfBlank(this.spark()).select(package$.MODULE$.st_asBinary((Column)package$.MODULE$.st_geomFromWKT("POLYGON((0 0, 2 0, 2 2, 0 2, 0 0))"))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_asBinary with 3 dimensions").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n          |select st_asBinary(st_geomFromWKT('POLYGON((0 0 1, 2 0 1, 2 2 1, 0 2 1, 0 0 1))'))\n        ")).stripMargin());
                byte[] expected = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0, -128, 0, 0, 3, 0, 0, 0, 1, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, -16, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, -16, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 63, -16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 63, -16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, -16, 0, 0, 0, 0, 0, 0}), ClassTag$.MODULE$.Byte());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (byte[])((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (byte[])this.dfBlank(this.spark()).select(package$.MODULE$.st_asBinary((Column)package$.MODULE$.st_geomFromWKT("POLYGON((0 0 1, 2 0 1, 2 2 1, 0 2 1, 0 0 1))"))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_asGeoJSON").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.blockExample("null").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_asGeoJSON(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)this.dfBlank(this.spark()).select(package$.MODULE$.st_asGeoJSON(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("point").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString("\n            |select st_asGeoJSON(st_geomFromWKT('POINT(0 0)'))\n          ")).stripMargin());
                    String expected = "{\"type\":\"Point\",\"coordinates\":[0.0,0.0]}";
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)this.dfBlank(this.spark()).select(package$.MODULE$.st_asGeoJSON((Column)package$.MODULE$.st_geomFromWKT("POINT(0 0)"))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("lineString").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "LINESTRING(0 0, 1 1, 2 2)";
                    Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n            |select st_asGeoJSON(st_geomFromWKT('").append(line).append("'))\n          ").toString())).stripMargin());
                    String expected = "{\"type\":\"LineString\",\"coordinates\":[[0.0,0.0],[1,1],[2,2]]}";
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)this.dfBlank(this.spark()).select(package$.MODULE$.st_asGeoJSON((Column)package$.MODULE$.st_geomFromWKT(line))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("polygon").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String poly = "POLYGON((0.45 0.75, 1.15 0.75, 1.15 1.45, 0.45 1.45, 0.45 0.75))";
                    Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n            |select st_asGeoJSON(st_geomFromWKT('").append(poly).append("'))\n          ").toString())).stripMargin());
                    String expected = "{\"type\":\"Polygon\",\"coordinates\":[[[0.45,0.75],[1.15,0.75],[1.15,1.45],[0.45,1.45],[0.45,0.75]]]}";
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)this.dfBlank(this.spark()).select(package$.MODULE$.st_asGeoJSON((Column)package$.MODULE$.st_geomFromWKT(poly))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("multiPoint").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String point = "MULTIPOINT((0 0), (1 1))";
                    Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n            |select st_asGeoJSON(st_geomFromWKT('").append(point).append("'))\n          ").toString())).stripMargin());
                    String expected = "{\"type\":\"MultiPoint\",\"coordinates\":[[0.0,0.0],[1,1]]}";
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)this.dfBlank(this.spark()).select(package$.MODULE$.st_asGeoJSON((Column)package$.MODULE$.st_geomFromWKT(point))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("multiLineString").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String line = "MULTILINESTRING((0 0, 1 1, 2 2), (-3 -3, -2 -2, -1 -1))";
                    Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n            |select st_asGeoJSON(st_geomFromWKT('").append(line).append("'))\n          ").toString())).stripMargin());
                    String expected = "{\"type\":\"MultiLineString\",\"coordinates\":[[[0.0,0.0],[1,1],[2,2]],[[-3,-3],[-2,-2],[-1,-1]]]}";
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                this.blockExample("multiPolygon").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String poly = "MULTIPOLYGON(((0.45 0.75, 1.15 0.75, 1.15 1.45, 0.45 1.45, 0.45 0.75)),((0 0, 1 0, 1 1, 0 1, 0 0)))";
                    Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n            |select st_asGeoJSON(st_geomFromWKT('").append(poly).append("'))\n          ").toString())).stripMargin());
                    String expected = "{\"type\":\"MultiPolygon\",\"coordinates\":[[[[0.45,0.75],[1.15,0.75],[1.15,1.45],[0.45,1.45],[0.45,0.75]]],[[[0.0,0.0],[1,0.0],[1,1],[0.0,1],[0.0,0.0]]]]}";
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)this.dfBlank(this.spark()).select(package$.MODULE$.st_asGeoJSON((Column)package$.MODULE$.st_geomFromWKT(poly))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
                return this.blockExample("geometryCollection").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                    String geom = "GEOMETRYCOLLECTION(POINT(0 0), LINESTRING(0 0, 1 1, 2 2))";
                    Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n            |select st_asGeoJSON(st_geomFromWKT('").append(geom).append("'))\n          ").toString())).stripMargin());
                    String expected = "{\"type\":\"GeometryCollection\",\"geometries\":[{\"type\":\"Point\",\"coordinates\":[0.0,0.0]},{\"type\":\"LineString\",\"coordinates\":[[0.0,0.0],[1,1],[2,2]]}]}";
                    this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                    return this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)this.dfBlank(this.spark()).select(package$.MODULE$.st_asGeoJSON((Column)package$.MODULE$.st_geomFromWKT(geom))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            });
            this.blockExample("st_asLatLonText").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_asLatLonText(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                GeometryFactory gf = new GeometryFactory();
                Dataset df = this.sc().createDataset((Seq)new .colon.colon((Object)gf.createPoint(new Coordinate(-76.5, 38.5)), (List)Nil$.MODULE$), package$.MODULE$.jtsPointEncoder()).toDF();
                Dataset r = df.select(package$.MODULE$.st_asLatLonText(functions$.MODULE$.col("value")));
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).mustEqual((Function0 & Serializable & scala.Serializable)() -> "38\u00b030'0.000\"N 77\u00b030'0.000\"W");
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_asText").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_asText(null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)this.dfBlank(this.spark()).select(package$.MODULE$.st_asText(functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                String point = "POINT (-76.5 38.5)";
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(57).append("\n          |select st_asText(st_geomFromWKT('").append(point).append("'))\n        ").toString())).stripMargin());
                String expected = "POINT (-76.5 38.5)";
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)this.dfBlank(this.spark()).select(package$.MODULE$.st_asText((Column)package$.MODULE$.st_geomFromWKT(point))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("st_geoHash").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                this.theValue((Function0 & Serializable & scala.Serializable)() -> ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.sc().sql("select st_geoHash(null, null)").collect())).head()).apply(0)).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)this.dfBlank(this.spark()).select(package$.MODULE$.st_geoHash(functions$.MODULE$.lit(null), functions$.MODULE$.lit(null))).first()).must((Function0 & Serializable & scala.Serializable)() -> this.beNull());
                String point = "POINT (-76.5 38.5)";
                int precision = 25;
                Dataset r = this.sc().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(60).append("\n          |select st_geoHash(st_geomFromWKT('").append(point).append("'), ").append(precision).append(")\n        ").toString())).stripMargin());
                String expected = "dqce5";
                this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])r.collect())).head()).getAs(0)).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
                return this.theValue((Function0 & Serializable & scala.Serializable)() -> (String)this.dfBlank(this.spark()).select(package$.MODULE$.st_geoHash((Column)package$.MODULE$.st_geomFromWKT(functions$.MODULE$.lit((Object)point)), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)precision)))).first()).mustEqual((Function0 & Serializable & scala.Serializable)() -> expected);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            return this.step((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.spark().stop());
        });
    }
}

