/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.jts.util;

import java.io.Serializable;
import org.locationtech.geomesa.spark.jts.util.Bounds;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class GeoHash$ {
    public static GeoHash$ MODULE$;
    private double latRange;
    private double lonRange;
    private Map<Object, Object> powersOf2Map;
    private Map<Object, Object> latDeltaMap;
    private Map<Object, Object> lonDeltaMap;
    private GeometryFactory latLonGeoFactory;
    private final int MAX_PRECISION;
    private final Bounds latBounds;
    private final Bounds lonBounds;
    private final double lonMax;
    private final double latMax;
    private final int[] bits;
    private final String base32;
    private final Map<Object, scala.collection.BitSet> characterMap;
    private volatile byte bitmap$0;

    static {
        new GeoHash$();
    }

    public int MAX_PRECISION() {
        return this.MAX_PRECISION;
    }

    private Bounds latBounds() {
        return this.latBounds;
    }

    private Bounds lonBounds() {
        return this.lonBounds;
    }

    private double latRange$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.latRange = this.latBounds().high() - this.latBounds().low();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.latRange;
    }

    private double latRange() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.latRange$lzycompute() : this.latRange;
    }

    private double lonRange$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.lonRange = this.lonBounds().high() - this.lonBounds().low();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.lonRange;
    }

    private double lonRange() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.lonRange$lzycompute() : this.lonRange;
    }

    private Map<Object, Object> powersOf2Map$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.powersOf2Map = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.MAX_PRECISION()).map((Function1 & Serializable & scala.Serializable)i -> GeoHash$.$anonfun$powersOf2Map$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.powersOf2Map;
    }

    private Map<Object, Object> powersOf2Map() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.powersOf2Map$lzycompute() : this.powersOf2Map;
    }

    private Map<Object, Object> latDeltaMap$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.latDeltaMap = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.MAX_PRECISION()).map((Function1 & Serializable & scala.Serializable)i -> GeoHash$.$anonfun$latDeltaMap$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.latDeltaMap;
    }

    private Map<Object, Object> latDeltaMap() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.latDeltaMap$lzycompute() : this.latDeltaMap;
    }

    private Map<Object, Object> lonDeltaMap$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.lonDeltaMap = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.MAX_PRECISION()).map((Function1 & Serializable & scala.Serializable)i -> GeoHash$.$anonfun$lonDeltaMap$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.lonDeltaMap;
    }

    private Map<Object, Object> lonDeltaMap() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.lonDeltaMap$lzycompute() : this.lonDeltaMap;
    }

    public double latitudeDeltaForPrecision(int prec) {
        this.checkPrecision(prec);
        return BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
    }

    public double longitudeDeltaForPrecision(int prec) {
        this.checkPrecision(prec);
        return BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
    }

    private double lonMax() {
        return this.lonMax;
    }

    private double latMax() {
        return this.latMax;
    }

    private int[] bits() {
        return this.bits;
    }

    public String base32() {
        return this.base32;
    }

    private Map<Object, scala.collection.BitSet> characterMap() {
        return this.characterMap;
    }

    private GeometryFactory latLonGeoFactory$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.latLonGeoFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.latLonGeoFactory;
    }

    public GeometryFactory latLonGeoFactory() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.latLonGeoFactory$lzycompute() : this.latLonGeoFactory;
    }

    private Envelope envFromIndiciesDeltas(long lonIndex, long latIndex, double lonDelta, double latDelta) {
        return new Envelope(this.lonBounds().low() + lonDelta * (double)lonIndex, this.lonBounds().low() + lonDelta * (double)(lonIndex + 1L), this.latBounds().low() + latDelta * (double)latIndex, this.latBounds().low() + latDelta * (double)(latIndex + 1L));
    }

    private long interleaveReverseBits(long first, long second, int numBits) {
        Tuple2.mcJJ.sp sp2;
        boolean even = (numBits & 1) == 0;
        Tuple2.mcJJ.sp sp3 = sp2 = even ? new Tuple2.mcJJ.sp(second, first) : new Tuple2.mcJJ.sp(first, second);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        long actualFirst = sp2._1$mcJ$sp();
        long actualSecond = sp2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(actualFirst, actualSecond);
        Tuple2.mcJJ.sp sp5 = sp4;
        long actualFirst2 = sp5._1$mcJ$sp();
        long actualSecond2 = sp5._2$mcJ$sp();
        int numPairs = numBits >> 1;
        LongRef result = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPairs).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pairNum -> {
            result$1.elem = result$1.elem << 1 | actualFirst2 >> pairNum & 1L;
            result$1.elem = result$1.elem << 1 | actualSecond2 >> pairNum & 1L;
        });
        return !even ? result.elem << 1 | actualFirst2 >> numPairs & 1L : result.elem;
    }

    private Tuple2<Object, Object> extractReverseBits(long value, int numBits) {
        int numPairs = numBits >> 1;
        LongRef first = LongRef.create((long)0L);
        LongRef second = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPairs).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pairNum -> {
            first$1.elem = first$1.elem << 1 | value >> pairNum * 2 & 1L;
            second$1.elem = second$1.elem << 1 | value >> pairNum * 2 + 1 & 1L;
        });
        return new Tuple2.mcJJ.sp((numBits & 1) == 1 ? first.elem << 1 | value >> numBits - 1 & 1L : first.elem, second.elem);
    }

    private scala.collection.BitSet shift(int n, scala.collection.BitSet bs) {
        return (scala.collection.BitSet)bs.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$2 -> x$2 + n, scala.collection.BitSet$.MODULE$.canBuildFrom());
    }

    private scala.collection.BitSet bitSetFromBase32Character(long charIndex) {
        return scala.collection.BitSet$.MODULE$.apply((Seq)((TraversableLike)((TraversableLike)new StringOps(Predef$.MODULE$.augmentString(this.toPaddedBinaryString(charIndex, 5))).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GeoHash$.$anonfun$bitSetFromBase32Character$1(x0$1)))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._2$mcI$sp()), IndexedSeq$.MODULE$.canBuildFrom()));
    }

    private String toPaddedBinaryString(long i, int length) {
        return String.format(new StringBuilder(2).append("%").append(length).append("s").toString(), RichLong$.MODULE$.toBinaryString$extension(Predef$.MODULE$.longWrapper(i))).replace(' ', '0');
    }

    private String toBase32(scala.collection.BitSet bitset, int prec) {
        int n;
        int numLeftoverBits;
        int n2 = numLeftoverBits = prec % 5;
        switch (n2) {
            case 0: {
                n = 0;
                break;
            }
            default: {
                n = 5 - numLeftoverBits;
                break;
            }
        }
        int precision = prec + n;
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), precision).grouped(5).map((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToCharacter((char)GeoHash$.MODULE$.ch((IndexedSeq<Object>)i, bitset))).mkString();
    }

    private char ch(IndexedSeq<Object> v, scala.collection.BitSet bitset) {
        return StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.base32()), BoxesRunTime.unboxToInt((Object)v.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(cur, i) -> cur + (bitset.apply((Object)BoxesRunTime.boxToInteger((int)i)) ? MODULE$.bits()[i % MODULE$.bits().length] : 0))));
    }

    public void checkPrecision(int precision) {
        Predef$.MODULE$.require(precision <= this.MAX_PRECISION(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("GeoHash precision of ").append(precision).append(" requested, but precisions above ").append(MODULE$.MAX_PRECISION()).append(" are not supported").toString());
    }

    public String encode(double lon, double lat, int prec) {
        Predef$.MODULE$.require(lon >= -180.0 && lon <= 180.0);
        Predef$.MODULE$.require(lat >= -90.0 && lat <= 90.0);
        this.checkPrecision(prec);
        double lonDelta = BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
        double latDelta = BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
        long lonIndex = lon == 180.0 ? (long)(this.lonMax() / lonDelta) : (long)((lon - this.lonBounds().low()) / lonDelta);
        long latIndex = lat == 90.0 ? (long)(this.latMax() / latDelta) : (long)((lat - this.latBounds().low()) / latDelta);
        BitSet bitSet = BitSet$.MODULE$.fromBitMaskNoCopy(new long[]{this.interleaveReverseBits(lonIndex, latIndex, prec)});
        return this.toBase32((scala.collection.BitSet)bitSet, prec);
    }

    public int encode$default$3() {
        return 25;
    }

    public Geometry decode(String string, Option<Object> precisionOption) {
        scala.collection.BitSet bitSet;
        int prec = BoxesRunTime.unboxToInt((Object)precisionOption.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 5 * string.length()));
        this.checkPrecision(prec);
        scala.collection.immutable.IndexedSeq bitsets = (scala.collection.immutable.IndexedSeq)((TraversableLike)new StringOps(Predef$.MODULE$.augmentString(string)).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            char c = tuple2._1$mcC$sp();
            int i = tuple2._2$mcI$sp();
            char c2 = c;
            int n = i;
            scala.collection.BitSet bitSet = MODULE$.shift(n * 5, (scala.collection.BitSet)MODULE$.characterMap().apply((Object)BoxesRunTime.boxToCharacter((char)c2)));
            return bitSet;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        int n = bitsets.size();
        switch (n) {
            case 0: {
                bitSet = scala.collection.BitSet$.MODULE$.apply((Seq)Nil$.MODULE$);
                break;
            }
            case 1: {
                bitSet = (scala.collection.BitSet)bitsets.apply(0);
                break;
            }
            default: {
                bitSet = (scala.collection.BitSet)bitsets.reduce((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> (scala.collection.BitSet)x$4.$bar(x$5));
                break;
            }
        }
        scala.collection.BitSet finalBitset = bitSet;
        Tuple2<Object, Object> tuple2 = this.extractReverseBits(BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(finalBitset.toBitMask())).head()), prec);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long lonIndex = tuple2._1$mcJ$sp();
        long latIndex = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(lonIndex, latIndex);
        Tuple2.mcJJ.sp sp3 = sp2;
        long lonIndex2 = sp3._1$mcJ$sp();
        long latIndex2 = sp3._2$mcJ$sp();
        Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec))), BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec))));
        if (sp4 == null) {
            throw new MatchError((Object)sp4);
        }
        double lonDelta = sp4._1$mcD$sp();
        double latDelta = sp4._2$mcD$sp();
        Tuple2.mcDD.sp sp5 = new Tuple2.mcDD.sp(lonDelta, latDelta);
        Tuple2.mcDD.sp sp6 = sp5;
        double lonDelta2 = sp6._1$mcD$sp();
        double latDelta2 = sp6._2$mcD$sp();
        Envelope envelope = this.envFromIndiciesDeltas(lonIndex2, latIndex2, lonDelta2, latDelta2);
        return this.latLonGeoFactory().toGeometry(envelope);
    }

    public Option<Object> decode$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ Tuple2 $anonfun$powersOf2Map$1(int i) {
        return new Tuple2.mcIJ.sp(i, 1L << i);
    }

    public static final /* synthetic */ Tuple2 $anonfun$latDeltaMap$1(int i) {
        return new Tuple2.mcID.sp(i, MODULE$.latRange() / (double)BoxesRunTime.unboxToLong((Object)MODULE$.powersOf2Map().apply((Object)BoxesRunTime.boxToInteger((int)(i / 2)))));
    }

    public static final /* synthetic */ Tuple2 $anonfun$lonDeltaMap$1(int i) {
        return new Tuple2.mcID.sp(i, MODULE$.lonRange() / (double)BoxesRunTime.unboxToLong((Object)MODULE$.powersOf2Map().apply((Object)BoxesRunTime.boxToInteger((int)(i / 2 + i % 2)))));
    }

    public static final /* synthetic */ boolean $anonfun$bitSetFromBase32Character$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        char c = tuple2._1$mcC$sp();
        boolean bl = c == '1';
        return bl;
    }

    private GeoHash$() {
        MODULE$ = this;
        this.MAX_PRECISION = 63;
        this.latBounds = new Bounds(-90.0, 90.0);
        this.lonBounds = new Bounds(-180.0, 180.0);
        this.lonMax = (double)360 - package$.MODULE$.pow(0.5, 32.0);
        this.latMax = (double)180 - package$.MODULE$.pow(0.5, 32.0);
        this.bits = new int[]{16, 8, 4, 2, 1};
        this.base32 = "0123456789bcdefghjkmnpqrstuvwxyz";
        this.characterMap = ((TraversableOnce)((TraversableLike)new StringOps(Predef$.MODULE$.augmentString(this.base32())).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            char c = tuple2._1$mcC$sp();
            int i = tuple2._2$mcI$sp();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)c)), (Object)MODULE$.bitSetFromBase32Character(i));
            return tuple22;
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }
}

