/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.jts.docs;

import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.junit.runner.RunWith;
import org.locationtech.geomesa.spark.jts.TestEnvironment;
import org.locationtech.geomesa.spark.jts.package;
import org.locationtech.geomesa.spark.jts.package$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.specs2.matcher.MatchResult;
import org.specs2.matcher.MatchResult$;
import org.specs2.mutable.Specification;
import org.specs2.runner.JUnitRunner;
import org.specs2.specification.core.AsExecution$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u0001E2AAA\u0002\u0001!!)Q\u0004\u0001C\u0001=\tY!\nV*E_\u000e\u001cH+Z:u\u0015\t!Q!\u0001\u0003e_\u000e\u001c(B\u0001\u0004\b\u0003\rQGo\u001d\u0006\u0003\u0011%\tQa\u001d9be.T!AC\u0006\u0002\u000f\u001d,w.\\3tC*\u0011A\"D\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u001d\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!E\r\u0011\u0005I9R\"A\n\u000b\u0005Q)\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0003-5\taa\u001d9fGN\u0014\u0014B\u0001\r\u0014\u00055\u0019\u0006/Z2jM&\u001c\u0017\r^5p]B\u0011!dG\u0007\u0002\u000b%\u0011A$\u0002\u0002\u0010)\u0016\u001cH/\u00128wSJ|g.\\3oi\u00061A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011a\u0001\u0015\u0005\u0001\tR3\u0006\u0005\u0002$Q5\tAE\u0003\u0002&M\u00051!/\u001e8oKJT!aJ\u0007\u0002\u000b),h.\u001b;\n\u0005%\"#a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0002YA\u0011QfL\u0007\u0002])\u0011Q%F\u0005\u0003a9\u00121BS+oSR\u0014VO\u001c8fe\u0002")
public class JTSDocsTest
extends Specification
implements TestEnvironment {
    private SparkSession spark;
    private SQLContext sc;
    private volatile byte bitmap$0;

    @Override
    public Dataset<Row> dfBlank(SparkSession spark) {
        return TestEnvironment.dfBlank$(this, spark);
    }

    private SparkSession spark$lzycompute() {
        JTSDocsTest jTSDocsTest = this;
        synchronized (jTSDocsTest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.spark = TestEnvironment.spark$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.spark;
    }

    @Override
    public SparkSession spark() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.spark$lzycompute() : this.spark;
    }

    private SQLContext sc$lzycompute() {
        JTSDocsTest jTSDocsTest = this;
        synchronized (jTSDocsTest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sc = TestEnvironment.sc$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sc;
    }

    @Override
    public SQLContext sc() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sc$lzycompute() : this.sc;
    }

    public JTSDocsTest() {
        TestEnvironment.$init$(this);
        this.blockExample("jts documentation example").should((Function0 & Serializable & scala.Serializable)() -> {
            this.sequential();
            this.blockExample("read and convert geospatial csv").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                package.SparkSessionWithJTS$.MODULE$.withJTS$extension(package$.MODULE$.SparkSessionWithJTS(this.spark()));
                StructType schema = new StructType((StructField[])((Object[])new StructField[]{new StructField("name", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("pointText", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("polygonText", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("latitude", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("longitude", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}));
                String dataFile = this.getClass().getClassLoader().getResource("jts-example.csv").getPath();
                Dataset df = this.spark().read().schema(schema).option("sep", "-").option("timestampFormat", "yyyy/MM/dd HH:mm:ss ZZ").csv(dataFile);
                Dataset alteredDF = df.withColumn("polygon", (Column)package$.MODULE$.st_polygonFromText((Column)this.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"polygonText"}))).$((Seq)Nil$.MODULE$))).withColumn("point", (Column)package$.MODULE$.st_makePoint((Column)this.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"latitude"}))).$((Seq)Nil$.MODULE$), (Column)this.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"longitude"}))).$((Seq)Nil$.MODULE$)));
                Tuple2[] points = (Tuple2[])alteredDF.select(this.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pointText"}))).$((Seq)Nil$.MODULE$).as(this.spark().implicits().newStringEncoder()), this.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"}))).$((Seq)Nil$.MODULE$).as(package$.MODULE$.jtsPointEncoder())).collect();
                this.forall((Traversable)Predef$.MODULE$.wrapRefArray((Object[])points), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String pt = (String)tuple2._1();
                    Point p = (Point)tuple2._2();
                    MatchResult matchResult = this.thisValue((Function0 & Serializable & scala.Serializable)() -> pt.toUpperCase()).shouldEqual((Function0 & Serializable & scala.Serializable)() -> p.toString());
                    return matchResult;
                }, MatchResult$.MODULE$.matchResultAsResult());
                Tuple2[] polys = (Tuple2[])alteredDF.select(this.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"polygonText"}))).$((Seq)Nil$.MODULE$).as(this.spark().implicits().newStringEncoder()), this.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"polygon"}))).$((Seq)Nil$.MODULE$).as(package$.MODULE$.jtsPolygonEncoder())).collect();
                return this.forall((Traversable)Predef$.MODULE$.wrapRefArray((Object[])polys), (Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String pt = (String)tuple2._1();
                    Polygon p = (Polygon)tuple2._2();
                    MatchResult matchResult = this.thisValue((Function0 & Serializable & scala.Serializable)() -> pt.toUpperCase()).shouldEqual((Function0 & Serializable & scala.Serializable)() -> p.toString());
                    return matchResult;
                }, MatchResult$.MODULE$.matchResultAsResult());
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            this.blockExample("convert point into dataset").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                Point point = new GeometryFactory().createPoint(new Coordinate(3.4, 5.6));
                Dataset df = this.spark().implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)point, (List)Nil$.MODULE$), package$.MODULE$.jtsPointEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"}));
                return this.thisValue((Function0 & Serializable & scala.Serializable)() -> (Point)df.as(package$.MODULE$.jtsPointEncoder()).first()).shouldEqual((Function0 & Serializable & scala.Serializable)() -> point);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
            Dataset chicagoDF = this.dfBlank(this.spark()).withColumn("geom", (Column)package$.MODULE$.st_makePoint(10.0, 10.0));
            return this.blockExample("should search chicago").$greater$greater((Function0 & Serializable & scala.Serializable)() -> {
                chicagoDF.where((Column)package$.MODULE$.st_contains((Column)package$.MODULE$.st_makeBBOX(0.0, 0.0, 90.0, 90.0), (Column)this.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"geom"}))).$((Seq)Nil$.MODULE$)));
                return this.thisValue((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> chicagoDF.count()).shouldEqual((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1);
            }, AsExecution$.MODULE$.resultAsExecution(MatchResult$.MODULE$.matchResultAsResult()));
        });
    }
}

