/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.jts.udf;

import java.io.Serializable;
import org.apache.spark.sql.SQLContext;
import org.locationtech.geomesa.spark.jts.udf.GeometricConstructorFunctions$;
import org.locationtech.geomesa.spark.jts.util.GeoHashUtils$;
import org.locationtech.geomesa.spark.jts.util.GeometryUtils$;
import org.locationtech.geomesa.spark.jts.util.SQLFunctionHelper$;
import org.locationtech.geomesa.spark.jts.util.WKBUtils$;
import org.locationtech.geomesa.spark.jts.util.WKTUtils$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.geojson.GeoJsonReader;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class GeometricConstructorFunctions$ {
    public static final GeometricConstructorFunctions$ MODULE$ = new GeometricConstructorFunctions$();
    private static transient GeoJsonReader geoJsonReader;
    private static final transient GeometryFactory geomFactory;
    private static final Function2<String, Object, Geometry> ST_GeomFromGeoHash;
    private static final Function1<String, Geometry> ST_GeomFromGeoJSON;
    private static final Function1<String, Geometry> ST_GeomFromWKT;
    private static final Function1<byte[], Geometry> ST_GeomFromWKB;
    private static final Function1<String, LineString> ST_LineFromText;
    private static final Function2<Point, Point, Geometry> ST_MakeBox2D;
    private static final Function4<Object, Object, Object, Object, Geometry> ST_MakeBBOX;
    private static final Function1<LineString, Polygon> ST_MakePolygon;
    private static final Function2<Object, Object, Point> ST_MakePoint;
    private static final Function1<Seq<Point>, LineString> ST_MakeLine;
    private static final Function3<Object, Object, Object, Point> ST_MakePointM;
    private static final Function1<String, MultiLineString> ST_MLineFromText;
    private static final Function1<String, MultiPoint> ST_MPointFromText;
    private static final Function1<String, MultiPolygon> ST_MPolyFromText;
    private static final Function2<Object, Object, Point> ST_Point;
    private static final Function2<String, Object, Point> ST_PointFromGeoHash;
    private static final Function1<String, Point> ST_PointFromText;
    private static final Function1<byte[], Point> ST_PointFromWKB;
    private static final Function1<LineString, Polygon> ST_Polygon;
    private static final Function1<String, Polygon> ST_PolygonFromText;
    private static final Map<Object, String> constructorNames;
    private static volatile transient boolean bitmap$trans$0;

    static {
        geomFactory = new GeometryFactory();
        ST_GeomFromGeoHash = SQLFunctionHelper$.MODULE$.nullableUDF((Function2 & Serializable)(hash, prec) -> GeoHashUtils$.MODULE$.decode(hash, BoxesRunTime.unboxToInt((Object)prec)));
        ST_GeomFromGeoJSON = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)text -> MODULE$.geoJsonReader().read(text));
        ST_GeomFromWKT = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)text -> WKTUtils$.MODULE$.read((String)text));
        ST_GeomFromWKB = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)array -> WKBUtils$.MODULE$.read((byte[])array));
        ST_LineFromText = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)text -> (LineString)WKTUtils$.MODULE$.read((String)text));
        ST_MakeBox2D = SQLFunctionHelper$.MODULE$.nullableUDF((Function2 & Serializable)(lowerLeft, upperRight) -> MODULE$.geomFactory().toGeometry(new Envelope(lowerLeft.getX(), upperRight.getX(), lowerLeft.getY(), upperRight.getY())));
        ST_MakeBBOX = SQLFunctionHelper$.MODULE$.nullableUDF((Function4 & Serializable)(lowerX, lowerY, upperX, upperY) -> GeometryUtils$.MODULE$.addWayPointsToBBOX(GeometricConstructorFunctions$.MODULE$.geomFactory().toGeometry(new Envelope(BoxesRunTime.unboxToDouble((Object)lowerX), BoxesRunTime.unboxToDouble((Object)upperX), BoxesRunTime.unboxToDouble((Object)lowerY), BoxesRunTime.unboxToDouble((Object)upperY)))));
        ST_MakePolygon = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)shell -> {
            LinearRing ring = MODULE$.geomFactory().createLinearRing(shell.getCoordinateSequence());
            return MODULE$.geomFactory().createPolygon(ring);
        });
        ST_MakePoint = SQLFunctionHelper$.MODULE$.nullableUDF((Function2 & Serializable)(x, y) -> GeometricConstructorFunctions$.$anonfun$ST_MakePoint$1(BoxesRunTime.unboxToDouble((Object)x), BoxesRunTime.unboxToDouble((Object)y)));
        ST_MakeLine = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)s -> MODULE$.geomFactory().createLineString((Coordinate[])((IterableOnceOps)s.map((Function1 & Serializable)x$1 -> x$1.getCoordinate())).toArray(ClassTag$.MODULE$.apply(Coordinate.class))));
        ST_MakePointM = SQLFunctionHelper$.MODULE$.nullableUDF((Function3 & Serializable)(x, y, m) -> GeometricConstructorFunctions$.$anonfun$ST_MakePointM$1(BoxesRunTime.unboxToDouble((Object)x), BoxesRunTime.unboxToDouble((Object)y), BoxesRunTime.unboxToDouble((Object)m)));
        ST_MLineFromText = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)text -> (MultiLineString)WKTUtils$.MODULE$.read((String)text));
        ST_MPointFromText = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)text -> (MultiPoint)WKTUtils$.MODULE$.read((String)text));
        ST_MPolyFromText = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)text -> (MultiPolygon)WKTUtils$.MODULE$.read((String)text));
        ST_Point = (Function2 & Serializable)(x, y) -> GeometricConstructorFunctions$.$anonfun$ST_Point$1(BoxesRunTime.unboxToDouble((Object)x), BoxesRunTime.unboxToDouble((Object)y));
        ST_PointFromGeoHash = SQLFunctionHelper$.MODULE$.nullableUDF((Function2 & Serializable)(hash, prec) -> GeometricConstructorFunctions$.$anonfun$ST_PointFromGeoHash$1(hash, BoxesRunTime.unboxToInt((Object)prec)));
        ST_PointFromText = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)text -> (Point)WKTUtils$.MODULE$.read((String)text));
        ST_PointFromWKB = (Function1 & Serializable)array -> (Point)MODULE$.ST_GeomFromWKB().apply(array);
        ST_Polygon = (Function1 & Serializable)shell -> (Polygon)MODULE$.ST_MakePolygon().apply(shell);
        ST_PolygonFromText = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)text -> (Polygon)WKTUtils$.MODULE$.read((String)text));
        constructorNames = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_GeomFromGeoHash()), (Object)"st_geomFromGeoHash"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_GeomFromGeoJSON()), (Object)"st_geomFromGeoJSON"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_GeomFromWKT()), (Object)"st_geomFromWKT"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_GeomFromWKB()), (Object)"st_geomFromWKB"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_LineFromText()), (Object)"st_lineFromText"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_MakeBox2D()), (Object)"st_makeBox2D"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_MakeBBOX()), (Object)"st_makeBBOX"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_MakePolygon()), (Object)"st_makePolygon"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_MakePoint()), (Object)"st_makePoint"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_MakeLine()), (Object)"st_makeLine"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_MakePointM()), (Object)"st_makePointM"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_MLineFromText()), (Object)"st_mLineFromText"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_MPointFromText()), (Object)"st_mPointFromText"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_MPolyFromText()), (Object)"st_mPolyFromText"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_Point()), (Object)"st_point"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_PointFromGeoHash()), (Object)"st_pointFromGeoHash"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_PointFromText()), (Object)"st_pointFromText"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_PointFromWKB()), (Object)"st_pointFromWKB"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_Polygon()), (Object)"st_polygon"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_PolygonFromText()), (Object)"st_polygonFromText")}));
    }

    private GeometryFactory geomFactory() {
        return geomFactory;
    }

    private GeoJsonReader geoJsonReader$lzycompute() {
        GeometricConstructorFunctions$ geometricConstructorFunctions$ = this;
        synchronized (geometricConstructorFunctions$) {
            if (!bitmap$trans$0) {
                geoJsonReader = new GeoJsonReader(this.geomFactory());
                bitmap$trans$0 = true;
            }
        }
        return geoJsonReader;
    }

    private GeoJsonReader geoJsonReader() {
        if (!bitmap$trans$0) {
            return this.geoJsonReader$lzycompute();
        }
        return geoJsonReader;
    }

    public Function2<String, Object, Geometry> ST_GeomFromGeoHash() {
        return ST_GeomFromGeoHash;
    }

    public Function1<String, Geometry> ST_GeomFromGeoJSON() {
        return ST_GeomFromGeoJSON;
    }

    public Function1<String, Geometry> ST_GeomFromWKT() {
        return ST_GeomFromWKT;
    }

    public Function1<byte[], Geometry> ST_GeomFromWKB() {
        return ST_GeomFromWKB;
    }

    public Function1<String, LineString> ST_LineFromText() {
        return ST_LineFromText;
    }

    public Function2<Point, Point, Geometry> ST_MakeBox2D() {
        return ST_MakeBox2D;
    }

    public Function4<Object, Object, Object, Object, Geometry> ST_MakeBBOX() {
        return ST_MakeBBOX;
    }

    public Function1<LineString, Polygon> ST_MakePolygon() {
        return ST_MakePolygon;
    }

    public Function2<Object, Object, Point> ST_MakePoint() {
        return ST_MakePoint;
    }

    public Function1<Seq<Point>, LineString> ST_MakeLine() {
        return ST_MakeLine;
    }

    public Function3<Object, Object, Object, Point> ST_MakePointM() {
        return ST_MakePointM;
    }

    public Function1<String, MultiLineString> ST_MLineFromText() {
        return ST_MLineFromText;
    }

    public Function1<String, MultiPoint> ST_MPointFromText() {
        return ST_MPointFromText;
    }

    public Function1<String, MultiPolygon> ST_MPolyFromText() {
        return ST_MPolyFromText;
    }

    public Function2<Object, Object, Point> ST_Point() {
        return ST_Point;
    }

    public Function2<String, Object, Point> ST_PointFromGeoHash() {
        return ST_PointFromGeoHash;
    }

    public Function1<String, Point> ST_PointFromText() {
        return ST_PointFromText;
    }

    public Function1<byte[], Point> ST_PointFromWKB() {
        return ST_PointFromWKB;
    }

    public Function1<LineString, Polygon> ST_Polygon() {
        return ST_Polygon;
    }

    public Function1<String, Polygon> ST_PolygonFromText() {
        return ST_PolygonFromText;
    }

    public Map<Object, String> constructorNames() {
        return constructorNames;
    }

    public void registerFunctions(SQLContext sqlContext) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator1$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator2$1() {
            }
        }
        sqlContext.udf().register("st_box2DFromGeoHash", this.ST_GeomFromGeoHash(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator2$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator3$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator4$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_GeomFromGeoHash()), this.ST_GeomFromGeoHash(), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator3$1()), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator4$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u6 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator5$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator6$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_GeomFromGeoJSON()), this.ST_GeomFromGeoJSON(), ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator5$1()), ((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator6$1()));
        JavaUniverse $u7 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m7 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u8 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m8 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator7$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator7$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator8$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator8$1() {
            }
        }
        sqlContext.udf().register("st_geomFromText", this.ST_GeomFromWKT(), ((TypeTags)$u7).TypeTag().apply((Mirror)$m7, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator7$1()), ((TypeTags)$u8).TypeTag().apply((Mirror)$m8, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator8$1()));
        JavaUniverse $u9 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m9 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u10 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m10 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator9$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator9$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator10$1() {
            }
        }
        sqlContext.udf().register("st_geometryFromText", this.ST_GeomFromWKT(), ((TypeTags)$u9).TypeTag().apply((Mirror)$m9, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator9$1()), ((TypeTags)$u10).TypeTag().apply((Mirror)$m10, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator10$1()));
        JavaUniverse $u11 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m11 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u12 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m12 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator11$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator11$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator12$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator12$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_GeomFromWKT()), this.ST_GeomFromWKT(), ((TypeTags)$u11).TypeTag().apply((Mirror)$m11, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator11$1()), ((TypeTags)$u12).TypeTag().apply((Mirror)$m12, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator12$1()));
        JavaUniverse $u13 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m13 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u14 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m14 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator13$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator13$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator14$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator14$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_GeomFromWKB()), this.ST_GeomFromWKB(), ((TypeTags)$u13).TypeTag().apply((Mirror)$m13, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator13$1()), ((TypeTags)$u14).TypeTag().apply((Mirror)$m14, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator14$1()));
        JavaUniverse $u15 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m15 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u16 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m16 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator15$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.LineString").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator15$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator16$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator16$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_LineFromText()), this.ST_LineFromText(), ((TypeTags)$u15).TypeTag().apply((Mirror)$m15, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator15$1()), ((TypeTags)$u16).TypeTag().apply((Mirror)$m16, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator16$1()));
        JavaUniverse $u17 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m17 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u18 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m18 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator17$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.MultiLineString").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator17$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator18$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator18$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_MLineFromText()), this.ST_MLineFromText(), ((TypeTags)$u17).TypeTag().apply((Mirror)$m17, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator17$1()), ((TypeTags)$u18).TypeTag().apply((Mirror)$m18, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator18$1()));
        JavaUniverse $u19 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m19 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u20 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m20 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator19$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.MultiPoint").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator19$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator20$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator20$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_MPointFromText()), this.ST_MPointFromText(), ((TypeTags)$u19).TypeTag().apply((Mirror)$m19, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator19$1()), ((TypeTags)$u20).TypeTag().apply((Mirror)$m20, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator20$1()));
        JavaUniverse $u21 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m21 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u22 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m22 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator21$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.MultiPolygon").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator21$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator22$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator22$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_MPolyFromText()), this.ST_MPolyFromText(), ((TypeTags)$u21).TypeTag().apply((Mirror)$m21, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator21$1()), ((TypeTags)$u22).TypeTag().apply((Mirror)$m22, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator22$1()));
        JavaUniverse $u23 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m23 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator23$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator23$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_MakeBBOX()), this.ST_MakeBBOX(), ((TypeTags)$u23).TypeTag().apply((Mirror)$m23, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator23$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        JavaUniverse $u24 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m24 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u25 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m25 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u26 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m26 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator24$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator24$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator25$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Point").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator25$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator26$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Point").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator26$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_MakeBox2D()), this.ST_MakeBox2D(), ((TypeTags)$u24).TypeTag().apply((Mirror)$m24, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator24$1()), ((TypeTags)$u25).TypeTag().apply((Mirror)$m25, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator25$1()), ((TypeTags)$u26).TypeTag().apply((Mirror)$m26, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator26$1()));
        JavaUniverse $u27 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m27 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u28 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m28 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator27$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.LineString").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator27$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator28$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("org.locationtech.jts.geom.Point").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator28$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_MakeLine()), this.ST_MakeLine(), ((TypeTags)$u27).TypeTag().apply((Mirror)$m27, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator27$1()), ((TypeTags)$u28).TypeTag().apply((Mirror)$m28, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator28$1()));
        JavaUniverse $u29 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m29 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator29$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Point").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator29$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_MakePoint()), this.ST_MakePoint(), ((TypeTags)$u29).TypeTag().apply((Mirror)$m29, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator29$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        JavaUniverse $u30 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m30 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator30$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Point").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator30$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_MakePointM()), this.ST_MakePointM(), ((TypeTags)$u30).TypeTag().apply((Mirror)$m30, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator30$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        JavaUniverse $u31 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m31 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u32 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m32 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator31$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Polygon").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator31$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator32$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.LineString").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator32$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_MakePolygon()), this.ST_MakePolygon(), ((TypeTags)$u31).TypeTag().apply((Mirror)$m31, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator31$1()), ((TypeTags)$u32).TypeTag().apply((Mirror)$m32, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator32$1()));
        JavaUniverse $u33 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m33 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator33$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Point").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator33$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_Point()), this.ST_Point(), ((TypeTags)$u33).TypeTag().apply((Mirror)$m33, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator33$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        JavaUniverse $u34 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m34 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u35 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m35 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator34$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Point").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator34$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator35$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator35$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_PointFromGeoHash()), this.ST_PointFromGeoHash(), ((TypeTags)$u34).TypeTag().apply((Mirror)$m34, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator34$1()), ((TypeTags)$u35).TypeTag().apply((Mirror)$m35, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator35$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        JavaUniverse $u36 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m36 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u37 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m37 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator36$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Point").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator36$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator37$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator37$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_PointFromText()), this.ST_PointFromText(), ((TypeTags)$u36).TypeTag().apply((Mirror)$m36, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator36$1()), ((TypeTags)$u37).TypeTag().apply((Mirror)$m37, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator37$1()));
        JavaUniverse $u38 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m38 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u39 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m39 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator38$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Point").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator38$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator39$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Byte").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator39$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_PointFromWKB()), this.ST_PointFromWKB(), ((TypeTags)$u38).TypeTag().apply((Mirror)$m38, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator38$1()), ((TypeTags)$u39).TypeTag().apply((Mirror)$m39, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator39$1()));
        JavaUniverse $u40 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m40 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u41 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m41 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator40$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Polygon").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator40$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator41$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.LineString").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator41$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_Polygon()), this.ST_Polygon(), ((TypeTags)$u40).TypeTag().apply((Mirror)$m40, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator40$1()), ((TypeTags)$u41).TypeTag().apply((Mirror)$m41, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator41$1()));
        JavaUniverse $u42 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m42 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u43 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m43 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator42$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Polygon").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator42$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator43$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator43$1() {
            }
        }
        sqlContext.udf().register((String)this.constructorNames().apply(this.ST_PolygonFromText()), this.ST_PolygonFromText(), ((TypeTags)$u42).TypeTag().apply((Mirror)$m42, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator42$1()), ((TypeTags)$u43).TypeTag().apply((Mirror)$m43, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricConstructorFunctions$$typecreator43$1()));
    }

    public static final /* synthetic */ Point $anonfun$ST_MakePoint$1(double x, double y) {
        return MODULE$.geomFactory().createPoint(new Coordinate(x, y));
    }

    public static final /* synthetic */ Point $anonfun$ST_MakePointM$1(double x, double y, double m) {
        return (Point)WKTUtils$.MODULE$.read(new StringBuilder(9).append("POINT(").append(x).append(" ").append(y).append(" ").append(m).append(")").toString());
    }

    public static final /* synthetic */ Point $anonfun$ST_Point$1(double x, double y) {
        return (Point)MODULE$.ST_MakePoint().apply((Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)y));
    }

    public static final /* synthetic */ Point $anonfun$ST_PointFromGeoHash$1(String hash, int prec) {
        return GeoHashUtils$.MODULE$.decode(hash, prec).getInteriorPoint();
    }

    private GeometricConstructorFunctions$() {
    }
}

