/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.jts.udf;

import java.io.Serializable;
import org.apache.spark.sql.SQLContext;
import org.locationtech.geomesa.spark.jts.udf.GeometricProcessingFunctions$;
import org.locationtech.geomesa.spark.jts.util.SQLFunctionHelper$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.jts.util.GeometricShapeFactory;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsPoint;
import org.locationtech.spatial4j.shape.jts.JtsShapeFactory;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;

public final class GeometricProcessingFunctions$ {
    public static final GeometricProcessingFunctions$ MODULE$ = new GeometricProcessingFunctions$();
    private static transient JtsSpatialContext spatialContext;
    private static transient JtsShapeFactory shapeFactory;
    private static transient GeometryFactory org$locationtech$geomesa$spark$jts$udf$GeometricProcessingFunctions$$geometryFactory;
    private static final transient ThreadLocal<GeometricShapeFactory> geometricShapeFactory;
    private static final Function1<Geometry, Geometry> ST_antimeridianSafeGeom;
    private static final Function2<Point, Object, Geometry> ST_BufferPoint;
    private static final Function1<Geometry, Geometry> ST_MakeValid;
    private static final Map<Object, String> processingNames;
    private static volatile transient byte bitmap$trans$0;

    static {
        geometricShapeFactory = new ThreadLocal<GeometricShapeFactory>(){

            public GeometricShapeFactory initialValue() {
                return new GeometricShapeFactory(GeometricProcessingFunctions$.MODULE$.org$locationtech$geomesa$spark$jts$udf$GeometricProcessingFunctions$$geometryFactory());
            }
        };
        ST_antimeridianSafeGeom = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)geom -> {
            Geometry geomCopy = MODULE$.org$locationtech$geomesa$spark$jts$udf$GeometricProcessingFunctions$$geometryFactory().createGeometry(geom);
            if (geomCopy.getEnvelopeInternal().getMinX() < (double)-180 || geomCopy.getEnvelopeInternal().getMaxX() > (double)180) {
                geomCopy.apply(new CoordinateSequenceFilter(){

                    public void filter(CoordinateSequence seq, int i) {
                        seq.setOrdinate(i, 0, seq.getX(i) + GeometricProcessingFunctions$.org$locationtech$geomesa$spark$jts$udf$GeometricProcessingFunctions$$degreesToTranslate$1(seq.getX(i)));
                    }

                    public boolean isDone() {
                        return false;
                    }

                    public boolean isGeometryChanged() {
                        return true;
                    }
                });
            }
            Shape datelineSafeShape = MODULE$.shapeFactory().makeShapeFromGeometry(geomCopy);
            return MODULE$.shapeFactory().getGeometryFrom(datelineSafeShape);
        });
        ST_BufferPoint = (Function2 & Serializable)(p, d) -> GeometricProcessingFunctions$.$anonfun$ST_BufferPoint$1(p, BoxesRunTime.unboxToDouble((Object)d));
        ST_MakeValid = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)geom -> {
            GeometryFixer fix = new GeometryFixer(geom);
            return fix.getResult();
        });
        processingNames = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_antimeridianSafeGeom()), (Object)"st_antimeridianSafeGeom"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_BufferPoint()), (Object)"st_bufferPoint"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_MakeValid()), (Object)"st_makeValid")}));
    }

    private JtsSpatialContext spatialContext$lzycompute() {
        GeometricProcessingFunctions$ geometricProcessingFunctions$ = this;
        synchronized (geometricProcessingFunctions$) {
            if ((byte)(bitmap$trans$0 & 1) == 0) {
                spatialContext = JtsSpatialContext.GEO;
                bitmap$trans$0 = (byte)(bitmap$trans$0 | 1);
            }
        }
        return spatialContext;
    }

    private JtsSpatialContext spatialContext() {
        if ((byte)(bitmap$trans$0 & 1) == 0) {
            return this.spatialContext$lzycompute();
        }
        return spatialContext;
    }

    private JtsShapeFactory shapeFactory$lzycompute() {
        GeometricProcessingFunctions$ geometricProcessingFunctions$ = this;
        synchronized (geometricProcessingFunctions$) {
            if ((byte)(bitmap$trans$0 & 2) == 0) {
                shapeFactory = this.spatialContext().getShapeFactory();
                bitmap$trans$0 = (byte)(bitmap$trans$0 | 2);
            }
        }
        return shapeFactory;
    }

    private JtsShapeFactory shapeFactory() {
        if ((byte)(bitmap$trans$0 & 2) == 0) {
            return this.shapeFactory$lzycompute();
        }
        return shapeFactory;
    }

    private GeometryFactory geometryFactory$lzycompute() {
        GeometricProcessingFunctions$ geometricProcessingFunctions$ = this;
        synchronized (geometricProcessingFunctions$) {
            if ((byte)(bitmap$trans$0 & 4) == 0) {
                org$locationtech$geomesa$spark$jts$udf$GeometricProcessingFunctions$$geometryFactory = new GeometryFactory();
                bitmap$trans$0 = (byte)(bitmap$trans$0 | 4);
            }
        }
        return org$locationtech$geomesa$spark$jts$udf$GeometricProcessingFunctions$$geometryFactory;
    }

    public GeometryFactory org$locationtech$geomesa$spark$jts$udf$GeometricProcessingFunctions$$geometryFactory() {
        if ((byte)(bitmap$trans$0 & 4) == 0) {
            return this.geometryFactory$lzycompute();
        }
        return org$locationtech$geomesa$spark$jts$udf$GeometricProcessingFunctions$$geometryFactory;
    }

    private ThreadLocal<GeometricShapeFactory> geometricShapeFactory() {
        return geometricShapeFactory;
    }

    private Geometry fastCircleToGeom(Circle circle) {
        GeometricShapeFactory gsf = this.geometricShapeFactory().get();
        gsf.setSize(circle.getBoundingBox().getWidth());
        gsf.setNumPoints(100);
        gsf.setCentre(new Coordinate(circle.getCenter().getX(), circle.getCenter().getY()));
        return (Geometry)this.ST_antimeridianSafeGeom().apply((Object)gsf.createCircle());
    }

    public Function1<Geometry, Geometry> ST_antimeridianSafeGeom() {
        return ST_antimeridianSafeGeom;
    }

    public Function2<Point, Object, Geometry> ST_BufferPoint() {
        return ST_BufferPoint;
    }

    public Function1<Geometry, Geometry> ST_MakeValid() {
        return ST_MakeValid;
    }

    public Map<Object, String> processingNames() {
        return processingNames;
    }

    public void registerFunctions(SQLContext sqlContext) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator1$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator2$1() {
            }
        }
        sqlContext.udf().register((String)this.processingNames().apply(this.ST_antimeridianSafeGeom()), this.ST_antimeridianSafeGeom(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator2$1()));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator3$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator4$1() {
            }
        }
        sqlContext.udf().register("st_idlSafeGeom", this.ST_antimeridianSafeGeom(), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator3$1()), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator4$1()));
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u6 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator5$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Point").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator6$1() {
            }
        }
        sqlContext.udf().register((String)this.processingNames().apply(this.ST_BufferPoint()), this.ST_BufferPoint(), ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator5$1()), ((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator6$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        JavaUniverse $u7 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m7 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u8 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m8 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator7$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator7$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator8$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator8$1() {
            }
        }
        sqlContext.udf().register((String)this.processingNames().apply(this.ST_MakeValid()), this.ST_MakeValid(), ((TypeTags)$u7).TypeTag().apply((Mirror)$m7, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator7$1()), ((TypeTags)$u8).TypeTag().apply((Mirror)$m8, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricProcessingFunctions$$typecreator8$1()));
    }

    public static final double org$locationtech$geomesa$spark$jts$udf$GeometricProcessingFunctions$$degreesToTranslate$1(double x) {
        return (int)(RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((x + (double)180) / 360.0)) * (double)-360);
    }

    public static final /* synthetic */ Geometry $anonfun$ST_BufferPoint$1(Point p, double d) {
        double degrees = DistanceUtils.dist2Degrees((double)(d / 1000.0), (double)6371.0087714);
        return MODULE$.fastCircleToGeom(new JtsPoint(p, MODULE$.spatialContext()).getBuffered(degrees, (SpatialContext)MODULE$.spatialContext()));
    }

    private GeometricProcessingFunctions$() {
    }
}

