/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.jts.udf;

import java.io.Serializable;
import org.apache.spark.sql.SQLContext;
import org.locationtech.geomesa.spark.jts.udf.GeometricAccessorFunctions$;
import org.locationtech.geomesa.spark.jts.util.SQLFunctionHelper$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class GeometricAccessorFunctions$ {
    public static final GeometricAccessorFunctions$ MODULE$ = new GeometricAccessorFunctions$();
    private static final Function1<Geometry, Geometry> ST_Boundary = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)geom -> geom.getBoundary());
    private static final Function1<Geometry, Integer> ST_CoordDim = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)geom -> {
        Coordinate coord = geom.getCoordinate();
        if (Double.isNaN(coord.z)) {
            return Predef$.MODULE$.int2Integer(2);
        }
        return Predef$.MODULE$.int2Integer(3);
    });
    private static final Function1<Geometry, Integer> ST_Dimension = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)geom -> Predef$.MODULE$.int2Integer(geom.getDimension()));
    private static final Function1<Geometry, Geometry> ST_Envelope = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)geom -> geom.getEnvelope());
    private static final Function1<Geometry, LineString> ST_ExteriorRing = (Function1 & Serializable)x0$1 -> {
        Geometry geometry = x0$1;
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            return polygon.getExteriorRing();
        }
        return null;
    };
    private static final Function2<Geometry, Object, Geometry> ST_GeometryN = SQLFunctionHelper$.MODULE$.nullableUDF((Function2 & Serializable)(geom, n) -> GeometricAccessorFunctions$.$anonfun$ST_GeometryN$1(geom, BoxesRunTime.unboxToInt((Object)n)));
    private static final Function1<Geometry, String> ST_GeometryType = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)geom -> geom.getGeometryType());
    private static final Function2<Geometry, Object, Geometry> ST_InteriorRingN = SQLFunctionHelper$.MODULE$.nullableUDF((Function2 & Serializable)(geom, n) -> GeometricAccessorFunctions$.$anonfun$ST_InteriorRingN$1(geom, BoxesRunTime.unboxToInt((Object)n)));
    private static final Function1<Geometry, Boolean> ST_IsClosed = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)x0$2 -> {
        Geometry geometry = x0$2;
        if (geometry instanceof LineString) {
            LineString lineString = (LineString)geometry;
            return Predef$.MODULE$.boolean2Boolean(lineString.isClosed());
        }
        if (geometry instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)geometry;
            return Predef$.MODULE$.boolean2Boolean(multiLineString.isClosed());
        }
        return Predef$.MODULE$.boolean2Boolean(true);
    });
    private static final Function1<Geometry, Boolean> ST_IsCollection = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)geom -> Predef$.MODULE$.boolean2Boolean(geom instanceof GeometryCollection));
    private static final Function1<Geometry, Boolean> ST_IsEmpty = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)geom -> Predef$.MODULE$.boolean2Boolean(geom.isEmpty()));
    private static final Function1<Geometry, Boolean> ST_IsRing = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)x0$3 -> {
        Geometry geometry = x0$3;
        if (geometry instanceof LineString) {
            LineString lineString = (LineString)geometry;
            return Predef$.MODULE$.boolean2Boolean(lineString.isClosed() && lineString.isSimple());
        }
        if (geometry instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)geometry;
            return Predef$.MODULE$.boolean2Boolean(multiLineString.isClosed() && multiLineString.isSimple());
        }
        return Predef$.MODULE$.boolean2Boolean(geometry.isSimple());
    });
    private static final Function1<Geometry, Boolean> ST_IsSimple = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)geom -> Predef$.MODULE$.boolean2Boolean(geom.isSimple()));
    private static final Function1<Geometry, Boolean> ST_IsValid = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)geom -> Predef$.MODULE$.boolean2Boolean(geom.isValid()));
    private static final Function1<Geometry, Integer> ST_NumGeometries = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)geom -> Predef$.MODULE$.int2Integer(geom.getNumGeometries()));
    private static final Function1<Geometry, Integer> ST_NumPoints = SQLFunctionHelper$.MODULE$.nullableUDF((Function1 & Serializable)geom -> Predef$.MODULE$.int2Integer(geom.getNumPoints()));
    private static final Function2<Geometry, Object, Point> ST_PointN = SQLFunctionHelper$.MODULE$.nullableUDF((Function2 & Serializable)(geom, n) -> GeometricAccessorFunctions$.$anonfun$ST_PointN$1(geom, BoxesRunTime.unboxToInt((Object)n)));
    private static final Function1<Geometry, Float> ST_X = (Function1 & Serializable)x0$4 -> {
        Geometry geometry = x0$4;
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            return Predef$.MODULE$.float2Float((float)point.getX());
        }
        return null;
    };
    private static final Function1<Geometry, Float> ST_Y = (Function1 & Serializable)x0$5 -> {
        Geometry geometry = x0$5;
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            return Predef$.MODULE$.float2Float((float)point.getY());
        }
        return null;
    };
    private static final Map<Object, String> accessorNames = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_Boundary()), (Object)"st_boundary"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_CoordDim()), (Object)"st_coordDim"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_Dimension()), (Object)"st_dimension"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_Envelope()), (Object)"st_envelope"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_ExteriorRing()), (Object)"st_exteriorRing"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_GeometryN()), (Object)"st_geometryN"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_GeometryType()), (Object)"st_geometryType"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_InteriorRingN()), (Object)"st_interiorRingN"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_IsClosed()), (Object)"st_isClosed"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_IsCollection()), (Object)"st_isCollection"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_IsEmpty()), (Object)"st_isEmpty"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_IsRing()), (Object)"st_isRing"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_IsSimple()), (Object)"st_isSimple"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_IsValid()), (Object)"st_isValid"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_NumGeometries()), (Object)"st_numGeometries"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_NumPoints()), (Object)"st_numPoints"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_PointN()), (Object)"st_pointN"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_X()), (Object)"st_x"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.ST_Y()), (Object)"st_y")}));

    public Function1<Geometry, Geometry> ST_Boundary() {
        return ST_Boundary;
    }

    public Function1<Geometry, Integer> ST_CoordDim() {
        return ST_CoordDim;
    }

    public Function1<Geometry, Integer> ST_Dimension() {
        return ST_Dimension;
    }

    public Function1<Geometry, Geometry> ST_Envelope() {
        return ST_Envelope;
    }

    public Function1<Geometry, LineString> ST_ExteriorRing() {
        return ST_ExteriorRing;
    }

    public Function2<Geometry, Object, Geometry> ST_GeometryN() {
        return ST_GeometryN;
    }

    public Function1<Geometry, String> ST_GeometryType() {
        return ST_GeometryType;
    }

    public Function2<Geometry, Object, Geometry> ST_InteriorRingN() {
        return ST_InteriorRingN;
    }

    public Function1<Geometry, Boolean> ST_IsClosed() {
        return ST_IsClosed;
    }

    public Function1<Geometry, Boolean> ST_IsCollection() {
        return ST_IsCollection;
    }

    public Function1<Geometry, Boolean> ST_IsEmpty() {
        return ST_IsEmpty;
    }

    public Function1<Geometry, Boolean> ST_IsRing() {
        return ST_IsRing;
    }

    public Function1<Geometry, Boolean> ST_IsSimple() {
        return ST_IsSimple;
    }

    public Function1<Geometry, Boolean> ST_IsValid() {
        return ST_IsValid;
    }

    public Function1<Geometry, Integer> ST_NumGeometries() {
        return ST_NumGeometries;
    }

    public Function1<Geometry, Integer> ST_NumPoints() {
        return ST_NumPoints;
    }

    public Function2<Geometry, Object, Point> ST_PointN() {
        return ST_PointN;
    }

    public Function1<Geometry, Float> ST_X() {
        return ST_X;
    }

    public Function1<Geometry, Float> ST_Y() {
        return ST_Y;
    }

    public Map<Object, String> accessorNames() {
        return accessorNames;
    }

    public void registerFunctions(SQLContext sqlContext) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator1$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator2$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_Boundary()), this.ST_Boundary(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator2$1()));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.Integer").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator3$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator4$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_CoordDim()), this.ST_CoordDim(), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator3$1()), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator4$1()));
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u6 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m6 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.Integer").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator5$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator6$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_Dimension()), this.ST_Dimension(), ((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator5$1()), ((TypeTags)$u6).TypeTag().apply((Mirror)$m6, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator6$1()));
        JavaUniverse $u7 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m7 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u8 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m8 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator7$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator7$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator8$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator8$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_Envelope()), this.ST_Envelope(), ((TypeTags)$u7).TypeTag().apply((Mirror)$m7, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator7$1()), ((TypeTags)$u8).TypeTag().apply((Mirror)$m8, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator8$1()));
        JavaUniverse $u9 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m9 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u10 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m10 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator9$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.LineString").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator9$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator10$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_ExteriorRing()), this.ST_ExteriorRing(), ((TypeTags)$u9).TypeTag().apply((Mirror)$m9, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator9$1()), ((TypeTags)$u10).TypeTag().apply((Mirror)$m10, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator10$1()));
        JavaUniverse $u11 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m11 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u12 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m12 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator11$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator11$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator12$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator12$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_GeometryN()), this.ST_GeometryN(), ((TypeTags)$u11).TypeTag().apply((Mirror)$m11, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator11$1()), ((TypeTags)$u12).TypeTag().apply((Mirror)$m12, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator12$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        JavaUniverse $u13 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m13 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u14 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m14 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator13$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator13$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator14$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator14$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_GeometryType()), this.ST_GeometryType(), ((TypeTags)$u13).TypeTag().apply((Mirror)$m13, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator13$1()), ((TypeTags)$u14).TypeTag().apply((Mirror)$m14, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator14$1()));
        JavaUniverse $u15 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m15 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u16 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m16 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator15$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator15$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator16$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator16$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_InteriorRingN()), this.ST_InteriorRingN(), ((TypeTags)$u15).TypeTag().apply((Mirror)$m15, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator15$1()), ((TypeTags)$u16).TypeTag().apply((Mirror)$m16, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator16$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        JavaUniverse $u17 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m17 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u18 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m18 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator17$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.Boolean").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator17$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator18$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator18$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_IsClosed()), this.ST_IsClosed(), ((TypeTags)$u17).TypeTag().apply((Mirror)$m17, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator17$1()), ((TypeTags)$u18).TypeTag().apply((Mirror)$m18, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator18$1()));
        JavaUniverse $u19 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m19 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u20 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m20 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator19$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.Boolean").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator19$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator20$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator20$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_IsCollection()), this.ST_IsCollection(), ((TypeTags)$u19).TypeTag().apply((Mirror)$m19, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator19$1()), ((TypeTags)$u20).TypeTag().apply((Mirror)$m20, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator20$1()));
        JavaUniverse $u21 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m21 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u22 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m22 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator21$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.Boolean").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator21$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator22$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator22$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_IsEmpty()), this.ST_IsEmpty(), ((TypeTags)$u21).TypeTag().apply((Mirror)$m21, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator21$1()), ((TypeTags)$u22).TypeTag().apply((Mirror)$m22, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator22$1()));
        JavaUniverse $u23 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m23 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u24 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m24 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator23$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.Boolean").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator23$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator24$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator24$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_IsRing()), this.ST_IsRing(), ((TypeTags)$u23).TypeTag().apply((Mirror)$m23, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator23$1()), ((TypeTags)$u24).TypeTag().apply((Mirror)$m24, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator24$1()));
        JavaUniverse $u25 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m25 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u26 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m26 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator25$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.Boolean").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator25$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator26$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator26$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_IsSimple()), this.ST_IsSimple(), ((TypeTags)$u25).TypeTag().apply((Mirror)$m25, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator25$1()), ((TypeTags)$u26).TypeTag().apply((Mirror)$m26, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator26$1()));
        JavaUniverse $u27 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m27 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u28 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m28 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator27$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.Boolean").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator27$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator28$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator28$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_IsValid()), this.ST_IsValid(), ((TypeTags)$u27).TypeTag().apply((Mirror)$m27, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator27$1()), ((TypeTags)$u28).TypeTag().apply((Mirror)$m28, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator28$1()));
        JavaUniverse $u29 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m29 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u30 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m30 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator29$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.Integer").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator29$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator30$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator30$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_NumGeometries()), this.ST_NumGeometries(), ((TypeTags)$u29).TypeTag().apply((Mirror)$m29, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator29$1()), ((TypeTags)$u30).TypeTag().apply((Mirror)$m30, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator30$1()));
        JavaUniverse $u31 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m31 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u32 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m32 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator31$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.Integer").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator31$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator32$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator32$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_NumPoints()), this.ST_NumPoints(), ((TypeTags)$u31).TypeTag().apply((Mirror)$m31, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator31$1()), ((TypeTags)$u32).TypeTag().apply((Mirror)$m32, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator32$1()));
        JavaUniverse $u33 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m33 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u34 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m34 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator33$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Point").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator33$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator34$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator34$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_PointN()), this.ST_PointN(), ((TypeTags)$u33).TypeTag().apply((Mirror)$m33, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator33$1()), ((TypeTags)$u34).TypeTag().apply((Mirror)$m34, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator34$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        JavaUniverse $u35 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m35 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u36 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m36 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator35$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.Float").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator35$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator36$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator36$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_X()), this.ST_X(), ((TypeTags)$u35).TypeTag().apply((Mirror)$m35, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator35$1()), ((TypeTags)$u36).TypeTag().apply((Mirror)$m36, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator36$1()));
        JavaUniverse $u37 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m37 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u38 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m38 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator37$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.Float").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator37$1() {
            }
        }
        public final class Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator38$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.locationtech.jts.geom.Geometry").asType().toTypeConstructor();
            }

            public Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator38$1() {
            }
        }
        sqlContext.udf().register((String)this.accessorNames().apply(this.ST_Y()), this.ST_Y(), ((TypeTags)$u37).TypeTag().apply((Mirror)$m37, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator37$1()), ((TypeTags)$u38).TypeTag().apply((Mirror)$m38, (TypeCreator)new Org_locationtech_geomesa_spark_jts_udf_GeometricAccessorFunctions$$typecreator38$1()));
    }

    public static final /* synthetic */ Geometry $anonfun$ST_GeometryN$1(Geometry geom, int n) {
        if (n > 0 && n <= geom.getNumGeometries()) {
            return geom.getGeometryN(n - 1);
        }
        return null;
    }

    public static final /* synthetic */ Geometry $anonfun$ST_InteriorRingN$1(Geometry geom, int n) {
        Geometry geometry = geom;
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            if (0 < n && n <= polygon.getNumInteriorRing()) {
                return polygon.getInteriorRingN(n - 1);
            }
            return null;
        }
        return null;
    }

    public static final /* synthetic */ Point $anonfun$ST_PointN$1(Geometry geom, int n) {
        Geometry geometry = geom;
        if (geometry instanceof LineString) {
            LineString lineString = (LineString)geometry;
            if (n > 0 && n <= lineString.getNumPoints()) {
                return lineString.getPointN(n - 1);
            }
            if (n < 0 && n + lineString.getNumPoints() >= 0) {
                return lineString.getPointN(n + lineString.getNumPoints());
            }
            return null;
        }
        return null;
    }

    private GeometricAccessorFunctions$() {
    }
}

